/*
 * Decompiled with CFR 0.152.
 */
package jet.connect.jdbms;

import java.io.IOException;
import java.sql.SQLException;
import jet.connect.DbBit;
import jet.connect.DbColDesc;
import jet.connect.DbRecord;
import jet.connect.DbRecordModel;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.connect.jdbms.JDbRecordModel;
import jet.connect.jdbms.JDbWhere;
import jet.connect.jdbms.JResultSet;

public class JDbResultSet
extends DbRecord
implements JResultSet {
    JDbWhere where;
    int index = 0;

    public JDbResultSet(DbRecordModel dbRecordModel) {
        super(dbRecordModel);
        DbColDesc[] dbColDescArray = dbRecordModel.getColDescs();
        this.cells = new DbValue[dbColDescArray.length];
        for (int i = 0; i < dbColDescArray.length; ++i) {
            this.cells[i] = DbValue.makeDbValue((DbColDesc)dbColDescArray[i]);
        }
    }

    @Override
    public void setCursor(int n) {
        this.index = n;
    }

    @Override
    public void setWhere(JDbWhere jDbWhere) {
        this.where = jDbWhere;
        this.index = 0;
        this.setRecordIndex(this.index);
    }

    @Override
    public int nextRecord() {
        int n;
        int n2 = ((JDbRecordModel)this.getRecordModel()).getRecordCount();
        while (this.index < n2) {
            this.setRecordIndex(this.index);
            this.refresh(true);
            if (((DbBit)this.getCell(0)).get()) {
                ++this.index;
                continue;
            }
            if (this.where == null || this.where.isTrue(this)) break;
            ++this.index;
        }
        if (this.index < n2) {
            int n3 = this.index;
            n = n3;
            this.index = n3 + 1;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public synchronized int insert() throws SQLException {
        ((DbBit)this.cells[0]).set(false);
        this.getRecordModel().getDbBuffer().addRecord((Record)this);
        ((JDbRecordModel)this.getRecordModel()).incRecordCount();
        return this.getRecordIndex();
    }

    @Override
    public synchronized void delete() throws SQLException {
        DbBit dbBit = (DbBit)this.getCell(0);
        dbBit.set(true);
        this.update();
        this.nextRecord();
    }

    @Override
    public synchronized void deleteAll() throws SQLException {
        while (this.nextRecord() != -1) {
            DbBit dbBit = (DbBit)this.getCell(0);
            dbBit.set(true);
            this.update();
        }
    }

    @Override
    public synchronized void commit() throws SQLException, IOException {
        this.getRecordModel().getDbBuffer().refreshAllToFile();
    }

    @Override
    public synchronized void close() throws SQLException {
    }

    @Override
    public int getRecordCount() {
        return ((JDbRecordModel)this.getRecordModel()).getRecordCount();
    }
}

