/*
 * Decompiled with CFR 0.152.
 */
package jet.cs;

import guitools.toolkit.JDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.Env;
import jet.JCliResource;
import jet.ReportEnv;
import jet.cs.CSConst;
import jet.cs.InvalidReportURLException;

public class CSUtil
extends CSConst {
    public static final int buildNumber = ReportEnv.BuildNumber;
    public static final String TAG_INSTANT = JCliResource.getMessage("CS_LAUNCH_INSTANT");
    public static final String TAG_ONE_TIME = JCliResource.getMessage("CS_LAUNCH_ONE_TIME");
    public static final String TAG_REPEATLY = JCliResource.getMessage("CS_LAUNCH_REPEATEDLY");
    public static final String P_TASK_PUBLISH = JCliResource.getMessage("CS_TASK_TO_RPT");
    public static final String P_TASK_UPDATE = JCliResource.getMessage("CS_TASK_TO_VERSION");
    public static final String P_TASK_DISK = JCliResource.getMessage("CS_TASK_TO_FILE");
    public static final String P_TASK_MAIL = JCliResource.getMessage("CS_TASK_TO_MAIL");
    public static final String P_TASK_PRINT = JCliResource.getMessage("CS_TASK_TO_PRINTER");
    public static final String P_TASK_VALUE_TRIGGER = JCliResource.getMessage("CS_TASK_VALUE_TRIGGER");
    public static final String P_TASK_USER_TASK = JCliResource.getMessage("CS_TASK_TO_USER_TASK");
    public static final String[] P_TASK_TYPE = new String[]{P_TASK_UPDATE, P_TASK_DISK, P_TASK_MAIL, P_TASK_PRINT};
    public static String fileSep = "\\";
    private static final String BuildNumber = "M'/'d'/'yyyy h:mm:ss a";
    private static final String C = "MMM dd',' yyyy";
    private static final String SEDU = "MM'/'dd'/'yy HH:mm";
    private static final String WARNING = "MM'/'dd'/'yy h:mm:ss a";
    public static final String commonDateFormator = "yyyy-MM-dd HH:mm:ss z";
    private static String add;
    private static MessageDigest addElement;
    private static String addURLPath;
    private static String addUrlPaths;
    private static Pattern append;
    private static Pattern appendQry;

    public static String getUrlEncoding() {
        return add;
    }

    public static void appendQry(String string, String string2, StringBuffer stringBuffer) {
        if (string2 != null) {
            stringBuffer.append(CSUtil.replWithEsc(string));
            stringBuffer.append("=");
            stringBuffer.append(CSUtil.replWithEsc(string2));
            stringBuffer.append("&");
        }
    }

    public static String makeQuery(Hashtable hashtable) {
        return CSUtil.makeQuery(hashtable, new StringBuffer("?"));
    }

    public static String makeNoHeadQuery(Hashtable hashtable) {
        return CSUtil.makeQuery(hashtable, null);
    }

    public static String makeQuery(Hashtable hashtable, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            Object object = enumeration.nextElement();
            if (!(object instanceof String) || (object = hashtable.get(string2 = (String)object)) == null) continue;
            if (object instanceof String) {
                string = (String)object;
            } else {
                int n;
                int n2;
                String[] stringArray;
                if (object instanceof List) {
                    stringArray = (String[])object;
                    n2 = stringArray.size();
                    for (n = 0; n < n2; ++n) {
                        string = stringArray.get(n).toString();
                        CSUtil.appendQry(string2, string, stringBuffer2);
                    }
                    continue;
                }
                if (object instanceof String[]) {
                    stringArray = (String[])object;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        string = stringArray[n].toString();
                        CSUtil.appendQry(string2, string, stringBuffer2);
                    }
                    continue;
                }
                string = object.toString();
            }
            CSUtil.appendQry(string2, string, stringBuffer2);
        }
        return stringBuffer2.toString();
    }

    public static String makeQueryToRow(Hashtable hashtable, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("\n");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3;
            Object object = enumeration.nextElement();
            if (!(object instanceof String) || (object = hashtable.get(string3 = (String)object)) == null) continue;
            String string4 = object instanceof String ? (String)object : object.toString();
            if (string3.startsWith("jrs.schd_props")) continue;
            CSUtil.appendQryWithRow(string3, string4, stringBuffer);
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static void appendQryWithRow(String string, String string2, StringBuffer stringBuffer) {
        if (string2 != null && string != null) {
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            stringBuffer.append(LINE);
        }
    }

    public static Properties parseQueryWithTag(String string, String string2) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        String string3 = string.trim();
        if (string3.length() <= 0) {
            return properties;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2, false);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            n = string4.indexOf(61);
            if (n < 0) continue;
            try {
                if (n <= 0) continue;
                string5 = CSUtil.convertEscapes(string4.substring(0, n).trim());
                string6 = n > string4.length() - 1 ? null : CSUtil.convertEscapes(string4.substring(n + 1).trim());
                if (string6 == null) continue;
                properties.put(string5, string6);
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
        }
        return properties;
    }

    public static Properties parseQuery(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        Hashtable hashtable = CSUtil.parseQueryString(string);
        for (String string2 : hashtable.keySet()) {
            String[] stringArray = (String[])hashtable.get(string2);
            if (stringArray == null) continue;
            if (hashtable.get("_isMultiple_" + string2) != null) {
                properties.put(string2, stringArray);
                continue;
            }
            String string3 = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string3 = string3 + ";" + stringArray[i];
            }
            properties.put(string2, string3);
        }
        return properties;
    }

    public static Hashtable parseQueryString(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        String string2 = string.trim();
        if (string2.length() <= 0) {
            return properties;
        }
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&", false);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            n = string3.indexOf(61);
            if (n < 0) continue;
            try {
                if (n <= 0) continue;
                string4 = CSUtil.convertEscapes(string3.substring(0, n).trim());
                string5 = n > string3.length() - 1 ? null : CSUtil.convertEscapes(string3.substring(n + 1).trim());
                if (string5 == null) continue;
                String[] stringArray2 = (String[])((Hashtable)properties).get(string4);
                if (stringArray2 != null) {
                    stringArray = new String[stringArray2.length + 1];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray[i] = stringArray2[i];
                    }
                    stringArray[stringArray2.length] = string5;
                } else {
                    stringArray = new String[]{string5};
                }
                ((Hashtable)properties).put(string4, stringArray);
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
        }
        return properties;
    }

    public static String convertEscapes(String string) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        boolean bl = false;
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        char c = '\u0000';
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '+') {
                bl = true;
                byArray[n2] = 32;
                ++n2;
                continue;
            }
            if (c == '%') {
                bl = true;
                if (i + 2 < n) {
                    try {
                        n3 = Integer.parseInt(string.substring(i + 1, i + 3), 16);
                        byArray[n2] = (byte)n3;
                        ++n2;
                        i += 2;
                    }
                    catch (Exception exception) {
                        byArray[n2] = 37;
                        ++n2;
                    }
                    continue;
                }
                byArray[n2] = 37;
                ++n2;
                continue;
            }
            byArray[n2] = (byte)c;
            ++n2;
        }
        if (!bl) {
            return string;
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i];
        }
        if (add != null) {
            try {
                return new String(byArray2, add);
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
        }
        return new String(byArray2);
    }

    public static String replWithEsc(String string) {
        return CSUtil.replWithEsc(string, true);
    }

    public static String replWithEsc(String string, boolean bl) {
        return CSUtil.replWithEsc(string, bl ? "._-$" : "._-$/");
    }

    public static String replWithEsc(String string, String string2) {
        int n;
        byte[] byArray;
        if (string == null || string.length() == 0) {
            return string;
        }
        if (add != null) {
            try {
                byArray = string.getBytes(add);
            }
            catch (Throwable throwable) {
                byArray = string.getBytes();
            }
        } else {
            byArray = string.getBytes();
        }
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 * 3];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            byte by = byArray[n];
            if (by >= 48 && by <= 57 || by >= 65 && by <= 90 || by >= 97 && by <= 122 || string2 != null && string2.indexOf(by) >= 0) {
                byArray2[n3] = by;
                ++n3;
                continue;
            }
            byArray2[n3] = 37;
            ++n3;
            String string3 = Integer.toHexString(by & 0xFF);
            int n4 = string3.length();
            if (n4 == 1) {
                byArray2[n3] = 48;
                ++n3;
            }
            for (int i = 0; i < n4; ++i) {
                byArray2[n3] = (byte)string3.charAt(i);
                ++n3;
            }
        }
        byArray = new byte[n3];
        for (n = 0; n < n3; ++n) {
            byArray[n] = byArray2[n];
        }
        if (add != null) {
            try {
                return new String(byArray, add);
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
        }
        return new String(byArray);
    }

    public static String replaceSubstrings(String string, String string2, String string3) {
        if (string == null || string.trim().length() == 0 || string2 == null) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        String string4 = string;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = string4.length();
        while (bl) {
            n2 = string4.indexOf(string2, n);
            if (n2 != -1) {
                stringBuffer = stringBuffer.append(string4.substring(n, n2));
                stringBuffer = stringBuffer.append(string3);
                n = n2 + n3;
                if (n != n4) continue;
                bl = false;
                continue;
            }
            stringBuffer = stringBuffer.append(string4.substring(n));
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static int parseInt(String string) {
        return CSUtil.parseInt(string, -1);
    }

    public static int parseInt(String string, int n) {
        int n2 = n;
        if (string != null && string.length() > 0) {
            try {
                n2 = Integer.parseInt(string.trim(), 10);
            }
            catch (Exception exception) {
                n2 = n;
            }
        }
        return n2;
    }

    public static float parseFloat(String string) {
        return CSUtil.parseFloat(string, -1.0f);
    }

    public static float parseFloat(String string, float f) {
        float f2 = f;
        if (string != null && string.length() > 0) {
            try {
                f2 = Float.valueOf(string.trim()).floatValue();
            }
            catch (Exception exception) {
                f2 = f;
            }
        }
        return f2;
    }

    public static long parseLong(String string) {
        return CSUtil.parseLong(string, -1L);
    }

    public static long parseLong(String string, long l) {
        long l2 = l;
        if (string != null && string.length() > 0) {
            try {
                l2 = Long.parseLong(string.trim(), 10);
            }
            catch (Exception exception) {
                l2 = l;
            }
        }
        return l2;
    }

    public static boolean getBoolean(String string) {
        return CSUtil.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string.equalsIgnoreCase("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static String getStdName(String string) {
        String string2 = null;
        if (string != null) {
            File file = new File(string);
            try {
                string2 = file.getCanonicalPath();
                if (file.isDirectory() && !string2.endsWith(fileSep)) {
                    string2 = string2 + fileSep;
                }
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        return string2;
    }

    public static String getNameWithoutExt(String string) {
        return CSUtil.getNameWithoutExt(string, false);
    }

    public static String getNameWithoutExt(String string, boolean bl) {
        String string2 = string;
        String string3 = null;
        if (string != null) {
            String string4;
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string3 = string2.substring(n);
                string2 = string.substring(0, n);
                if ((n = string2.lastIndexOf(fileSep)) >= 0) {
                    string2 = string2.substring(n + 1);
                }
            }
            if (bl && string3 != null && string3.equalsIgnoreCase(".xml") && (n = string2.lastIndexOf(".")) > 0 && ((string4 = string2.substring(n)).equalsIgnoreCase(".cat") || string4.equalsIgnoreCase(".cls"))) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public static String getNodeNameWithoutExt(String string, boolean bl) {
        String string2 = string;
        if (string != null) {
            int n = string.lastIndexOf("/");
            int n2 = string.lastIndexOf(46);
            if (n2 > 0 && n2 > n) {
                String string3;
                String string4 = string2.substring(n2);
                string2 = string.substring(0, n2);
                if (bl && string4.equalsIgnoreCase(".xml") && (n2 = string2.lastIndexOf(".")) > 0 && ((string3 = string2.substring(n2)).equalsIgnoreCase(".cat") || string3.equalsIgnoreCase(".cls"))) {
                    string2 = string2.substring(0, n2);
                }
            }
        }
        return string2;
    }

    public static String removeExtName(String string) {
        int n;
        String string2 = string;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String includeExtName(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            return string;
        }
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string3 = string.substring(n);
        }
        if (!string2.equalsIgnoreCase(string3)) {
            string = string + string2;
        }
        return string;
    }

    public static String getExtName(String string) {
        int n;
        String string2 = string;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            string2 = string.substring(n);
        }
        return string2;
    }

    public static String getExtNameWithoutDot(String string) {
        int n;
        String string2 = string;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static Hashtable parseParamValues(InputStream inputStream) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (inputStream != null) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = null;
            String string3 = null;
            int n = 0;
            while (null != (string = bufferedReader.readLine())) {
                n = string.indexOf(61);
                if (n <= 0) continue;
                string3 = string.substring(n + 1);
                string2 = string.substring(0, n);
                hashtable.put(string2, string3);
                hashtable.put(string2.toUpperCase(), string3);
            }
            bufferedReader.close();
        }
        return hashtable;
    }

    public static synchronized String getH(String string, String string2) {
        addElement.reset();
        addElement.update(string.getBytes());
        if (string2 != null) {
            addElement.update(string2.getBytes());
        }
        byte[] byArray = addElement.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string3 = Integer.toHexString(byArray[i] & 0xFF);
            if (string3.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String removeQuotes(String string) {
        String string2 = string;
        if (string != null && (string2 = string2.trim()).startsWith("\"") && (string2 = string2.substring(1)).endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static void copyHashtable(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable != null && hashtable2 != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                hashtable2.put(k, hashtable.get(k));
            }
        }
    }

    public static Properties htToProp(Hashtable hashtable) {
        Properties properties = null;
        if (hashtable != null) {
            properties = new Properties();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object v;
                Object k = enumeration.nextElement();
                if (!(k instanceof String) || (v = hashtable.get(k)) == null || !(v instanceof String)) continue;
                properties.put((String)k, (String)v);
            }
        }
        return properties;
    }

    public static String[] getPathAndName(String string) {
        String[] stringArray = new String[]{null, null};
        if (string != null) {
            int n;
            int n2 = string.lastIndexOf("/");
            int n3 = n2 = n2 > (n = string.lastIndexOf(fileSep)) ? n2 : n;
            if (n2 > 0) {
                stringArray[0] = string.substring(0, n2);
                stringArray[1] = string.substring(n2 + 1);
            } else if (n2 == 0) {
                stringArray[0] = string.substring(0, 1);
                stringArray[1] = string.substring(1);
            }
        }
        return stringArray;
    }

    public static String getLaunchTypeString(int n) {
        String string = null;
        if (n == 0) {
            string = TAG_INSTANT;
        } else if (n == 1) {
            string = TAG_ONE_TIME;
        } else if (n == 8) {
            string = TAG_REPEATLY;
        }
        return string;
    }

    public static String addUrlPaths(String string, String string2) {
        String string3;
        String string4 = string3 = string == null ? "" : string;
        if (string != null) {
            string3 = string;
            if (!string.endsWith("/")) {
                string3 = string3 + "/";
            }
        }
        if (string3 != null) {
            if (string2 != null) {
                string3 = string2.startsWith("/") ? string3 + string2.substring(1) : string3 + string2;
            }
        } else if (string2 != null) {
            string3 = string2;
        }
        return string3;
    }

    public static Vector toVector(Enumeration enumeration) {
        Vector vector = null;
        if (enumeration != null) {
            vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public static String getDefaultTimeZone() {
        String string = TimeZone.getDefault().getID();
        if (string == null || string.trim().length() == 0 || string.startsWith("?")) {
            try {
                string = System.getProperty("user.timezone");
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
        }
        return string;
    }

    public static Vector parseStringToVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&", false);
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                vector.addElement(CSUtil.convertEscapes(string2));
            }
        }
        return vector;
    }

    public static String convertToAbsPath(File file, File file2) {
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.toString();
        }
        String string2 = null;
        try {
            string2 = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file2.toString();
        }
        int n = string.toLowerCase().indexOf(string2.toLowerCase());
        n = n >= 0 ? (n += string2.length()) : 0;
        string = string.substring(n, string.length());
        if (File.separatorChar != '/') {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != File.separatorChar) continue;
                stringBuffer.setCharAt(i, '/');
            }
            string = stringBuffer.toString();
        }
        if (!string.startsWith("/")) {
            string = '/' + string;
        }
        return CSUtil.escape(string, ":@&=+$,/-_.!~*'()");
    }

    public static String escape(String string, String string2) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || string2.indexOf(c) > 0) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('%');
            int n2 = (c & 0xF0) >>> 4;
            stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
            n2 = c & 0xF;
            stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
        }
        if (stringBuffer.length() == n) {
            return string;
        }
        return stringBuffer.toString();
    }

    public static Vector getElements(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement(stringTokenizer.nextElement());
        }
        return vector;
    }

    public static String composeElements(String[] stringArray, String string) {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= n - 1) continue;
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String composeElements(Vector vector, String string) {
        int n;
        int n2 = n = vector == null ? 0 : vector.size();
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i));
                if (i >= n - 1) continue;
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String VectorToURLEncodedString(Vector vector) {
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            string = (String)vector.elementAt(i);
            if (string == null) continue;
            if (i != 0) {
                stringBuffer.append('&');
            }
            stringBuffer.append(CSUtil.replWithEsc(string));
        }
        return stringBuffer.toString();
    }

    public static Vector parseURLEncodedStringToVector(String string) {
        Vector<String> vector = new Vector<String>(8);
        if (string == null || string.length() <= 0) {
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&", false);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            vector.addElement(CSUtil.convertEscapes(string2));
        }
        return vector;
    }

    public static boolean hasParameter(Hashtable hashtable) throws Exception {
        if (hashtable == null) {
            return false;
        }
        String string = null;
        try {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!string.startsWith("jrs.param$")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
        }
        return false;
    }

    public static String addURLPath(String string, String string2) {
        String string3 = CSUtil.addUrlPaths(CSUtil.escapeURLPathWhenNeed(string), CSUtil.escapeURLPathWhenNeed(string2));
        return string3;
    }

    public static String[] getHostAndPath(String string) {
        int n;
        String string2 = string;
        if (string != null && (n = (string2 = string.trim()).indexOf("://")) >= 0) {
            String string3 = string2.substring(n += 3);
            int n2 = string3.indexOf("/");
            if (n2 >= 0) {
                String string4 = string2.substring(0, n += n2);
                String string5 = string2.substring(n);
                return new String[]{string4, string5};
            }
            return new String[]{CSUtil.formatServerURL(string), ""};
        }
        return new String[]{null, string2};
    }

    public static String[] parseReportURL(String string) throws InvalidReportURLException {
        String string2 = string;
        if (string2 == null) {
            throw new InvalidReportURLException(840001, new String[]{string}, null);
        }
        string2 = CSUtil.BuildNumber(string2);
        int n = string2.lastIndexOf("/");
        if (string2.lastIndexOf("/") == -1) {
            throw new InvalidReportURLException(840001, new String[]{string}, null);
        }
        String[] stringArray = new String[2];
        stringArray[1] = CSUtil.convertEscapes(string2.substring(n + 1));
        stringArray[0] = CSUtil.convertEscapes(string2.substring(0, n));
        return stringArray;
    }

    private static String BuildNumber(String string) {
        String string2 = string;
        if (string != null && string2.endsWith("/")) {
            string2 = string.substring(0, string.length() - 1);
        }
        return string2;
    }

    public static String formatServerURL(String string) {
        String string2 = string;
        if (string != null && !(string2 = string.trim()).endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2;
    }

    public static String escapeURLPath(String string) {
        return CSUtil.C(string, false);
    }

    public static String escapeURLPathWhenNeed(String string) {
        return CSUtil.C(string, true);
    }

    private static String C(String string, boolean bl) {
        String string2 = string;
        if (string != null) {
            string2 = string.trim();
            int n = string2.indexOf("://");
            if (n >= 0) {
                String string3 = string2.substring(n += 3);
                int n2 = string3.indexOf("/");
                if (n2 >= 0) {
                    String string4 = string2.substring(0, n += n2);
                    String string5 = string2.substring(n);
                    if (!bl || CSUtil.needEscape(string5)) {
                        string5 = CSUtil.replWithEsc(string5, false);
                    }
                    string2 = string4 + string5;
                }
            } else {
                String string6 = string2;
                if (!bl || CSUtil.needEscape(string6)) {
                    string6 = CSUtil.replWithEsc(string6, false);
                }
                string2 = string6;
            }
        }
        return string2;
    }

    public static boolean needEscape(String string) {
        String[] stringArray = CSUtil.getHostAndPath(string);
        if (stringArray == null || stringArray[1] == null || stringArray[1].trim().length() == 0) {
            return false;
        }
        return CSUtil.LINE(stringArray[1]);
    }

    private static boolean LINE(String string) {
        String string2 = string;
        if (string2 == null || string2.trim().length() == 0) {
            return false;
        }
        byte[] byArray = string2.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by >= 48 && by <= 57 || by >= 65 && by <= 90 || by >= 97 && by <= 122 || addURLPath.indexOf(by) >= 0) continue;
            if (by == 37) {
                if (i + 2 < n && byArray[i + 1] >= 48 && byArray[i + 1] <= 57 && byArray[i + 2] >= 48 && byArray[i + 2] <= 57) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static String makeReportURL(String string, String string2, String string3) {
        return CSUtil.addURLPath(string, CSUtil.addURLPath(string2, string3));
    }

    public static String getWinDate(Date date) {
        return new SimpleDateFormat(BuildNumber).format(date);
    }

    public static String getWinDateInHead(Date date) {
        return new SimpleDateFormat(C).format(date);
    }

    public static String getSortableWinDate(Date date) {
        return new SimpleDateFormat(SEDU).format(date);
    }

    public static String getWinDateWithSec(Date date) {
        return new SimpleDateFormat(WARNING).format(date);
    }

    public static String getTimeElapseString(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        return (l3 > 0L ? String.valueOf(l3) + "' " : "") + String.valueOf(l2 % 60L) + "\"";
    }

    public static int getResultType(String string, int n) {
        int n2 = CSUtil.parseInt(string, -9999);
        if (n2 == -9999) {
            n2 = string != null && string.length() > 1 ? CSUtil.parseInt(string.substring(string.length() - 1), n) : n;
        }
        return n2;
    }

    public static String getFileNameOnly(String string) {
        String string2 = string;
        if (string != null) {
            string2 = string;
            if (string.equalsIgnoreCase(File.separator)) {
                string2 = File.separator;
            } else if (string2.lastIndexOf(File.separator) >= 0) {
                string2 = string2.substring(string2.lastIndexOf(File.separator) + 1);
            }
        }
        return string2;
    }

    public static String getFileNameWithoutDir(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string;
            if (string2.indexOf(File.separator) > 0) {
                return CSUtil.getFileNameOnly(string2);
            }
            if (string.equalsIgnoreCase("/")) {
                string2 = "/";
            } else {
                if (string2.length() == string2.lastIndexOf("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string2.lastIndexOf("/") > 0) {
                    string2 = string2.substring(string2.lastIndexOf("/"));
                }
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
            }
        }
        return string2;
    }

    public static String[] getLogicalFolderAndName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string;
        if (string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        String[] stringArray = new String[]{null, null};
        if (string2.indexOf("/") < 0) {
            stringArray[0] = "";
            stringArray[1] = string;
        } else {
            int n = string2.lastIndexOf("/");
            if (n == 0) {
                stringArray[0] = "";
                if (string2.length() > 1) {
                    stringArray[1] = string2.substring(1);
                }
            } else if (n > 0) {
                stringArray[0] = string2.substring(0, n);
                if (n < string2.length() + 1) {
                    stringArray[1] = string2.substring(n + 1);
                }
            }
        }
        return stringArray;
    }

    public static void copyAllFiles(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                Object object2;
                if (!fileArray[i].isDirectory()) {
                    object2 = new FileInputStream(fileArray[i].toString());
                    object = new FileOutputStream(string2 + File.separator + fileArray[i].getName());
                    byte[] byArray = new byte[((FileInputStream)object2).available()];
                    ((FileInputStream)object2).read(byArray);
                    ((FileOutputStream)object).write(byArray);
                    ((FileInputStream)object2).close();
                    ((FileOutputStream)object).close();
                    continue;
                }
                object2 = string2 + File.separator + fileArray[i].getName();
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                CSUtil.copyAllFiles(fileArray[i].getPath(), (String)object2);
            }
        }
    }

    public static String writeFileToString(File file) {
        if (file == null) {
            return null;
        }
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = ((InputStream)fileInputStream).read();
            while (n > 0) {
                string = string == null ? String.valueOf((char)n) : string + (char)n;
                n = ((InputStream)fileInputStream).read();
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING((Throwable)iOException);
        }
        return string;
    }

    public static String checkExt(String string, String string2) {
        int n = string.lastIndexOf(".");
        String string3 = string.substring(n + 1);
        if (n >= 0 && string3.equalsIgnoreCase(string2)) {
            return string;
        }
        return string + "." + string2;
    }

    public static String readStringFromFile(File file) {
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[((InputStream)fileInputStream).available()];
            if (byArray != null) {
                ((InputStream)fileInputStream).read(byArray);
                string = new String(byArray);
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING((Throwable)iOException);
        }
        return string;
    }

    public static boolean writeStringToFile(String string, File file) {
        if (file == null) {
            return false;
        }
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(string.getBytes());
            ((OutputStream)fileOutputStream).close();
            bl = true;
        }
        catch (IOException iOException) {
            JDebug.WARNING((Throwable)iOException);
        }
        return bl;
    }

    public static int compareIgnoreCase(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        int n = string3.length();
        int n2 = string4.length();
        int n3 = 0;
        for (int i = 0; n3 < n && i < n2; ++n3, ++i) {
            char c;
            char c2 = string3.charAt(n3);
            if (c2 == (c = string4.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static boolean isValidNodeName(String string) {
        if (string == null || string.length() == 0 || string.length() > 256) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '_' || c == '-' || c == '~' || c == '.' || c == '(' || c == ')') continue;
            return false;
        }
        return true;
    }

    public static void deleteUploadedFiles(String string) throws SecurityException {
        if (string == null) {
            return;
        }
        CSUtil.deleteFolderTree(new File(string));
    }

    public static void deleteFolderTree(File file) throws SecurityException {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                CSUtil.deleteFolderTree(fileArray[i]);
            }
            file.delete();
        }
    }

    public static Vector[] getRptRelatedFiles(String string) throws SecurityException {
        if (string == null || string.length() == 0) {
            return null;
        }
        Vector[] vectorArray = new Vector[3];
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            vectorArray[0] = new Vector();
            vectorArray[1] = new Vector();
            vectorArray[2] = new Vector();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!CSUtil.isValidNodeName(stringArray[i])) continue;
                String string2 = string + stringArray[i];
                if (CSUtil.isReportFile(string2)) {
                    vectorArray[0].addElement(string2);
                    continue;
                }
                if (CSUtil.isCatalogFile(string2)) {
                    vectorArray[1].addElement(string2);
                    continue;
                }
                File file2 = new File(string2);
                if (!file2.exists() || !file2.isDirectory()) continue;
                vectorArray[2].addElement(string2);
            }
            if (vectorArray[0].size() > 0 || vectorArray[1].size() > 0 || vectorArray[2].size() > 0) {
                return vectorArray;
            }
        }
        return null;
    }

    public static Vector[] getLcRelatedFiles(String string) throws SecurityException {
        if (string == null || string.length() == 0) {
            return null;
        }
        Vector[] vectorArray = new Vector[3];
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            vectorArray[0] = new Vector();
            vectorArray[1] = new Vector();
            vectorArray[2] = new Vector();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!CSUtil.isValidNodeName(stringArray[i])) continue;
                String string2 = string + stringArray[i];
                if (CSUtil.isLCFile(string2)) {
                    vectorArray[0].addElement(string2);
                    continue;
                }
                if (CSUtil.isCatalogFile(string2)) {
                    vectorArray[1].addElement(string2);
                    continue;
                }
                File file2 = new File(string2);
                if (!file2.exists() || !file2.isDirectory()) continue;
                vectorArray[2].addElement(string2);
            }
            if (vectorArray[0].size() > 0 || vectorArray[1].size() > 0 || vectorArray[2].size() > 0) {
                return vectorArray;
            }
        }
        return null;
    }

    public static boolean isReportFile(String string) {
        if (string == null) {
            return false;
        }
        return CSUtil.isOrdinaryReportFile(string);
    }

    public static boolean isOrdinaryReportFile(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        if (string2.endsWith(".dsh") || string2.endsWith(".va")) {
            return true;
        }
        int n = Env.getFileType((String)string);
        return n == 6 || n == 9;
    }

    public static boolean isCatalogFile(String string) {
        if (string == null) {
            return false;
        }
        return Env.getFileType((String)string) == 1;
    }

    public static boolean isLCFile(String string) {
        if (string == null) {
            return false;
        }
        return string.endsWith(".lc");
    }

    public static String getResourceType(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) > -1) {
            return string.substring(n + 1).toUpperCase();
        }
        return null;
    }

    public static String toDateTimeString(Date date, String string) {
        return CSUtil.toDateTimeString(date, string == null ? TimeZone.getDefault() : TimeZone.getTimeZone(string));
    }

    public static String toDateTimeString(Date date, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(addUrlPaths);
        simpleDateFormat.setTimeZone(timeZone == null ? TimeZone.getDefault() : timeZone);
        return simpleDateFormat.format(date == null ? new Date() : date);
    }

    public static Object getHashtableValue(Hashtable hashtable, Object object, boolean bl) {
        if (hashtable != null && object != null) {
            if (bl) {
                return hashtable.remove(object);
            }
            return hashtable.get(object);
        }
        return null;
    }

    public static void appendScript(Vector vector, Hashtable hashtable, Object object, boolean bl, boolean bl2) {
        Object object2 = CSUtil.getHashtableValue(hashtable, object, bl2);
        if (bl && object2 != null && vector != null && object != null && (object2 instanceof String || object2 instanceof String[])) {
            String[] stringArray = object2 instanceof String ? new String[]{(String)object2} : (String[])object2;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if ((string = string.replaceAll("\\r", "\\\\")).endsWith("\\")) {
                    string = string.substring(0, string.length() - 1);
                }
                vector.add((String)object + "=" + string);
            }
        }
    }

    public static boolean isUserTask(String string) {
        if (string == null) {
            return false;
        }
        return !string.equals("jet.server.schedule.jrtasks.PublishRptTask") && !string.equals("jet.server.schedule.jrtasks.PublishToDiskTask") && !string.equals("jet.server.schedule.jrtasks.SendJRMailTask") && !string.equals("jet.server.schedule.jrtasks.PrintRptTask") && !string.equals("jet.server.schedule.jrtasks.ValueTriggerTask") && !string.equals("jet.server.schedule.jrtasks.SendMailTask") && !string.equals("jet.server.schedule.jrtasks.UpdateRptTask");
    }

    public static String addExt(String string, String string2) {
        String string3;
        String string4 = string.toLowerCase();
        if (string4.endsWith(string3 = string2.toLowerCase())) {
            return string;
        }
        return string + "." + string2;
    }

    public static boolean isNumeric(String string) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static Vector getFTPs(Hashtable hashtable) {
        return CSUtil.getFTPs(hashtable, false);
    }

    public static Vector getFTPs(Hashtable hashtable, boolean bl) {
        boolean bl2 = false;
        Vector<Properties> vector = new Vector<Properties>();
        bl2 = bl ? CSUtil.getBoolean((String)hashtable.get("jrs.nonbursting$jrs.to_FTP")) : CSUtil.getBoolean((String)hashtable.get("jrs.to_FTP"));
        if (bl2 && hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                Object object = enumeration.nextElement();
                if (!(object instanceof String) || !((object = hashtable.get(string = (String)object)) instanceof String)) continue;
                String string2 = (String)object;
                if (bl) {
                    if (string2.trim().length() <= 0 || !string.startsWith("jrs.nonbursting$jrs.ftp")) continue;
                    vector.addElement(CSUtil.parseQuery(string2));
                    continue;
                }
                if (string2.trim().length() <= 0 || !string.startsWith("jrs.ftp")) continue;
                vector.addElement(CSUtil.parseQuery(string2));
            }
        }
        return vector;
    }

    public static Properties toProperties(Vector vector, Properties properties) {
        return CSUtil.toProperties(vector, properties, false);
    }

    public static Properties toProperties(Vector vector, Properties properties, boolean bl) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string;
                Object e = vector.elementAt(i);
                if (e == null || (string = CSUtil.makeNoHeadQuery((Hashtable)e)) == null || string.trim().length() <= 0) continue;
                if (bl) {
                    properties2.put("jrs.nonbursting$jrs.ftp" + i, string);
                    continue;
                }
                properties2.put("jrs.ftp" + i, string);
            }
        }
        return properties2;
    }

    public static String[] parsePrincipalDisplayName(String string) {
        String string2;
        String string3;
        if (string == null) {
            return new String[2];
        }
        int n = string.lastIndexOf("\\");
        int n2 = "\\".length();
        if (n < 0) {
            string3 = null;
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.length() > n + n2 ? string.substring(n + n2) : "";
        }
        string3 = string3 == null || string3.isEmpty() ? null : string3;
        return new String[]{string3, string2};
    }

    public static String getPrincipalDisplayName(String string, String string2) {
        return string == null || string.isEmpty() ? string2 : string + "\\" + string2;
    }

    public static boolean isBelongOrganization(String string) {
        if (string != null) {
            return string.indexOf("\\") >= 0;
        }
        return false;
    }

    public static String[] parseVirtualResourcePath(String string) {
        if (string == null) {
            return new String[2];
        }
        String[] stringArray = new String[2];
        Matcher matcher = append.matcher(string);
        if (matcher.lookingAt() && matcher.start() == 0) {
            int n = matcher.end();
            stringArray[0] = string.substring(2, n - 2);
            stringArray[1] = string.substring(n - 1);
        } else {
            matcher = appendQry.matcher(string);
            if (matcher.lookingAt() && matcher.start() == 0) {
                int n = matcher.end();
                stringArray[0] = string.substring(2, n - 2);
                stringArray[1] = string.substring(n - 1);
            } else {
                stringArray[1] = string;
            }
        }
        return stringArray;
    }

    public static String getVirtualResourcePathPrefix(String string) {
        if (string != null && string.trim().length() > 0) {
            return "/<" + string + ">";
        }
        return "";
    }

    static {
        try {
            fileSep = System.getProperty("file.separator");
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
        add = null;
        String string = null;
        try {
            string = System.getProperty("jreport.url.encoding");
            if (string == null || string.trim().length() == 0) {
                System.setProperty("jreport.url.encoding", "UTF-8");
                string = "UTF-8";
            }
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
        if (string != null && string.length() > 0) {
            try {
                "0".getBytes(string);
                add = string;
            }
            catch (Throwable throwable) {
                add = "UTF-8";
                JDebug.WARNING((Throwable)throwable);
            }
        }
        addElement = null;
        try {
            addElement = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            JDebug.WARNING((Throwable)noSuchAlgorithmException);
        }
        addURLPath = "._-$/";
        addUrlPaths = "EEE MMM d HH:mm:ss z yyyy";
        append = Pattern.compile("^/<\\w(\\w|\\s)+\\w>/");
        appendQry = Pattern.compile("^/<\\w{1,2}>/");
    }
}

