/*
 * Decompiled with CFR 0.152.
 */
package jet.cs;

import guitools.toolkit.JDebug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jet.ReportEnv;
import jet.cs.CSUtil;

public class ExProperties
extends Properties {
    protected int BuildNumber = 0;
    public static String BUILDNUMBER = "BuildNumber";

    public ExProperties() {
    }

    public ExProperties(Properties properties) {
        super(properties);
    }

    public int getBuildNumber() {
        return this.BuildNumber;
    }

    public void updateBuildNumber() {
        this.BuildNumber = ReportEnv.BuildNumber;
        this.setProperty(BUILDNUMBER, this.BuildNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) throws IOException {
        IOException iOException = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        try {
            this.load(bufferedInputStream);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            bufferedInputStream.close();
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        this.BUILDNUMBER(inputStream);
        try {
            this.BuildNumber = this.getProperty(BUILDNUMBER, -1);
        }
        catch (NumberFormatException numberFormatException) {
            this.BuildNumber = -1;
        }
    }

    public void load(File file) throws IOException {
        this.load(file.getPath());
    }

    public void save(String string, String string2) throws IOException {
        this.backUpAndSave(string, string2);
    }

    @Override
    public void save(OutputStream outputStream, String string) {
        this.saveTo(outputStream, string);
    }

    public void save(File file, String string) throws IOException {
        this.save(file.getPath(), string);
    }

    public void merge(ExProperties exProperties) {
        Enumeration<?> enumeration = exProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.put(string, exProperties.getProperty(string));
        }
    }

    public void replace(ExProperties exProperties) {
        Enumeration<?> enumeration = exProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.containsKey(string)) continue;
            this.put(string, exProperties.getProperty(string));
        }
    }

    public void delete(ExProperties exProperties) {
        Enumeration<?> enumeration = exProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.remove(string);
        }
    }

    public int getProperty(String string, int n) throws NumberFormatException {
        String string2 = this.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    public long getProperty(String string, long l) throws NumberFormatException {
        String string2 = this.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            return Long.parseLong(string2);
        }
        return l;
    }

    public boolean getProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            return string2.equals("true");
        }
        return bl;
    }

    @Override
    public Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public void setProperty(String string, int n) {
        this.put(string, "" + n);
    }

    public void setProperty(String string, long l) {
        this.put(string, "" + l);
    }

    public void setProperty(String string, boolean bl) {
        this.put(string, bl ? "true" : "false");
    }

    private void BUILDNUMBER(InputStream inputStream) throws IOException {
        String string;
        LineNumberReader lineNumberReader = CSUtil.getUrlEncoding() != null ? new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream, CSUtil.getUrlEncoding()))) : new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1")));
        while ((string = this.BuildNumber(lineNumberReader)) != null) {
            int n;
            String string2 = null;
            String string3 = null;
            if (string.startsWith("#") || (n = string.indexOf("=")) == -1) continue;
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1, string.length());
            if (string2 == null || string3 == null) continue;
            this.put(string2, string3.trim());
        }
    }

    private String BuildNumber(LineNumberReader lineNumberReader) throws IOException {
        String string = this.readLine(lineNumberReader);
        if (string == null) {
            return string;
        }
        if (string.startsWith("#")) {
            return string;
        }
        while (string.endsWith("\\")) {
            String string2 = this.readLine(lineNumberReader);
            if (string2 == null) {
                return string;
            }
            string = string.substring(0, string.length() - 1) + string2.trim();
        }
        return string;
    }

    protected void saveTo(OutputStream outputStream, String string) {
        try {
            PrintWriter printWriter = CSUtil.getUrlEncoding() != null ? new PrintWriter(new OutputStreamWriter(outputStream, CSUtil.getUrlEncoding())) : new PrintWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
            Enumeration<Object> enumeration = this.keys();
            if (string != null && string.length() != 0) {
                this.writeLine(printWriter, "# " + string);
            }
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)this.get(string2);
                if (string3.endsWith("\\")) {
                    string3 = string3 + " ";
                }
                this.writeLine(printWriter, string2 + "=" + string3);
            }
            this.writeLine(printWriter, "");
            printWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDebug.WARNING((Throwable)unsupportedEncodingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backUpAndSave(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string + ".bak");
        IOException iOException = null;
        if (file.exists()) {
            file2.delete();
            file.renameTo(file2);
            file2 = new File(string + ".bak");
        }
        if (!file2.exists()) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            this.saveTo(bufferedOutputStream, string2);
            bufferedOutputStream.close();
            return;
        }
        LineNumberReader lineNumberReader = CSUtil.getUrlEncoding() != null ? new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), CSUtil.getUrlEncoding()))) : new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "ISO-8859-1")));
        BufferedWriter bufferedWriter = CSUtil.getUrlEncoding() != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), CSUtil.getUrlEncoding())) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "ISO-8859-1"));
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        try {
            Object object;
            String string3;
            String string4;
            Hashtable hashtable = (Hashtable)this.clone();
            if (string2 != null && string2.length() == 0) {
                this.writeLine(printWriter, "# " + string2);
                this.writeLine(printWriter, "");
            }
            while ((string4 = this.BuildNumber(lineNumberReader)) != null) {
                int n;
                if (!(string4.equals("") || string4.equals("\n") || string4.startsWith("#") || (n = string4.indexOf("=")) == -1)) {
                    string3 = string4.substring(0, n);
                    object = string4.substring(n + 1, string4.length()).trim();
                    if (string3 != null && object != null) {
                        if (this.containsKey(string3)) {
                            hashtable.remove(string3);
                            object = (String)this.get(string3);
                            if (((String)object).endsWith("\\")) {
                                object = (String)object + " ";
                            }
                            string4 = string3 + "=" + (String)object;
                        } else {
                            string4 = "";
                        }
                    }
                }
                if (!string4.equals("")) {
                    this.writeLine(printWriter, string4);
                }
                printWriter.flush();
            }
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string5 = (String)object.nextElement();
                string3 = (String)this.get(string5);
                if (string3.endsWith("\\")) {
                    string3 = string3 + " ";
                }
                this.writeLine(printWriter, string5 + "=" + string3);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            lineNumberReader.close();
            printWriter.close();
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    protected String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        return string;
    }

    protected void writeLine(PrintWriter printWriter, String string) {
        printWriter.println(string);
    }
}

