/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.JCliResource;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.cs.FileNameFromTemplate;
import jet.cs.JRMail;
import jet.cs.QuickSort;
import jet.export.pdf.SignatureTools;
import jet.util.EncodingSupport;
import jet.util.HeadlessHelper;

public class APIUtil {
    private static Hashtable SEDU = new Hashtable();

    private APIUtil() {
    }

    public static int parseInt(String string) {
        return CSUtil.parseInt(string);
    }

    public static int parseInt(String string, int n) {
        return CSUtil.parseInt(string, n);
    }

    public static long parseLong(String string) {
        return CSUtil.parseLong(string);
    }

    public static long parseLong(String string, int n) {
        return CSUtil.parseLong(string, n);
    }

    public static long parseLong(String string, long l) {
        return CSUtil.parseLong(string, l);
    }

    public static double parseDouble(String string, double d) {
        double d2 = d;
        if (string != null && string.length() > 0) {
            try {
                d2 = Double.valueOf(string.trim());
            }
            catch (Exception exception) {
                d2 = d;
            }
        }
        return d2;
    }

    public static boolean getBoolean(String string) {
        return CSUtil.getBoolean(string);
    }

    public static boolean getBoolean(String string, boolean bl) {
        return CSUtil.getBoolean(string, bl);
    }

    public static String getDefaultTimeZone() {
        return CSUtil.getDefaultTimeZone();
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        if (throwable != null) {
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public static String toDateTimeString(Date date, TimeZone timeZone) {
        return CSUtil.toDateTimeString(date, timeZone);
    }

    public static String toWinDateString(Date date) {
        return CSUtil.getWinDate(date);
    }

    public static String toSortableWinDateString(Date date) {
        return CSUtil.getSortableWinDate(date);
    }

    public static String toWinDateStringShowing(Date date) {
        return CSUtil.getWinDateInHead(date);
    }

    public static String toWinDateSecondString(Date date) {
        return CSUtil.getWinDateWithSec(date);
    }

    public static String getTimeElapseString(long l) {
        return CSUtil.getTimeElapseString(l);
    }

    public static String getLaunchTypeString(int n) {
        return CSUtil.getLaunchTypeString(n);
    }

    public static String getDisplayNameOfTask(String string) {
        try {
            return CustomTaskManager.getDisplayName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Hashtable parseParamValues(InputStream inputStream) throws IOException {
        return CSUtil.parseParamValues(inputStream);
    }

    public static String addUrlPath(String string, String string2) {
        return CSUtil.addUrlPaths(string, string2);
    }

    public static String addUrlPaths(String string, String string2) {
        return CSUtil.addURLPath(string, string2);
    }

    public static String convertToAbsPath(File file, File file2) {
        return CSUtil.convertToAbsPath(file, file2);
    }

    public static String[] getPathAndName(String string) {
        return CSUtil.getPathAndName(string);
    }

    public static String VectorToURLEncodedString(Vector vector) {
        return CSUtil.VectorToURLEncodedString(vector);
    }

    public static void transferJRMailProperties(Properties properties) {
        Vector<JRMail> vector = new Vector<JRMail>(1);
        vector.addElement(new JRMail(properties));
        JRMail.toProperties(vector, properties);
    }

    public static Properties makeMailProperty(Properties properties, boolean bl) {
        Vector<CSMail> vector = new Vector<CSMail>(1);
        vector.addElement(bl ? new CSMail(properties) : new JRMail(properties));
        return JRMail.toProperties(vector, properties);
    }

    public static String[][] getSupportedEncodings() {
        return EncodingSupport.encodings;
    }

    public static String[] getSupportedEncodingNames() {
        return EncodingSupport.getSupportedEncodingNames();
    }

    public static String[] getSupportedEncodingDescriptions() {
        return EncodingSupport.getSupportedEncodingDescriptions();
    }

    public static String getEncodingNameByDescription(String string) {
        return EncodingSupport.getEncodingNameByDescription((String)string);
    }

    public static String getEncodingDescriptionByName(String string) {
        return EncodingSupport.getEncodingDescriptionByName((String)string);
    }

    public static String getExtName(String string) {
        return CSUtil.getExtName(string);
    }

    public static String removeExtName(String string) {
        return CSUtil.removeExtName(string);
    }

    public static String getNameWithoutExt(String string) {
        return CSUtil.getNameWithoutExt(string);
    }

    public static String getNameWithoutExt(String string, boolean bl) {
        return CSUtil.getNameWithoutExt(string, bl);
    }

    public static String getNodeNameWithoutExt(String string, boolean bl) {
        return CSUtil.getNodeNameWithoutExt(string, bl);
    }

    public static String getFileNameWithoutDir(String string) {
        return CSUtil.getFileNameWithoutDir(string);
    }

    public static boolean checkFileNameWithTemplate(String string) {
        if (string != null && string.trim().length() > 0) {
            return FileNameFromTemplate.checkFileNameWithTemplate(string);
        }
        return false;
    }

    public static String writeFileToString(File file) {
        return CSUtil.writeFileToString(file);
    }

    public static Properties parseQuery(String string) {
        return CSUtil.parseQuery(string);
    }

    public static String escapeHtmlSpecialChars(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    bl = true;
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    bl = true;
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    bl = true;
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    bl = true;
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return bl ? stringBuffer.toString() : string;
    }

    public static Vector sortAsCol(Vector vector, Vector vector2, boolean bl) {
        return QuickSort.sort(vector, vector2, bl);
    }

    public static String[][] sortAsCol(String[][] stringArray, int n, int n2) {
        block12: {
            int n3;
            int[][] nArray;
            block11: {
                int n4 = stringArray.length;
                if (n4 < 2) {
                    return stringArray;
                }
                int n5 = n4 / 2;
                nArray = new int[n5][2];
                n3 = 0;
                nArray[0][0] = 0;
                nArray[0][1] = n4 - 1;
                if (n2 != 0) break block11;
                while (n3 >= 0) {
                    int n6;
                    int n7;
                    int n8 = n7 = nArray[n3][0];
                    int n9 = n6 = nArray[n3][1];
                    --n3;
                    if (n8 >= n9) continue;
                    String string = stringArray[(n8 + n9) / 2][n].toLowerCase();
                    while (n7 <= n6) {
                        while (n7 < n9 && stringArray[n7][n].toLowerCase().compareTo(string) < 0) {
                            ++n7;
                        }
                        while (n6 > n8 && stringArray[n6][n].toLowerCase().compareTo(string) > 0) {
                            --n6;
                        }
                        if (n7 > n6) continue;
                        String[] stringArray2 = stringArray[n7];
                        stringArray[n7] = stringArray[n6];
                        stringArray[n6] = stringArray2;
                        ++n7;
                        --n6;
                    }
                    if (n8 < n6) {
                        nArray[++n3][0] = n8;
                        nArray[n3][1] = n6;
                    }
                    if (n7 >= n9) continue;
                    nArray[++n3][0] = n7;
                    nArray[n3][1] = n9;
                }
                break block12;
            }
            if (n2 != 1) break block12;
            while (n3 >= 0) {
                int n10;
                int n11;
                int n12 = n11 = nArray[n3][0];
                int n13 = n10 = nArray[n3][1];
                --n3;
                if (n12 >= n13) continue;
                String string = stringArray[(n12 + n13) / 2][n].toLowerCase();
                while (n11 <= n10) {
                    while (n11 < n13 && stringArray[n11][n].toLowerCase().compareTo(string) > 0) {
                        ++n11;
                    }
                    while (n10 > n12 && stringArray[n10][n].toLowerCase().compareTo(string) < 0) {
                        --n10;
                    }
                    if (n11 > n10) continue;
                    String[] stringArray3 = stringArray[n11];
                    stringArray[n11] = stringArray[n10];
                    stringArray[n10] = stringArray3;
                    ++n11;
                    --n10;
                }
                if (n12 < n10) {
                    nArray[++n3][0] = n12;
                    nArray[n3][1] = n10;
                }
                if (n11 >= n13) continue;
                nArray[++n3][0] = n11;
                nArray[n3][1] = n13;
            }
        }
        return stringArray;
    }

    public static String getPublishRptTaskDisplayName(Hashtable hashtable) {
        String string = (String)hashtable.get("jrs.task_class");
        if (string != null && string.equals("jet.server.schedule.jrtasks.PublishRptTask")) {
            string = "";
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_version"), false)) {
                string = "CS_MSG_203";
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_disk"), false)) {
                if (!string.equals("")) {
                    string = string + ",";
                }
                string = string + "CS_MSG_204";
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_mail"), false)) {
                if (!string.equals("")) {
                    string = string + ",";
                }
                string = string + "CS_MSG_205";
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_FTP"), false)) {
                if (!string.equals("")) {
                    string = string + ",";
                }
                string = string + "CS_MSG_251";
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_printer"), false)) {
                if (!string.equals("")) {
                    string = string + ",";
                }
                string = string + "CS_MSG_206";
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.to_fax"), false)) {
                if (!string.equals("")) {
                    string = string + ",";
                }
                string = string + "CS_MSG_283";
            }
        }
        return string;
    }

    public static boolean isValidEmailAddress(String string) {
        int n = 0;
        int n2 = 0;
        n = string.indexOf("@");
        n2 = string.lastIndexOf(".");
        return n > 0 && n <= n2 && n2 != string.length() - 1 && n2 != n + 1;
    }

    public static boolean isValidNodeName(String string) {
        return CSUtil.isValidNodeName(string);
    }

    public static int[] getYearMonthDate(Date date) {
        int[] nArray = new int[]{-1, -1, -1};
        nArray[0] = date.getYear() + 1900;
        nArray[1] = date.getMonth() + 1;
        nArray[2] = date.getDate();
        return nArray;
    }

    public static void deleteDirectory(String string) throws SecurityException {
        CSUtil.deleteUploadedFiles(string);
    }

    public static Vector[] getRptRelatedFiles(String string) throws SecurityException {
        return CSUtil.getRptRelatedFiles(string);
    }

    public static Vector[] getLcRelatedFiles(String string) throws Exception {
        return CSUtil.getLcRelatedFiles(string);
    }

    public static boolean isReportFile(String string) {
        return CSUtil.isReportFile(string);
    }

    public static boolean isCatalogFile(String string) {
        return CSUtil.isCatalogFile(string);
    }

    public static boolean isLCFile(String string) {
        return CSUtil.isLCFile(string);
    }

    public static String[] getLogicalFolderAndName(String string) {
        return CSUtil.getLogicalFolderAndName(string);
    }

    public static void putTempValueToHt(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        SEDU.put(string, string2);
    }

    public static Object getTempValueFromHt(String string) {
        return SEDU.get(string);
    }

    public static void removeTempValueInHt(String string) {
        SEDU.remove(string);
    }

    public static String checkDigitalIDFileAndPassword(InputStream inputStream, String string) {
        int n = SignatureTools.checkDigitalIDFileAndPassword((InputStream)inputStream, (String)string);
        String string2 = null;
        if (n == 102) {
            string2 = JCliResource.getMessage("CS_MSG_240");
        } else if (n == 101) {
            string2 = JCliResource.getMessage("CS_MSG_241");
        } else if (n == 100) {
            string2 = null;
        }
        return string2;
    }

    public static int getScreenResolution() {
        return HeadlessHelper.getScreenResolution();
    }

    public static boolean isLCResource(String string) {
        return string != null && string.startsWith("/COMPONENT_LIB");
    }

    public static String[] getServerDateFormats() {
        return APIUtil.getDateFormats();
    }

    public static String[] getServerTimeFormats() {
        return APIUtil.getTimeFormats();
    }

    public static String[] getDateFormats() {
        String[] stringArray = new String[]{"M/d/yyyy", "MM/dd/yy", "MM/dd/yyyy", "yyyy-MM-dd", "yy-MM-dd", "MMMMM d, yyyy", "yy", "yyyy", "M", "MMM", "MMMMM", "dd"};
        return stringArray;
    }

    public static String[] getTimeFormats() {
        String[] stringArray = new String[]{"h:mm:ss a", "hh:mm:ss", "hh:mm a", "hh:mm:ss a", "HH:mm", "HH"};
        return stringArray;
    }

    public static String[] getTimestampFormats() {
        String[] stringArray = new String[]{"M/d/yyyy h:mm:ss a", "M/dd/yy", "MM/dd/yy", "MM/dd/yyyy", "yyyy-MM-dd", "yy-MM-dd", "MMMMM d, yyyy", "hh:mm:ss", "hh:mm a", "h:mm:ss a", "hh:mm:ss a", "yyyy-MM-dd hh:mm:ss", "MM/dd/yyyy hh:mm:ss a", "yy", "yyyy", "M", "MMM", "MMMMM", "dd", "HH"};
        return stringArray;
    }

    public static boolean isValidFormat(String string) {
        char[] cArray;
        if (null == string || string.length() == 0) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            switch (c) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'X': 
                case 'Y': 
                case 'b': 
                case 'c': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'i': 
                case 'j': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'x': {
                    return false;
                }
            }
        }
        return true;
    }

    public static String[] parsePrincipalDisplayName(String string) {
        return CSUtil.parsePrincipalDisplayName(string);
    }

    public static boolean isBelongToOrganization(String string) {
        return CSUtil.isBelongOrganization(string);
    }

    public static String getPrincipalDisplayName(String string, String string2) {
        return CSUtil.getPrincipalDisplayName(string, string2);
    }

    public static String getVirtualResourcePathPrefix(String string) {
        return CSUtil.getVirtualResourcePathPrefix(string);
    }

    public static String[] parseVirtualResourcePath(String string) {
        return CSUtil.parseVirtualResourcePath(string);
    }
}

