/*
 * Decompiled with CFR 0.152.
 */
package jet.server;

import com.jinfonet.util.JRLog;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.ShutdownThread;
import jet.server.log.ServiceLogger;
import jet.server.util.SCMEvent;
import jet.server.util.SCMEventListener;
import jet.server.util.SCMEventManager;
import jet.util.NullStream;
import server.servlet.http.HttpAdminServer;
import server.servlet.http.HttpDashboardServer;
import server.servlet.http.HttpServer;
import server.servlet.http.HttpServerBase;

public class JREntServer
implements SCMEventListener {
    private static boolean SEDU = false;
    private static HttpServer addSCMEventListener = null;
    private static HttpAdminServer append = null;

    protected static void help() {
        PrintStream printStream = System.err;
        printStream.println("Usage: srun [options]");
        printStream.println("Options:");
        printStream.println("  -?                print this help message");
        printStream.println("  -p port           the port number to listen on");
        printStream.println("  -ap adminport    the port number administration tools used");
        printStream.println("  -realm realmname  active realm");
        printStream.println("  -l backlog        maximum queue length for incoming connection indications");
        printStream.println("  -m max            maximum number of connection handlers");
        printStream.println("  -t timeout        connection timeout in milliseconds");
        printStream.println("  -s filename       servlet property file name");
        printStream.println("  -web directory    root directory when access via web, default value is %install_root%\\public_html");
        printStream.println("  -env              print environment");
        printStream.println("  -silent           output nothing");
        printStream.println("  -local            administration on local host only");
        printStream.println("  -vDebug           Enables JReport Engine to output messages to a file and sets engine log file's trace level to INFO and error level to WARN. ");
        printStream.println("  -vError           Enables JReport Engine to output messages to a file and sets engine log file's trace level to OFF and error level to ERROR.");
        printStream.println("  -logall           set all logger's trace level to INFO and error level to WARN.");
        printStream.println("  -jrs.admin.server");
        printStream.println("       [host:port]  admin server's host and RMI port");
        printStream.println("  -cleanup          check integrality of server data and cleanup invalid data");
        System.exit(1);
    }

    protected static void printEnv() {
        System.out.println("Java VM: " + System.getProperty("java.version"));
        System.out.println("Java home: " + System.getProperty("java.home"));
        System.out.println("Server port: " + ServerEnv.getPort());
        System.out.println("Administration port: " + ServerEnv.getAdminPort());
        System.out.println("Active realm: " + ServerEnv.getActiveRealm());
        System.out.println("Maximum connection handlers: " + addSCMEventListener.getMaxHandlers());
        System.out.println("Connection timeout(ms): " + addSCMEventListener.getTimeout());
        System.out.println("Maximum connection queue length: " + addSCMEventListener.getBacklog());
        if (SEDU) {
            System.out.println("Administration on local host only");
        }
    }

    public static synchronized void shutdownServer() {
        if (addSCMEventListener != null) {
            addSCMEventListener.quitWithoutExit();
            addSCMEventListener = null;
        }
        if (append != null) {
            append.quit();
            append = null;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        int n;
        ExProperties exProperties = new ExProperties();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        String string = "jrserver.log";
        int n2 = 0;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                object3 = stringArray[n];
                if (((String)object3).equals("-?") || ((String)object3).equals("-help")) {
                    JREntServer.help();
                    return;
                }
                if (((String)object3).equalsIgnoreCase("-p")) {
                    exProperties.put("httpserver.port", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-ap")) {
                    exProperties.put("httpserver.admin.port", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-realm")) {
                    exProperties.put("server.realm.active", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-l")) {
                    exProperties.put("httpserver.backlog", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-m")) {
                    exProperties.put("httpserver.max.handlers", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-t")) {
                    exProperties.put("httpserver.timeout", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-d")) {
                    exProperties.put("servlet.dir", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-web")) {
                    if (!((File)(object2 = new File((String)(object = stringArray[++n])))).isDirectory()) {
                        System.out.println((String)object + " is not a directory!");
                        System.exit(1);
                    } else if (!((File)object2).exists()) {
                        System.out.println((String)object + " does not exist!");
                        System.exit(1);
                    } else if (!((File)object2).canRead()) {
                        System.out.println((String)object + " can not be read!");
                        System.exit(1);
                    }
                    ServerEnv.setWebDir((String)object);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-r")) {
                    exProperties.put("document.dir", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-s")) {
                    exProperties.put("httpserver.servlet.propfile", stringArray[++n]);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-env")) {
                    bl = true;
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-silent")) {
                    System.setOut(new PrintStream((OutputStream)new NullStream()));
                    System.setErr(new PrintStream((OutputStream)new NullStream()));
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-local")) {
                    SEDU = true;
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-vError")) {
                    n2 |= 4;
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-vDebug")) {
                    n2 |= 1;
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-logall")) {
                    n2 = 5;
                    continue;
                }
                if (((String)object3).toUpperCase().startsWith("-log".toUpperCase())) {
                    System.out.println("-log[:fileName] option has been discarded, please set the logger file name in " + System.getProperty("reporthome") + "\\bin\\LogConfig.properties.");
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-jrs.admin.server")) {
                    System.getProperties().put("jrs.admin.server", stringArray[++n]);
                    continue;
                }
                if (((String)object3).startsWith("-Rsystemtables:")) {
                    System.getProperties().put("restore.systemtables", ((String)object3).substring("-Rrealmtables:".length()));
                    continue;
                }
                if (((String)object3).startsWith("-Rrealmtables:")) {
                    System.getProperties().put("restore.realmtables", ((String)object3).substring("-Rrealmtables:".length()));
                    continue;
                }
                if (((String)object3).startsWith("-Rprofiling:")) {
                    System.getProperties().put("restore.profiling", ((String)object3).substring("-Rprofiling:".length()));
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("-cleanup")) {
                    System.getProperties().put("check.realmtables", "true");
                    continue;
                }
                System.err.println("Invalid option:" + (String)object3);
                bl2 = false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JREntServer.help();
        }
        if (!bl2) {
            JREntServer.help();
        }
        if (JRLog.isAd()) {
            JRLog.print((Object)("set debugLevel in main :" + n2));
        }
        n = APIUtil.getBoolean(System.getProperty("isLaunchPad"), false) ? 1 : 0;
        try {
            addSCMEventListener = new HttpServer(exProperties, false);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            if (n != 0) {
                JREntServer.SEDU();
            }
            System.exit(1);
        }
        if (n2 != 0) {
            JDebug.setDebugLevel((int)n2);
            ServiceLogger.setDebug();
        }
        object3 = new HttpAdminServer(addSCMEventListener.getServerPorps(), addSCMEventListener, SEDU);
        addSCMEventListener.setAdminServer((HttpAdminServer)object3);
        ((HttpAdminServer)object3).setLocalOnly(SEDU);
        append = object3;
        object = null;
        if (ReportEnv.isDashBoard()) {
            object = new HttpDashboardServer(addSCMEventListener.getServerPorps(), addSCMEventListener);
            addSCMEventListener.setDashboardServer((HttpDashboardServer)object);
        }
        addSCMEventListener.start();
        ((HttpServerBase)object3).start();
        if (ReportEnv.isDashBoard()) {
            ((HttpServerBase)object).start();
        }
        System.out.println(ReportEnv.getProductionName() + " Version " + ReportEnv.getVerWithoutProducteInfo());
        System.out.println("");
        if (bl) {
            JREntServer.printEnv();
            System.out.println("");
        }
        System.out.println(JSvrResource.getMessage("SERVER_OK"));
        System.out.println("");
        System.out.println(ReportEnv.getProductionName() + " is ready for service.");
        object2 = new JREntServer();
        SCMEventManager sCMEventManager = SCMEventManager.getInstance();
        sCMEventManager.addSCMEventListener((SCMEventListener)object2);
        ServiceLogger.logDebug(4670008, object2, 4);
        if (n != 0) {
            JREntServer.SEDU();
        }
        try {
            ShutdownThread.registerShutdownHook();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        addSCMEventListener.lockForPreviewServer();
    }

    private static void SEDU() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
            if (string == null) {
                string = inetAddress.getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError(unknownHostException);
        }
        if (string == null) {
            string = "localhost";
        }
        int n = ServerEnv.getPort();
        String string2 = "http://" + string + ":" + n + "/launchpad.jsp";
        String string3 = System.getProperty("DefaultBrowserPath");
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(new String[]{string3, string2});
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    @Override
    public void handleSCMEvent(SCMEvent sCMEvent) {
        int n = sCMEvent.getID();
        switch (n) {
            case 1: {
                ServiceLogger.logDebug(4670009, 4);
                ServiceLogger.logDebug(4670010, addSCMEventListener, 4);
                addSCMEventListener.quitWithoutExit();
                break;
            }
            case 3: {
                ServiceLogger.logDebug(4670011, 4);
                break;
            }
            case 4: {
                ServiceLogger.logDebug(4670012, 4);
                break;
            }
            case 2: {
                ServiceLogger.logDebug(4670013, 4);
                break;
            }
            default: {
                ServiceLogger.logDebug(4670014, new Integer(n), 4);
            }
        }
    }
}

