/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.blocks;

import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.ClusterMapTransceiver;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapContainerLocalImpl;

public abstract class MapFactory {
    public static ClusterMap getMap(MapAttr mapAttr) throws ClusterException {
        return MapFactory.getMapByName(MapAttr.makeMapName(mapAttr, null));
    }

    public static ClusterMap getMapForRealm(String string, MapAttr mapAttr) throws ClusterException {
        return MapFactory.getMapByName(MapAttr.makeMapName(mapAttr, string.toLowerCase()));
    }

    public static ClusterMap getCommonMap(String string) throws ClusterException {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("illegal cluster map name.");
        }
        return MapFactory.getMapByName(MapAttr.makeMapName(MapAttr.COMMON_ALL_NOVERIFY, "#" + string));
    }

    public static ClusterMap getDHTMLCommonMap(String string) throws ClusterException {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("illegal cluster map name.");
        }
        return MapFactory.getMapByName(MapAttr.makeMapName(MapAttr.COMMON_DHTML_ALL_NOVERIFY, "#" + string));
    }

    public static ClusterMap getMapByName(String string) throws ClusterException {
        ClusterMap clusterMap;
        if (ClusterEnv.isClusterEnabled()) {
            clusterMap = ClusterMapTransceiver.getInstance().getMap(string);
        } else {
            MapAttr.parseMapAttr(string);
            clusterMap = MapContainerLocalImpl.getInstance().getMap(string);
        }
        return clusterMap;
    }

    public static void clearMem() {
        if (!ClusterEnv.isClusterEnabled()) {
            MapContainerLocalImpl.destroyContainers();
        }
    }

    public static String makeRealmMapName(String string, String string2) {
        return string + "@" + string2.toLowerCase();
    }
}

