/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.core;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.ClusterRuntimeException;
import jet.server.cluster.core.Channel;
import jet.server.cluster.core.CoreTransceiver;
import jet.server.cluster.core.JRMemberService;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MembershipListener;
import jet.server.cluster.core.MessageReceiver;
import jet.server.cluster.core.Topic;
import jet.server.cluster.core.Transceiver;
import jet.server.cluster.jgroups.JGroupsChannel;
import jet.server.cluster.rmi.JRMIChannel;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRChannel
extends Thread
implements Channel,
MessageReceiver,
MembershipListener {
    private JRMember CORE;
    private ConcurrentMap MILLISECONDS;
    private JRMemberService SECONDS;
    private JGroupsChannel SEDU;
    private JRMIChannel afterShutdown;
    private CoreTransceiver append;
    private static final long awaitTermination = 3600000L;
    private static final long beforeShutdown = 10000L;
    private final Object castRequest = new Object();
    private boolean checkState;
    private boolean clear;
    private boolean clearMem;
    private ExecutorService close;
    private ExecutorService connected;

    JRChannel() {
        this.CORE = ClusterEnv.getMember();
        this.MILLISECONDS = new ConcurrentSkipListMap();
        this.SECONDS = new JRMemberService(this.CORE, this);
        this.SEDU = new JGroupsChannel(this.CORE, this, this);
        this.afterShutdown = new JRMIChannel(this.CORE, this, this, this.SECONDS);
        this.append = new CoreTransceiver(this);
    }

    private boolean CORE() {
        return true;
    }

    @Override
    public boolean hasStarted() {
        return this.checkState;
    }

    private boolean MILLISECONDS() {
        return this.clearMem;
    }

    private boolean SECONDS() {
        return this.clear;
    }

    private void SEDU() throws ClusterRuntimeException {
        if (this.MILLISECONDS()) {
            throw new ClusterRuntimeException("JRChannel:: illegal access, channel was destroied.");
        }
    }

    private void afterShutdown() throws ClusterRuntimeException {
        if (!this.hasStarted()) {
            throw new ClusterRuntimeException("JRChannel:: illegal access, channel not started.");
        }
    }

    @Override
    public void startup() throws ClusterException {
        this.SEDU();
        if (this.hasStarted()) {
            throw new ClusterException("JRChannel:: illegal access, channel has started.");
        }
        this.setName("JRChannelThread");
        this.close = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private ThreadFactory SEDU = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = this.SEDU.newThread(runnable);
                thread.setName("JRChannel-out-" + thread.getName());
                thread.setDaemon(true);
                return thread;
            }
        });
        this.connected = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private ThreadFactory SEDU = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = this.SEDU.newThread(runnable);
                thread.setName("JRChannel-in-" + thread.getName());
                thread.setDaemon(true);
                return thread;
            }
        });
        this.afterShutdown.startup();
        this.SEDU.startup();
        RemoteObjectFactory.registerRpcHandler(JRMemberService.rpcHandlerName, this.SECONDS);
        JRView jRView = this.afterShutdown.verifyView(null, null, this.SEDU.getView());
        this.SECONDS.setView(jRView);
        this.checkState = true;
        JRView jRView2 = this.append.getHistoryView();
        if (jRView2 != null) {
            jRView.setHistory(jRView2);
            ServiceLogger.logDebug("JRChannel:: setHistory view: historyView=" + jRView2 + "\n\tnewView=" + jRView);
        }
        this.start();
        ServiceLogger.logDebug(4650050, 4);
        this.SECONDS.connected(this.CORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws ClusterException {
        if (!this.hasStarted()) {
            return;
        }
        try {
            this.clear = true;
            this.append.notifyShutdown();
            this.SECONDS.beforeShutdown();
            for (Transceiver transceiver : this.MILLISECONDS.values()) {
                transceiver.close();
            }
            this.checkState = false;
            this.close.shutdown();
            try {
                this.close.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException);
            }
            this.connected.shutdownNow();
            try {
                this.connected.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException);
            }
            this.SEDU.shutdown();
            this.afterShutdown.shutdown();
        }
        finally {
            this.checkState = false;
            this.SECONDS.afterShutdown();
            this.append();
            ServiceLogger.logDebug(4650051, 4);
        }
    }

    private void append() {
        this.clearMem = true;
        this.MILLISECONDS.clear();
        this.SECONDS.clearMem();
        this.MILLISECONDS = null;
        this.CORE = null;
        this.SECONDS = null;
        this.SEDU = null;
        this.afterShutdown = null;
        this.append = null;
    }

    CoreTransceiver getCoreTransceiver() {
        return this.append;
    }

    Transceiver registerTransceiver(Transceiver transceiver) {
        this.SEDU();
        Transceiver transceiver2 = this.MILLISECONDS.putIfAbsent(transceiver.getTopic(), transceiver);
        if (transceiver2 != null) {
            ServiceLogger.logError("JRChannel:: registerTransceiver(): attemp to replaced registed transceiver " + transceiver2, 3);
            throw new ClusterRuntimeException("Attemp to replaced registed transceiver.");
        }
        return transceiver2;
    }

    boolean unregisterTransceiver(Transceiver transceiver) {
        this.SEDU();
        return this.MILLISECONDS.remove((Object)transceiver.getTopic()) != null;
    }

    public Transceiver getTransceiver(Topic topic) {
        this.SEDU();
        return (Transceiver)this.MILLISECONDS.get((Object)topic);
    }

    public JRMember getLocalMember() {
        this.SEDU();
        return this.CORE;
    }

    public JRMemberService getMemberService() {
        this.SEDU();
        return this.SECONDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServiceLogger.logDebug("JRChannelThread:: start.");
        long l = 3600000L;
        while (!this.SECONDS()) {
            try {
                Thread.sleep(l);
                if (this.SECONDS()) break;
                ServiceLogger.logDebug("JRChannel:: check transceiver state periodly: delay=" + l);
                for (Object object : this.MILLISECONDS.values()) {
                    if (this.SECONDS()) break;
                    Object object2 = this.castRequest;
                    synchronized (object2) {
                        ((Transceiver)object).checkState();
                    }
                }
                l = 3600000L;
            }
            catch (InterruptedException interruptedException) {
                Object object;
                ServiceLogger.logDebug("JRChannel:: Interrupted by view accepted.");
                object = this.SECONDS.getView();
                int n = ((JRView)object).getMembers().indexOf(this.CORE);
                l = 1000L;
                if (n < 3) {
                    l += (long)n * 10000L;
                    continue;
                }
                l = 60000L;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        ServiceLogger.logDebug("JRChannelThread:: stop.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewAccepted0(JRView jRView) throws ClusterException {
        if (this.MILLISECONDS() || this.SECONDS()) {
            return;
        }
        Object object = this.castRequest;
        synchronized (object) {
            this.SECONDS.setViewReady(false);
            JRView jRView2 = this.SECONDS.getView0();
            JRView jRView3 = null;
            Set set = this.SECONDS.getShutdownMembers();
            try {
                jRView3 = this.afterShutdown.verifyView(jRView2, set, jRView);
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
                this.SECONDS.setViewReady(true);
                return;
            }
            if (jRView3 == jRView2) {
                this.SECONDS.setViewReady(true);
                return;
            }
            this.SECONDS.setView(jRView3);
            if (jRView3.isMergeView() && jRView3.isShareMemoryNode()) {
                this.append.notifyIamShareMemory();
            }
            for (Transceiver transceiver : this.MILLISECONDS.values()) {
                try {
                    ServiceLogger.logDebug("JRChannel:: notifyView: transceiver=" + transceiver);
                    transceiver.viewAccepted(jRView3);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            this.SECONDS.viewAccepted(jRView3);
            if (jRView.isMergeView()) {
                this.interrupt();
            }
        }
    }

    @Override
    public void viewAccepted(JRView jRView) {
        if (!this.hasStarted()) {
            return;
        }
        new ViewHandlerThread(jRView).start();
    }

    @Override
    public void suspect(JRMember jRMember) {
        if (!this.hasStarted()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(final JRMessage jRMessage) {
        long l;
        block5: {
            Transceiver transceiver;
            block4: {
                this.afterShutdown();
                l = System.currentTimeMillis();
                try {
                    if (jRMessage.getTopic() != Topic.CORE) break block4;
                    this.append.handleMessage(jRMessage);
                }
                catch (Throwable throwable) {
                    long l2 = System.currentTimeMillis() - l;
                    ServiceLogger.logDebug(6650052, new Object[]{l2, jRMessage}, 7);
                    throw throwable;
                }
                long l3 = System.currentTimeMillis() - l;
                ServiceLogger.logDebug(6650052, new Object[]{l3, jRMessage}, 7);
                return;
            }
            Transceiver transceiver2 = transceiver = jRMessage.getTopic() == null ? null : (Transceiver)this.MILLISECONDS.get((Object)jRMessage.getTopic());
            if (transceiver != null) {
                this.connected.submit(new Callable(){

                    public Object call() throws ClusterException {
                        transceiver.handleMessage(jRMessage);
                        return null;
                    }
                });
                break block5;
            }
            ServiceLogger.logError("JRChannel:: handleMessage(): There is not a transceiver to HANDLE the message: " + jRMessage, 3);
        }
        long l4 = System.currentTimeMillis() - l;
        ServiceLogger.logDebug(6650052, new Object[]{l4, jRMessage}, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable handleRequest(final JRMessage var1_1) {
        this.afterShutdown();
        var2_2 = System.currentTimeMillis();
        if (var1_1.getTopic() == Topic.CORE) {
            var4_3 = this.append.handleRequest(var1_1);
        }
        ** GOTO lbl-1000
        {
            block8: {
                catch (Throwable var8_14) {
                    var9_15 = System.currentTimeMillis() - var2_2;
                    ServiceLogger.logDebug(6650053, new Object[]{var9_15, var1_1}, 7);
                    throw var8_14;
                }
                var5_5 = System.currentTimeMillis() - var2_2;
                ServiceLogger.logDebug(6650053, new Object[]{var5_5, var1_1}, 7);
                return var4_3;
lbl-1000:
                // 1 sources

                {
                    v0 = var4_4 = var1_1.getTopic() == null ? null : (Transceiver)this.MILLISECONDS.get((Object)var1_1.getTopic());
                    if (var4_4 == null) ** GOTO lbl34
                    if (!this.CORE()) break block8;
                    var5_6 = var4_4.handleRequest(var1_1);
                }
                var6_11 = System.currentTimeMillis() - var2_2;
                ServiceLogger.logDebug(6650053, new Object[]{var6_11, var1_1}, 7);
                return var5_6;
            }
            try {
                var5_7 = (Serializable)this.connected.submit(new Callable(){

                    public Serializable call() throws ClusterException {
                        return var4_4.handleRequest(var1_1);
                    }
                }).get();
            }
            catch (InterruptedException var5_8) {}
            var6_12 = System.currentTimeMillis() - var2_2;
            ServiceLogger.logDebug(6650053, new Object[]{var6_12, var1_1}, 7);
            return var5_7;
            {
                block9: {
                    ServiceLogger.logError(var5_8);
                    break block9;
                    catch (ExecutionException var5_9) {
                        ServiceLogger.logError(var5_9);
                        break block9;
                    }
lbl34:
                    // 1 sources

                    ServiceLogger.logError("JRChannel:: handleRequest(): There is not a transceiver to HANDLE the message: " + var1_1, 3);
                }
                var5_10 = null;
            }
        }
        var6_13 = System.currentTimeMillis() - var2_2;
        ServiceLogger.logDebug(6650053, new Object[]{var6_13, var1_1}, 7);
        return var5_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(final JRMessage jRMessage) throws ClusterException {
        this.afterShutdown();
        if (jRMessage.getDest() == this.CORE.getID()) {
            return;
        }
        if (jRMessage.getDest() == -1) {
            if (this.SECONDS.isCoordinator()) {
                return;
            }
            jRMessage.setDest(this.SECONDS.getCoordinator().getID());
        }
        long l = System.currentTimeMillis();
        try {
            this.close.submit(new Callable(){

                public Object call() throws ClusterException {
                    JRChannel.this.afterShutdown.sendMessage(jRMessage);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            long l2 = System.currentTimeMillis() - l;
            ServiceLogger.logDebug(6650054, new Object[]{l2, jRMessage}, 7);
            throw throwable;
        }
        long l3 = System.currentTimeMillis() - l;
        ServiceLogger.logDebug(6650054, new Object[]{l3, jRMessage}, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void castMessage(final JRMessage jRMessage) throws ClusterException {
        this.afterShutdown();
        if (this.SECONDS.getView().size() < 2) {
            return;
        }
        long l = System.currentTimeMillis();
        try {
            jRMessage.setDest(-1);
            this.close.submit(new Callable(){

                public Object call() throws ClusterException {
                    JRChannel.this.afterShutdown.castMessage(jRMessage);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            long l2 = System.currentTimeMillis() - l;
            ServiceLogger.logDebug(6650055, new Object[]{l2, -1, jRMessage}, 7);
            throw throwable;
        }
        long l3 = System.currentTimeMillis() - l;
        ServiceLogger.logDebug(6650055, new Object[]{l3, -1, jRMessage}, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void castMessage(final List list, final JRMessage jRMessage) throws ClusterException {
        this.afterShutdown();
        if (this.SECONDS.getView().size() < 2) {
            return;
        }
        if (list == null || list.size() == 0 || list.size() == 1 && list.contains(this.CORE.getID())) {
            return;
        }
        long l = System.currentTimeMillis();
        try {
            jRMessage.setDest(-1);
            this.close.submit(new Callable(){

                public Object call() throws ClusterException {
                    JRChannel.this.afterShutdown.castMessage(list, jRMessage);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            long l2 = System.currentTimeMillis() - l;
            ServiceLogger.logDebug(6650055, new Object[]{l2, list, jRMessage}, 7);
            throw throwable;
        }
        long l3 = System.currentTimeMillis() - l;
        ServiceLogger.logDebug(6650055, new Object[]{l3, list, jRMessage}, 7);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object sendRequest(final JRMessage jRMessage, final long l) throws ClusterException {
        Object t;
        Future future;
        long l2;
        block12: {
            block11: {
                this.afterShutdown();
                if (jRMessage.getDest() == this.CORE.getID()) {
                    return null;
                }
                if (jRMessage.getDest() == -1) {
                    if (this.SECONDS.isCoordinator()) {
                        return null;
                    }
                    jRMessage.setDest(this.SECONDS.getCoordinator().getID());
                }
                l2 = System.currentTimeMillis();
                if (!this.CORE()) break block11;
                Object object = this.afterShutdown.sendRequest(jRMessage, l);
                long l3 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650056, new Object[]{l3, jRMessage}, 7);
                return object;
            }
            future = this.close.submit(new Callable(){

                public Object call() throws ClusterException {
                    return JRChannel.this.afterShutdown.sendRequest(jRMessage, l);
                }
            });
            if (l <= 0L) break block12;
            Object t2 = future.get(l, TimeUnit.MILLISECONDS);
            long l4 = System.currentTimeMillis() - l2;
            ServiceLogger.logDebug(6650056, new Object[]{l4, jRMessage}, 7);
            return t2;
        }
        try {
            t = future.get();
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new ClusterException(interruptedException);
                catch (ExecutionException executionException) {
                    throw new ClusterException(executionException);
                }
                catch (TimeoutException timeoutException) {
                    throw new ClusterException(timeoutException);
                }
            }
            catch (Throwable throwable) {
                long l5 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650056, new Object[]{l5, jRMessage}, 7);
                throw throwable;
            }
        }
        long l6 = System.currentTimeMillis() - l2;
        ServiceLogger.logDebug(6650056, new Object[]{l6, jRMessage}, 7);
        return t;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List castRequest(final JRMessage jRMessage, final long l) throws ClusterException {
        List list;
        Future future;
        long l2;
        block10: {
            block9: {
                this.afterShutdown();
                if (this.SECONDS.getView().size() < 2) {
                    return null;
                }
                l2 = System.currentTimeMillis();
                jRMessage.setDest(-1);
                if (!this.CORE()) break block9;
                List list2 = this.afterShutdown.castRequest(jRMessage, l);
                long l3 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650057, new Object[]{l3, -1, jRMessage}, 7);
                return list2;
            }
            future = this.close.submit(new Callable(){

                public List call() throws ClusterException {
                    return JRChannel.this.afterShutdown.castRequest(jRMessage, l);
                }
            });
            if (l <= 0L) break block10;
            List list3 = (List)future.get(l, TimeUnit.MILLISECONDS);
            long l4 = System.currentTimeMillis() - l2;
            ServiceLogger.logDebug(6650057, new Object[]{l4, -1, jRMessage}, 7);
            return list3;
        }
        try {
            list = (List)future.get();
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new ClusterException(interruptedException);
                catch (ExecutionException executionException) {
                    throw new ClusterException(executionException);
                }
                catch (TimeoutException timeoutException) {
                    throw new ClusterException(timeoutException);
                }
            }
            catch (Throwable throwable) {
                long l5 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650057, new Object[]{l5, -1, jRMessage}, 7);
                throw throwable;
            }
        }
        long l6 = System.currentTimeMillis() - l2;
        ServiceLogger.logDebug(6650057, new Object[]{l6, -1, jRMessage}, 7);
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List castRequest(final List list, final JRMessage jRMessage, final long l) throws ClusterException {
        List list2;
        Future future;
        long l2;
        block11: {
            block10: {
                this.afterShutdown();
                if (this.SECONDS.getView().size() < 2) {
                    return null;
                }
                if (list == null || list.size() == 0 || list.size() == 1 && list.contains(this.CORE.getID())) {
                    return null;
                }
                l2 = System.currentTimeMillis();
                jRMessage.setDest(-1);
                if (!this.CORE()) break block10;
                List list3 = this.afterShutdown.castRequest(list, jRMessage, l);
                long l3 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650057, new Object[]{l3, list, jRMessage}, 7);
                return list3;
            }
            future = this.close.submit(new Callable(){

                public List call() throws ClusterException {
                    return JRChannel.this.afterShutdown.castRequest(list, jRMessage, l);
                }
            });
            if (l <= 0L) break block11;
            List list4 = (List)future.get(l, TimeUnit.MILLISECONDS);
            long l4 = System.currentTimeMillis() - l2;
            ServiceLogger.logDebug(6650057, new Object[]{l4, list, jRMessage}, 7);
            return list4;
        }
        try {
            list2 = (List)future.get();
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new ClusterException(interruptedException);
                catch (ExecutionException executionException) {
                    throw new ClusterException(executionException);
                }
                catch (TimeoutException timeoutException) {
                    throw new ClusterException(timeoutException);
                }
            }
            catch (Throwable throwable) {
                long l5 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650057, new Object[]{l5, list, jRMessage}, 7);
                throw throwable;
            }
        }
        long l6 = System.currentTimeMillis() - l2;
        ServiceLogger.logDebug(6650057, new Object[]{l6, list, jRMessage}, 7);
        return list2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object castRequestAndReturnFirstResult(final List list, final JRMessage jRMessage, final boolean bl, final long l) throws ClusterException {
        Object t;
        Future future;
        long l2;
        block11: {
            block10: {
                this.afterShutdown();
                if (this.SECONDS.getView().size() < 2) {
                    return null;
                }
                if (list == null || list.size() == 0 || list.size() == 1 && list.contains(this.CORE.getID())) {
                    return null;
                }
                l2 = System.currentTimeMillis();
                jRMessage.setDest(-1);
                if (!this.CORE()) break block10;
                List list2 = this.afterShutdown.castRequest(list, jRMessage, l);
                long l3 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650057, new Object[]{l3, list, jRMessage}, 7);
                return list2;
            }
            future = this.close.submit(new Callable(){

                public Object call() throws ClusterException {
                    return JRChannel.this.afterShutdown.castRequestAndReturnFirstResult(list, jRMessage, bl, l);
                }
            });
            if (l <= 0L) break block11;
            Object t2 = future.get(l, TimeUnit.MILLISECONDS);
            long l4 = System.currentTimeMillis() - l2;
            ServiceLogger.logDebug(6650057, new Object[]{l4, list, jRMessage}, 7);
            return t2;
        }
        try {
            t = future.get();
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new ClusterException(interruptedException);
                catch (ExecutionException executionException) {
                    throw new ClusterException(executionException);
                }
                catch (TimeoutException timeoutException) {
                    throw new ClusterException(timeoutException);
                }
            }
            catch (Throwable throwable) {
                long l5 = System.currentTimeMillis() - l2;
                ServiceLogger.logDebug(6650057, new Object[]{l5, list, jRMessage}, 7);
                throw throwable;
            }
        }
        long l6 = System.currentTimeMillis() - l2;
        ServiceLogger.logDebug(6650057, new Object[]{l6, list, jRMessage}, 7);
        return t;
    }

    class ViewHandlerThread
    extends Thread {
        private final JRView SEDU;

        ViewHandlerThread(JRView jRView) {
            this.SEDU = jRView;
        }

        @Override
        public void run() {
            try {
                JRChannel.this.viewAccepted0(this.SEDU);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }
}

