/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.jgroups;

import java.util.HashMap;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

class JRMBR {
    JRMBR() {
    }

    public static JRMember makeMember(Address address) {
        Object object = null;
        byte[] byArray = null;
        try {
            if (address instanceof UUID) {
                byArray = ((UUID)address).getAdditionalData();
            } else if (address instanceof IpAddress) {
                byArray = ((IpAddress)address).getAdditionalData();
            }
            object = Util.objectFromByteBuffer((byte[])byArray);
            if (object instanceof JRMember) {
                return (JRMember)object;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        ServiceLogger.logError("Can not parse JRMember from additional-data of jgroups addr: " + address + ", " + object);
        return null;
    }

    public static void setMember(JChannel jChannel, JRMember jRMember) throws Exception {
        jChannel.setName(jRMember.getHost() + "-" + jRMember.getID());
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        hashMap.put("additional_data", Util.objectToByteBuffer((Object)jRMember));
        jChannel.down(new Event(56, hashMap));
    }
}

