/*
 * Decompiled with CFR 0.152.
 */
package jet.server.crd;

import com.jinfonet.api.crd.CRDResult;
import com.jinfonet.api.crd.DataResult;
import com.jinfonet.resstore.DiskStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import jet.cache.Cache;
import jet.dataengine.api.DSException;
import jet.dataengine8.olap.core.CubeDataResult;
import jet.dataservice.api.JParameterCRD;
import jet.dataservice.impl.DataResultImpl;
import jet.server.jrc.JRRemoteCRDManager;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;

public abstract class AbstractCRDResult
implements CRDResult,
Serializable {
    private static final long serialVersionUID = -1054366909101792366L;
    protected int refrencedCount = 0;
    protected boolean expired;
    protected String persistFile;
    protected String persistBVFile;
    protected String localPersistFile;
    protected int type;
    private long actualCubeMemory = -1L;
    protected transient Cache crdCache;
    protected transient InputStream stream;
    protected transient DataResult dataResult;
    protected transient InputStream BVstream;
    private transient String CRD_CACHE = null;
    protected transient DataResult bvDataResult;
    protected transient JParameterCRD parameterCRD;
    private static HashMap SEDU = new HashMap();

    protected abstract DiskStore getDiskStore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataResult generateDataResult(boolean bl) throws IOException {
        block19: {
            try {
                ServiceLogger.logDebug("CRDResult: generateDataResult..., isBV: " + bl, 6);
                String string = null;
                if (!bl && this.persistFile != null) {
                    string = this.persistFile;
                } else if (bl && this.persistBVFile != null) {
                    string = this.persistBVFile;
                }
                if (string == null) break block19;
                String string2 = string.replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), "");
                try {
                    File file = StorageEnv.getStorage().get(Storage.StorageRoot.CRD_CACHE, string2);
                    ServiceLogger.logDebug("CRDResult: persistence file: " + file, 7);
                    String string3 = file.getAbsolutePath();
                    Object object = this.BVstream(string3);
                    synchronized (object) {
                        if (!bl) {
                            return new DataResultImpl(this.crdCache.getInputStream(file), this.type, this.getDiskStore());
                        }
                        ServiceLogger.logDebug("CRDResult: key: " + string3 + ", cached result: " + this.bvDataResult, 7);
                        if (this.bvDataResult == null) {
                            String string4 = string2.substring(0, string2.length() - 4) + ".swap";
                            File file2 = null;
                            try {
                                file2 = StorageEnv.getStorage().get(Storage.StorageRoot.CRD_CACHE, string4);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                            FileInputStream fileInputStream = new FileInputStream(file);
                            this.bvDataResult = new CubeDataResult((InputStream)fileInputStream, file2 == null ? null : file2.getAbsolutePath());
                            if (fileInputStream != null) {
                                try {
                                    ((InputStream)fileInputStream).close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        ServiceLogger.logDebug("CRDResult: return result: " + this.bvDataResult, 6);
                        return this.bvDataResult;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ServiceLogger.logError(fileNotFoundException, 2);
                }
            }
            catch (StorageException storageException) {
                throw new IOException(storageException.getMessage());
            }
            catch (IllegalStateException illegalStateException) {
                ServiceLogger.logError(illegalStateException, 2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceLogger.logError(classNotFoundException, 2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object BVstream(String string) {
        HashMap hashMap = SEDU;
        synchronized (hashMap) {
            Object object = SEDU.get(string);
            if (object == null) {
                object = new Object();
                SEDU.put(string, object);
            }
            return object;
        }
    }

    @Override
    public void releaseDataResult() {
        --this.refrencedCount;
        this.release();
    }

    public void increaseRefrenced() {
        ++this.refrencedCount;
    }

    protected void release() {
        boolean bl = this.isExpired();
        if (this.refrencedCount <= 0 && bl && (this.persistFile != null || this.persistBVFile != null)) {
            Object object;
            String string;
            ServiceLogger.logDebug(String.format("CRDManager: AbstractCRDResult.release()[%s]", this), 5);
            DiskStore diskStore = this.getDiskStore();
            if (this.persistFile != null) {
                string = this.persistFile.replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), "");
                try {
                    object = StorageEnv.getStorage().map(Storage.StorageRoot.CRD_CACHE, string);
                    StorageEnv.getStorage().delete(Storage.StorageRoot.CRD_CACHE, string);
                    diskStore.delete((File)object);
                    this.removeFromCache(((File)object).getAbsolutePath());
                }
                catch (StorageException storageException) {
                    ServiceLogger.logError((Throwable)((Object)storageException), 2);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 2);
                }
            }
            if (this.persistBVFile != null) {
                string = this.persistBVFile.replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), "");
                try {
                    object = StorageEnv.getStorage().map(Storage.StorageRoot.CRD_CACHE, string);
                    StorageEnv.getStorage().delete(Storage.StorageRoot.CRD_CACHE, string);
                    diskStore.delete((File)object);
                    this.removeFromCache(((File)object).getAbsolutePath());
                }
                catch (StorageException storageException) {
                    ServiceLogger.logError((Throwable)((Object)storageException), 2);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 2);
                }
                object = string.substring(0, string.length() - 4) + ".swap";
                try {
                    File file = StorageEnv.getStorage().map(Storage.StorageRoot.CRD_CACHE, string);
                    StorageEnv.getStorage().delete(Storage.StorageRoot.CRD_CACHE, (String)object);
                    diskStore.delete(file);
                }
                catch (StorageException storageException) {
                    ServiceLogger.logError((Throwable)((Object)storageException), 2);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 2);
                }
            }
            this.crdCache = null;
            this.stream = null;
            this.BVstream = null;
            this.persistFile = null;
            this.persistBVFile = null;
            this.parameterCRD = null;
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean bl) {
        this.expired = bl;
        this.release();
    }

    public String getPersistFile() {
        return this.persistFile;
    }

    public void setPersistFile(String string) {
        this.persistFile = string;
    }

    public String getPersistBVFile() {
        return this.persistBVFile;
    }

    public void setPersistBVFile(String string) {
        this.persistBVFile = string;
        if (this.bvDataResult == null) {
            String string2 = string.replace("\\", "/").replace(JRRemoteCRDManager.getCachePath(), "");
            try {
                File file = StorageEnv.getStorage().get(Storage.StorageRoot.CRD_CACHE, string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                String string3 = string2.substring(0, string2.length() - 4) + ".swap";
                File file2 = null;
                try {
                    file2 = StorageEnv.getStorage().get(Storage.StorageRoot.CRD_CACHE, string3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                this.bvDataResult = new CubeDataResult((InputStream)fileInputStream, file2 == null ? null : file2.getAbsolutePath());
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    public void setCRDCache(Cache cache) {
        this.crdCache = cache;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setDataResult(DataResult dataResult) {
        this.dataResult = dataResult;
    }

    public void setStream(InputStream inputStream) {
        this.stream = inputStream;
    }

    public InputStream getBVStream() {
        return this.BVstream;
    }

    public void setBVStream(InputStream inputStream) {
        this.BVstream = inputStream;
    }

    public String getLocalPersistFile() {
        return this.localPersistFile;
    }

    public void setLocalPersistFile(String string) {
        this.localPersistFile = string;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public JParameterCRD getPrameterCRD() throws IOException, DSException {
        if (this.parameterCRD != null) {
            return this.parameterCRD;
        }
        DataResult dataResult = this.generateDataResult(false);
        this.parameterCRD = dataResult.getParameterCRD();
        return this.parameterCRD;
    }

    public void removeFromCache(String string) {
        if (this.crdCache != null && this.crdCache.getCacheObj(string) != null) {
            this.crdCache.remove(string);
        }
    }

    public void setBVDataResult(DataResult dataResult) {
        this.bvDataResult = dataResult;
        String string = ((CubeDataResult)dataResult).getSwapFileName();
        if (string != null && string.trim().length() > 0) {
            this.CRD_CACHE = string;
        }
    }

    public String getBVSwapFile() {
        return this.CRD_CACHE;
    }

    public void setBVSwapFileToCube(String string) {
        if (this.bvDataResult != null) {
            try {
                ((CubeDataResult)this.bvDataResult).getBV().setSwapFileName(string);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    public DataResult getBVDataResult() {
        return this.bvDataResult;
    }

    public long getCubeActualMemorySize() {
        if (this.actualCubeMemory == -1L && this.bvDataResult != null) {
            try {
                this.actualCubeMemory = this.bvDataResult.getBV().size();
            }
            catch (DSException dSException) {
                ServiceLogger.logError(dSException);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }
        return this.actualCubeMemory;
    }

    @Override
    public boolean hasBVData() {
        return this.persistBVFile != null;
    }

    @Override
    public boolean hasResultSet() {
        return this.persistFile != null;
    }

    public String toString() {
        return "{" + this.toStr() + "}";
    }

    public String toStr() {
        return new StringBuffer("expired:").append(this.isExpired()).append(", refrencedCount:").append(this.refrencedCount).append(", type:").append(this.type).append(", persistFile:").append(this.persistFile).append(", persistBVFile:").append(this.persistBVFile).toString();
    }

    public int getRefrencedCount() {
        return this.refrencedCount;
    }
}

