/*
 * Decompiled with CFR 0.152.
 */
package jet.server.crd;

import com.jinfonet.resstore.DiskStore;
import java.util.Date;
import jet.dataservice.api.autocachekey.JAutoCacheKey;
import jet.server.cluster.ClusterEnv;
import jet.server.crd.AbstractCRDResult;
import jet.server.resstore.ServerResourceStoreFactory;

public class AutoCacheResult
extends AbstractCRDResult {
    private static final long serialVersionUID = 1L;
    private JAutoCacheKey queryKey;
    private long expiredFrom = 0L;
    private long expiredTo = 0L;
    private long size = 0L;
    private Date recentUsaged;

    public AutoCacheResult(JAutoCacheKey jAutoCacheKey, long l, int n, long l2) {
        this.queryKey = jAutoCacheKey;
        this.expiredFrom = ClusterEnv.getClusterTime();
        if (l > 0L) {
            this.expiredTo = this.expiredFrom + l;
        }
        this.type = n;
        this.size = l2;
        this.recentUsaged = new Date();
    }

    @Override
    protected DiskStore getDiskStore() {
        return ServerResourceStoreFactory.getInstance().getResourceStoreByResourcePath(this.queryKey == null ? null : this.queryKey.getCatalogKey().getPath()).getDiskStore().getCrdAutoCacheDiskStore();
    }

    @Override
    public void increaseRefrenced() {
        super.increaseRefrenced();
        this.recentUsaged = new Date();
    }

    public void setExpired(long l) {
        if (!this.isExpired()) {
            this.expiredTo = l <= 0L ? 0L : this.expiredFrom + l;
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.refrencedCount == 0 && this.isExpired()) {
            this.queryKey = null;
        }
    }

    public JAutoCacheKey getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(JAutoCacheKey jAutoCacheKey) {
        this.queryKey = jAutoCacheKey;
    }

    @Override
    public boolean isExpired() {
        long l = ClusterEnv.getClusterTime();
        if (this.expiredTo > 0L) {
            return l + 60000L < this.expiredFrom || l > this.expiredTo;
        }
        return this.expired;
    }

    @Override
    public String toString() {
        return new StringBuffer("{").append("queryKey:").append(this.queryKey).append(", recentUsaged:").append(this.recentUsaged).append(", size:").append(this.size).append(", ").append(super.toStr()).append(", expiredFrom:").append(this.expiredFrom).append(", expiredTo:").append(this.expiredTo).append("}").toString();
    }

    public Date getRecentUsaged() {
        return this.recentUsaged;
    }

    public long getSize() {
        return this.size;
    }
}

