/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import jet.server.db.DataHandler;
import jet.server.db.core.Dbs;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.log.ServiceLogger;
import jet.server.schedule.Committer;

public abstract class AbstractDataTable
implements Committer,
DataHandler {
    public static final String CREATE_TABLE_PREFIX = "CREATE TABLE ";
    public static final String CREATE_HSQLTABLE_PREFIX = "CREATE CACHED TABLE ";
    public static final String DROP_TABLE_PREFIX = "DROP TABLE ";
    public static final String INSERT_PREFIX = "INSERT INTO ";
    public static final String DELETE_PREFIX = "DELETE FROM ";
    public static final String SELECT_ALL_PREFIX = "SELECT * FROM ";
    public static final String SELECT_NUM_PREFIX = "SELECT COUNT(*) FROM ";
    public static final String UPDATE_PREFIX = "UPDATE ";
    public static final String ORDER_BY_ID_DESC = " ORDER BY ID DESC";
    public static final String FAILED_CONSTRUCTOR = "FailedConstructor";
    public static final String FAILED_CREATE_TABLE = "FailedCreateTable";
    public static final String FAILED_DROP_TABLE = "FailedDropTable";
    public static final String FAILED_ADDREC = "FailedInsertRecord";
    public static final String FAILED_DELREC = "FailedDeleteRecord";
    public static final String FAILED_UPDREC = "FailedUpdateRecord";
    public static final String FAILED_GETREC = "FailedSelectRecord";
    public static final String FAILED_COMMIT = "FailedCommit";
    public static int MAX_BATCH_COMMIT = 100;
    protected Connection conn = null;
    protected Statement stmt = null;
    protected StringBuffer sqlbuf = new StringBuffer();
    private DaemonThread EMPTY = null;
    private int SEDU = MAX_BATCH_COMMIT;
    private int append = 0;

    public String makeTableName(String string, String string2, int n) {
        String string3 = string.length() > 8 ? string.substring(0, 7) : string;
        String string4 = string2 == null ? "00000000" : Integer.toHexString(string2.hashCode());
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append(string3).append("_");
        this.sqlbuf.append(string4).append("_").append(n);
        return this.sqlbuf.substring(0);
    }

    public AbstractDataTable(String string, String string2, String string3) throws RemoteException {
        try {
            this.conn = DriverManager.getConnection(string, string2, string3);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
            try {
                this.stmt.execute("CHECKPOINT");
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_CONSTRUCTOR, exception);
        }
    }

    @Override
    public void commit() throws RemoteException {
        try {
            this.conn.commit();
            try {
                this.stmt.execute("CHECKPOINT");
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            this.append = 0;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_COMMIT, exception);
        }
    }

    public void setCommitDelay(int n) {
        this.SEDU = n;
    }

    public int getCommitDelay() {
        return this.SEDU;
    }

    public boolean isValidTable(String string) throws RemoteException {
        try {
            this.stmt.executeQuery(SELECT_NUM_PREFIX + string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean createTable(String string, String string2) throws RemoteException {
        try {
            boolean bl = this.conn.getMetaData().getDatabaseProductName().indexOf("HSQL") != -1;
            String string3 = bl ? CREATE_HSQLTABLE_PREFIX : CREATE_TABLE_PREFIX;
            this.stmt.execute(string3 + string + "(" + string2 + ");");
            this.commit();
            return true;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_CREATE_TABLE, exception);
        }
    }

    public boolean dropTable(String string) throws RemoteException {
        try {
            this.stmt.execute(DROP_TABLE_PREFIX + string);
            this.commit();
            return true;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_DROP_TABLE, exception);
        }
    }

    public void close() throws RemoteException {
        if (this.EMPTY != null) {
            this.EMPTY.shutdown();
        }
        try {
            this.commit();
            this.stmt.close();
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized int getRecordsAmount(String string, String string2, ParameterMetaInfo parameterMetaInfo) throws RemoteException {
        ResultSet resultSet = null;
        int n = 0;
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append(SELECT_NUM_PREFIX).append(string);
        if (string2 != null) {
            this.sqlbuf.append(" WHERE ").append(string2);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(this.sqlbuf.toString());
            Dbs.setParameterMetaInfo(preparedStatement, parameterMetaInfo);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_GETREC, exception);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return n;
    }

    @Override
    public void dataHandle(Object object) throws Exception {
    }

    @Override
    public void excpHandle(Throwable throwable) {
        this.logException(throwable);
    }

    protected void process(Object object) throws RemoteException {
        if (this.EMPTY == null || !this.EMPTY.isActive()) {
            throw new RemoteException("NullDaemonThread");
        }
        this.EMPTY.process(object);
    }

    protected void registerDataHandler(DataHandler dataHandler, String string) {
        this.EMPTY = new DaemonThread(dataHandler, string);
        this.EMPTY.setPriority(3);
        this.EMPTY.start();
    }

    protected boolean delRecord(String string, String string2, ParameterMetaInfo parameterMetaInfo, boolean bl) throws RemoteException {
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append(DELETE_PREFIX).append(string);
        if (string2 != null) {
            this.sqlbuf.append(" WHERE ").append(string2);
        }
        Statement statement = null;
        try {
            statement = this.conn.prepareStatement(this.sqlbuf.toString());
            Dbs.setParameterMetaInfo((PreparedStatement)statement, parameterMetaInfo);
            statement.execute();
            this.checkDoCommit(bl);
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_DELREC, exception);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean delRecords(String string, boolean bl) throws RemoteException {
        return this.delRecord(string, null, ParameterMetaInfo.EMPTY, true);
    }

    protected void checkDoCommit(boolean bl) throws RemoteException {
        if (bl) {
            this.commit();
        } else {
            ++this.append;
            if (this.append > this.SEDU) {
                this.commit();
            }
        }
    }

    protected void logException(Throwable throwable) {
        ServiceLogger.logError(throwable);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    private class DaemonThread
    extends Thread {
        private LinkedList Q = new LinkedList();
        private Object SEDU = new Object();
        private DataHandler addLast = null;
        private String append = null;
        private boolean clear = false;
        private boolean dataHandle = false;

        public DaemonThread(DataHandler dataHandler, String string) {
            this.addLast = dataHandler;
            this.append = string == null ? "" : string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.clear = true;
            Object var1_1 = null;
            while (this.clear) {
                Object object;
                while (!this.Q.isEmpty()) {
                    this.dataHandle = true;
                    if (this.addLast == null) continue;
                    try {
                        object = this.Q;
                        synchronized (object) {
                            var1_1 = this.Q.removeFirst();
                        }
                        this.addLast.dataHandle(var1_1);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                ServiceLogger.logEvent(this.append + ".Qsize= " + this.Q.size());
                this.dataHandle = false;
                super.setPriority(1);
                Thread.yield();
                object = this.SEDU;
                synchronized (object) {
                    try {
                        this.SEDU.wait();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        break;
                    }
                }
                super.setPriority(10);
            }
            this.Q.clear();
            this.clear = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Object object) {
            Object object2 = this.Q;
            synchronized (object2) {
                this.Q.addLast(object);
            }
            object2 = this.SEDU;
            synchronized (object2) {
                this.SEDU.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.SEDU;
            synchronized (object) {
                this.SEDU.notify();
            }
            this.clear = false;
        }

        public boolean isActive() {
            return this.clear;
        }
    }
}

