/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Vector;
import jet.cs.api.CompletedResultRecord;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.jrserver.JRCompletedResultRecord;
import jet.server.log.ServiceLogger;

public class CompletedResultTableImpl
extends TableImpl
implements Table {
    private static int EMPTY = 1;
    private static int INTEGER = 2;
    private static int SEDU = 3;
    private static String VARCHAR = "COMPLETEDRESULTTABLE_" + SEDU;
    private static int add = 0;
    private static int append = 1;
    private static int close = 2;
    private static int contains = 3;
    private static int createTable = 4;
    private static String[] delete = new String[]{"PublishId", "RecordId", "pub_type", "Status", "Detail"};

    public CompletedResultTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, VARCHAR);
        Table table;
        super.append(new FieldImpl(this.getName(), delete[add], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), delete[append], JDBCType.VARCHAR, 40, 1, 0));
        super.append(new FieldImpl(this.getName(), delete[close], JDBCType.VARCHAR, 128, 1, 0));
        super.append(new FieldImpl(this.getName(), delete[contains], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), delete[createTable], JDBCType.VARCHAR, 256, 17, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "COMPLETEDRESULTTABLE_" + EMPTY;
        if (database.tables().contains(string)) {
            table = database.tables(string);
            if (!updateDetailsTable.isUpdating(string)) {
                this.EMPTY(table, true);
                table.delete(null, ParameterMetaInfo.EMPTY);
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logDebug(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
        string = "COMPLETEDRESULTTABLE_" + INTEGER;
        if (database.tables().contains(string)) {
            table = database.tables(string);
            if (!updateDetailsTable.isUpdating(string)) {
                this.EMPTY(table, false);
                table.delete("", ParameterMetaInfo.EMPTY);
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logDebug(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
    }

    private void EMPTY(Table table, boolean bl) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields("PublishId").getValue());
            fieldValueArray[1].setValue(recordset.fields("RecordId").getValue());
            if (bl) {
                fieldValueArray[2].setValue(recordset.fields("Type").getValue());
            } else {
                fieldValueArray[2].setValue(recordset.fields("pub_type").getValue());
            }
            fieldValueArray[3].setValue(recordset.fields("Status").getValue());
            fieldValueArray[4].setValue(recordset.fields("Detail").getValue());
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    public void addRecords(int n, String string, Vector vector) throws RemoteException {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CompletedResultRecord completedResultRecord = (CompletedResultRecord)vector.get(i);
                FieldValue[] fieldValueArray = super.fields().values();
                fieldValueArray[add].setValue(new Integer(n));
                fieldValueArray[append].setValue(string);
                fieldValueArray[close].setValue(completedResultRecord.getType());
                fieldValueArray[contains].setValue(new Integer(completedResultRecord.getStatus()));
                fieldValueArray[createTable].setValue(completedResultRecord.getDetail());
                try {
                    super.insert(fieldValueArray);
                    continue;
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    throw new RemoteException("", sQLException);
                }
            }
        }
    }

    public Vector getRecordsByPublishID(int n) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<JRCompletedResultRecord> vector = new Vector<JRCompletedResultRecord>();
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(delete[add]).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(this.fields(delete[add]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
            while (recordset.next()) {
                JRCompletedResultRecord jRCompletedResultRecord = new JRCompletedResultRecord(recordset.getString(delete[close]), recordset.getInt(delete[contains]), recordset.getString(delete[createTable]));
                vector.add(jRCompletedResultRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RemoteException("", exception);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    public boolean deleteRecordsByPublishID(int n) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(delete[add]).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(this.fields(delete[add]).getName()).append("=?");
            try {
                bl = super.delete(stringBuffer.toString(), parameterMetaInfo) > 0;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return false;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RemoteException("", exception);
        }
        return bl;
    }

    public boolean deleteRecordsByRecordID(String string) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(delete[append]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(this.fields(delete[append]).getName()).append("=?");
            try {
                bl = super.delete(stringBuffer.toString(), parameterMetaInfo) > 0;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return false;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RemoteException("", exception);
        }
        return bl;
    }

    public int deleteAllRecords() throws SQLException {
        return super.delete(null, ParameterMetaInfo.EMPTY);
    }
}

