/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import guitools.toolkit.JDebug;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.db.VersionController;
import jet.server.log.ServiceLogger;
import jet.server.schedule.InternalStorableTask;

public class DeleteVersionTask
extends InternalStorableTask {
    int iVersionId;
    static int ttl = 0;

    public DeleteVersionTask() {
        ++ttl;
    }

    public DeleteVersionTask(int n) {
        this.iVersionId = n;
    }

    @Override
    public void init(Properties properties) throws Exception {
        super.init(properties);
        this.iVersionId = CSUtil.parseInt((String)properties.get("jrs.version_id"));
    }

    public int getVersionId() {
        return this.iVersionId;
    }

    @Override
    public void run() {
        try {
            VersionController versionController = this.dataService.getVersionController();
            if (versionController != null) {
                versionController.removeVersion(this.iVersionId);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            JDebug.WARNING((Throwable)throwable);
        }
    }

    @Override
    public boolean hasError() {
        return false;
    }

    @Override
    public String getErrorMsg() {
        return null;
    }

    @Override
    public void stopExec() {
    }

    @Override
    public void stopExec(boolean bl) {
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.task_class", this.getClass().getName());
        properties2.put("jrs.version_id", String.valueOf(this.iVersionId));
        return properties2;
    }
}

