/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.db.DeleteVersionTask;
import jet.server.db.VersionController;
import jet.server.jrc.quartz.JRSchedulingServiceQuartzImpl;
import jet.server.log.ServiceLogger;

public class ExpirationManager {
    JRSchedulingServiceQuartzImpl schdServ;
    VersionController versionManager;

    public ExpirationManager(VersionController versionController, JRSchedulingServiceQuartzImpl jRSchedulingServiceQuartzImpl) {
        this.versionManager = versionController;
        this.schdServ = jRSchedulingServiceQuartzImpl;
    }

    public void addVersion(int n, Date date) {
        Properties properties = new Properties();
        properties.put("jrs.version_id", String.valueOf(n));
        properties.put("jrs.task_class", DeleteVersionTask.class.getName());
        properties.put("jrs.launch_type", (Object)1);
        properties.put("jrs.exe_year", String.valueOf(date.getYear()));
        properties.put("jrs.exe_month", String.valueOf(date.getMonth()));
        properties.put("jrs.exe_day", String.valueOf(date.getDay()));
        properties.put("jrs.exe_hour", String.valueOf(date.getHours()));
        properties.put("jrs.exe_min", String.valueOf(date.getMinutes()));
        properties.put("jrs.exe_sec", String.valueOf(date.getSeconds()));
        try {
            this.schdServ.submit(properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void removeVersion(int n) {
        Properties properties = this.getScheduleByVersionId(n);
        if (properties != null) {
            try {
                this.schdServ.removeScheduledTask((String)properties.get("jrs.task_id"));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    public void updateVersion(int n, Date date) {
        this.removeVersion(n);
        this.addVersion(n, date);
    }

    protected Properties getScheduleByVersionId(int n) {
        try {
            Vector vector = this.schdServ.getScheduledTasks();
            for (int i = 0; i < vector.size(); ++i) {
                Properties properties = (Properties)vector.elementAt(i);
                String string = (String)properties.get("jrs.version_id");
                if (null == string || CSUtil.parseInt(string) != n) continue;
                return properties;
            }
            return null;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }
}

