/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.Connector;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.IDGenerator;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.log.ServiceLogger;

public abstract class DB
implements DBAdapter {
    protected Connector connector;
    protected IDGenerator idGen = null;

    @Override
    public String formatValue(boolean bl) {
        return bl ? "1" : "0";
    }

    @Override
    public String getDefaultSchema(String string, Connection connection) {
        String string2 = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            string2 = databaseMetaData.getUserName();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 2);
        }
        return string2 == null ? string : string2;
    }

    @Override
    public String formatValue(String string) {
        if (string == null) {
            return "NULL";
        }
        if (string.trim().length() == 0) {
            return "''";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n = 0;
        int n2 = -1;
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append("'");
        while ((n2 = string.indexOf("'", n)) != -1) {
            stringBuffer.append(string.substring(n, n2 == 0 ? 0 : n2)).append("''");
            n = n2 + 1;
        }
        stringBuffer.append(string.substring(n)).append("'");
        string2 = stringBuffer.substring(0);
        return string2;
    }

    @Override
    public String formatValue(Date date) {
        return "{d " + this.formatValue(date.toString()) + "}";
    }

    @Override
    public String formatValue(Time time) {
        return "{t " + this.formatValue(time.toString()) + "}";
    }

    @Override
    public String formatValue(Timestamp timestamp) {
        return "{ts " + this.formatValue(timestamp.toString()) + "}";
    }

    @Override
    public final void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public final void setIDGenerator(IDGenerator iDGenerator) {
        this.idGen = iDGenerator;
    }

    @Override
    public final Recordset select(Field[] fieldArray, Table[] tableArray, String string, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException {
        return this.select(fieldArray, tableArray, string, parameterMetaInfo, bl, 1);
    }

    @Override
    public final Recordset select(Field[] fieldArray, Table[] tableArray, String string, ParameterMetaInfo parameterMetaInfo, boolean bl, int n) throws SQLException {
        return this.select(fieldArray, tableArray, string, parameterMetaInfo, bl, n, 1004);
    }

    protected final String sqlWhere(String string) {
        return string != null && string.length() > 0 ? " " + string : "";
    }

    @Override
    public final int insert(Table table, FieldValue[] fieldValueArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = fieldValueArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = fieldValueArray[i].getValue();
            String string = fieldValueArray[i].getName();
            int n2 = fieldValueArray[i].getJDBCType().dataType();
            stringBuffer2.append(string);
            stringBuffer3.append("?");
            if (fieldValueArray[i].isIdentity() && object == null) {
                int n3 = 0;
                try {
                    n3 = this.getID(table, table.fields(string));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                object = String.valueOf(n3);
            }
            parameterMetaInfo.add(string, object, n2);
            if (i >= n - 1) continue;
            stringBuffer2.append(", ");
            stringBuffer3.append(", ");
        }
        stringBuffer.append("INSERT INTO ").append(table.getName()).append(" (");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(") VALUES (");
        stringBuffer.append(stringBuffer3);
        stringBuffer.append(")");
        return this.executeUpdate(stringBuffer.toString(), parameterMetaInfo);
    }

    @Override
    public int insert(Table table, List list) throws SQLException {
        Connection connection = this.connector.getConnection();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            FieldValue[] fieldValueArray = (FieldValue[])iterator.next();
            int n2 = fieldValueArray.length;
            stringBuffer2.delete(0, stringBuffer2.length());
            stringBuffer3.delete(0, stringBuffer3.length());
            for (int i = 0; i < n2; ++i) {
                if (fieldValueArray[i] == null) continue;
                Object object = fieldValueArray[i].getValue();
                String string = fieldValueArray[i].getName();
                int n3 = fieldValueArray[i].getJDBCType().dataType();
                stringBuffer2.append(string);
                stringBuffer3.append("?");
                parameterMetaInfo.add(string, object, n3);
                stringBuffer2.append(", ");
                stringBuffer3.append(", ");
            }
            if (stringBuffer2.lastIndexOf(", ") == stringBuffer2.length() - 2) {
                stringBuffer2.delete(stringBuffer2.length() - 2, stringBuffer2.length());
                stringBuffer3.delete(stringBuffer3.length() - 2, stringBuffer3.length());
            }
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("INSERT INTO ").append(table.getName()).append(" (");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(") VALUES (");
            stringBuffer.append(stringBuffer3);
            stringBuffer.append(")");
            String string = stringBuffer.toString();
            try {
                n += this.executeUpdate(string, parameterMetaInfo);
            }
            catch (Throwable throwable) {
                connection.clearWarnings();
                ServiceLogger.logError(throwable);
                ServiceLogger.logError(string);
            }
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        connection.close();
        return n;
    }

    @Override
    public int delete(Table table, String string, ParameterMetaInfo parameterMetaInfo) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(table.getName()).append(this.sqlWhere(string));
        return this.executeUpdate(stringBuffer.toString(), parameterMetaInfo);
    }

    @Override
    public final int update(Table table, FieldValue[] fieldValueArray, String string, ParameterMetaInfo parameterMetaInfo) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo2 = new ParameterMetaInfo();
        stringBuffer.append("UPDATE ").append(table.getName()).append(" SET ");
        int n = fieldValueArray.length;
        for (int i = 0; i < n; ++i) {
            FieldValue fieldValue = fieldValueArray[i];
            stringBuffer.append(fieldValue.getName()).append("=?");
            parameterMetaInfo2.add(fieldValue.getName(), fieldValue.getValue(), fieldValue.getJDBCType().dataType());
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" ").append(this.sqlWhere(string));
        parameterMetaInfo2.add(parameterMetaInfo);
        return this.executeUpdate(stringBuffer.toString(), parameterMetaInfo2);
    }

    protected abstract String valueToString(StringBuffer var1, Table var2, FieldValue var3);

    /*
     * Unable to fully structure code
     */
    @Override
    public final Recordset executeQuery(Field[] var1_1, String var2_2, ParameterMetaInfo var3_3, int var4_4, int var5_5) throws SQLException {
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = System.currentTimeMillis();
        var11_10 = false;
        try {
            var7_7 = this.connector.getConnection();
            var8_8 = var7_7.prepareStatement(var2_2, var5_5, 1007);
            this.EMPTY(var8_8, var3_3);
            var8_8.setEscapeProcessing(true);
            var12_11 = var8_8.executeQuery();
            switch (var4_4) {
                case 1: {
                    var6_6 = new LinkedRecordset(var1_1, var7_7, var8_8, var12_11);
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 2: {
                    var6_6 = new CachedRecordset(var1_1, var12_11);
                    var12_11.close();
                    try {
                        var8_8.close();
                        var8_8 = null;
                    }
                    catch (Exception var13_17) {
                        ServiceLogger.logError(var13_17, 3);
                    }
                    try {
                        var7_7.close();
                        var7_7 = null;
                        ** break;
lbl30:
                        // 1 sources

                    }
                    catch (Exception var13_18) {
                        ServiceLogger.logError(var13_18, 3);
                        ** break;
                    }
lbl34:
                    // 1 sources

                    break;
                }
                default: {
                    throw new SQLException("Not support recordset type:" + var4_4);
                }
            }
        }
        catch (Throwable var12_15) {
            var11_10 = true;
            ServiceLogger.logError(var12_15);
            ServiceLogger.logError(var2_2 + ", paras=" + var3_3);
            throw new SQLException(var12_15.getMessage());
        }
        finally {
            if (var11_10) {
                try {
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                    var6_6 = null;
                }
                catch (Exception var12_12) {
                    ServiceLogger.logError(var12_12, 3);
                }
                try {
                    if (var8_8 != null) {
                        var8_8.close();
                    }
                    var8_8 = null;
                }
                catch (Exception var12_13) {
                    ServiceLogger.logError(var12_13, 3);
                }
                try {
                    if (var7_7 != null) {
                        var7_7.close();
                    }
                    var7_7 = null;
                }
                catch (Exception var12_14) {
                    ServiceLogger.logError(var12_14, 3);
                }
            }
        }
        var12_16 = System.currentTimeMillis() - var9_9;
        ServiceLogger.print(var2_2 + " paras=" + var3_3 + " ( " + var12_16 + " ms )");
        return var6_6;
    }

    protected Timestamp queryDBTimestamp(String string) throws SQLException {
        ResultSet resultSet = null;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.connector.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                Timestamp timestamp = resultSet.getTimestamp(1, Calendar.getInstance(TimeZone.getTimeZone("GMT-0")));
                return timestamp;
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            ServiceLogger.logError(string);
            throw new SQLException(throwable.getMessage());
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                statement.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return null;
    }

    private void EMPTY(PreparedStatement preparedStatement, ParameterMetaInfo parameterMetaInfo) throws SQLException {
        if (parameterMetaInfo == null) {
            ServiceLogger.logDebug("DB.setParameterMetaInfo: war the paras is null.");
            return;
        }
        int n = parameterMetaInfo.getParameterCount();
        if (n == 0) {
            if (parameterMetaInfo != ParameterMetaInfo.EMPTY) {
                ServiceLogger.logDebug("DB.setParameterMetaInfo: warn, the paras is empty.");
            }
            return;
        }
        block24: for (int i = 1; i <= n; ++i) {
            int n2 = parameterMetaInfo.getParameterMode(i);
            int n3 = parameterMetaInfo.getJDBCType(i);
            Object object = parameterMetaInfo.getValue(i);
            if (object == null) {
                this.setNullParam(preparedStatement, i, n3);
                continue;
            }
            if (n2 == 4) {
                preparedStatement.setObject(i, object);
                continue;
            }
            switch (n3) {
                case -7: 
                case 16: {
                    boolean bl = Boolean.parseBoolean(object.toString());
                    preparedStatement.setShort(i, (short)(bl ? 1 : 0));
                    continue block24;
                }
                case -5: {
                    preparedStatement.setLong(i, Long.parseLong(object.toString()));
                    continue block24;
                }
                case 91: {
                    preparedStatement.setDate(i, (Date)object);
                    continue block24;
                }
                case 2: 
                case 3: {
                    preparedStatement.setBigDecimal(i, new BigDecimal(object.toString()));
                    continue block24;
                }
                case 8: {
                    preparedStatement.setDouble(i, Double.parseDouble(object.toString()));
                    continue block24;
                }
                case 6: {
                    preparedStatement.setFloat(i, Float.parseFloat(object.toString()));
                    continue block24;
                }
                case 4: {
                    preparedStatement.setInt(i, Integer.parseInt(object.toString()));
                    continue block24;
                }
                case 7: {
                    preparedStatement.setDouble(i, Float.parseFloat(object.toString()));
                    continue block24;
                }
                case 5: {
                    preparedStatement.setShort(i, Short.parseShort(object.toString()));
                    continue block24;
                }
                case 92: {
                    preparedStatement.setTime(i, (Time)object);
                    continue block24;
                }
                case 93: {
                    preparedStatement.setTimestamp(i, (Timestamp)object);
                    continue block24;
                }
                case -6: {
                    preparedStatement.setShort(i, Short.parseShort(object.toString()));
                    continue block24;
                }
                case -4: 
                case -3: 
                case -2: {
                    Object object2;
                    if (object instanceof byte[]) {
                        preparedStatement.setBytes(i, (byte[])object);
                        continue block24;
                    }
                    if (object instanceof InputStream) {
                        object2 = (InputStream)object;
                        try {
                            preparedStatement.setBinaryStream(i, (InputStream)object2, ((InputStream)object2).available());
                            continue block24;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    this.setNullParam(preparedStatement, i, n3);
                    continue block24;
                }
                case 2004: {
                    Object object2;
                    if (object instanceof byte[]) {
                        preparedStatement.setBytes(i, (byte[])object);
                        continue block24;
                    }
                    if (object instanceof InputStream) {
                        object2 = (InputStream)object;
                        try {
                            preparedStatement.setBinaryStream(i, (InputStream)object2, ((InputStream)object2).available());
                            continue block24;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    if (object instanceof Blob) {
                        preparedStatement.setBlob(i, (Blob)object);
                        continue block24;
                    }
                    this.setNullParam(preparedStatement, i, n3);
                    continue block24;
                }
                case 2005: {
                    Object object2;
                    if (object instanceof String) {
                        preparedStatement.setString(i, (String)object);
                        continue block24;
                    }
                    if (object instanceof InputStream) {
                        object2 = (InputStream)object;
                        try {
                            preparedStatement.setAsciiStream(i, (InputStream)object2, ((InputStream)object2).available());
                            continue block24;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    if (object instanceof Reader) {
                        object2 = (Reader)object;
                        preparedStatement.setCharacterStream(i, (Reader)object2, Integer.MAX_VALUE);
                        continue block24;
                    }
                    if (object instanceof Clob) {
                        preparedStatement.setClob(i, (Clob)object);
                        continue block24;
                    }
                    this.setNullParam(preparedStatement, i, n3);
                    continue block24;
                }
                case -1: 
                case 1: 
                case 12: {
                    Object object2 = object.toString();
                    object2 = ((String)object2).isEmpty() ? " " : object2;
                    preparedStatement.setString(i, (String)object2);
                    continue block24;
                }
                default: {
                    preparedStatement.setObject(i, object);
                }
            }
        }
    }

    public void setNullParam(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        preparedStatement.setNull(n, n2);
    }

    @Override
    public final int executeUpdate(String string, ParameterMetaInfo parameterMetaInfo) throws SQLException {
        int n = 0;
        Connection connection = null;
        Statement statement = null;
        long l = System.currentTimeMillis();
        try {
            connection = this.connector.getConnection();
            statement = connection.prepareStatement(string);
            this.EMPTY((PreparedStatement)statement, parameterMetaInfo);
            statement.setEscapeProcessing(true);
            n = statement.executeUpdate();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            ServiceLogger.logError(string + " paras=" + parameterMetaInfo);
            throw new SQLException(throwable.getMessage());
        }
        finally {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.print(string + " paras=" + parameterMetaInfo + " ( " + l2 + " ms )");
        return n;
    }

    @Override
    public final boolean execute(String string) throws SQLException {
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        long l = System.currentTimeMillis();
        ServiceLogger.logDebug(string, 4);
        try {
            connection = this.connector.getConnection();
            statement = connection.createStatement();
            statement.setEscapeProcessing(true);
            bl = statement.execute(string);
        }
        catch (Throwable throwable) {
            if (!string.startsWith("CREATE")) {
                ServiceLogger.logError(throwable);
                ServiceLogger.logError(string);
            }
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(throwable);
        }
        finally {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.print(string + " ( " + l2 + " ms )");
        if (string.startsWith("CREATE")) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
        }
        return bl;
    }

    @Override
    public final boolean createTable(Table table) throws SQLException {
        String string = this.getDdlSQL(table);
        try {
            this.execute(string);
        }
        catch (SQLException sQLException) {
            try {
                this.execute("SELECT * FROM " + table.getName() + " WHERE 0=1");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    ServiceLogger.logError(interruptedException, 3);
                }
            }
            catch (SQLException sQLException2) {
                ServiceLogger.logError(sQLException);
                ServiceLogger.logError(string);
                throw sQLException;
            }
        }
        return true;
    }

    @Override
    public final int getID(Table table, Field field) throws SQLException {
        if (this.idGen == null) {
            throw new SQLException("ID generator is null.");
        }
        return this.idGen.getID(table, field);
    }

    @Override
    public final void setID(Table table, Field field, int n) throws SQLException {
        if (this.idGen == null) {
            throw new SQLException("ID generator is null.");
        }
        this.idGen.setID(table, field, n);
    }

    @Override
    public Timestamp getCurrentTimestamp() throws SQLException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        timestamp.setNanos((int)(System.nanoTime() % 1000000L));
        return timestamp;
    }

    protected String getForeignKeyString(Field[] fieldArray) {
        ArrayList arrayList;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < fieldArray.length; ++i) {
            object2 = fieldArray[i];
            if (!object2.isForeignKey()) continue;
            object = object2.getForeignTableName();
            arrayList = (ArrayList)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(object2.getName());
                hashMap.put(object, arrayList);
                continue;
            }
            arrayList.add(object2.getName());
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (hashMap.size() > 0) {
            object2 = hashMap.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                arrayList = new StringBuffer();
                String string = (String)object.next();
                ArrayList arrayList2 = (ArrayList)hashMap.get(string);
                if (string == null || string.length() == 0 || arrayList2 == null || arrayList2.size() <= 0) continue;
                Iterator iterator = arrayList2.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    ((StringBuffer)((Object)arrayList)).append((String)iterator.next());
                    if (n < arrayList2.size() - 1) {
                        ((StringBuffer)((Object)arrayList)).append(",");
                    }
                    ++n;
                }
                stringBuffer.append(" FOREIGN KEY (").append((StringBuffer)((Object)arrayList)).append(")");
                stringBuffer.append(" REFERENCES ").append(string).append("(").append((StringBuffer)((Object)arrayList)).append(")");
            }
        }
        return stringBuffer.toString();
    }

    private static abstract class RecordsetImpl
    implements Recordset {
        protected Field[] fields;
        protected FieldValue[] values;
        private HashMap append = new HashMap();
        private StringBuffer clear = new StringBuffer();

        RecordsetImpl(Field[] fieldArray, ResultSetMetaData resultSetMetaData) throws Throwable {
            int n = fieldArray.length;
            this.fields = new Field[n];
            this.values = new FieldValue[n];
            for (int i = 0; i < n; ++i) {
                FieldImpl fieldImpl = (FieldImpl)fieldArray[i].createClone();
                this.fields[i] = fieldImpl;
                this.values[i] = fieldImpl.createFieldValue();
                String string = resultSetMetaData.getColumnName(i + 1);
                string = string == null || string.trim().length() == 0 ? String.valueOf(i + 1) : string;
                fieldImpl.setFieldName(string);
                fieldImpl.setSize(resultSetMetaData.getColumnDisplaySize(i + 1));
                this.append.put(fieldImpl.getName(), new Integer(i));
            }
        }

        @Override
        public final FieldValue[] fields() {
            return this.values;
        }

        @Override
        public final FieldValue fields(int n) {
            FieldValue[] fieldValueArray = this.fields();
            return fieldValueArray[n];
        }

        @Override
        public final FieldValue fields(String string) {
            return this.fields(this.findField(string));
        }

        @Override
        public final Object getValue(int n) {
            FieldValue fieldValue = this.fields(n);
            return fieldValue != null ? fieldValue.getValue() : null;
        }

        @Override
        public final Object getValue(String string) {
            FieldValue fieldValue = this.fields(string);
            return fieldValue != null ? fieldValue.getValue() : null;
        }

        @Override
        public final int columns() {
            return this.fields.length;
        }

        @Override
        public final Date getDate(int n) throws SQLException {
            return this.fields(n).getDate();
        }

        @Override
        public final Date getDate(String string) throws SQLException {
            return this.getDate(this.findField(string));
        }

        @Override
        public final Time getTime(int n) throws SQLException {
            return this.fields(n).getTime();
        }

        @Override
        public final Time getTime(String string) throws SQLException {
            return this.getTime(this.findField(string));
        }

        @Override
        public final Timestamp getTimestamp(int n) throws SQLException {
            return this.fields(n).getTimestamp();
        }

        @Override
        public final Timestamp getTimestamp(String string) throws SQLException {
            return this.getTimestamp(this.findField(string));
        }

        @Override
        public final boolean getBoolean(int n) throws SQLException {
            return this.fields(n).getBoolean();
        }

        @Override
        public final boolean getBoolean(String string) throws SQLException {
            return this.getBoolean(this.findField(string));
        }

        @Override
        public final byte getByte(int n) throws SQLException {
            return this.fields(n).getByte();
        }

        @Override
        public final byte getByte(String string) throws SQLException {
            return this.getByte(this.findField(string));
        }

        @Override
        public final short getShort(int n) throws SQLException {
            return this.fields(n).getShort();
        }

        @Override
        public final short getShort(String string) throws SQLException {
            return this.getShort(this.findField(string));
        }

        @Override
        public final int getInt(int n) throws SQLException {
            return this.fields(n).getInt();
        }

        @Override
        public final int getInt(String string) throws SQLException {
            return this.getInt(this.findField(string));
        }

        @Override
        public final long getLong(int n) throws SQLException {
            return this.fields(n).getLong();
        }

        @Override
        public final long getLong(String string) throws SQLException {
            return this.getLong(this.findField(string));
        }

        @Override
        public final float getFloat(int n) throws SQLException {
            return this.fields(n).getFloat();
        }

        @Override
        public final float getFloat(String string) throws SQLException {
            return this.getFloat(this.findField(string));
        }

        @Override
        public final double getDouble(int n) throws SQLException {
            return this.fields(n).getDouble();
        }

        @Override
        public final double getDouble(String string) throws SQLException {
            return this.getDouble(this.findField(string));
        }

        @Override
        public final String getString(int n) throws SQLException {
            return this.fields(n).getString();
        }

        @Override
        public final String getString(String string) throws SQLException {
            return this.getString(this.findField(string));
        }

        @Override
        public final byte[] getBytes(int n) throws SQLException {
            return this.fields(n).getBytes();
        }

        @Override
        public final byte[] getBytes(String string) throws SQLException {
            return this.getBytes(this.findField(string));
        }

        protected int findField(String string) {
            return (Integer)this.append.get(string.toUpperCase());
        }

        protected FieldValue[] newRecord(ResultSet resultSet) throws SQLException {
            FieldValue[] fieldValueArray = new FieldValue[this.fields.length];
            int n = fieldValueArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                fieldValueArray[i] = this.fields[i].createFieldValue();
                Object object2 = resultSet.getObject(i + 1);
                if (object2 instanceof Blob) {
                    object = (Blob)object2;
                    object2 = object.getBytes(1L, (int)object.length());
                } else if (object2 instanceof Clob) {
                    object = (Clob)object2;
                    object2 = object.getSubString(1L, (int)object.length());
                } else if (object2 instanceof InputStream) {
                    try {
                        object = (InputStream)object2;
                        byte[] byArray = new byte[((InputStream)object).available()];
                        ((InputStream)object).read(byArray);
                        object2 = byArray;
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException);
                    }
                }
                fieldValueArray[i].setValue(object2);
            }
            return fieldValueArray;
        }

        public String toString() {
            this.clear.delete(0, this.clear.length());
            int n = this.columns();
            for (int i = 0; i < n; ++i) {
                this.clear.append(this.values[i].getName()).append("=").append("'").append(this.values[i].getValue()).append("'");
                if (i >= n - 1) continue;
                this.clear.append(", ");
            }
            return this.clear.toString();
        }

        protected void finalize() throws Throwable {
            this.append.clear();
            this.append = null;
            this.fields = null;
            this.values = null;
            super.finalize();
        }
    }

    public static final class CachedRecordset
    extends RecordsetImpl
    implements Recordset {
        private List SEDU = new LinkedList();
        private Iterator add;

        public CachedRecordset(Field[] fieldArray, ResultSet resultSet) throws Throwable {
            super(fieldArray, resultSet.getMetaData());
            while (resultSet.next()) {
                this.SEDU.add(this.newRecord(resultSet));
            }
            this.first();
        }

        @Override
        public int getSetType() {
            return 2;
        }

        @Override
        public int rows() {
            return this.SEDU.size();
        }

        @Override
        public boolean first() {
            this.add = this.SEDU.iterator();
            return true;
        }

        @Override
        public boolean next() {
            if (this.add.hasNext()) {
                this.values = (FieldValue[])this.add.next();
                return true;
            }
            return false;
        }

        @Override
        public void delete() {
            this.add.remove();
        }

        @Override
        public void close() {
            this.SEDU.clear();
            this.add = null;
        }

        @Override
        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    private final class LinkedRecordset
    extends RecordsetImpl
    implements Recordset {
        private Connection SEDU;
        private Statement available;
        private ResultSet beforeFirst;

        LinkedRecordset(Field[] fieldArray, Connection connection, Statement statement, ResultSet resultSet) throws Throwable {
            super(fieldArray, resultSet.getMetaData());
            this.SEDU = connection;
            this.available = statement;
            this.beforeFirst = resultSet;
        }

        @Override
        public int getSetType() {
            return 1;
        }

        @Override
        public int rows() {
            return 0;
        }

        @Override
        public boolean first() {
            try {
                this.beforeFirst.beforeFirst();
                return true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return false;
            }
        }

        @Override
        public boolean next() {
            block10: {
                try {
                    if (!this.beforeFirst.next()) break block10;
                    int n = this.columns();
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        Object object2 = this.beforeFirst.getObject(i + 1);
                        if (object2 instanceof Blob) {
                            object = (Blob)object2;
                            object2 = object.getBytes(1L, (int)object.length());
                        } else if (object2 instanceof Clob) {
                            object = (Clob)object2;
                            object2 = object.getSubString(1L, (int)object.length());
                        } else if (object2 instanceof InputStream) {
                            try {
                                object = (InputStream)object2;
                                byte[] byArray = new byte[((InputStream)object).available()];
                                ((InputStream)object).read(byArray);
                                object2 = byArray;
                            }
                            catch (IOException iOException) {
                                throw new SQLException(iOException);
                            }
                        }
                        this.values[i].setValue(object2);
                    }
                    return true;
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
            }
            return false;
        }

        @Override
        public void delete() {
        }

        @Override
        public void close() {
            if (this.SEDU == null) {
                return;
            }
            try {
                this.beforeFirst.close();
                this.beforeFirst = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                this.available.close();
                this.available = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                this.SEDU.close();
                this.SEDU = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }

        @Override
        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

