/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.cfg;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.adapter.DB;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.log.ServiceLogger;

public class PropsTable
extends TableImpl {
    public static final int OLDVERSION = 1;
    public static final int VERSION = 2;
    private static final String BIT = "CFG_PROPS_";
    public static final String TABLE_NAME = "CFG_PROPS_2";
    private static final int BLOB = 512;
    private static final String[] SEDU = new String[]{"PROP_NAME", "PROP_KEY", "PROP_VALUE", "IS_LOB", "LOB_VAL"};
    private static final int VARCHAR = 0;
    private static final int add = 1;
    private static final int addBatch = 2;
    private static final int append = 3;
    private static final int appendSystemTable = 4;
    public static final String PROP_NAME_SERVER_PROPERTIES = "server.properties";
    public static final String PROP_NAME_MAILCONFIG_PROPERTIES = "mailconfig.properties";
    public static final String PROP_NAME_CLUSTERWEIGHT_PROPERTIES = "clusterweight.properties";
    public static final String PROP_NAME_PREFERENCE = "preference";

    public PropsTable(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), SEDU[0], JDBCType.VARCHAR, 128, 9, 0));
        super.append(new FieldImpl(this.getName(), SEDU[1], JDBCType.VARCHAR, 512, 9, 0));
        super.append(new FieldImpl(this.getName(), SEDU[2], JDBCType.VARCHAR, 512, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU[3], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[4], JDBCType.BLOB, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        ((DatabaseImpl)database).appendSystemTable(this);
        String string = "CFG_PROPS_1";
        super.upgradeOldTable(database, updateDetailsTable, "CFG_PROPS_1", 1);
    }

    private String BIT(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private byte[] encode(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryKeys(String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Field[] fieldArray = new Field[]{this.fields(1)};
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(SEDU[0], string, JDBCType.VARCHAR.dataType());
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(SEDU[0]).append("=?");
        Recordset recordset = super.query(fieldArray, stringBuilder.toString(), parameterMetaInfo, false, 1, 1003);
        try {
            while (recordset.next()) {
                arrayList.add(recordset.getString(0));
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties queryProp(String string) throws SQLException {
        Properties properties = new Properties();
        Field[] fieldArray = new Field[]{this.fields(1), this.fields(3), this.fields(2), this.fields(4)};
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(SEDU[0], string, JDBCType.VARCHAR.dataType());
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(SEDU[0]).append("=?");
        Recordset recordset = super.query(fieldArray, stringBuilder.toString(), parameterMetaInfo, false, 1, 1003);
        try {
            while (recordset.next()) {
                String string2 = recordset.getString(0);
                boolean bl = recordset.getBoolean(1);
                String string3 = null;
                string3 = !bl ? recordset.getString(2) : this.BIT(recordset.getBytes(3));
                if (string3 == null) continue;
                properties.put(string2, string3);
            }
        }
        finally {
            recordset.close();
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryProp(String string, String string2) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(3), this.fields(2), this.fields(4)};
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(SEDU[0], string, JDBCType.VARCHAR.dataType());
        parameterMetaInfo.add(SEDU[1], string2, JDBCType.VARCHAR.dataType());
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(SEDU[0]).append("=?").append(" AND ").append(SEDU[1]).append("=?");
        Recordset recordset = super.query(fieldArray, stringBuilder.toString(), parameterMetaInfo, false, 1, 1003);
        String string3 = null;
        try {
            if (recordset.next()) {
                boolean bl = recordset.getBoolean(0);
                string3 = !bl ? recordset.getString(1) : this.BIT(recordset.getBytes(2));
            }
        }
        finally {
            recordset.close();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties queryBytes(String string) throws SQLException {
        Properties properties = new Properties();
        Field[] fieldArray = new Field[]{this.fields(1), this.fields(3), this.fields(2), this.fields(4)};
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(SEDU[0], string, JDBCType.VARCHAR.dataType());
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(SEDU[0]).append("=?");
        Recordset recordset = super.query(fieldArray, stringBuilder.toString(), parameterMetaInfo, false, 1, 1003);
        try {
            while (recordset.next()) {
                String string2 = recordset.getString(0);
                boolean bl = recordset.getBoolean(1);
                String string3 = null;
                byte[] byArray = null;
                if (!bl) {
                    string3 = recordset.getString(2);
                    if (string3 != null) {
                        byArray = this.encode(string3);
                    }
                } else {
                    byArray = recordset.getBytes(3);
                }
                if (byArray == null) continue;
                properties.put(string2, byArray);
            }
        }
        finally {
            recordset.close();
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] queryBytes(String string, String string2) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(3), this.fields(2), this.fields(4)};
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(SEDU[0], string, JDBCType.VARCHAR.dataType());
        parameterMetaInfo.add(SEDU[1], string2, JDBCType.VARCHAR.dataType());
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(SEDU[0]).append("=?").append(" AND ").append(SEDU[1]).append("=?");
        Recordset recordset = super.query(fieldArray, stringBuilder.toString(), parameterMetaInfo, false, 1, 1003);
        String string3 = null;
        byte[] byArray = null;
        try {
            if (recordset.next()) {
                boolean bl = recordset.getBoolean(0);
                if (!bl) {
                    string3 = recordset.getString(1);
                    if (string3 != null) {
                        byArray = this.encode(string3);
                    }
                } else {
                    byArray = recordset.getBytes(2);
                }
            }
        }
        finally {
            recordset.close();
        }
        return byArray;
    }

    public void updateBytes(String string, String string2, byte[] byArray) throws SQLException {
        Properties properties = new Properties();
        properties.put(string2, byArray);
        this.updateProp(string, properties, false);
    }

    public void updateProp(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        properties.put(string2, string3);
        this.updateProp(string, properties, false);
    }

    public void updateProp(final String string, final Properties properties, final boolean bl) throws SQLException {
        try {
            ((DatabaseImpl)this.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    PropsTable.this.doUpdateProp(connection, string, properties, bl);
                    return null;
                }
            });
        }
        catch (LockException lockException) {
            ServiceLogger.logError(lockException);
            throw new SQLException(lockException.getMessage());
        }
    }

    public void doUpdateProp(String string, Properties properties, boolean bl) throws SQLException {
        this.updateProp(string, properties, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateProp(Connection connection, String string, Properties properties, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("DELETE FROM ").append(this.getName()).append(" WHERE ").append(SEDU[0]).append("=?");
            preparedStatement = connection.prepareStatement(stringBuilder.toString());
            try {
                preparedStatement.setString(1, string);
                int n = preparedStatement.executeUpdate();
            }
            finally {
                preparedStatement.close();
            }
        }
        stringBuilder.append("DELETE FROM ").append(this.getName()).append(" WHERE ").append(SEDU[0]).append("=?").append(" AND ").append(SEDU[1]).append("=?");
        preparedStatement = connection.prepareStatement(stringBuilder.toString());
        try {
            Object object = properties.keySet().iterator();
            while (object.hasNext()) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, object.next().toString());
                preparedStatement.addBatch();
            }
            object = preparedStatement.executeBatch();
        }
        finally {
            preparedStatement.close();
        }
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append("INSERT INTO ").append(this.getName()).append("(").append(SEDU[0]).append(",").append(SEDU[1]).append(",").append(SEDU[2]).append(",").append(SEDU[3]).append(",").append(SEDU[4]).append(")").append(" VALUES(?,?,?,?,?)");
        preparedStatement = connection.prepareStatement(stringBuilder.toString());
        try {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, (String)entry.getKey());
                Object object = entry.getValue();
                byte[] byArray = null;
                String string2 = null;
                boolean bl2 = false;
                if (object instanceof byte[]) {
                    byArray = (byte[])object;
                    bl2 = true;
                } else {
                    string2 = (String)object;
                    boolean bl3 = bl2 = string2.length() > 512;
                    if (bl2) {
                        byArray = this.encode(string2);
                    }
                }
                if (!bl2) {
                    preparedStatement.setString(3, string2);
                    preparedStatement.setBoolean(4, bl2);
                    ((DB)this.adapter).setNullParam(preparedStatement, 5, 2004);
                } else {
                    ((DB)this.adapter).setNullParam(preparedStatement, 3, 12);
                    preparedStatement.setBoolean(4, bl2);
                    preparedStatement.setBytes(5, byArray);
                }
                preparedStatement.addBatch();
            }
            Object object = preparedStatement.executeBatch();
        }
        finally {
            preparedStatement.close();
        }
    }

    public boolean deleteProp(String string) throws SQLException {
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(SEDU[0], string, JDBCType.VARCHAR.dataType());
        StringBuilder stringBuilder = new StringBuilder("WHERE ").append(SEDU[0]).append("=?");
        return super.delete(stringBuilder.toString(), parameterMetaInfo) > 0;
    }
}

