/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jet.server.ServerEnvBuilder;
import jet.server.db.Connector;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.DBCollectionImpl;
import jet.server.db.core.Dbs;
import jet.server.log.ServiceLogger;
import jet.server.util.WebSecurityUtil;

public final class ConnectorManager {
    private static ConnectorManager SEDU = null;
    public static int MAX_HOLD = 128;
    public static int MAX_USES = 0;
    public static long MAX_IDLE = 600000L;
    public static long MAX_WAIT = 30000L;
    private static HashMap access$100 = new HashMap(2);
    private DBCollectionImpl append = new DBCollectionImpl();
    private Thread clear;
    private LifeCycleController clone = new LifeCycleController();
    private static StringBuffer contains = new StringBuffer();
    private static Class[] delete = new Class[]{Connection.class};
    private static Class[] disconnect = new Class[]{Statement.class};
    private static Class[] get = new Class[]{PreparedStatement.class};
    private static Class[] getConnector = new Class[]{CallableStatement.class};

    public static ConnectorManager getInstance() {
        return ConnectorManager.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorManager newInstance() {
        Class<ConnectorManager> clazz = ConnectorManager.class;
        synchronized (ConnectorManager.class) {
            if (SEDU == null) {
                SEDU = new ConnectorManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SEDU;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Class<ConnectorManager> clazz = ConnectorManager.class;
        synchronized (ConnectorManager.class) {
            if (SEDU == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (ConnectorManager.SEDU.clone != null) {
                if (ConnectorManager.SEDU.clone.inSleep()) {
                    ConnectorManager.SEDU.clear.interrupt();
                }
                ConnectorManager.SEDU.clone.stop();
                while (!ConnectorManager.SEDU.clone.isExit()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        ServiceLogger.logError(interruptedException, 3);
                    }
                }
            }
            Iterator iterator = ConnectorManager.SEDU.append.iterator();
            while (iterator.hasNext()) {
                ConnectionPool connectionPool = (ConnectionPool)iterator.next();
                try {
                    connectionPool.disconnect();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
            }
            ConnectorManager.SEDU.append.clear();
            access$100.clear();
            SEDU = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
            return;
        }
    }

    public synchronized Connector getConnector(Properties properties) {
        Connector connector = null;
        Properties properties2 = null;
        String string = properties.getProperty("datasource");
        if (string != null) {
            if (string.startsWith("jndi://")) {
                properties2 = this.MAX_USES(string, properties);
                try {
                    connector = new JNDIDataSource(properties2);
                    return connector;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ServiceLogger.logError(exception);
                }
            }
            if (string.startsWith("jdbc://")) {
                properties2 = this.MAX_USES(string, properties);
            } else if (string.startsWith("file://")) {
                properties2 = (Properties)properties.clone();
            }
        } else {
            properties2 = (Properties)properties.clone();
        }
        String string2 = ConnectorManager.MAX_IDLE(properties2);
        if (this.append.contains(string2)) {
            connector = (Connector)this.append.get(string2);
        } else {
            connector = new ConnectionPool(properties2);
            this.append.append(connector);
        }
        return connector;
    }

    public Connector getConnector(String string, String string2, String string3, String string4) {
        Properties properties = new Properties();
        properties.setProperty("driver", string);
        properties.setProperty("url", string2);
        properties.setProperty("user", string3);
        properties.setProperty("password", string4);
        return this.getConnector(properties);
    }

    private ConnectorManager() {
        this.clear = new Thread(this.clone);
        this.clear.start();
    }

    private synchronized void remove(ConnectionPool connectionPool) {
        this.append.remove(connectionPool.name);
    }

    private synchronized void MAX_HOLD() {
        Iterator iterator = this.append.iterator();
        while (iterator.hasNext()) {
            ConnectionPool connectionPool = (ConnectionPool)iterator.next();
            connectionPool.access$200();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String MAX_IDLE(Properties properties) {
        String string = null;
        StringBuffer stringBuffer = contains;
        synchronized (stringBuffer) {
            contains.delete(0, contains.length());
            contains.append(properties.getProperty("url", "")).append("#");
            contains.append("user=").append(properties.getProperty("user", ""));
            contains.append(",password=").append(properties.getProperty("password", ""));
            contains.append(",driver=").append(properties.getProperty("driver", ""));
            contains.append(",schema=").append(properties.getProperty("schema", ""));
            contains.append(",tablespace=").append(properties.getProperty("tablespace", ""));
            string = contains.toString();
        }
        return string;
    }

    private Properties MAX_USES(String string, Properties properties) {
        Properties properties2;
        Properties properties3 = properties2 = properties == null ? new Properties() : (Properties)properties.clone();
        if (string != null) {
            Object object;
            properties2.setProperty("datasource", string);
            String string2 = null;
            int n = 0;
            if (string.startsWith("jndi://")) {
                string2 = string.substring("jndi://".length());
                n = 1;
            } else if (string.startsWith("jdbc://")) {
                string2 = string.substring("jdbc://".length());
                n = 2;
            }
            int n2 = string2.indexOf("@");
            if (n2 != -1) {
                object = string2.substring(0, n2);
                int n3 = ((String)object).indexOf(":");
                if (n3 != -1) {
                    properties2.setProperty("user", ((String)object).substring(0, n3));
                    properties2.setProperty("password", ((String)object).substring(n3 + 1));
                }
                string2 = string2.substring(n2 + 1);
            }
            if ((n2 = string2.indexOf("#")) != -1) {
                switch (n) {
                    case 1: {
                        properties2.setProperty("jndi-name", string2.substring(0, n2));
                        break;
                    }
                    case 2: {
                        properties2.setProperty("url", string2.substring(0, n2));
                        break;
                    }
                }
                string2 = string2.substring(n2 + 1);
                if (string2 != null && string2.trim().length() > 0) {
                    object = new StringTokenizer(string2, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string3 = ((StringTokenizer)object).nextToken();
                        n2 = string3.indexOf("=");
                        if (n2 == -1) continue;
                        String string4 = string3.substring(0, n2).trim();
                        String string5 = string3.substring(n2 + 1).trim();
                        properties2.setProperty(string4, string5);
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        properties2.setProperty("jndi-name", string2);
                        break;
                    }
                    case 2: {
                        properties2.setProperty("url", string2);
                        break;
                    }
                }
            }
        }
        return properties2;
    }

    private final class JNDIDataSource
    extends AbstractDBObject
    implements Connector {
        private Context SEDU;
        private DataSource append;
        private final String close = "java:comp/env/";
        private String connect;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JNDIDataSource(Properties properties) throws Exception {
            super(properties);
            this.SEDU = null;
            this.close = "java:comp/env/";
            this.connect = this.getProperty("jndi-name");
            if (this.connect == null) throw new Exception("jndi-name is null");
            this.SEDU = new InitialContext();
            try {
                this.SEDU.lookup(this.connect);
                return;
            }
            catch (NamingException namingException) {
                if (this.connect.startsWith("java:")) return;
                this.connect = "java:comp/env/" + this.connect;
                try {
                    this.SEDU.lookup(this.connect);
                    return;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw new Exception("Invalid jndi-name: " + this.connect);
                }
            }
        }

        @Override
        public synchronized boolean testConnecting() throws SQLException {
            try {
                DataSource dataSource = (DataSource)this.SEDU.lookup(this.connect);
                if (dataSource != null) {
                    Connection connection = dataSource.getConnection();
                    connection.getMetaData();
                    connection.close();
                    return true;
                }
            }
            catch (NamingException namingException) {
                throw new SQLException("Can not found DataSource " + this.connect);
            }
            return false;
        }

        @Override
        public synchronized void connect() throws SQLException {
            if (this.append == null) {
                try {
                    this.append = (DataSource)this.SEDU.lookup(this.connect);
                    ServiceLogger.logDebug(4640004, this.connect, 4);
                }
                catch (NamingException namingException) {
                    throw new SQLException(namingException.getMessage());
                }
            }
        }

        @Override
        public synchronized void disconnect() throws SQLException {
            this.append = null;
        }

        @Override
        public synchronized Connection getConnection() throws SQLException {
            if (this.append == null) {
                this.connect();
            }
            if (this.append != null) {
                String string = this.getProperty("user");
                String string2 = this.getProperty("password");
                if (string != null && string2 != null) {
                    return this.append.getConnection(string, string2);
                }
                return this.append.getConnection();
            }
            return null;
        }

        @Override
        public synchronized Connection getConnection(long l) throws SQLException {
            if (this.append != null) {
                this.append.setLoginTimeout((int)l);
            }
            return this.getConnection();
        }

        @Override
        public void destroy() {
            try {
                this.disconnect();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
        }
    }

    private final class LifeCycleController
    implements Runnable {
        long timeout = 180000L;
        boolean loop = false;
        boolean exit = false;
        boolean sleep = false;

        private LifeCycleController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LifeCycleController lifeCycleController;
            this.loop = true;
            while (this.inLoop()) {
                lifeCycleController = this;
                synchronized (lifeCycleController) {
                    this.sleep = true;
                }
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                lifeCycleController = this;
                synchronized (lifeCycleController) {
                    this.sleep = false;
                }
                if (!this.inLoop()) break;
                ConnectorManager.this.MAX_HOLD();
                if (this.inLoop()) continue;
            }
            lifeCycleController = this;
            synchronized (lifeCycleController) {
                this.exit = true;
            }
        }

        synchronized void stop() {
            this.loop = false;
        }

        synchronized boolean inSleep() {
            return this.sleep;
        }

        synchronized boolean isExit() {
            return this.exit;
        }

        synchronized boolean inLoop() {
            return this.loop;
        }
    }

    private final class LifeCycle {
        Connection conn;
        private long SEDU;
        int using;

        public LifeCycle(Connection connection, int n) {
            this.conn = connection;
            this.SEDU = System.currentTimeMillis();
        }

        public long lastAccessTime() {
            return this.SEDU;
        }
    }

    private final class ConnectionPool
    extends AbstractDBObject
    implements Connector {
        private int MAX_HOLD;
        private int MAX_IDLE;
        private int MAX_USES;
        private long MAX_WAIT;
        private long SEDU;
        private Driver acceptsURL;
        private boolean access$200;
        private ArrayList access$300;
        private HashMap access$400;
        private int access$500;

        public ConnectionPool(Properties properties) {
            super(ConnectorManager.MAX_IDLE(properties), properties);
            this.access$200 = false;
            this.MAX_HOLD = this.getName().hashCode();
            this.MAX_IDLE = Integer.parseInt(this.getProperty("max-pooled", String.valueOf(MAX_HOLD)));
            this.MAX_USES = Integer.parseInt(this.getProperty("max-using", String.valueOf(MAX_USES)));
            this.MAX_WAIT = Long.parseLong(this.getProperty("max-idletime", String.valueOf(MAX_IDLE)));
            this.SEDU = Long.parseLong(this.getProperty("max-waittime", String.valueOf(MAX_WAIT)));
            this.access$300 = new ArrayList(this.MAX_IDLE);
            this.access$400 = new HashMap(this.MAX_IDLE);
        }

        @Override
        public synchronized boolean testConnecting() throws SQLException {
            Connection connection;
            if (this.acceptsURL == null) {
                this.acceptsURL = this.MAX_IDLE(this.getClasspath(), this.getDriver(), this.getURL());
                if (this.acceptsURL == null) {
                    throw new SQLException("Cannot load " + this.getDriver());
                }
            }
            if ((connection = this.MAX_USES()) != null) {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ServiceLogger.logDebug("Database:" + databaseMetaData.getDatabaseProductName() + ", " + databaseMetaData.getDatabaseProductVersion() + ", Driver:" + databaseMetaData.getDriverName() + ", " + databaseMetaData.getDriverVersion(), 4);
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                connection.close();
                return true;
            }
            return false;
        }

        @Override
        public synchronized void connect() throws SQLException {
            if (this.acceptsURL == null) {
                this.acceptsURL = this.MAX_IDLE(this.getClasspath(), this.getDriver(), this.getURL());
                if (this.acceptsURL == null) {
                    throw new SQLException("No suitable driver for " + this.getDriver());
                }
            }
            if (this.access$200) {
                return;
            }
            Connection connection = this.MAX_USES();
            if (connection != null) {
                this.access$300.add(new LifeCycle(connection, 0));
            }
            this.access$200 = this.access$500 > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void disconnect() throws SQLException {
            Connection connection;
            if (!this.access$200) {
                return;
            }
            Iterator<Object> iterator = this.access$400.keySet().iterator();
            while (iterator.hasNext()) {
                connection = (Connection)iterator.next();
                try {
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
                finally {
                    iterator.remove();
                }
            }
            iterator = this.access$300.iterator();
            while (iterator.hasNext()) {
                connection = ((LifeCycle)iterator.next()).conn;
                try {
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
                finally {
                    iterator.remove();
                }
            }
            this.access$500 = 0;
            this.access$200 = false;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.getConnection(this.SEDU);
        }

        @Override
        public synchronized Connection getConnection(long l) throws SQLException {
            Object object;
            Connection connection = null;
            int n = 0;
            if (!this.access$200) {
                this.connect();
            }
            if (!this.access$300.isEmpty()) {
                object = (LifeCycle)this.access$300.remove(0);
                connection = ((LifeCycle)object).conn;
                n = ((LifeCycle)object).using;
                if (!this.MAX_HOLD(connection)) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    String string = dateFormat.format(new Date(((LifeCycle)object).lastAccessTime()));
                    ServiceLogger.logDebug(3640002, string, 3);
                    Connection connection2 = this.MAX_USES();
                    this.acceptsURL(connection);
                    connection = connection2;
                    n = 0;
                }
            } else {
                if (this.access$500 >= this.MAX_IDLE) {
                    long l2 = System.currentTimeMillis();
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new SQLException(interruptedException.getMessage());
                    }
                    long l3 = System.currentTimeMillis() - l2;
                    if (l <= l3 && l > 0L) {
                        throw new SQLException("Connecting is overtime.");
                    }
                    return this.getConnection(l - l3);
                }
                connection = this.MAX_USES();
            }
            object = this.MAX_WAIT(connection, n);
            this.access$400.put(connection, object);
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean MAX_HOLD(Connection connection) {
            String string = Dbs.fullTableName(this.getProperty("schema"), "TBL_DUAL_JINFONET");
            boolean bl = false;
            Statement statement = null;
            try {
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string + " WHERE 0=1");
                resultSet.close();
                bl = true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logDebug("Invalid connection @" + Integer.toHexString(connection.hashCode()) + ": " + sQLException.getMessage(), 3);
            }
            finally {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public void destroy() {
            try {
                this.disconnect();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            ConnectorManager.this.remove(this);
        }

        public String getClasspath() {
            return this.getProperty("classpath");
        }

        public String getDriver() {
            return this.getProperty("driver");
        }

        public String getURL() {
            return this.getProperty("url");
        }

        public String getUser() {
            return this.getProperty("user");
        }

        public String getPassword() {
            return this.getProperty("password");
        }

        public boolean equals(Object object) {
            return object != null && this.MAX_HOLD == object.hashCode();
        }

        public int hashCode() {
            return this.MAX_HOLD;
        }

        public String toString() {
            return this.getName();
        }

        private Driver MAX_IDLE(String string, String string2, String string3) {
            Object object;
            boolean bl = "org.hsqldb.jdbcDriver".equals(string2);
            if (bl) {
                object = ServerEnvBuilder.servEnv;
                string = ((Properties)object).getProperty("hsqldb.classpath");
                this.setProperty("shutdown", "false");
            }
            object = string == null ? string2 : string + string2;
            Driver driver = null;
            if (access$100.containsKey(object) && !bl) {
                driver = (Driver)access$100.get(object);
            } else {
                if (string != null && string.trim().length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (stringTokenizer.hasMoreElements()) {
                        arrayList.add(stringTokenizer.nextElement());
                    }
                    try {
                        URL[] uRLArray = null;
                        ArrayList<URL> arrayList2 = new ArrayList<URL>();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            File file = new File((String)arrayList.get(i));
                            if ((file = WebSecurityUtil.validateFilePath(file)) == null) continue;
                            arrayList2.add(file.toURL());
                        }
                        uRLArray = arrayList2.toArray(new URL[0]);
                        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, null);
                        driver = (Driver)uRLClassLoader.loadClass(string2).newInstance();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        driver = null;
                    }
                }
                if (driver == null) {
                    try {
                        Class.forName(string2);
                        driver = DriverManager.getDriver(string3);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        driver = null;
                    }
                }
            }
            if (driver != null && !bl && !access$100.containsKey(object)) {
                access$100.put(object, driver);
            }
            return driver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection MAX_USES() throws SQLException {
            Object object;
            if (!this.acceptsURL.acceptsURL(this.getURL())) {
                throw new SQLException("Cannot accept URL: " + this.getURL());
            }
            Connection connection = null;
            try {
                object = new Properties();
                ((Properties)object).setProperty("user", this.getUser());
                ((Properties)object).setProperty("password", this.getPassword());
                ((Properties)object).setProperty("url", this.getURL());
                ((Properties)object).setProperty("driver", this.getDriver());
                connection = this.acceptsURL.connect(this.getURL(), (Properties)object);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                String string = this.getProperties().toString().replaceAll("password=[\\w]*", "password=******");
                ServiceLogger.logError("Connection URL:" + this.getURL() + ",\tConnection Properties:" + string);
                throw new SQLException(sQLException.getMessage());
            }
            if (connection != null) {
                if ("org.hsqldb.jdbcDriver".equals(this.getDriver())) {
                    object = null;
                    String string = this.getProperty("hsql-write-delay");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("SET WRITE_DELAY ");
                    try {
                        long l = Long.parseLong(string);
                        stringBuffer.append(l).append(" MILLIS");
                    }
                    catch (Throwable throwable) {
                        stringBuffer.append("FALSE");
                    }
                    try {
                        object = connection.createStatement();
                        object.execute(stringBuffer.toString());
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    finally {
                        object.close();
                        connection.clearWarnings();
                    }
                }
                ++this.access$500;
            }
            return connection;
        }

        private Connection MAX_WAIT(Connection connection, int n) {
            return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), delete, (InvocationHandler)new ConnectionInvocationHandler(connection, n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void SEDU(Connection connection, int n) {
            block12: {
                try {
                    Object v = this.access$400.remove(connection);
                    if (null != v) {
                        ConnectionInvocationHandler connectionInvocationHandler = (ConnectionInvocationHandler)Proxy.getInvocationHandler(v);
                        connectionInvocationHandler.conn = null;
                    }
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                        connection.setAutoCommit(true);
                    }
                    if (this.MAX_USES > 0 && n > this.MAX_USES) {
                        try {
                            connection.close();
                            break block12;
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException, 3);
                            break block12;
                        }
                        finally {
                            --this.access$500;
                        }
                    }
                    connection.clearWarnings();
                    this.access$300.add(new LifeCycle(connection, n));
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                    this.acceptsURL(connection);
                    try {
                        this.access$300.add(new LifeCycle(this.MAX_USES(), 0));
                    }
                    catch (SQLException sQLException2) {
                        ServiceLogger.logError(sQLException2);
                    }
                }
            }
            this.notify();
        }

        private synchronized void acceptsURL(Connection connection) {
            try {
                connection.close();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("Invalid connection @" + Integer.toHexString(connection.hashCode()) + ": " + throwable, 3);
            }
            --this.access$500;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void access$200() {
            if (!this.access$200) {
                return;
            }
            Iterator iterator = this.access$300.iterator();
            while (iterator.hasNext()) {
                LifeCycle lifeCycle = (LifeCycle)iterator.next();
                long l = System.currentTimeMillis() - lifeCycle.lastAccessTime();
                if (l < this.MAX_WAIT || this.MAX_WAIT <= 0L || this.access$500 <= 1) continue;
                try {
                    if (!lifeCycle.conn.getAutoCommit()) {
                        lifeCycle.conn.commit();
                    }
                    lifeCycle.conn.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
                finally {
                    iterator.remove();
                    --this.access$500;
                }
            }
        }

        private final class StatementInvocationHandler
        implements InvocationHandler {
            Object connProxy;
            Object stmt;

            StatementInvocationHandler(Object object, Object object2) {
                this.connProxy = object;
                this.stmt = object2;
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (((ConnectionInvocationHandler)Proxy.getInvocationHandler((Object)this.connProxy)).conn == null) {
                    throw new SQLException("The connection is closed.");
                }
                try {
                    return method.invoke(this.stmt, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
        }

        private final class ConnectionInvocationHandler
        implements InvocationHandler {
            Connection conn;
            int using;

            ConnectionInvocationHandler(Connection connection, int n) {
                this.conn = connection;
                this.using = n + 1;
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (this.conn == null) {
                    throw new SQLException("The connection is closed.");
                }
                if ("close".equals(method.getName())) {
                    ConnectionPool.this.SEDU(this.conn, this.using);
                    return null;
                }
                try {
                    if ("createStatement".equals(method.getName())) {
                        return Proxy.newProxyInstance(Statement.class.getClassLoader(), disconnect, (InvocationHandler)new StatementInvocationHandler(object, method.invoke((Object)this.conn, objectArray)));
                    }
                    if ("prepareCall".equals(method.getName())) {
                        return Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), getConnector, (InvocationHandler)new StatementInvocationHandler(object, method.invoke((Object)this.conn, objectArray)));
                    }
                    if ("prepareStatement".equals(method.getName())) {
                        return Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), get, (InvocationHandler)new StatementInvocationHandler(object, method.invoke((Object)this.conn, objectArray)));
                    }
                    return method.invoke((Object)this.conn, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }

            protected void finalize() throws Throwable {
                if (this.conn != null) {
                    ConnectionPool.this.acceptsURL(this.conn);
                }
                super.finalize();
            }
        }
    }
}

