/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.dao.CompletedCRDConnInfoDAO;
import jet.server.db.model.AbstractCRDInfoModel;
import jet.server.db.model.CRDConnInfoModel;
import jet.server.db.model.CompletedCRDInfoModel;
import jet.server.db.model.DataVersionModel;
import jet.server.log.ServiceLogger;

public class CompletedCRDInfoDAO
extends AbstractDAO {
    public static final String TABLE_NAME_1 = "COMPLETED_CRD_INFO_1";
    public static final String TABLE_NAME_2 = "COMPLETED_CRD_INFO_2";
    public static final String TABLE_NAME = "COMPLETED_CRD_INFO_3";
    private static final String BIGINT = "ID";
    private static final String INTEGER = "SVERSION";
    private static final String SEDU = "CATALOGID";
    private static final String TINYINT = "CATALOGPATH";
    private static final String VARCHAR = "DATASOURCE";
    private static final String add = "QUERYTYPE";
    private static final String append = "QUERYNAME";
    private static final String buildInsertSql = "LASTMODIFIED";
    private static final String buildUpdateSql = "USERNAME";
    private static final String close = "PWD";
    private static final String closeResultSet = "PARAMFILE";
    private static final String closeStatement = "LAZY";
    private static final String commit = "CATALOGVERSION";
    private static final String contains = "CATALOGLASTMODIFIED";
    private static final String createTable = "STARTTIME";
    private static final String delete = "COMPLETEDTIME";
    private static final String equals = "SUCC";
    private static final String executeQuery = "BVNAME";
    private static final String executeUpdate = "ACTIVITYTYPE";
    private static final String get = "MESSAGE";
    private static CompletedCRDInfoDAO getActivity;
    private int getBvName = 3000;
    private int getCatalogId = 3000;
    private Integer getCatalogLastModified = new Integer(0);
    private Integer getCatalogPath = new Integer(0);
    private CompletedCRDConnInfoDAO getCatalogVersion;
    private static final String getCompletedTime;
    private static final String getConnection;
    private static final String getDataSource = "DELETE FROM {0} WHERE ID = ? AND SVERSION = ?";
    private static final String getDataVersion = "SELECT * FROM {0} WHERE CATALOGID = ? and DATASOURCE = ? and QUERYTYPE = ? and QUERYNAME = ?";
    private static final String getID = "SELECT * FROM {0} WHERE CATALOGPATH = ? and DATASOURCE = ? and QUERYTYPE = ? and QUERYNAME = ?";
    private static final String getId = "SELECT * FROM {0} ORDER BY ID";
    private static final String getInt = "SELECT * FROM {0} WHERE ID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletedCRDInfoDAO(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIGINT, JDBCType.INTEGER, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), INTEGER, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), TINYINT, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), add, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), append, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), buildInsertSql, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), buildUpdateSql, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), close, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), closeResultSet, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), closeStatement, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), commit, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), contains, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), createTable, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), delete, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), equals, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), executeQuery, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), executeUpdate, JDBCType.TINYINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), get, JDBCType.VARCHAR, 512, 16, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        this.getCatalogVersion = CompletedCRDConnInfoDAO.newInstance(database, this, updateDetailsTable);
        this.upgradeOldTable(database, updateDetailsTable, TABLE_NAME_1, 1);
        this.upgradeOldTable(database, updateDetailsTable, TABLE_NAME_2, 2);
        if (ServerEnv.getMaxCubeLogCount() > 0) {
            this.getCatalogId = ServerEnv.getMaxCubeLogCount();
        }
        if (ServerEnv.getMaxCompletedRecordCount() > 0) {
            this.getBvName = ServerEnv.getMaxCompletedRecordCount();
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.BIGINT(connection);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mergeOldTable(Table table, int n) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            List list = this.listAllOld(connection, table.getName(), n);
            for (CompletedCRDInfoModel completedCRDInfoModel : list) {
                this.insert(connection, completedCRDInfoModel);
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            ServiceLogger.logError("upgrade crd info table exception.", 2);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
    }

    public static CompletedCRDInfoDAO newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        if (getActivity == null) {
            try {
                getActivity = new CompletedCRDInfoDAO(database, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return getActivity;
    }

    public static CompletedCRDInfoDAO getInstance() {
        return getActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(Connection connection, CompletedCRDInfoModel completedCRDInfoModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement;
        block11: {
            preparedStatement = null;
            n = 0;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getCompletedTime));
                int n2 = 1;
                preparedStatement.setInt(n2++, this.adapter.getID(this, this.fields(0)));
                preparedStatement.setInt(n2++, completedCRDInfoModel.getDataVersion());
                preparedStatement.setInt(n2++, completedCRDInfoModel.getCatalogId());
                preparedStatement.setString(n2++, completedCRDInfoModel.getCatalogPath());
                preparedStatement.setString(n2++, completedCRDInfoModel.getDataSource());
                preparedStatement.setInt(n2++, completedCRDInfoModel.getQueryType());
                preparedStatement.setString(n2++, completedCRDInfoModel.getQueryName());
                preparedStatement.setLong(n2++, completedCRDInfoModel.getLastModified());
                preparedStatement.setString(n2++, null);
                preparedStatement.setString(n2++, null);
                preparedStatement.setString(n2++, completedCRDInfoModel.getParamFile());
                preparedStatement.setInt(n2++, completedCRDInfoModel.getLazy());
                preparedStatement.setInt(n2++, completedCRDInfoModel.getCatalogVersion());
                preparedStatement.setLong(n2++, completedCRDInfoModel.getCatalogLastModified());
                preparedStatement.setLong(n2++, completedCRDInfoModel.getStartTime());
                preparedStatement.setLong(n2++, completedCRDInfoModel.getCompletedTime());
                preparedStatement.setInt(n2++, completedCRDInfoModel.getSuccess());
                preparedStatement.setString(n2++, completedCRDInfoModel.getBvName());
                preparedStatement.setShort(n2++, completedCRDInfoModel.getActivity());
                String string = completedCRDInfoModel.getMessage();
                if (string != null && string.length() > super.fields(get).getSize()) {
                    string = string.substring(0, super.fields(get).getSize() - 3) + "...";
                }
                preparedStatement.setString(n2++, string);
                n = preparedStatement.executeUpdate();
                this.getCatalogVersion.update(connection, completedCRDInfoModel);
                if (completedCRDInfoModel.getBvName() == null) {
                    Integer n3 = this.getCatalogLastModified;
                    synchronized (n3) {
                        Integer n4 = this.getCatalogLastModified;
                        Integer n5 = this.getCatalogLastModified = Integer.valueOf(this.getCatalogLastModified + 1);
                        break block11;
                    }
                }
                Integer n6 = this.getCatalogPath;
                synchronized (n6) {
                    Integer n7 = this.getCatalogPath;
                    Integer n8 = this.getCatalogPath = Integer.valueOf(this.getCatalogPath + 1);
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        this.closeStatement(preparedStatement);
        if (this.getCatalogLastModified > this.getBvName || this.getCatalogPath > this.getCatalogId) {
            this.BIGINT(connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, CompletedCRDInfoModel completedCRDInfoModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            Integer n2;
            preparedStatement = connection.prepareStatement(this.rtp(getDataSource));
            int n3 = 1;
            preparedStatement.setInt(n3++, completedCRDInfoModel.getId());
            preparedStatement.setInt(n3++, completedCRDInfoModel.getDataVersion());
            int n4 = preparedStatement.executeUpdate();
            this.getCatalogVersion.delete(connection, completedCRDInfoModel.getId());
            if (completedCRDInfoModel.getBvName() == null) {
                n2 = this.getCatalogLastModified;
                synchronized (n2) {
                    Integer n5 = this.getCatalogLastModified;
                    Integer n6 = this.getCatalogLastModified = Integer.valueOf(this.getCatalogLastModified - 1);
                }
            }
            n2 = this.getCatalogPath;
            synchronized (n2) {
                Integer n7 = this.getCatalogPath;
                Integer n8 = this.getCatalogPath = Integer.valueOf(this.getCatalogPath - 1);
            }
            n = n4;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, CompletedCRDInfoModel completedCRDInfoModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getConnection));
            int n2 = 1;
            preparedStatement.setInt(n2++, completedCRDInfoModel.getCatalogId());
            preparedStatement.setString(n2++, completedCRDInfoModel.getCatalogPath());
            preparedStatement.setString(n2++, completedCRDInfoModel.getDataSource());
            preparedStatement.setInt(n2++, completedCRDInfoModel.getQueryType());
            preparedStatement.setString(n2++, completedCRDInfoModel.getQueryName());
            preparedStatement.setLong(n2++, completedCRDInfoModel.getLastModified());
            preparedStatement.setString(n2++, null);
            preparedStatement.setString(n2++, null);
            preparedStatement.setString(n2++, completedCRDInfoModel.getParamFile());
            preparedStatement.setInt(n2++, completedCRDInfoModel.getLazy());
            preparedStatement.setInt(n2++, completedCRDInfoModel.getCatalogVersion());
            preparedStatement.setLong(n2++, completedCRDInfoModel.getCatalogLastModified());
            preparedStatement.setLong(n2++, completedCRDInfoModel.getStartTime());
            preparedStatement.setLong(n2++, completedCRDInfoModel.getCompletedTime());
            preparedStatement.setInt(n2++, completedCRDInfoModel.getSuccess());
            preparedStatement.setString(n2++, completedCRDInfoModel.getBvName());
            preparedStatement.setShort(n2++, completedCRDInfoModel.getActivity());
            preparedStatement.setString(n2++, completedCRDInfoModel.getMessage());
            preparedStatement.setInt(n2++, completedCRDInfoModel.getId());
            preparedStatement.setInt(n2++, completedCRDInfoModel.getDataVersion());
            int n3 = preparedStatement.executeUpdate();
            this.getCatalogVersion.update(connection, completedCRDInfoModel);
            n = n3;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BIGINT(Connection connection) {
        try {
            this.getCatalogLastModified = 0;
            this.getCatalogPath = 0;
            List list = this.listAll(connection);
            for (CompletedCRDInfoModel completedCRDInfoModel : list) {
                Serializable serializable;
                Object object;
                if (completedCRDInfoModel.getBvName() == null) {
                    object = this.getCatalogLastModified;
                    this.getCatalogLastModified = this.getCatalogLastModified + 1;
                    serializable = this.getCatalogLastModified;
                    continue;
                }
                object = this.getCatalogPath;
                this.getCatalogPath = this.getCatalogPath + 1;
                serializable = this.getCatalogPath;
            }
            boolean bl = false;
            boolean bl2 = false;
            for (Serializable serializable : list) {
                Integer n;
                if (serializable.getBvName() == null) {
                    if (this.getCatalogLastModified > this.getBvName) {
                        n = this.getCatalogLastModified;
                        synchronized (n) {
                            this.delete(connection, (CompletedCRDInfoModel)serializable);
                        }
                    } else {
                        bl = true;
                    }
                } else if (this.getCatalogPath > this.getCatalogId) {
                    n = this.getCatalogPath;
                    synchronized (n) {
                        this.delete(connection, (CompletedCRDInfoModel)serializable);
                    }
                } else {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                break;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listAll(Connection connection) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getId));
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            HashMap hashMap = this.getCatalogVersion.listAll(connection);
            while (resultSet.next()) {
                serializable = this.TINYINT(resultSet);
                CRDConnInfoModel cRDConnInfoModel = (CRDConnInfoModel)hashMap.get(((DataVersionModel)serializable).getId());
                if (cRDConnInfoModel != null) {
                    ((AbstractCRDInfoModel)serializable).setUserNames(cRDConnInfoModel.getUserNames());
                    ((AbstractCRDInfoModel)serializable).setPasswords(cRDConnInfoModel.getPasswords());
                }
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listAllOld(Connection connection, String string, int n) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getId, string));
            resultSet = preparedStatement.executeQuery();
            Vector<CompletedCRDInfoModel> vector = new Vector<CompletedCRDInfoModel>();
            while (resultSet.next()) {
                switch (n) {
                    case 1: {
                        serializable = this.INTEGER(resultSet);
                        break;
                    }
                    case 2: {
                        serializable = this.SEDU(resultSet);
                    }
                }
                vector.add(this.INTEGER(resultSet));
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletedCRDInfoModel get(Connection connection, int n) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CompletedCRDInfoModel completedCRDInfoModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getInt));
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                completedCRDInfoModel = this.TINYINT(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return completedCRDInfoModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List list(Connection connection, int n, String string, int n2, String string2, String string3) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getDataVersion));
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            preparedStatement.setString(n3++, string);
            preparedStatement.setInt(n3++, n2);
            preparedStatement.setString(n3++, string2);
            preparedStatement.setString(n3++, string3);
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            HashMap hashMap = this.getCatalogVersion.listAll(connection);
            while (resultSet.next()) {
                serializable = this.TINYINT(resultSet);
                CRDConnInfoModel cRDConnInfoModel = (CRDConnInfoModel)hashMap.get(((DataVersionModel)serializable).getId());
                if (cRDConnInfoModel != null) {
                    ((AbstractCRDInfoModel)serializable).setUserNames(cRDConnInfoModel.getUserNames());
                    ((AbstractCRDInfoModel)serializable).setPasswords(cRDConnInfoModel.getPasswords());
                }
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(Connection connection, String string, String string2, int n, String string3, String string4) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getID));
            int n2 = 1;
            preparedStatement.setString(n2++, string);
            preparedStatement.setString(n2++, string2);
            preparedStatement.setInt(n2++, n);
            preparedStatement.setString(n2++, string3);
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            HashMap hashMap = this.getCatalogVersion.listAll(connection);
            while (resultSet.next()) {
                serializable = this.TINYINT(resultSet);
                if ((string4 != null || ((AbstractCRDInfoModel)serializable).getBvName() != null) && !((AbstractCRDInfoModel)serializable).getBvName().equals(string4)) continue;
                CRDConnInfoModel cRDConnInfoModel = (CRDConnInfoModel)hashMap.get(((DataVersionModel)serializable).getId());
                if (cRDConnInfoModel != null) {
                    ((AbstractCRDInfoModel)serializable).setUserNames(cRDConnInfoModel.getUserNames());
                    ((AbstractCRDInfoModel)serializable).setPasswords(cRDConnInfoModel.getPasswords());
                }
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    private CompletedCRDInfoModel INTEGER(ResultSet resultSet) throws SQLException {
        CompletedCRDInfoModel completedCRDInfoModel = new CompletedCRDInfoModel();
        completedCRDInfoModel.setId(resultSet.getInt(BIGINT));
        completedCRDInfoModel.setDataVersion(resultSet.getInt(INTEGER));
        completedCRDInfoModel.setCatalogId(resultSet.getInt(SEDU));
        completedCRDInfoModel.setDataSource(resultSet.getString(VARCHAR));
        completedCRDInfoModel.setQueryType(resultSet.getInt(add));
        completedCRDInfoModel.setQueryName(resultSet.getString(append));
        completedCRDInfoModel.setLastModified(resultSet.getLong(buildInsertSql));
        completedCRDInfoModel.setParamFile(resultSet.getString(closeResultSet));
        completedCRDInfoModel.setLazy(resultSet.getInt(closeStatement));
        completedCRDInfoModel.setCatalogVersion(resultSet.getInt(commit));
        completedCRDInfoModel.setCatalogLastModified(resultSet.getLong(contains));
        completedCRDInfoModel.setStartTime(resultSet.getLong(createTable));
        completedCRDInfoModel.setCompletedTime(resultSet.getLong(delete));
        completedCRDInfoModel.setSuccess(resultSet.getInt(equals));
        return completedCRDInfoModel;
    }

    private CompletedCRDInfoModel SEDU(ResultSet resultSet) throws SQLException {
        CompletedCRDInfoModel completedCRDInfoModel = this.INTEGER(resultSet);
        completedCRDInfoModel.setCatalogPath(resultSet.getString(TINYINT));
        return completedCRDInfoModel;
    }

    private CompletedCRDInfoModel TINYINT(ResultSet resultSet) throws SQLException {
        CompletedCRDInfoModel completedCRDInfoModel = this.SEDU(resultSet);
        completedCRDInfoModel.setBvName(resultSet.getString(executeQuery));
        completedCRDInfoModel.setActivity(resultSet.getShort(executeUpdate));
        completedCRDInfoModel.setMessage(resultSet.getString(get));
        return completedCRDInfoModel;
    }

    static {
        getCompletedTime = CompletedCRDInfoDAO.buildInsertSql(new String[]{BIGINT, INTEGER, SEDU, TINYINT, VARCHAR, add, append, buildInsertSql, buildUpdateSql, close, closeResultSet, closeStatement, commit, contains, createTable, delete, equals, executeQuery, executeUpdate, get});
        getConnection = CompletedCRDInfoDAO.buildUpdateSql(BIGINT, INTEGER, new String[]{SEDU, TINYINT, VARCHAR, add, append, buildInsertSql, buildUpdateSql, close, closeResultSet, closeStatement, commit, contains, createTable, delete, equals, executeQuery, executeUpdate, get});
    }
}

