/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.model.CustomFieldModel;
import jet.server.db.model.DataVersionModel;
import jet.server.log.ServiceLogger;

public class CustomFieldDAO
extends AbstractDAO {
    public static final String TABLE_NAME = "CUSTOM_FIELD_1";
    private static final String INTEGER = "ID";
    private static final String SEDU = "SVERSION";
    private static final String VARCHAR = "ENABLED";
    private static final String add = "NAME";
    private static final String append = "DESCRIPTION";
    private static CustomFieldDAO closeResultSet;
    private static final String closeStatement = "INSERT INTO {0} (ID,SVERSION,ENABLED,NAME,DESCRIPTION) values (?,?,?,?,?)";
    private static final String contains = "UPDATE {0} SET ENABLED=?,NAME=?,DESCRIPTION=? WHERE ID=? AND SVERSION=?";
    private static final String createTable = "DELETE FROM {0} WHERE ID = ? AND SVERSION = ?";
    private static final String delete = "SELECT * FROM {0}";
    private static final String executeQuery = "SELECT * FROM {0} WHERE NAME LIKE ?";
    private static final String executeUpdate = "SELECT * FROM {0} WHERE ID = ?";

    private CustomFieldDAO(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), INTEGER, JDBCType.INTEGER, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), SEDU, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), add, JDBCType.VARCHAR, 255, 7, 0));
        super.append(new FieldImpl(this.getName(), append, JDBCType.VARCHAR, 256, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public static CustomFieldDAO newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        if (closeResultSet == null) {
            try {
                closeResultSet = new CustomFieldDAO(database, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return closeResultSet;
    }

    public static CustomFieldDAO getInstance() {
        return closeResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(Connection connection, CustomFieldModel customFieldModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(closeStatement));
            preparedStatement.setInt(1, this.adapter.getID(this, this.fields(0)));
            preparedStatement.setInt(2, customFieldModel.getDataVersion());
            preparedStatement.setInt(3, customFieldModel.getIntEnabled());
            preparedStatement.setString(4, customFieldModel.getName());
            preparedStatement.setString(5, customFieldModel.getDescription());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, CustomFieldModel customFieldModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(createTable));
            preparedStatement.setInt(1, customFieldModel.getId());
            preparedStatement.setInt(2, customFieldModel.getDataVersion());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    public int deleteByName(Connection connection, String string) throws SQLException {
        CustomFieldModel customFieldModel = this.getFieldByName(connection, string);
        if (customFieldModel == null) {
            return 0;
        }
        return this.delete(connection, customFieldModel);
    }

    public int deleteByNames(Connection connection, List list) throws SQLException {
        int n = 0;
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = (String)list.get(i);
            CustomFieldModel customFieldModel = this.getFieldByName(connection, string);
            if (customFieldModel == null) continue;
            this.delete(connection, customFieldModel);
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, CustomFieldModel customFieldModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(contains));
            preparedStatement.setInt(1, customFieldModel.getIntEnabled());
            preparedStatement.setString(2, customFieldModel.getName());
            preparedStatement.setString(3, customFieldModel.getDescription());
            preparedStatement.setInt(4, customFieldModel.getId());
            preparedStatement.setInt(5, customFieldModel.getDataVersion());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    public int updateByName(Connection connection, String string, CustomFieldModel customFieldModel) throws SQLException {
        CustomFieldModel customFieldModel2 = this.getFieldByName(connection, string);
        if (customFieldModel2 == null) {
            return 0;
        }
        customFieldModel2.setName(customFieldModel.getName());
        customFieldModel2.setEnabled(customFieldModel.isEnabled());
        customFieldModel2.setDescription(customFieldModel.getDescription());
        return this.update(connection, customFieldModel2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector listAll(Connection connection) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(delete));
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            while (resultSet.next()) {
                serializable = new CustomFieldModel();
                ((CustomFieldModel)serializable).setId(resultSet.getInt(INTEGER));
                ((DataVersionModel)serializable).setDataVersion(resultSet.getInt(SEDU));
                ((CustomFieldModel)serializable).setEnabled(resultSet.getInt(VARCHAR));
                ((CustomFieldModel)serializable).setName(resultSet.getString(add));
                ((CustomFieldModel)serializable).setDescription(resultSet.getString(append));
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    public Vector getFieldNames(Connection connection) throws SQLException {
        Vector vector = this.listAll(connection);
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CustomFieldModel customFieldModel = (CustomFieldModel)vector.get(i);
                vector2.add(customFieldModel.getName());
            }
        }
        return vector2;
    }

    public Vector getEnabledFieldNames(Connection connection) throws SQLException {
        Vector vector = this.listAll(connection);
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CustomFieldModel customFieldModel = (CustomFieldModel)vector.get(i);
                if (!customFieldModel.isEnabled()) continue;
                vector2.add(customFieldModel.getName());
            }
        }
        return vector2;
    }

    public boolean existed(Connection connection, String string) throws SQLException {
        return this.getFieldByName(connection, string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFieldModel getFieldByName(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CustomFieldModel customFieldModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(executeQuery));
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                CustomFieldModel customFieldModel2 = new CustomFieldModel();
                customFieldModel2.setId(resultSet.getInt(INTEGER));
                customFieldModel2.setDataVersion(resultSet.getInt(SEDU));
                customFieldModel2.setEnabled(resultSet.getInt(VARCHAR));
                customFieldModel2.setName(resultSet.getString(add));
                customFieldModel2.setDescription(resultSet.getString(append));
                customFieldModel = customFieldModel2;
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return customFieldModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFieldModel getFieldById(Connection connection, int n) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CustomFieldModel customFieldModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(executeUpdate));
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                CustomFieldModel customFieldModel2 = new CustomFieldModel();
                customFieldModel2.setId(resultSet.getInt(INTEGER));
                customFieldModel2.setDataVersion(resultSet.getInt(SEDU));
                customFieldModel2.setEnabled(resultSet.getInt(VARCHAR));
                customFieldModel2.setName(resultSet.getString(add));
                customFieldModel2.setDescription(resultSet.getString(append));
                customFieldModel = customFieldModel2;
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return customFieldModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }
}

