/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.dao.DashboardListenerTargetDAO;
import jet.server.db.model.DashboardListenerInfoModel;
import jet.server.log.ServiceLogger;

public class DashboardListenerInfoDAO
extends AbstractDAO {
    public static final String TABLE_NAME = "DASHBOARDLISTENER_1";
    private static final String BIGINT = "CLASSNAME";
    private static final String BOOLEAN = "DESCRIPTION";
    private static final String SEDU = "ENABLED";
    private static final String VARCHAR = "CREATETIME";
    private static DashboardListenerInfoDAO add;
    private static final String append;
    private static final String buildInsertSql;
    private static final String buildUpdateSql = "DELETE FROM {0} WHERE CLASSNAME = ?";
    private static final String closeResultSet = "SELECT {0}.CLASSNAME, DESCRIPTION, ENABLED, CREATETIME, TARGET, APPLYTIME FROM {0}, {1} WHERE {0}.CLASSNAME={1}.CLASSNAME ORDER BY {0}.CLASSNAME";
    private static final String closeStatement = "SELECT {0}.CLASSNAME, DESCRIPTION, ENABLED, CREATETIME, TARGET, APPLYTIME FROM {0}, {1} WHERE {0}.CLASSNAME={1}.CLASSNAME AND CLASSNAME = ?";
    private static final String contains = "UPDATE {0} SET ENABLED = ? WHERE CLASSNAME = ?";
    private DashboardListenerTargetDAO createTable = null;

    private DashboardListenerInfoDAO(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIGINT, JDBCType.VARCHAR, 512, 15, 0));
        super.append(new FieldImpl(this.getName(), BOOLEAN, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU, JDBCType.BOOLEAN, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR, JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        this.createTable = DashboardListenerTargetDAO.newInstance(database, this, updateDetailsTable);
    }

    public static DashboardListenerInfoDAO newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        if (add == null) {
            try {
                add = new DashboardListenerInfoDAO(database, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return add;
    }

    public static DashboardListenerInfoDAO getInstance() {
        return add;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(Connection connection, DashboardListenerInfoModel dashboardListenerInfoModel) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(append));
            int n2 = 1;
            preparedStatement.setString(n2++, dashboardListenerInfoModel.getClassName());
            preparedStatement.setString(n2++, dashboardListenerInfoModel.getDescription());
            preparedStatement.setBoolean(n2++, dashboardListenerInfoModel.isEnabled());
            preparedStatement.setLong(n2++, dashboardListenerInfoModel.getCreateTime());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        this.createTable.update(connection, dashboardListenerInfoModel);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, String string) throws SQLException {
        int n;
        if (string == null) {
            return 0;
        }
        this.createTable.delete(connection, string);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(buildUpdateSql));
            int n2 = 1;
            preparedStatement.setString(n2++, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, DashboardListenerInfoModel dashboardListenerInfoModel) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(buildInsertSql));
            int n2 = 1;
            preparedStatement.setString(n2++, dashboardListenerInfoModel.getDescription());
            preparedStatement.setBoolean(n2++, dashboardListenerInfoModel.isEnabled());
            preparedStatement.setString(n2++, dashboardListenerInfoModel.getClassName());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        this.createTable.update(connection, dashboardListenerInfoModel);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, String string, boolean bl) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(contains));
            int n2 = 1;
            preparedStatement.setBoolean(n2++, bl);
            preparedStatement.setString(n2++, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listAll(Connection connection) throws SQLException {
        List list;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(closeResultSet, this.getTableName(), this.createTable.getTableName()));
            resultSet = preparedStatement.executeQuery();
            list = this.BIGINT(resultSet);
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardListenerInfoModel get(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            DashboardListenerInfoModel dashboardListenerInfoModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(closeStatement, this.getTableName(), this.createTable.getTableName()));
                int n = 1;
                preparedStatement.setString(n++, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                dashboardListenerInfoModel = this.BOOLEAN(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return dashboardListenerInfoModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    private List BIGINT(ResultSet resultSet) throws SQLException {
        Vector<DashboardListenerInfoModel> vector = new Vector<DashboardListenerInfoModel>();
        String string = null;
        DashboardListenerInfoModel dashboardListenerInfoModel = null;
        HashMap<String, Long> hashMap = null;
        while (resultSet.next()) {
            if (string == null || !string.equals(resultSet.getString(BIGINT))) {
                dashboardListenerInfoModel = new DashboardListenerInfoModel();
                dashboardListenerInfoModel.setClassName(resultSet.getString(BIGINT));
                dashboardListenerInfoModel.setDescription(resultSet.getString(BOOLEAN));
                dashboardListenerInfoModel.setEnabled(resultSet.getBoolean(SEDU));
                dashboardListenerInfoModel.setCreateTime(resultSet.getLong(VARCHAR));
                hashMap = new HashMap<String, Long>();
                dashboardListenerInfoModel.setTargets(hashMap);
                vector.add(dashboardListenerInfoModel);
                string = dashboardListenerInfoModel.getClassName();
            }
            hashMap.put(resultSet.getString("TARGET"), resultSet.getLong("APPLYTIME"));
        }
        return vector;
    }

    private DashboardListenerInfoModel BOOLEAN(ResultSet resultSet) throws SQLException {
        DashboardListenerInfoModel dashboardListenerInfoModel = new DashboardListenerInfoModel();
        dashboardListenerInfoModel.setClassName(resultSet.getString(BIGINT));
        dashboardListenerInfoModel.setDescription(resultSet.getString(BOOLEAN));
        dashboardListenerInfoModel.setEnabled(resultSet.getBoolean(SEDU));
        dashboardListenerInfoModel.setCreateTime(resultSet.getLong(VARCHAR));
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        dashboardListenerInfoModel.setTargets(hashMap);
        while (dashboardListenerInfoModel.getClassName().equals(resultSet.getString(BIGINT))) {
            hashMap.put(resultSet.getString("TARGET"), resultSet.getLong("APPLYTIME"));
            if (resultSet.next()) continue;
        }
        return dashboardListenerInfoModel;
    }

    static {
        append = DashboardListenerInfoDAO.buildInsertSql(new String[]{BIGINT, BOOLEAN, SEDU, VARCHAR});
        buildInsertSql = DashboardListenerInfoDAO.buildUpdateSql(BIGINT, new String[]{BOOLEAN, SEDU});
    }
}

