/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.nls;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.nls.FontNLSEntry;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.util.ServerUtil;

public class GlobalNLSFontTable
extends TableImpl {
    public static final int VERSION = 1;
    public static final String TABLE_NAME = "GLOBAL_NLS_FONT_1";
    private static final String[] BIT = new String[]{"LOC", "ORG_FACE", "ORG_SIZE", "TAR_FACE", "TAR_SIZE", "IS_RELATIVE"};
    private static final int EMPTY = 0;
    private static final int INTEGER = 1;
    private static final int SEDU = 2;
    private static final int VARCHAR = 3;
    private static final int add = 4;
    private static final int append = 5;

    GlobalNLSFontTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIT[0], JDBCType.VARCHAR, 10, 9, 0));
        super.append(new FieldImpl(this.getName(), BIT[1], JDBCType.VARCHAR, 20, 9, 0));
        super.append(new FieldImpl(this.getName(), BIT[2], JDBCType.INTEGER, 0, 9, 0));
        super.append(new FieldImpl(this.getName(), BIT[3], JDBCType.VARCHAR, 20, 1, 0));
        super.append(new FieldImpl(this.getName(), BIT[4], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), BIT[5], JDBCType.BIT, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        ((DatabaseImpl)database).appendSystemTable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryNLSLocales() throws SQLException {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        Recordset recordset = super.query(new Field[]{super.fields(0)}, null, ParameterMetaInfo.EMPTY, true);
        try {
            while (recordset.next()) {
                Locale locale = ServerUtil.getLocale(recordset.getString(0));
                if (locale == null) continue;
                arrayList.add(locale);
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryNLS(Locale locale) throws SQLException {
        ArrayList<FontNLSEntry> arrayList = new ArrayList<FontNLSEntry>();
        StringBuilder stringBuilder = new StringBuilder("where ").append(this.fields(0).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        Recordset recordset = super.query(new Field[]{this.fields(1), this.fields(2), this.fields(3), this.fields(4), this.fields(5)}, stringBuilder.toString(), parameterMetaInfo, true);
        try {
            while (recordset.next()) {
                String string = recordset.getString(0);
                int n = recordset.getInt(1);
                String string2 = recordset.getString(2);
                int n2 = recordset.getInt(3);
                boolean bl = recordset.getBoolean(4);
                arrayList.add(new FontNLSEntry(string, n, string2, n2, bl));
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryNLS(Locale locale, FontNLSEntry fontNLSEntry) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("where ").append(BIT[0]).append("=?").append(" and ").append(BIT[1]).append("=?").append(" and ").append(BIT[2]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        parameterMetaInfo.add(this.fields(1).getName(), fontNLSEntry.getOrginalFace(), 12);
        parameterMetaInfo.add(this.fields(2).getName(), fontNLSEntry.getOrginalSize(), 4);
        Recordset recordset = super.query(new Field[]{this.fields(3), this.fields(4), this.fields(5)}, stringBuilder.toString(), parameterMetaInfo, true);
        try {
            if (recordset.next()) {
                String string = recordset.getString(0);
                int n = recordset.getInt(1);
                boolean bl = recordset.getBoolean(2);
                fontNLSEntry.setTargetFace(string);
                fontNLSEntry.setTargetSize(n);
                fontNLSEntry.setRelative(bl);
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            recordset.close();
        }
        return false;
    }

    public int saveNLS(final Locale locale, final List list) throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("delete from ").append(super.getName()).append(" WHERE ").append(BIT[0]).append("=?");
        final StringBuilder stringBuilder2 = new StringBuilder("insert into ").append(super.getName()).append("(").append(BIT[0]).append(",").append(BIT[1]).append(",").append(BIT[2]).append(",").append(BIT[3]).append(",").append(BIT[4]).append(",").append(BIT[5]).append(")values(").append("?,?,?,?,?,?").append(")");
        try {
            Integer n = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n = 0;
                    PreparedStatement preparedStatement = null;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        preparedStatement.setString(1, locale.toString());
                        preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    if (list.size() == 0) {
                        return n;
                    }
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder2.toString());
                        Object object = list.iterator();
                        while (object.hasNext()) {
                            FontNLSEntry fontNLSEntry = (FontNLSEntry)object.next();
                            preparedStatement.setString(1, locale.toString());
                            preparedStatement.setString(2, fontNLSEntry.getOrginalFace());
                            preparedStatement.setInt(3, fontNLSEntry.getOrginalSize());
                            preparedStatement.setString(4, fontNLSEntry.getTargetFace());
                            preparedStatement.setInt(5, fontNLSEntry.getTargetSize());
                            preparedStatement.setBoolean(6, fontNLSEntry.isRelative());
                            preparedStatement.addBatch();
                        }
                        for (Object object2 : object = (Object)preparedStatement.executeBatch()) {
                            n += object2;
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return n;
                }
            });
            return n;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public int deleteNLS(Locale locale) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("where ").append(this.fields(0).getName()).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(this.fields(0).getName(), locale.toString(), 12);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }
}

