/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.quartz;

import java.sql.SQLException;
import java.util.ArrayList;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.quartz.JobDetailsTable;
import jet.server.db.quartz.TriggerRecord;
import jet.server.log.ServiceLogger;

public class TriggersTable
extends TableImpl
implements Table {
    public static final String TABLENAME = "JR_QRTZ_TRIGGERS";
    static final String[] COLNAMES = new String[16];

    public static TriggersTable newInstance(Database database, JobDetailsTable jobDetailsTable) {
        try {
            return new TriggersTable(database, jobDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private TriggersTable(Database database, JobDetailsTable jobDetailsTable) throws SQLException, InstantiationException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 200, 9, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.VARCHAR, 200, 9, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[2], JDBCType.VARCHAR, 200, 33, 0, jobDetailsTable.getName()));
        super.append(new FieldImpl(this.getName(), COLNAMES[3], JDBCType.VARCHAR, 200, 33, 0, jobDetailsTable.getName()));
        super.append(new FieldImpl(this.getName(), COLNAMES[4], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[5], JDBCType.VARCHAR, 250, 0, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[6], JDBCType.BIGINT, 13, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[7], JDBCType.BIGINT, 13, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[8], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[9], JDBCType.VARCHAR, 16, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[10], JDBCType.VARCHAR, 8, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[11], JDBCType.BIGINT, 13, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[12], JDBCType.BIGINT, 13, 0, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[13], JDBCType.VARCHAR, 200, 0, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[14], JDBCType.SMALLINT, 2, 0, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[15], JDBCType.BLOB, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList getAllTriggersName() {
        ArrayList<TriggerRecord> arrayList = new ArrayList<TriggerRecord>();
        Field[] fieldArray = new Field[4];
        fieldArray[0] = this.fields(COLNAMES[0]);
        fieldArray[0] = this.fields(COLNAMES[1]);
        fieldArray[0] = this.fields(COLNAMES[2]);
        fieldArray[0] = this.fields(COLNAMES[3]);
        Recordset recordset = null;
        try {
            Object object;
            recordset = super.query(fieldArray, null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                object = (String)recordset.fields(COLNAMES[0]).getValue();
                String string = (String)recordset.fields(COLNAMES[1]).getValue();
                String string2 = (String)recordset.fields(COLNAMES[2]).getValue();
                String string3 = (String)recordset.fields(COLNAMES[3]).getValue();
                TriggerRecord triggerRecord = new TriggerRecord((String)object, string, string2, string3);
                arrayList.add(triggerRecord);
            }
            object = arrayList;
            return object;
        }
        catch (SQLException sQLException) {
            arrayList = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return arrayList;
    }

    static {
        TriggersTable.COLNAMES[0] = "TRIGGER_NAME";
        TriggersTable.COLNAMES[1] = "TRIGGER_GROUP";
        TriggersTable.COLNAMES[2] = "JOB_NAME";
        TriggersTable.COLNAMES[3] = "JOB_GROUP";
        TriggersTable.COLNAMES[4] = "IS_VOLATILE";
        TriggersTable.COLNAMES[5] = "DESCRIPTION";
        TriggersTable.COLNAMES[6] = "NEXT_FIRE_TIME";
        TriggersTable.COLNAMES[7] = "PREV_FIRE_TIME";
        TriggersTable.COLNAMES[8] = "PRIORITY";
        TriggersTable.COLNAMES[9] = "TRIGGER_STATE";
        TriggersTable.COLNAMES[10] = "TRIGGER_TYPE";
        TriggersTable.COLNAMES[11] = "START_TIME";
        TriggersTable.COLNAMES[12] = "END_TIME";
        TriggersTable.COLNAMES[13] = "CALENDAR_NAME";
        TriggersTable.COLNAMES[14] = "MISFIRE_INSTR";
        TriggersTable.COLNAMES[15] = "JOB_DATA";
    }
}

