/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.resource;

import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.resource.DynamicNodeCache;
import jet.server.db.resource.DynamicNodeRecord;
import jet.server.db.resource.DynamicNodeTable;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.log.ServiceLogger;

public class DynamicNodeTableImpl
extends TableImpl
implements Table,
DynamicNodeTable {
    private static final int BIT = 5;
    private static final int EMPTY = 1;
    private static final int INTEGER = 2;
    private static final int SEDU = 3;
    private static final int TINYINT = 4;
    private static final String VARCHAR = "DYNAMICNODE_5";
    private static final String[] add = new String[]{"NAME", "ROOT", "REALPATH", "NODETYPE", "ENABLEARCHIVEPOLICY", "DELETED", "ACLID", "DESCRIPTION", "MAXVERSIONAMOUNT", "ENABLELINKEDCAT", "LINKEDCAT", "USEINHERITED", "ENABLENLS", "STATUS", "LINKEDCATID"};
    private static final int addElement = 0;
    private static final int append = 1;
    private static final int arraycopy = 2;
    private static final int clear = 3;
    private static final int close = 4;
    private static final int contains = 5;
    private static final int createFieldValue = 6;
    private static final int createTable = 7;
    private static final int delete = 8;
    private static final int get = 9;
    private static final int getAclID = 10;
    private static final int getAllRecords = 11;
    private static final int getBoolean = 12;
    private static final int getByte = 13;
    private static final int getInt = 14;
    private Vector getMaxVersionAmount = null;
    private DynamicNodeCache getName;

    public static DynamicNodeTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        try {
            return new DynamicNodeTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, VARCHAR, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private DynamicNodeTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, VARCHAR);
        super.append(new FieldImpl(this.getName(), add[0], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), add[1], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), add[2], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), add[3], JDBCType.TINYINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), add[4], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), add[5], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), add[6], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), add[7], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), add[8], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), add[9], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), add[10], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), add[11], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), add[12], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), add[13], JDBCType.TINYINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), add[14], JDBCType.INTEGER, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "DYNAMICNODE_1";
        super.upgradeOldTable(database, updateDetailsTable, string, 1);
        String string2 = "DYNAMICNODE_2";
        super.upgradeOldTable(database, updateDetailsTable, string2, 2);
        String string3 = "DYNAMICNODE_3";
        super.upgradeOldTable(database, updateDetailsTable, string3, 3);
        String string4 = "DYNAMICNODE_4";
        super.upgradeOldTable(database, updateDetailsTable, string4, 4);
        this.getMaxVersionAmount = new Vector();
        Vector vector = this.getAllRecords();
        for (int i = 0; i < vector.size(); ++i) {
            this.getMaxVersionAmount.add(((DynamicNodeRecord)vector.get(i)).getName());
        }
        this.getName = new DynamicNodeCache();
    }

    @Override
    protected void mergeOldTable(Table table, int n) throws SQLException {
        if (n == 3) {
            super.mergeOldTable(table, n);
            return;
        }
        this.BIT(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BIT(Table table) throws SQLException {
        Recordset recordset = null;
        try {
            recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            boolean bl = table.fields().contains(add[12]);
            boolean bl2 = table.fields().contains(add[13]);
            if (bl && bl2) {
                while (recordset.next()) {
                    super.insert(recordset.fields());
                }
            } else if (!bl && !bl2) {
                FieldValue[] fieldValueArray = new FieldValue[recordset.fields().length + 2];
                fieldValueArray[fieldValueArray.length - 2] = this.fields(add[12]).createFieldValue();
                fieldValueArray[fieldValueArray.length - 1] = this.fields(add[13]).createFieldValue();
                while (recordset.next()) {
                    try {
                        System.arraycopy(recordset.fields(), 0, fieldValueArray, 0, fieldValueArray.length - 2);
                        boolean bl3 = false;
                        byte by = 1;
                        if (recordset.getByte(add[3]) == 1) {
                            String string = recordset.getString(2);
                            bl3 = NLSUtil.isReportNationalLanguageSupport(string);
                            ServiceLogger.logDebug(5620033, new Object[]{new Boolean(bl3), new Byte(by), string}, 5);
                        }
                        fieldValueArray[fieldValueArray.length - 2].setValue(new Boolean(bl3));
                        fieldValueArray[fieldValueArray.length - 1].setValue(new Byte(by));
                        super.insert(fieldValueArray);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                        super.insert(recordset.fields());
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    @Override
    public synchronized boolean addRecord(String string, String string2, String string3, byte by, boolean bl, boolean bl2, int n, String string4, int n2, boolean bl3, String string5, boolean bl4, boolean bl5, byte by2, int n3) {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(string2);
        fieldValueArray[2].setValue(string3);
        fieldValueArray[3].setValue(new Byte(by));
        fieldValueArray[4].setValue(new Boolean(bl));
        fieldValueArray[5].setValue(new Boolean(bl2));
        fieldValueArray[6].setValue(new Integer(n));
        fieldValueArray[7].setValue(string4);
        fieldValueArray[8].setValue(new Integer(n2));
        fieldValueArray[9].setValue(new Boolean(bl3));
        fieldValueArray[10].setValue(string5);
        fieldValueArray[11].setValue(new Boolean(bl4));
        fieldValueArray[12].setValue(new Boolean(bl5));
        fieldValueArray[13].setValue(new Byte(by2));
        fieldValueArray[14].setValue(new Integer(n3));
        try {
            super.insert(fieldValueArray);
            if (!this.getMaxVersionAmount.contains(string)) {
                this.getMaxVersionAmount.add(string);
            }
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public Object getRecord(String string) {
        if (!this.getMaxVersionAmount.contains(string)) {
            return null;
        }
        Object object = this.getName.getRecord(string);
        if (object == null && (object = this.EMPTY(string)) != null) {
            this.getName.updateRecord(object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object EMPTY(String string) {
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), string, 12);
            String string2 = " WHERE " + super.fields(0).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            if (recordset.next()) {
                DynamicNodeRecord dynamicNodeRecord;
                DynamicNodeRecord dynamicNodeRecord2 = dynamicNodeRecord = new DynamicNodeRecord(recordset.getString(add[0]), recordset.getString(add[1]), recordset.getString(add[2]), recordset.getByte(add[3]), recordset.getBoolean(add[4]), recordset.getBoolean(add[5]), recordset.getInt(add[6]), recordset.getString(add[7]), recordset.getInt(add[8]), recordset.getBoolean(add[9]), recordset.getString(add[10]), recordset.getBoolean(add[11]), recordset.getBoolean(add[12]), recordset.getByte(add[13]), recordset.getInt(add[14]));
                return dynamicNodeRecord2;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return null;
    }

    @Override
    public synchronized boolean updateAcl(String string, int n) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(6).createFieldValue()};
        fieldValueArray[0].setValue(new Integer(n));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            dynamicNodeRecord.setAclID(n);
        }
        return true;
    }

    @Override
    public synchronized boolean updateMaxVersionAmount(String string, int n) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(8).createFieldValue()};
        fieldValueArray[0].setValue(new Integer(n));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            dynamicNodeRecord.setMaxVersionAmount(n);
        }
        return true;
    }

    @Override
    public synchronized boolean updateDescriptionAndLinkedCatProp(String string, String string2, boolean bl, String string3, boolean bl2, int n) {
        FieldValue[] fieldValueArray = new FieldValue[5];
        fieldValueArray[0] = super.fields(7).createFieldValue();
        fieldValueArray[0].setValue(string2);
        fieldValueArray[1] = super.fields(9).createFieldValue();
        fieldValueArray[2] = super.fields(10).createFieldValue();
        fieldValueArray[3] = super.fields(11).createFieldValue();
        fieldValueArray[4] = super.fields(14).createFieldValue();
        fieldValueArray[1].setValue(new Boolean(bl));
        fieldValueArray[2].setValue(string3);
        fieldValueArray[3].setValue(new Boolean(bl2));
        fieldValueArray[4].setValue(new Integer(n));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            dynamicNodeRecord.setDescription(string2);
            dynamicNodeRecord.setLinkedCatalogProps(bl, string3, n, bl2);
        }
        return true;
    }

    @Override
    public synchronized boolean updateDescription(String string, String string2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(7).createFieldValue()};
        fieldValueArray[0].setValue(string2);
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            dynamicNodeRecord.setDescription(string2);
        }
        return true;
    }

    @Override
    public synchronized boolean updateLinkedCatalogProps(String string, boolean bl, String string2, boolean bl2, int n) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(9).createFieldValue(), super.fields(10).createFieldValue(), super.fields(11).createFieldValue(), super.fields(14).createFieldValue()};
        fieldValueArray[0].setValue(new Boolean(bl));
        fieldValueArray[1].setValue(string2);
        fieldValueArray[2].setValue(new Boolean(bl2));
        fieldValueArray[3].setValue(new Integer(n));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            dynamicNodeRecord.setLinkedCatalogProps(bl, string2, n, bl2);
        }
        return true;
    }

    @Override
    public synchronized boolean updateEnableNLS(String string, boolean bl) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(12).createFieldValue()};
        fieldValueArray[0].setValue(new Boolean(bl));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            dynamicNodeRecord.setIsEnableNLS(bl);
        }
        return true;
    }

    @Override
    public synchronized boolean updateStatus(String string, byte by) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(13).createFieldValue()};
        fieldValueArray[0].setValue(new Byte(by));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            dynamicNodeRecord.setStatus(by);
        }
        return true;
    }

    @Override
    public synchronized boolean deleteRecord(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(0).getName()).append("=?");
            super.delete(stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        this.getName.removeRecord(string);
        this.getMaxVersionAmount.remove(string);
        return true;
    }

    @Override
    public synchronized boolean deleteAll() {
        try {
            int n = super.delete(null, ParameterMetaInfo.EMPTY);
            this.getMaxVersionAmount.clear();
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAclID(String string) {
        if (!this.getMaxVersionAmount.contains(string)) {
            return -1;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            return dynamicNodeRecord.getAclID();
        }
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), string, 12);
            String string2 = " WHERE " + super.fields(0).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            if (recordset.next()) {
                int n = recordset.getInt(add[6]);
                return n;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxVersionAmount(String string) {
        if (!this.getMaxVersionAmount.contains(string)) {
            return -1;
        }
        Object object = this.getName.getRecord(string);
        if (object != null) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)object;
            return dynamicNodeRecord.getMaxVersionAmount();
        }
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), string, 12);
            String string2 = " WHERE " + super.fields(0).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            if (recordset.next()) {
                int n = recordset.getInt(add[8]);
                return n;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeExists(String string) {
        if (!this.getMaxVersionAmount.contains(string)) {
            return false;
        }
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), string, 12);
            String string2 = " WHERE " + super.fields(0).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            if (recordset.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllRecords() {
        Vector<DynamicNodeRecord> vector = new Vector<DynamicNodeRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                DynamicNodeRecord dynamicNodeRecord = new DynamicNodeRecord(recordset.getString(add[0]), recordset.getString(add[1]), recordset.getString(add[2]), recordset.getByte(add[3]), recordset.getBoolean(add[4]), recordset.getBoolean(add[5]), recordset.getInt(add[6]), recordset.getString(add[7]), recordset.getInt(add[8]), recordset.getBoolean(add[9]), recordset.getString(add[10]), recordset.getBoolean(add[11]), recordset.getBoolean(add[12]), recordset.getByte(add[13]), recordset.getInt(add[14]));
                vector.addElement(dynamicNodeRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }
}

