/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.UserProfileRecord;
import jet.server.db.security2.UserProfileTable;
import jet.server.log.ServiceLogger;

public class UserProfileTableImpl
extends TableImpl
implements Table,
UserProfileTable {
    public static final int OLDVERSION = 1;
    public static final int OLDVERSION2 = 2;
    public static final int OLDVERSION3 = 3;
    public static final int VERSION = 4;
    public static final String TABLENAME = "USERPROFILES_4";
    static final String[] COLNAMES = new String[2];

    public static UserProfileTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new UserProfileTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private UserProfileTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.VARCHAR, 65, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, "USERPROFILES_1", 1);
        super.upgradeOldTable(database, updateDetailsTable, "USERPROFILES_2", 2);
        super.upgradeOldTable(database, updateDetailsTable, "USERPROFILES_3", 3);
    }

    @Override
    public synchronized UserProfileRecord addRecord(String string, String string2) {
        UserProfileRecord userProfileRecord = new UserProfileRecord(string, string2);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(userProfileRecord.getUserName());
        fieldValueArray[1].setValue(userProfileRecord.getRoleName());
        try {
            super.insert(fieldValueArray);
            return userProfileRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteRecord(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getParentRolesName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[1])};
        Vector<String> vector = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            recordset = super.query(fieldArray, stringBuffer.substring(0), parameterMetaInfo, false);
            vector = new Vector<String>();
            while (recordset.next()) {
                vector.add(recordset.getString(COLNAMES[1]));
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            Vector<String> vector3 = vector;
            return vector3;
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getSubUsers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Object> vector = null;
        Recordset recordset = null;
        try {
            Object object;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.substring(0), parameterMetaInfo, false);
            vector = new Vector<Object>();
            while (recordset.next()) {
                object = new UserProfileRecord(recordset.getString(COLNAMES[0]), recordset.getString(COLNAMES[1]));
                vector.add(object);
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            Vector<Object> vector2 = vector;
            return vector2;
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    @Override
    public synchronized int getParentRolesCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.queryCountValue(this.fields(COLNAMES[0]).getName(), stringBuffer.toString(), parameterMetaInfo, false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    @Override
    public synchronized boolean deleteRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string2), 12);
            stringBuffer.append(" AND ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized int getSubUsersCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.queryCountValue(this.fields(COLNAMES[1]).getName(), stringBuffer.toString(), parameterMetaInfo, false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    @Override
    public synchronized boolean deleteRecordByRoleName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized UserProfileRecord getRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string2, 12);
            stringBuffer.append("WHERE ");
            stringBuffer.append(super.fields(COLNAMES[0]).getName()).append("=?");
            stringBuffer.append(" AND ");
            stringBuffer.append(super.fields(COLNAMES[1]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                UserProfileRecord userProfileRecord;
                UserProfileRecord userProfileRecord2 = userProfileRecord = new UserProfileRecord(recordset.getString(COLNAMES[0]), recordset.getString(COLNAMES[1]));
                return userProfileRecord2;
            }
            UserProfileRecord userProfileRecord = null;
            return userProfileRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            UserProfileRecord userProfileRecord = null;
            return userProfileRecord;
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Hashtable[] getAllRecords() {
        Hashtable[] hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable()};
        Recordset recordset = null;
        try {
            Hashtable[] hashtableArray2;
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                Vector<Object> vector;
                hashtableArray2 = recordset.getString(COLNAMES[0]);
                String string = recordset.getString(COLNAMES[1]);
                Vector vector2 = (Vector)hashtableArray[0].get(hashtableArray2);
                Vector vector3 = (Vector)hashtableArray[1].get(string);
                if (vector2 != null) {
                    vector2.add(string);
                } else {
                    vector = new Vector<Object>();
                    vector.add(string);
                    hashtableArray[0].put(hashtableArray2, vector);
                }
                if (vector3 != null) {
                    vector3.add(hashtableArray2);
                    continue;
                }
                vector = new Vector();
                vector.add(hashtableArray2);
                hashtableArray[1].put(string, vector);
            }
            hashtableArray2 = hashtableArray;
            return hashtableArray2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            Hashtable[] hashtableArray3 = null;
            return hashtableArray3;
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    @Override
    protected void mergeOldTable(Table table, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.COLNAMES(table);
                break;
            }
            case 2: 
            case 3: {
                this.EMPTY(table);
            }
        }
    }

    private void COLNAMES(Table table) throws SQLException {
        Object object;
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            object = super.fields().values();
            object[0].setValue(recordset.fields("userName").getValue());
            object[1].setValue(recordset.fields("roleName").getValue());
            super.insert((FieldValue[])object);
        }
        object = this.getRecord("admin", "everyone");
        if (object == null) {
            this.addRecord("admin", "everyone");
        }
        recordset.close();
    }

    private void EMPTY(Table table) throws SQLException {
        Object object;
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            object = super.fields().values();
            object[0].setValue(recordset.fields("user_name").getValue());
            object[1].setValue(recordset.fields("role_name").getValue());
            super.insert((FieldValue[])object);
        }
        object = this.getRecord("admin", "everyone");
        if (object == null) {
            this.addRecord("admin", "everyone");
        }
        recordset.close();
    }

    @Override
    public boolean deleteRecordByOrganization(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append(" LIKE ?");
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" OR ").append(super.fields(COLNAMES[1]).getName()).append(" LIKE ?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    static {
        UserProfileTableImpl.COLNAMES[0] = "user_name";
        UserProfileTableImpl.COLNAMES[1] = "role_name";
    }
}

