/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.transfer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.core.Dbs;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.transfer.AbstractTransferHelp;
import jet.server.db.version.LCVersionTableImpl;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.util.CreateDefExProperties;
import jet.server.util.WebSecurityUtil;

public final class RealmDBTransferHelp
extends AbstractTransferHelp {
    String histDir = null;

    public RealmDBTransferHelp() {
        String string = System.getProperty("history_dir");
        String string2 = string == null ? ServerEnv.homePath + "history" : string;
        String string3 = this.histDir = ServerEnv.isSharedHistDir() ? ServerEnv.getSharedHistDir() : string2;
        if (this.histDir.endsWith(File.separator)) {
            this.histDir = this.histDir.substring(0, this.histDir.length() - 1);
        }
    }

    @Override
    public synchronized boolean backup(Database database, String string) throws SQLException, IOException {
        Object object;
        Object object22;
        if (string == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        String string2 = database.getProperty("backup-type");
        if (string2 != null && string2.equalsIgnoreCase("DB")) {
            bl = true;
        }
        System.out.println("Backup begin...");
        String string3 = database.getWorkspace().getName();
        String string4 = database.getName();
        String string5 = string3 + "/";
        ZipOutputStream zipOutputStream = RealmDBTransferHelp.createBackupVolume(string, string5);
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        properties.setProperty("version", "1.0");
        if (bl) {
            properties.setProperty("type", "BAK_DB");
        } else {
            properties.setProperty("type", "BAK");
        }
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string3);
        properties.setProperty("database", string4);
        boolean bl2 = ServerEnv.isClusterEnabled();
        if (bl2) {
            properties.setProperty("cluster", String.valueOf(bl2));
            properties.setProperty("cluster.name", ServerEnv.getClusterName());
            properties.setProperty("cluster.member", ServerEnv.getServerID());
        }
        for (Object object22 : RealmDBTransferHelp.sortBackupTables(database.Realmtables())) {
            object = object22.query(object22.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2, 1003);
            System.err.print("Backup " + string4 + "." + object22.getName() + " ... ");
            n = RealmDBTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string5 + object22.getNameWithoutSchema() + ".dat"), (Recordset)object);
            object.close();
            System.out.println(n + " OK");
            stringBuffer.append(object22.getNameWithoutSchema()).append(";");
        }
        zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
        properties.setProperty("tableset", stringBuffer.toString());
        object22 = new ByteArrayOutputStream();
        properties.store((OutputStream)object22, "JREntServer server data backup archive");
        zipOutputStream.write(((ByteArrayOutputStream)object22).toByteArray());
        zipOutputStream.closeEntry();
        if (!bl) {
            String string6;
            Object object3;
            Object object4;
            object = new HashSet();
            System.out.print("Backup external data ... ");
            Iterator iterator = database.tables().iterator();
            while (iterator.hasNext()) {
                object4 = (Table)iterator.next();
                if (!object4.hasExternalData()) continue;
                object3 = object4.query(object4.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
                object3.first();
                while (object3.next()) {
                    Object object5;
                    FieldValue[] fieldValueArray = object3.fields();
                    string6 = object4.getExternalDataPath(fieldValueArray);
                    if (string6.endsWith(File.separator) && ((String)(object5 = string6.substring(0, string6.length() - 1))).equalsIgnoreCase(this.histDir)) continue;
                    object5 = new File(string6);
                    String string7 = null;
                    string7 = ServerEnv.isSharedHistDir() ? ((string7 = ServerEnv.getSharedHistDir()).endsWith(File.separator) ? (string7 = string7.substring(0, string7.length() - ("history" + File.separator).length())) : string7.substring(0, string7.length() - "history".length())) : ServerEnv.homePath;
                    if (!((File)object5).exists() || ((HashSet)object).contains(string6)) continue;
                    RealmDBTransferHelp.exportExternalData(zipOutputStream, string6, string7, string5);
                    ((HashSet)object).add(string6);
                }
                object3.close();
            }
            ((HashSet)object).clear();
            object4 = new File(this.histDir);
            object3 = ((File)object4).listFiles();
            for (int i = 0; i < ((File[])object3).length; ++i) {
                if (!((File)object3[i]).isFile()) continue;
                string6 = null;
                string6 = ServerEnv.isSharedHistDir() ? ((string6 = ServerEnv.getSharedHistDir()).endsWith(File.separator) ? (string6 = string6.substring(0, string6.length() - ("history" + File.separator).length())) : string6.substring(0, string6.length() - "history".length())) : ServerEnv.homePath;
                RealmDBTransferHelp.exportExternalData(zipOutputStream, ((File)object3[i]).getAbsolutePath(), string6, string5);
            }
            System.out.println(" OK");
        }
        zipOutputStream.close();
        System.gc();
        System.out.println("Backup end");
        return true;
    }

    @Override
    public synchronized boolean restore(Database database, String string) throws SQLException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(string);
        Properties properties = RealmDBTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string3 = properties.getProperty("version");
        String string4 = properties.getProperty("type");
        String string5 = properties.getProperty("realm");
        String string6 = properties.getProperty("database");
        String string7 = database.getWorkspace().getName();
        String string8 = database.getName();
        String string9 = database.getProperty("schema");
        if (!(string7.equals(string5) && string8.equals(string6) && string3.equals("1.0") && (string4.equals("BAK") || string4.equals("BAK_DB")))) {
            throw new IOException("The " + string + " is not for " + string7 + "." + string8);
        }
        String string10 = string7 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string10);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string7 + " workspace.");
        }
        List list = RealmDBTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        System.out.println("Restore begin...");
        RealmDBTransferHelp.deleteTablesPreRestore(list, string9, database);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string11 = (String)iterator.next();
            string2 = Dbs.fullTableName(string9, string11);
            object3 = database.tables(string2);
            object2 = string10 + string11 + ".dat";
            object = zipFile.getEntry((String)object2);
            if (object3 == null || object == null) continue;
            System.out.print("Restore " + database.getName() + "." + string2 + " ...");
            RealmDBTransferHelp.importsTableData((Table)object3, arrayList, zipFile.getInputStream((ZipEntry)object));
            int n2 = object3.insert2(arrayList);
            arrayList.clear();
            System.out.println(n2 + " OK");
            hashSet.add(((ZipEntry)object).getName());
        }
        boolean bl = false;
        string2 = database.getProperty("restore-type");
        if (string2 != null && string2.equals("DB") || string4.equals("BAK_DB")) {
            bl = true;
        }
        if (!bl) {
            System.out.print("Restore external data ...");
            object3 = zipFile.entries();
            while (object3.hasMoreElements()) {
                String string12;
                int n3;
                object2 = (ZipEntry)object3.nextElement();
                object = ((ZipEntry)object2).getName();
                if (!((String)object).startsWith(string5) || hashSet.contains(object) || (n3 = (string12 = ((String)object).substring(string5.length() + 1, ((String)object).length())).indexOf("/")) <= 0) continue;
                string12 = this.histDir + string12.substring(n3, string12.length());
                RealmDBTransferHelp.importsExternalData(string12, zipFile.getInputStream((ZipEntry)object2));
            }
            System.out.println(" OK");
        }
        hashSet.clear();
        zipFile.close();
        boolean bl2 = CSUtil.getBoolean(properties.getProperty("cluster"), false);
        boolean bl3 = ServerEnv.isClusterEnabled();
        if (bl2 && bl3) {
            object = properties.getProperty("cluster.member");
            int n4 = -1;
            try {
                n4 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string13 = ServerEnv.getServerID();
            if (!(n4 <= 0 || string13 != null && string13.length() != 0 && ((String)object).equals(string13))) {
                CreateDefExProperties createDefExProperties = new CreateDefExProperties(true);
                String string14 = ServerEnv.getServPropName();
                createDefExProperties.load(string14);
                createDefExProperties.setProperty("cluster.member.id", (String)object);
                createDefExProperties.save(string14, null);
            }
        }
        System.gc();
        System.out.println("Restore end");
        return true;
    }

    @Override
    public synchronized boolean cutdownTable(Database database, Table table, String string, String string2) throws SQLException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string3 = database.getWorkspace().getName();
        String string4 = database.getName();
        String string5 = table.getName();
        String string6 = table.getNameWithoutSchema();
        String string7 = Dbs.fullTableName(database.getProperty("schema"), "");
        if (!string5.equalsIgnoreCase(string7 + "RESULTVERSION_3")) {
            throw new SQLException("Can not cut down " + string5 + " in " + string4);
        }
        String string8 = null;
        long l = 0L;
        if (string2 != null && string2.trim().length() > 0) {
            try {
                l = DF.parse(string2).getTime() + 60000L;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        string8 = "WHERE CREATEDTIME <=?";
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("crtTime", l);
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        properties.setProperty("version", "1.0");
        properties.setProperty("type", "CUT");
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string3);
        properties.setProperty("database", string4);
        Table table2 = database.tables(string7 + "VERSIONNODES_3");
        Table table3 = database.tables(string7 + "NODES_6");
        ArrayList<FieldValue[]> arrayList = new ArrayList<FieldValue[]>();
        ArrayList<FieldValue[]> arrayList2 = new ArrayList<FieldValue[]>();
        Recordset recordset = table.query(table.fields().toArray(), string8 + " ORDER BY " + string5 + ".CREATEDTIME ASC", parameterMetaInfo, false);
        table.delete(string8, parameterMetaInfo);
        String string9 = null;
        if (recordset.next()) {
            string9 = DF.format(new Date(recordset.getLong("CREATEDTIME")));
        }
        recordset.first();
        while (recordset.next()) {
            int n = recordset.getInt("VERSIONNUMBER");
            int n2 = recordset.getInt("RESOURCEID");
            stringBuffer2.delete(0, stringBuffer2.length());
            stringBuffer2.append("WHERE VERSIONNUMBER=?").append(" AND ");
            stringBuffer2.append("RESOURCEID=?");
            object4 = new ParameterMetaInfo().add("verID", n).add("resID", n2);
            object3 = table2.query(table2.fields().toArray(), stringBuffer2.toString(), (ParameterMetaInfo)object4, true);
            if (object3.next()) {
                int n3 = object3.getInt("ID");
                arrayList.add(object3.fields());
                table2.delete(stringBuffer2.toString(), (ParameterMetaInfo)object4);
                stringBuffer2.delete(0, stringBuffer2.length());
                stringBuffer2.append("WHERE ID=?");
                object2 = new ParameterMetaInfo().add("vID", n3);
                object = table3.query(table3.fields().toArray(), stringBuffer2.toString(), (ParameterMetaInfo)object2, true);
                if (object.next()) {
                    arrayList2.add(object.fields());
                    table3.delete(stringBuffer2.toString(), (ParameterMetaInfo)object2);
                }
                object.close();
            }
            object3.close();
        }
        string9 = string9 != null ? string9 + " to " + DF.format(new Date(recordset.getLong("CREATEDTIME"))) : "";
        properties.setProperty("scope", string9);
        if (string != null && string.trim().length() > 0) {
            String string10 = string3 + "/";
            ZipOutputStream zipOutputStream = RealmDBTransferHelp.createBackupVolume(string, string10);
            System.out.println("Backup begin...");
            recordset.first();
            while (recordset.next()) {
                object4 = table.getExternalDataPath(recordset.fields());
                object3 = null;
                object3 = ServerEnv.isSharedHistDir() ? (((String)(object3 = ServerEnv.getSharedHistDir())).endsWith(File.separator) ? (object3 = ((String)object3).substring(0, ((String)object3).length() - ("history" + File.separator).length())) : ((String)object3).substring(0, ((String)object3).length() - "history".length())) : ServerEnv.homePath;
                RealmDBTransferHelp.exportExternalData(zipOutputStream, (String)object4, (String)object3, string10);
                RealmDBTransferHelp.deleteExternalData(new File((String)object4));
            }
            System.out.print("Backup " + string4 + "." + string5 + " ... ");
            int n = RealmDBTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string10 + string6 + ".dat"), recordset);
            recordset.close();
            System.out.println(n + " OK");
            object3 = table2.getName();
            String string11 = table2.getNameWithoutSchema();
            System.out.print("Backup " + string4 + "." + (String)object3 + " ... ");
            n = RealmDBTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string10 + string11 + ".dat"), arrayList);
            arrayList.clear();
            System.out.println(n + " OK");
            object2 = table3.getName();
            object = table3.getNameWithoutSchema();
            System.out.print("Backup " + string4 + "." + (String)object2 + " ... ");
            n = RealmDBTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string10 + (String)object + ".dat"), arrayList2);
            arrayList2.clear();
            System.out.println(n + " OK");
            stringBuffer.append(string6).append(";").append(string11).append(";").append((String)object);
            zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
            properties.setProperty("tableset", stringBuffer.toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, "JREntServer result version cutdown archive");
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            System.out.println("Backup end");
        }
        System.gc();
        return true;
    }

    @Override
    public synchronized boolean importsTable(Database database, Table table, String string) throws SQLException, IOException {
        Object object;
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(WebSecurityUtil.validateFilePath(string));
        Properties properties = RealmDBTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string2 = properties.getProperty("version");
        String string3 = properties.getProperty("type");
        String string4 = properties.getProperty("realm");
        String string5 = properties.getProperty("database");
        String string6 = database.getWorkspace().getName();
        String string7 = database.getName();
        if (!(string6.equals(string4) && string7.equals(string5) && string2.equals("1.0") && string3.equals("CUT"))) {
            throw new IOException("The " + string + " is not for " + string6 + "." + string7);
        }
        String string8 = Dbs.fullTableName(database.getProperty("schema"), "");
        String string9 = table.getName();
        if (!string9.equalsIgnoreCase(string8 + "RESULTVERSION_3")) {
            throw new IOException("Can not import " + string9 + " in " + string7);
        }
        String string10 = string6 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string10);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string6 + " workspace.");
        }
        List list = RealmDBTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            arrayList.add(object);
        }
        object = list.iterator();
        ArrayList arrayList2 = new ArrayList();
        while (object.hasNext()) {
            String string11 = (String)object.next();
            String string12 = string10 + string11 + ".dat";
            String string13 = string8 + string11;
            ZipEntry zipEntry2 = zipFile.getEntry(string12);
            System.err.print("Restore " + database.getName() + "." + string11 + " ...");
            RealmDBTransferHelp.importsTableData(database.tables(string13), arrayList2, zipFile.getInputStream(zipEntry2));
            if (string13.equals(string9)) {
                for (FieldValue[] fieldValueArray : arrayList2) {
                    String string14 = table.getExternalDataPath(fieldValueArray);
                    int n2 = string14.lastIndexOf(File.separator);
                    String string15 = string14.substring(n2 + 1);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ZipEntry zipEntry3 = (ZipEntry)iterator.next();
                        String string16 = zipEntry3.getName();
                        n2 = string16.indexOf(string15);
                        if (n2 == -1) continue;
                        if (!zipEntry3.isDirectory()) {
                            String string17 = string14 + string16.substring(n2 += string15.length());
                            RealmDBTransferHelp.importsExternalData(string17, zipFile.getInputStream(zipEntry3));
                        }
                        iterator.remove();
                    }
                }
            }
            int n3 = database.tables(string13).insert2(arrayList2);
            arrayList2.clear();
            System.out.println(n3 + " OK");
        }
        zipFile.close();
        System.gc();
        System.out.println("Restore end");
        return true;
    }

    @Override
    public synchronized void checkIntegrality(Database database, Map map) throws SQLException {
        int n;
        String string;
        Object object;
        Object object2;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object3;
        System.out.print("Checking " + database.getName() + " ...");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Dbs.fullTableName(database.getProperty("schema"), "");
        Table table = database.tables(string2 + "CATALOGVERSION_4");
        Table table2 = database.tables(string2 + "REPORTVERSION_4");
        Table table3 = database.tables(string2 + "RESULTVERSION_3");
        Table table4 = database.tables(string2 + LCVersionTableImpl.TABLE_NAME);
        Table table5 = database.tables(string2 + "FOLDERS_4");
        Table table6 = database.tables(string2 + "RESOURCENODES_5");
        Table table7 = database.tables(string2 + "VERSIONNODES_3");
        Table table8 = database.tables(string2 + "NODES_6");
        Table table9 = database.tables(string2 + "DYNAMICRESULT_2");
        HashMap<Object, Table> hashMap = new HashMap<Object, Table>();
        HashMap<Object, Table> hashMap2 = new HashMap<Object, Table>();
        Table[] tableArray = new Table[3];
        Table[] tableArray2 = new Table[]{table, table2, table3, table4};
        DBAdapter dBAdapter = ((TableImpl)table8).getDBAdapter();
        this.BIT(table8);
        for (Table table10 : tableArray2) {
            object3 = table10.query(table10.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (object3.next()) {
                n5 = object3.getInt("RESOURCEID");
                n4 = object3.getInt("VERSIONNUMBER");
                hashMap.put(n5 + ":" + n4, table10);
            }
            object3.close();
        }
        Object object4 = table7.query(table7.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
        while (object4.next()) {
            n3 = object4.getInt("ID");
            n2 = object4.getInt("RESOURCEID");
            int n6 = object4.getInt("VERSIONNUMBER");
            object3 = n2 + ":" + n6;
            if (!hashMap.containsKey(object3)) {
                table7.delete("WHERE ID=?", new ParameterMetaInfo().add("ID", n3));
                table8.delete("WHERE ID=?", new ParameterMetaInfo().add("ID", n3));
                continue;
            }
            hashMap2.put(object3, table7);
        }
        for (String string3 : hashMap.keySet()) {
            if (hashMap2.containsKey(string3)) continue;
            Table table11 = (Table)hashMap.get(string3);
            int n7 = string3.indexOf(":");
            int n8 = Integer.parseInt(string3.substring(0, n7));
            n5 = Integer.parseInt(string3.substring(n7 + 1));
            table11.delete("WHERE RESOURCEID=? AND VERSIONNUMBER=?", new ParameterMetaInfo().add("rID", n8).add("vID", n5));
        }
        hashMap.clear();
        hashMap2.clear();
        object4.close();
        tableArray[0] = table5;
        tableArray[1] = table6;
        tableArray[2] = table7;
        object4 = table7.query(table7.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (object4.next()) {
            n3 = object4.getInt("RESOURCEID");
            hashMap.put(new Integer(n3), table7);
        }
        object4.close();
        Recordset recordset = table6.query(table6.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
        while (recordset.next()) {
            n2 = recordset.getInt("ID");
            Integer n9 = new Integer(n2);
            if (hashMap.containsKey(n9)) continue;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("ID", n2);
            table6.delete("WHERE ID=?", parameterMetaInfo);
            table8.delete("WHERE ID=?", parameterMetaInfo);
        }
        recordset.close();
        hashMap.clear();
        this.BIT(table8);
        for (n2 = 0; n2 < 3; ++n2) {
            Recordset recordset2 = tableArray[n2].query(tableArray[n2].fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset2.next()) {
                int n10 = recordset2.getInt("ID");
                hashMap.put(new Integer(n10), tableArray[n2]);
            }
            recordset2.close();
        }
        Recordset recordset3 = table8.query(table8.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
        while (recordset3.next()) {
            int n11 = recordset3.getInt("ID");
            Integer n12 = new Integer(n11);
            if (!hashMap.containsKey(n12)) {
                table8.delete("WHERE ID=?", new ParameterMetaInfo().add("ID", n11));
                continue;
            }
            hashMap2.put(n12, table8);
        }
        for (Integer n13 : hashMap.keySet()) {
            if (hashMap2.containsKey(n13)) continue;
            Table table12 = (Table)hashMap.get(n13);
            if (table7.getName().equals(table12.getName())) {
                Recordset recordset4 = table12.query(table12.fields().toArray(), "WHERE ID=?", new ParameterMetaInfo().add("id", n13), false);
                if (recordset4.next()) {
                    n4 = recordset4.getInt("RESOURCEID");
                    int n14 = recordset4.getInt("VERSIONNUMBER");
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append("WHERE RESOURCEID=?");
                    stringBuffer.append(" AND VERSIONNUMBER=?");
                    object2 = new ParameterMetaInfo().add("rID", n4).add("vID", n14);
                    table.delete(stringBuffer.toString(), (ParameterMetaInfo)object2);
                    table2.delete(stringBuffer.toString(), (ParameterMetaInfo)object2);
                    table3.delete(stringBuffer.toString(), (ParameterMetaInfo)object2);
                }
                recordset4.close();
            }
            table12.delete("WHERE ID=?", new ParameterMetaInfo().add("id", n13));
        }
        hashMap.clear();
        hashMap2.clear();
        recordset3.close();
        for (Table table13 : tableArray2) {
            Recordset recordset5 = table13.query(table13.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
            while (recordset5.next()) {
                int n15 = recordset5.getInt("RESOURCEID");
                int n16 = recordset5.getInt("VERSIONNUMBER");
                object = recordset5.fields();
                string = table13.getExternalDataPath((FieldValue[])object);
                boolean bl = false;
                try {
                    bl = StorageEnv.getStorage().exists(Storage.StorageRoot.HISTORY, StorageEnv.getStorageEnv(-1).relativeStoragePath(Storage.StorageRoot.HISTORY, string, 2));
                }
                catch (Throwable throwable) {
                    bl = map.containsKey(string);
                }
                if (bl) {
                    map.remove(string);
                    continue;
                }
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append("WHERE RESOURCEID=?");
                stringBuffer.append(" AND VERSIONNUMBER=?");
                ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("rID", n15).add("vID", n16);
                table13.delete(stringBuffer.toString(), parameterMetaInfo);
                Recordset recordset6 = table7.query(table7.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
                if (recordset6.next()) {
                    int n17 = recordset6.getInt("ID");
                    table8.delete("WHERE ID=?", new ParameterMetaInfo().add("id", n17));
                }
                recordset6.close();
                table7.delete(stringBuffer.toString(), parameterMetaInfo);
            }
            recordset5.close();
        }
        tableArray[0] = table5;
        tableArray[1] = table6;
        tableArray[2] = table7;
        object4 = table7.query(table7.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (object4.next()) {
            int n18 = object4.getInt("RESOURCEID");
            hashMap.put(new Integer(n18), table7);
        }
        object4.close();
        recordset = table6.query(table6.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
        while (recordset.next()) {
            int n19 = recordset.getInt("ID");
            Integer n20 = new Integer(n19);
            if (hashMap.containsKey(n20)) continue;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("id", n19);
            table6.delete("WHERE ID=?", parameterMetaInfo);
            table8.delete("WHERE ID=?", parameterMetaInfo);
        }
        recordset.close();
        hashMap.clear();
        this.BIT(table8);
        for (n = 0; n < 3; ++n) {
            Recordset recordset7 = tableArray[n].query(tableArray[n].fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset7.next()) {
                int n21 = recordset7.getInt("ID");
                hashMap.put(new Integer(n21), tableArray[n]);
            }
            recordset7.close();
        }
        recordset3 = table8.query(table8.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
        while (recordset3.next()) {
            n = recordset3.getInt("ID");
            Integer n22 = new Integer(n);
            if (!hashMap.containsKey(n22)) {
                table8.delete("WHERE ID=?", new ParameterMetaInfo().add("id", n));
                continue;
            }
            hashMap2.put(n22, table8);
        }
        for (Integer n23 : hashMap.keySet()) {
            if (hashMap2.containsKey(n23)) continue;
            Table table14 = (Table)hashMap.get(n23);
            if (table7.getName().equals(table14.getName())) {
                Recordset recordset8 = table14.query(table14.fields().toArray(), "WHERE ID=?", new ParameterMetaInfo().add("id", n23), false);
                if (recordset8.next()) {
                    int n24 = recordset8.getInt("RESOURCEID");
                    int n25 = recordset8.getInt("VERSIONNUMBER");
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append("WHERE RESOURCEID=?");
                    stringBuffer.append(" AND VERSIONNUMBER=?");
                    object2 = new ParameterMetaInfo().add("rID", n24).add("vID", n25);
                    table.delete(stringBuffer.toString(), (ParameterMetaInfo)object2);
                    table2.delete(stringBuffer.toString(), (ParameterMetaInfo)object2);
                    table3.delete(stringBuffer.toString(), (ParameterMetaInfo)object2);
                }
                recordset8.close();
            }
            table14.delete("WHERE ID=?", new ParameterMetaInfo().add("id", n23));
        }
        hashMap.clear();
        hashMap2.clear();
        recordset3.close();
        Recordset recordset9 = table9.query(table9.fields().toArray(), null, ParameterMetaInfo.EMPTY, false, 2);
        while (recordset9.next()) {
            String string4 = recordset9.getString("REPORTNAME");
            int n26 = recordset9.getInt("VERSIONNUMBER");
            FieldValue[] fieldValueArray = recordset9.fields();
            String string5 = table9.getExternalDataPath(fieldValueArray);
            if (map.containsKey(string5)) {
                map.remove(string5);
                continue;
            }
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("WHERE REPORTNAME=?");
            stringBuffer.append(" AND VERSIONNUMBER=?");
            object2 = new ParameterMetaInfo().add("rptName", string4).add("vID", n26);
            table9.delete(stringBuffer.toString(), (ParameterMetaInfo)object2);
        }
        recordset9.close();
        stringBuffer.delete(0, stringBuffer.length());
        Field[] fieldArray = new FieldImpl[]{new FieldImpl(table8, "ID", JDBCType.INTEGER, 0, 0, 0), new FieldImpl(table8, "NAME", JDBCType.VARCHAR, 256, 0, 0), new FieldImpl(table5, "REALPATH", JDBCType.VARCHAR, 256, 0, 0), new FieldImpl(table5, "ENABLEDYNAMICRESOURCE", JDBCType.BIT, 0, 0, 0)};
        Table[] tableArray3 = new Table[]{table8, table5};
        recordset9 = dBAdapter.select(fieldArray, tableArray3, "WHERE " + string2 + "NODES_6" + ".ID= " + string2 + "FOLDERS_4" + ".ID", ParameterMetaInfo.EMPTY, false);
        while (recordset9.next()) {
            int n27 = recordset9.getInt("ID");
            boolean bl = recordset9.getBoolean("ENABLEDYNAMICRESOURCE");
            object2 = recordset9.getString("REALPATH");
            String string6 = recordset9.getString("NAME");
            if (!bl || object2 == null || ((File)(object = new File((String)object2))).exists()) continue;
            System.out.println();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("\"").append((String)object2).append("\"");
            stringBuffer.append(" does not exist for the mapped resource node [");
            stringBuffer.append(string6);
            stringBuffer.append("]");
            string = stringBuffer.toString();
            System.out.print(string);
            ServiceLogger.logError(string);
        }
        recordset9.close();
        if (stringBuffer.length() == 0) {
            System.out.println(" OK");
        } else {
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BIT(Table table) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        Field[] fieldArray = new FieldImpl[]{new FieldImpl(table, "PARENTID", JDBCType.INTEGER, 0, 0, 0)};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE PARENTID NOT IN (SELECT ID FROM ");
        stringBuffer.append(table.getName()).append(") AND PARENTID > 0");
        while (n > 0) {
            Recordset recordset = null;
            try {
                recordset = table.query(fieldArray, stringBuffer.toString(), ParameterMetaInfo.EMPTY, false);
                n = 0;
                while (recordset.next()) {
                    int n3 = recordset.getInt("PARENTID");
                    table.delete("WHERE PARENTID=?", new ParameterMetaInfo().add("parentID", n3));
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                break;
            }
            finally {
                recordset.close();
                n2 += n;
            }
        }
        if (n2 > 0) {
            System.out.print("clear " + n2 + " invalid nodes ...");
        }
    }
}

