/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.version;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.db.event.RecordEventListenerManager;
import jet.server.db.event.RecordEventType;
import jet.server.db.version.AbstractVersionTableImpl;
import jet.server.db.version.ResultDetailTable;
import jet.server.db.version.ResultVersionRecord;
import jet.server.intf.version.ResultVersionTableNew;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.util.IntKeyHashtable;

public class ResultVersionTableImpl
extends AbstractVersionTableImpl
implements ResultVersionTableNew {
    public static final String TABLE_NAME = "RESULTVERSION_3";
    private static String BIGINT = "RESULTVERSION_2";
    private static String BIT = "RESULTVERSION_1";
    private IntKeyHashtable EMPTY = new IntKeyHashtable();
    public static final int VER_NUM_COL = 1;
    public static final int PARAM_FILE_COL = 12;
    public static final String[] colNames = new String[]{"id", "versionNumber", "versionName", "resourceID", "creator", "createdTime", "modifier", "modifiedTime", "catalogVerNum", "catalogResNum", "reportVerNum", "reportResNum", "paramFile", "resultFile", "resultFmts", "launchType", "taskID", "expirationTime", "expire", "expireationMethod", "specifiedFolder", "reportAmount", "diskSize"};
    private ResultDetailTable HISTORY = null;

    public static ResultVersionTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            ResultVersionTableImpl resultVersionTableImpl = new ResultVersionTableImpl(database, updateDetailsTable);
            RecordEventListenerManager.initListener(resultVersionTableImpl);
            return resultVersionTableImpl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLE_NAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private ResultVersionTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), colNames[0], JDBCType.BIGINT, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), colNames[1], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[2], JDBCType.VARCHAR, 128, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[3], JDBCType.INTEGER, 0, 5, 0));
        super.append(new FieldImpl(this.getName(), colNames[4], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[5], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[6], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[7], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[8], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[9], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[10], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[11], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[12], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[13], JDBCType.VARCHAR, 128, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[14], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[15], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[16], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[17], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[18], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[19], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[20], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[21], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[22], JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        this.HISTORY = new ResultDetailTable(database, updateDetailsTable);
        super.upgradeOldTable(database, updateDetailsTable, BIT, 1);
        super.upgradeOldTable(database, updateDetailsTable, BIGINT, 2);
        try {
            this.adapter.setID(this, this.fields(colNames[0]), this.HISTORY() + 1);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public ResultDetailTable getResultDetailTable() {
        return this.HISTORY;
    }

    @Override
    public synchronized int addRecord(String string, final int n, String string2, long l, String string3, long l2, int n2, int n3, int n4, int n5, String string4, String string5, long l3, int n6, String string6, long l4, boolean bl, int n7, String string7, int n8, long l5) {
        String string8 = this.VARCHAR(string5);
        final FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(new Integer(this.INTEGER()));
        fieldValueArray[2].setValue(string);
        fieldValueArray[3].setValue(new Integer(n));
        fieldValueArray[4].setValue(string2);
        fieldValueArray[5].setValue(new Long(l));
        fieldValueArray[6].setValue(string3);
        fieldValueArray[7].setValue(new Long(l2));
        fieldValueArray[8].setValue(new Integer(n2));
        fieldValueArray[9].setValue(new Integer(n3));
        fieldValueArray[10].setValue(new Integer(n4));
        fieldValueArray[11].setValue(new Integer(n5));
        fieldValueArray[12].setValue(string4);
        fieldValueArray[14].setValue(new Long(l3));
        fieldValueArray[15].setValue(new Integer(n6));
        fieldValueArray[16].setValue(string6);
        fieldValueArray[17].setValue(new Long(l4));
        fieldValueArray[18].setValue(new Boolean(bl));
        fieldValueArray[19].setValue(new Integer(n7));
        fieldValueArray[20].setValue(string7);
        fieldValueArray[21].setValue(new Integer(n8));
        fieldValueArray[22].setValue(new Long(l5));
        int n9 = -1;
        try {
            String string9 = this.SEDU(string8);
            fieldValueArray[13].setValue(string9);
            if (n < 0) {
                ServiceLogger.logError(new Exception("resourceID=" + n));
            }
            int n10 = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n2 = ResultVersionTableImpl.this.EMPTY(n);
                    fieldValueArray[1].setValue(n2);
                    ResultVersionTableImpl.this.insert(fieldValueArray);
                    return n2;
                }
            });
            ResultVersionRecord resultVersionRecord = new ResultVersionRecord();
            resultVersionRecord.setVersionID(n10);
            this.fireEvent(RecordEventType.inserted, resultVersionRecord, string9);
            n9 = n10;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        catch (LockException lockException) {
            ServiceLogger.logError(lockException);
            return -1;
        }
        return n9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getRecord(int n, int n2) {
        ResultVersionRecord resultVersionRecord = null;
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(1).getName(), String.valueOf(n), 4);
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n2), 4);
            String string = "WHERE " + super.fields(1).getName() + "=? AND " + super.fields(3).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            if (recordset.next()) {
                resultVersionRecord = this.BIGINT(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return resultVersionRecord;
    }

    private ResultVersionRecord BIGINT(Recordset recordset) throws SQLException {
        ResultVersionRecord resultVersionRecord = new ResultVersionRecord();
        resultVersionRecord.setVersionID(recordset.getInt(colNames[1]));
        resultVersionRecord.setVersionName(recordset.getString(colNames[2]));
        resultVersionRecord.setResourceID(recordset.getInt(colNames[3]));
        resultVersionRecord.setCreator(recordset.getString(colNames[4]));
        resultVersionRecord.setCreatedTime(recordset.getLong(colNames[5]));
        resultVersionRecord.setModifier(recordset.getString(colNames[6]));
        resultVersionRecord.setModifiedTime(recordset.getLong(colNames[7]));
        resultVersionRecord.setCatalogVerNum(recordset.getInt(colNames[8]));
        resultVersionRecord.setCatalogResNum(recordset.getInt(colNames[9]));
        resultVersionRecord.setReprotVerNum(recordset.getInt(colNames[10]));
        resultVersionRecord.setReportResNum(recordset.getInt(colNames[11]));
        resultVersionRecord.setParamFile(recordset.getString(colNames[12]));
        String string = recordset.getString(colNames[13]);
        resultVersionRecord.setResultFiles(string);
        resultVersionRecord.setResultFmts(recordset.getLong(colNames[14]));
        resultVersionRecord.setLaunchType(recordset.getInt(colNames[15]));
        resultVersionRecord.setTaskID(recordset.getString(colNames[16]));
        resultVersionRecord.setExpirationTime(recordset.getLong(colNames[17]));
        resultVersionRecord.setExpire(recordset.getBoolean(colNames[18]));
        resultVersionRecord.setExpireationMethod(recordset.getInt(colNames[19]));
        resultVersionRecord.setSpecifiedFolder(recordset.getString(colNames[20]));
        resultVersionRecord.setReportAmount(recordset.getInt(colNames[21]));
        resultVersionRecord.setDiskSize(recordset.getLong(colNames[22]));
        return resultVersionRecord;
    }

    @Override
    public synchronized boolean delRecord(int n, int n2) {
        ResultVersionRecord resultVersionRecord = null;
        Vector vector = null;
        if (n >= 0) {
            resultVersionRecord = (ResultVersionRecord)this.getRecord(n, n2);
        } else {
            vector = this.getAllRecords(n2);
        }
        try {
            this.HISTORY.delRecord(n, n2);
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n2), 4);
            stringBuffer.append(" WHERE ").append(super.fields(3).getName()).append("=?");
            if (n >= 0) {
                parameterMetaInfo.add(super.fields(1).getName(), String.valueOf(n), 4);
                stringBuffer.append(" AND ").append(super.fields(1).getName()).append("=?");
            }
            n3 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            if (n >= 0) {
                this.fireEvent(RecordEventType.deleted, resultVersionRecord, resultVersionRecord.getResultFile());
            } else {
                for (ResultVersionRecord resultVersionRecord2 : vector) {
                    this.fireEvent(RecordEventType.deleted, resultVersionRecord2, resultVersionRecord2.getResultFile());
                }
            }
            return n3 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean delRecords(int n) {
        return this.delRecord(-1, n);
    }

    @Override
    public Vector getAllRecordsByPath(String string) {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecords(int n) {
        Vector<ResultVersionRecord> vector = new Vector<ResultVersionRecord>();
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(3).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecords() {
        Vector<ResultVersionRecord> vector = new Vector<ResultVersionRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, null, true);
            while (recordset.next()) {
                vector.addElement(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private void BIT(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields(colNames[0]).getValue());
            fieldValueArray[1].setValue(recordset.fields(colNames[1]).getValue());
            fieldValueArray[2].setValue(recordset.fields(colNames[2]).getValue());
            fieldValueArray[3].setValue(recordset.fields(colNames[3]).getValue());
            fieldValueArray[4].setValue(recordset.fields(colNames[4]).getValue());
            fieldValueArray[5].setValue(recordset.fields(colNames[5]).getValue());
            fieldValueArray[6].setValue(recordset.fields(colNames[6]).getValue());
            fieldValueArray[7].setValue(recordset.fields(colNames[7]).getValue());
            fieldValueArray[8].setValue(recordset.fields(colNames[8]).getValue());
            fieldValueArray[9].setValue(recordset.fields(colNames[9]).getValue());
            fieldValueArray[10].setValue(recordset.fields(colNames[10]).getValue());
            fieldValueArray[11].setValue(recordset.fields(colNames[11]).getValue());
            fieldValueArray[12].setValue(recordset.fields(colNames[12]).getValue());
            fieldValueArray[13].setValue(recordset.fields(colNames[13]).getValue());
            fieldValueArray[14].setValue(recordset.fields(colNames[14]).getValue());
            fieldValueArray[15].setValue(recordset.fields(colNames[15]).getValue());
            fieldValueArray[16].setValue(recordset.fields(colNames[16]).getValue());
            fieldValueArray[17].setValue(recordset.fields(colNames[17]).getValue());
            fieldValueArray[18].setValue(recordset.fields(colNames[18]).getValue());
            fieldValueArray[19].setValue(recordset.fields(colNames[19]).getValue());
            fieldValueArray[20].setValue(recordset.fields(colNames[20]).getValue());
            fieldValueArray[21].setValue(new Integer(-1));
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    @Override
    public synchronized boolean updateRecord(Object object) {
        ResultVersionRecord resultVersionRecord = (ResultVersionRecord)object;
        FieldValue[] fieldValueArray = super.fields().values();
        FieldValue[] fieldValueArray2 = new FieldValue[fieldValueArray.length - 1];
        for (int i = 1; i < fieldValueArray.length; ++i) {
            fieldValueArray2[i - 1] = fieldValueArray[i];
        }
        fieldValueArray2[0].setValue(new Integer(resultVersionRecord.getVersionID()));
        fieldValueArray2[1].setValue(resultVersionRecord.getVersionName());
        fieldValueArray2[2].setValue(new Integer(resultVersionRecord.getResourceID()));
        fieldValueArray2[3].setValue(resultVersionRecord.getCreator());
        fieldValueArray2[4].setValue(new Long(resultVersionRecord.getCreatedTime()));
        fieldValueArray2[5].setValue(resultVersionRecord.getModifier());
        fieldValueArray2[6].setValue(new Long(resultVersionRecord.getModifiedTime()));
        fieldValueArray2[7].setValue(new Integer(resultVersionRecord.getCatalogVerNum()));
        fieldValueArray2[8].setValue(new Integer(resultVersionRecord.getCatalogResNum()));
        fieldValueArray2[9].setValue(new Integer(resultVersionRecord.getReportVerNum()));
        fieldValueArray2[10].setValue(new Integer(resultVersionRecord.getReportResNum()));
        fieldValueArray2[11].setValue(resultVersionRecord.getParamFile());
        fieldValueArray2[12].setValue(this.SEDU(resultVersionRecord.getResultFile()));
        fieldValueArray2[13].setValue(new Long(resultVersionRecord.getResultFmts()));
        fieldValueArray2[14].setValue(new Integer(resultVersionRecord.getLaunchType()));
        fieldValueArray2[15].setValue(resultVersionRecord.getTaskID());
        fieldValueArray2[16].setValue(new Long(resultVersionRecord.getExpirationTime()));
        fieldValueArray2[17].setValue(new Boolean(resultVersionRecord.getExpire()));
        fieldValueArray2[18].setValue(new Integer(resultVersionRecord.getExpireationMethod()));
        fieldValueArray2[19].setValue(resultVersionRecord.getSpecifiedFolder());
        fieldValueArray2[20].setValue(new Integer(resultVersionRecord.getReportAmount()));
        fieldValueArray2[21].setValue(resultVersionRecord.getDiskSize());
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(1).getName(), String.valueOf(resultVersionRecord.getVersionID()), 4);
        parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(resultVersionRecord.getResourceID()), 4);
        String string = " WHERE " + super.fields(1).getName() + "=? AND " + super.fields(3).getName() + "=?";
        try {
            int n = super.update(fieldValueArray2, string, parameterMetaInfo);
            ResultVersionRecord resultVersionRecord2 = null;
            resultVersionRecord2 = (ResultVersionRecord)this.getRecord(resultVersionRecord.getVersionID(), resultVersionRecord.getResourceID());
            String string2 = resultVersionRecord.getResultFile();
            String string3 = resultVersionRecord2.getResultFile();
            if (!string2.equals(string3)) {
                this.fireEvent(RecordEventType.deleted, resultVersionRecord, string2);
                this.fireEvent(RecordEventType.inserted, resultVersionRecord, string3);
            }
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized Object getLatestVerRec(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(colNames[3]).getName()).append("=?");
            number = super.queryMaxValue(colNames[1], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    @Override
    public synchronized Object getEarliestVerRec(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(colNames[3]).getName()).append("=?");
            number = super.queryMinValue(colNames[1], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getVersionNumbers(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        Recordset recordset = null;
        Field[] fieldArray = new Field[]{this.fields(colNames[1])};
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(3).getName() + "=?";
            recordset = super.query(fieldArray, string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(new Integer(recordset.getInt(colNames[1])));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                recordset.close();
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public synchronized int getVersionAmount(int n) {
        Integer n2 = 0;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(colNames[3]).getName()).append("=?");
            n2 = super.queryCountValue(colNames[1], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n2;
    }

    @Override
    public synchronized boolean delEarliestVersion(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(colNames[3]).getName()).append("=?");
            number = super.queryMinValue(colNames[1], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            this.HISTORY.delRecord(number.intValue(), n);
            return this.delRecord(number.intValue(), n);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasResultWithTaskID(String string) {
        boolean bl = false;
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(16).getName(), string, 12);
            String string2 = "WHERE " + super.fields(16).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            if (recordset.next()) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return bl;
    }

    private synchronized int EMPTY(int n) {
        Number number;
        int n2 = 1;
        if (!ServerEnv.isClusterEnabled() && (number = (Integer)this.EMPTY.get(n)) != null) {
            n2 = number + 1;
            this.EMPTY.put(n, (Object)new Integer(n2));
            return n2;
        }
        number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(colNames[3]).getName()).append("=?");
            number = super.queryMaxValue(colNames[1], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        n2 = number == null || number <= 0 ? 1 : number + 1;
        if (!ServerEnv.isClusterEnabled()) {
            this.EMPTY.put(n, (Object)new Integer(n2));
        }
        return n2;
    }

    private synchronized int HISTORY() {
        Number number = null;
        try {
            number = super.queryMaxValue(colNames[0], null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number == null ? -1 : number.intValue();
    }

    private synchronized int INTEGER() {
        try {
            return this.adapter.getID(this, this.fields(colNames[0]));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return 1;
        }
    }

    @Override
    public boolean hasExternalData() {
        return true;
    }

    @Override
    public String getExternalDataPath(FieldValue[] fieldValueArray) {
        int n;
        String string = (String)fieldValueArray[13].getValue();
        if (string != null && string.length() != 0 && (n = string.lastIndexOf(File.separator)) > 0) {
            string = string.substring(0, n);
        }
        String string2 = this.getHistDir();
        return string2 + string;
    }

    private String SEDU(String string) {
        return StorageEnv.getStorageEnv(StorageEnv.getThreadMember()).relativeDiskPath(Storage.StorageRoot.HISTORY, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getRecordsByCatalog(int n) {
        Vector<ResultVersionRecord> vector = new Vector<ResultVersionRecord>();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        Recordset recordset = null;
        try {
            parameterMetaInfo.add(super.fields(9).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(9).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getRecordsByReport(int n) {
        Vector<ResultVersionRecord> vector = new Vector<ResultVersionRecord>();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        Recordset recordset = null;
        try {
            parameterMetaInfo.add(super.fields(11).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(11).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public void close() {
        super.close();
        if (this.HISTORY != null) {
            this.HISTORY.close();
        }
    }

    public void clearMem() {
        this.HISTORY = null;
    }

    private String VARCHAR(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.indexOf("=") >= 0) continue;
            return string2;
        }
        return "";
    }
}

