/*
 * Decompiled with CFR 0.152.
 */
package jet.server.event.subscriber;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Iterator;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.event.EventHandler;
import jet.server.event.FilterImpl;
import jet.server.event.Selector;
import jet.server.event.Subscriber;
import jet.server.event.core.InputChannelImpl;
import jet.server.event.core.RouterService;
import jet.server.event.publisher.PublishService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.event.MonitorEventHandler;
import jet.server.rmi.RemoteObjectFactory;

public final class SubscribeService {
    private static SubscribeService SEDU = null;
    private Hashtable _unsubscribe = new Hashtable();

    public static SubscribeService newInstance() {
        if (SEDU == null) {
            SEDU = new SubscribeService();
        }
        return SEDU;
    }

    public Subscriber createSubscriber(String string, int n, EventHandler eventHandler, int n2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("serverAddr can not be null.");
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException("handler can not be null.");
        }
        SubscriberImpl subscriberImpl = new SubscriberImpl(string, n, eventHandler, n2);
        this._unsubscribe.put(String.valueOf(subscriberImpl.getId()), subscriberImpl);
        return subscriberImpl;
    }

    public Subscriber createSubscriber(String string, int n, EventHandler eventHandler) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("serverAddr can not be null.");
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException("handler can not be null.");
        }
        SubscriberImpl subscriberImpl = new SubscriberImpl(string, n, eventHandler);
        this._unsubscribe.put(String.valueOf(subscriberImpl.getId()), subscriberImpl);
        return subscriberImpl;
    }

    public Subscriber createSubscriber(EventHandler eventHandler) {
        return this.createSubscriber("0.0.0.0", 0, eventHandler);
    }

    public Iterator getAllSubscribers() {
        return this._unsubscribe.values().iterator();
    }

    public void destroySubscriber(Subscriber subscriber) throws RemoteException {
        subscriber.destroy();
    }

    public void destroyAllSubscribers() {
        Iterator iterator = this.getAllSubscribers();
        while (iterator.hasNext()) {
            SubscriberImpl subscriberImpl = (SubscriberImpl)iterator.next();
            subscriberImpl._unsubscribe();
        }
        this._unsubscribe.clear();
    }

    private SubscribeService() {
    }

    private static String SEDU(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(":").append(n);
        return stringBuffer.substring(0);
    }

    private class SubscriberImpl
    implements Subscriber {
        String serverAddr;
        int serverPort;
        FilterImpl filter = new FilterImpl();
        InputChannelImpl recv;
        boolean active = false;
        boolean isLocal = false;
        EventHandler handler = null;
        private RouterService SEDU;
        private int _unsubscribe;

        public SubscriberImpl(String string, int n, EventHandler eventHandler, int n2) {
            this.serverAddr = string;
            this.serverPort = n;
            this.handler = eventHandler;
            try {
                this.recv = new InputChannelImpl(eventHandler, n2);
                if (ServerEnv.shouldStartRMI() || eventHandler instanceof MonitorEventHandler) {
                    UnicastRemoteObject.exportObject((Remote)this.recv, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                }
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
            if ("0.0.0.0".equals(this.serverAddr)) {
                this.isLocal = true;
            }
        }

        public SubscriberImpl(String string, int n, EventHandler eventHandler) {
            this.serverAddr = string;
            this.serverPort = n;
            this.handler = eventHandler;
            try {
                this.recv = new InputChannelImpl(eventHandler);
                if (ServerEnv.shouldStartRMI() || eventHandler instanceof MonitorEventHandler) {
                    UnicastRemoteObject.exportObject((Remote)this.recv, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                }
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
            if ("0.0.0.0".equals(this.serverAddr)) {
                this.isLocal = true;
            }
        }

        @Override
        public String getServerInfo() {
            return SubscribeService.SEDU(this.serverAddr, this.serverPort);
        }

        @Override
        public int getId() {
            return this.hashCode();
        }

        @Override
        public void addSelector(Selector selector) {
            this.filter.addSelector(selector);
        }

        @Override
        public Selector getSelector(String string) {
            return this.filter.getSelector(string);
        }

        @Override
        public Selector[] getAllSelectors() {
            return this.filter.getAllSelectors();
        }

        @Override
        public void delSelector(String string) {
            this.filter.delSelector(string);
        }

        @Override
        public void delAllSelectors() {
            this.filter.delAllSelectors();
        }

        @Override
        public synchronized void activate() throws Exception {
            if (this.active) {
                return;
            }
            if (this.recv == null) {
                this.recv = new InputChannelImpl(this.handler);
                if (ServerEnv.shouldStartRMI() || this.handler instanceof MonitorEventHandler) {
                    UnicastRemoteObject.exportObject((Remote)this.recv, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                }
            }
            if (this.SEDU == null) {
                if (this.isLocal) {
                    this.SEDU = PublishService.newInstance().getRouterService();
                    if (this.SEDU == null) {
                        throw new Exception("The local PublishService has not been start.");
                    }
                } else {
                    this.SEDU = (RouterService)RemoteObjectFactory.getRemoteObject(this.serverAddr, this.serverPort, "d1957da4-976f-4bf9-b242-93f3cd72d239");
                    if (this.SEDU == null) {
                        throw new Exception("The remote PublishService has not been start.");
                    }
                }
                this._unsubscribe = this.SEDU.createAgent(this.filter, this.recv);
            } else {
                this.SEDU.enableAgent(this._unsubscribe);
            }
            this.recv.activate();
            this.active = true;
        }

        @Override
        public synchronized void deactivate() throws Exception {
            this.active = false;
            this.recv.deactivate();
            if (this.SEDU != null) {
                this.SEDU.disableAgent(this._unsubscribe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void destroy() {
            try {
                this._unsubscribe();
            }
            catch (Exception exception) {
                SubscribeService subscribeService = SubscribeService.this;
                synchronized (subscribeService) {
                    SubscribeService.this._unsubscribe.remove(String.valueOf(this.getId()));
                }
            }
            finally {
                SubscribeService subscribeService = SubscribeService.this;
                synchronized (subscribeService) {
                    SubscribeService.this._unsubscribe.remove(String.valueOf(this.getId()));
                }
            }
            if (this.recv != null) {
                this.recv.destroy();
                this.recv = null;
            }
            this.SEDU = null;
        }

        @Override
        public synchronized void update() throws Exception {
            if (this.SEDU != null) {
                this.SEDU.updateAgent(this._unsubscribe, this.filter);
            }
        }

        @Override
        public synchronized boolean isActive() {
            return this.active;
        }

        @Override
        public synchronized boolean isValid() {
            boolean bl = false;
            if (this.SEDU != null) {
                try {
                    this.SEDU.echo();
                    bl = true;
                }
                catch (RemoteException remoteException) {
                    ServiceLogger.logError(remoteException, 3);
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void _unsubscribe() {
            try {
                if (this.SEDU != null) {
                    this.SEDU.destroyAgent(this._unsubscribe);
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            finally {
                try {
                    if (this.recv != null) {
                        this.recv.deactivate();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                this.active = false;
                this.SEDU = null;
            }
        }
    }
}

