/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.util.HashMap;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.util.ThreadQueueController;
import jet.server.util.ThreadQueueElement;

public class ConcurrentReportManager {
    private int SEDU;
    private ConfigService active;
    private ThreadQueueController decreaseActive;
    private HashMap decreaseWaiting;

    public ConcurrentReportManager(int n, ThreadQueueController threadQueueController, ConfigService configService) {
        this.SEDU = n;
        this.decreaseActive = threadQueueController;
        this.active = configService;
        this.decreaseWaiting = new HashMap();
    }

    public boolean hasQueueController() {
        return this.decreaseActive != null;
    }

    public int getCurrentReportsByOrg(String string) {
        OrganizationReportInfo organizationReportInfo = (OrganizationReportInfo)this.decreaseWaiting.get(string);
        if (organizationReportInfo != null) {
            return organizationReportInfo.getCurrentRunningReports();
        }
        return 0;
    }

    public boolean canRunReportInOrg(String string) {
        int n = this.active.getOrgConfiguration(string).getMaxConcurrentReports();
        return n <= 0 || this.getCurrentReportsByOrg(string) < n;
    }

    public boolean isRunningQueue() {
        if (this.decreaseActive == null) {
            return false;
        }
        return this.decreaseActive.getActiveAndWaitReportsCount() < this.SEDU || ServerEnv.isSpecialUser();
    }

    public boolean isTaskQueueFull(int n) {
        if (this.decreaseActive == null) {
            return false;
        }
        return this.decreaseActive.isTaskQueueFull(n);
    }

    public boolean isFullActive() {
        return this.decreaseActive.isFullActive();
    }

    public int getActiveAndWaitReportsCount() {
        return this.decreaseActive.getActiveAndWaitReportsCount();
    }

    public int getActiveReportsCount() {
        return this.decreaseActive == null ? -1 : this.decreaseActive.getActiveReportsCount();
    }

    public int getWaitReportsCount() {
        return this.decreaseActive == null ? -1 : this.decreaseActive.getWaitReportsCount();
    }

    public int getActiveReportsByOrg(String string) {
        OrganizationReportInfo organizationReportInfo = (OrganizationReportInfo)this.decreaseWaiting.get(string);
        if (organizationReportInfo != null) {
            return organizationReportInfo.active;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueUp(ThreadQueueElement[] threadQueueElementArray) {
        int n;
        String string = threadQueueElementArray[0].getOrganizationName();
        OrganizationReportInfo organizationReportInfo = null;
        HashMap hashMap = this.decreaseWaiting;
        synchronized (hashMap) {
            organizationReportInfo = (OrganizationReportInfo)this.decreaseWaiting.get(string);
            if (organizationReportInfo == null) {
                organizationReportInfo = new OrganizationReportInfo(string);
                this.decreaseWaiting.put(string, organizationReportInfo);
            }
        }
        organizationReportInfo.startWaiting(threadQueueElementArray.length);
        if (this.decreaseActive != null) {
            n = this.decreaseActive.queueUp(threadQueueElementArray);
        } else {
            n = threadQueueElementArray.length;
            for (int i = 0; i < n; ++i) {
                threadQueueElementArray[i].enqueue();
            }
        }
        organizationReportInfo.increaseActive(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueUp(ThreadQueueElement threadQueueElement) {
        boolean bl = false;
        String string = threadQueueElement.getOrganizationName();
        OrganizationReportInfo organizationReportInfo = null;
        HashMap hashMap = this.decreaseWaiting;
        synchronized (hashMap) {
            organizationReportInfo = (OrganizationReportInfo)this.decreaseWaiting.get(string);
            if (organizationReportInfo == null) {
                organizationReportInfo = new OrganizationReportInfo(string);
                this.decreaseWaiting.put(string, organizationReportInfo);
            }
        }
        organizationReportInfo.startWaiting(1);
        if (this.decreaseActive != null) {
            bl = this.decreaseActive.queueUp(threadQueueElement);
        } else {
            threadQueueElement.enqueue();
            bl = true;
        }
        if (bl) {
            organizationReportInfo.increaseActive(1);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyRelease(ThreadQueueElement threadQueueElement) {
        boolean bl = false;
        String string = threadQueueElement.getOrganizationName();
        OrganizationReportInfo organizationReportInfo = null;
        HashMap hashMap = this.decreaseWaiting;
        synchronized (hashMap) {
            organizationReportInfo = (OrganizationReportInfo)this.decreaseWaiting.get(string);
        }
        if (this.decreaseActive != null) {
            int n = threadQueueElement.getStatus();
            if (n == 3 || n == 1 || n == 2) {
                if (n == 3) {
                    bl = true;
                }
                this.decreaseActive.notifyRelease(threadQueueElement);
            }
        } else {
            if (threadQueueElement.getStatus() == 3) {
                bl = true;
            }
            threadQueueElement.dequeue();
        }
        if (bl) {
            organizationReportInfo.decreaseActive();
        } else {
            organizationReportInfo.decreaseWaiting();
        }
        return bl;
    }

    public void quit() {
        if (this.decreaseActive != null) {
            this.decreaseActive.quit();
        }
    }

    private class OrganizationReportInfo {
        int active;
        int waiting;
        String orgName;

        public OrganizationReportInfo(String string) {
            this.orgName = string;
            this.active = 0;
            this.waiting = 0;
        }

        synchronized void increaseActive(int n) {
            this.waiting -= n;
            this.active += n;
        }

        synchronized void startWaiting(int n) {
            this.waiting += n;
        }

        synchronized void decreaseActive() {
            --this.active;
        }

        synchronized void decreaseWaiting() {
            --this.waiting;
        }

        int getCurrentRunningReports() {
            return this.active + this.waiting;
        }
    }
}

