/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Date;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.cluster.Member;
import jet.server.intf.jrs.BackupService;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.PromoteThread;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class JRBackupService
implements BackupService {
    private JRRptServer SEDU = null;
    private Member[] append = null;
    private PromoteThread enableNotifyServerDown = null;
    private long getClusterService = 0L;
    private boolean getLocalMember = false;

    public JRBackupService(boolean bl) throws RemoteException {
        this.getLocalMember = bl;
    }

    public Member[] getActiveMembers() {
        return this.append;
    }

    public void setRptServer(JRRptServer jRRptServer) {
        this.SEDU = jRRptServer;
        if (this.getLocalMember) {
            this.enableNotifyServerDown = new PromoteThread(this);
            this.enableNotifyServerDown.setPriority(10);
            this.enableNotifyServerDown.start();
        }
    }

    public boolean isAdminServerCrashed() {
        if (this.SEDU != null) {
            JRClusterService jRClusterService = (JRClusterService)this.SEDU.getClusterService();
            return jRClusterService.isAdminServerCrashed();
        }
        return false;
    }

    public synchronized void upgradeToAdminServer() {
        try {
            this.SEDU.rebuildShareMemoryNode();
            System.out.println(JSvrResource.getMessage("SVR_83"));
            Member member = this.SEDU.getClusterService().getLocalMember();
            if (ServerEnv.enableNotifyServerDown()) {
                try {
                    ServerUtil.sendNormalMail(ServerEnv.getNotifyServerDownAddress(), null, null, JSvrResource.getMessage("SVR_89", member.getServerName()), JSvrResource.getMessage("SVR_90", new String[]{member.getServerName(), "" + new Date()}), null);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 5);
                }
            }
            ServiceLogger.logEvent(6650025, 6);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
    }

    @Override
    public synchronized void rebuildRemoteServices(String string, int n) throws RemoteException {
    }

    @Override
    public void refreshActiveMembers(Member[] memberArray, long l) throws RemoteException {
        this.append = memberArray;
        this.getClusterService = l;
        JRClusterService jRClusterService = (JRClusterService)this.SEDU.getClusterService();
    }

    @Override
    public synchronized void startUpgrading() throws RemoteException {
        if (this.SEDU == null || this.enableNotifyServerDown == null) {
            throw new ServerException("Can not promoted to admin server: invalid backup server!");
        }
        this.enableNotifyServerDown.notifyPromote();
    }
}

