/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.util.Vector;
import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.log.ServiceLogger;

public class JRLoadBalancer
implements LoadBalancer {
    protected Member localMember = null;

    @Override
    public Member selectMember(Member member, Member[] memberArray) {
        this.localMember = member;
        if (memberArray.length == 1) {
            return member;
        }
        Member[] memberArray2 = this.getEligibleMembers(memberArray);
        if (memberArray2.length == 0) {
            return this.select(memberArray);
        }
        if (memberArray2.length == 1) {
            return memberArray2[0];
        }
        return this.select(memberArray2);
    }

    protected float[] make(Member[] memberArray) {
        float[] fArray2 = new float[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            fArray2[i] = ((ReportMember)memberArray[i]).getPenddingReports();
            ServiceLogger.logDebug(6650028, new String[]{memberArray[i].getServerName(), "" + fArray2[i]}, 6);
        }
        return fArray2;
    }

    protected Member select(Member[] memberArray) {
        Member[] memberArray2 = this.getGoodMembers(memberArray);
        return this.getBestMembers(memberArray2);
    }

    protected Member[] getGoodMembers(Member[] memberArray) {
        float[] fArray2 = this.make(memberArray);
        if (fArray2.length == 0) {
            return new Member[0];
        }
        float f = fArray2[0];
        Vector<Member> vector = new Vector<Member>();
        vector.addElement(memberArray[0]);
        for (int i = 1; i < fArray2.length; ++i) {
            if (fArray2[i] < f) {
                vector.removeAllElements();
                vector.add(memberArray[i]);
                f = fArray2[i];
                continue;
            }
            if (fArray2[i] != f) continue;
            vector.addElement(memberArray[i]);
        }
        return this.getMembers(vector.toArray());
    }

    protected Member getBestMembers(Member[] memberArray) {
        int n;
        if (memberArray.length == 1) {
            return memberArray[0];
        }
        for (n = 0; n < memberArray.length; ++n) {
            if (memberArray[n] != this.localMember) continue;
            return this.localMember;
        }
        for (n = 0; n < memberArray.length; ++n) {
            if (memberArray[n].isAdmin()) continue;
            return memberArray[n];
        }
        if (memberArray.length >= 1) {
            return memberArray[0];
        }
        return null;
    }

    protected Member[] getEligibleMembers(Member[] memberArray) {
        Vector<Member> vector = new Vector<Member>();
        for (int i = 0; i < memberArray.length; ++i) {
            if (!this.canSelectMember(memberArray[i])) continue;
            vector.addElement(memberArray[i]);
        }
        return this.getMembers(vector.toArray());
    }

    protected Member[] getMembers(Object[] objectArray) {
        if (objectArray != null) {
            Member[] memberArray = new Member[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                memberArray[i] = (Member)objectArray[i];
            }
            return memberArray;
        }
        return new Member[0];
    }

    protected boolean canSelectMember(Member member) {
        int n = ((ReportMember)member).getPenddingReports();
        int n2 = ((ReportMember)member).getMaxConcurrentReports();
        if (n2 <= 0) {
            return true;
        }
        if (n < n2) {
            return true;
        }
        ServiceLogger.logDebug(6650029, new String[]{member.getServerName(), "" + n, "" + n2}, 6);
        return false;
    }
}

