/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.rmi.RemoteException;
import jet.ReportEnv;
import jet.server.intf.jrs.RemoteFileAccess;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.util.WebSecurityUtil;
import jet.util.WildcardMatcher;

public class JRRemoteFileAccess
implements RemoteFileAccess {
    @Override
    public int openForRead(String string) throws IOException {
        ServiceLogger.logDebug(6650001, string, 6);
        try {
            File file = WebSecurityUtil.validateFilePath(string);
            return (int)file.length();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new RemoteException("", exception);
        }
    }

    @Override
    public void openForWrite(String string) throws IOException {
        ServiceLogger.logDebug(6650002, string, 6);
        try {
            File file = WebSecurityUtil.validateFilePath(string.substring(0, string.lastIndexOf(File.separator)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((file = WebSecurityUtil.validateFilePath(string)).exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new RemoteException("", exception);
        }
    }

    @Override
    public synchronized byte[] read(long l, int n, String string) throws IOException {
        ServiceLogger.logDebug(6650003, new String[]{string, String.valueOf(l), String.valueOf(n)}, 6);
        FileInputStream fileInputStream = null;
        try {
            byte[] byArray;
            fileInputStream = new FileInputStream(WebSecurityUtil.validateFilePath(string));
            if (n != 0) {
                byArray = new byte[n];
                fileInputStream.skip(l);
                fileInputStream.read(byArray, 0, n);
            } else {
                byArray = new byte[]{};
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 2);
            throw iOException;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new RemoteException("", exception);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2, String string) throws IOException, RemoteException {
        ServiceLogger.logDebug(6650004, new String[]{string, String.valueOf(n), String.valueOf(n2)}, 6);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(WebSecurityUtil.validateFilePath(string), true);
            fileOutputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 2);
            throw iOException;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new RemoteException("", exception);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    @Override
    public boolean delete(String string) {
        ServiceLogger.logDebug(6650005, string, 6);
        File file = WebSecurityUtil.validateFilePath(string);
        return file.delete();
    }

    @Override
    public void close() throws IOException {
        ServiceLogger.logDebug(6650006, 6);
    }

    @Override
    public long length(String string) {
        ServiceLogger.logDebug(6650007, string, 6);
        File file = WebSecurityUtil.validateFilePath(string);
        return file == null ? 0L : file.length();
    }

    @Override
    public long lastModified(String string) {
        ServiceLogger.logDebug(6650008, string, 6);
        File file = WebSecurityUtil.validateFilePath(string);
        return file == null ? 0L : file.lastModified();
    }

    @Override
    public String[] list(String string, String string2) {
        ServiceLogger.logDebug(6650009, new String[]{string, string2}, 6);
        File file = WebSecurityUtil.validateFilePath(string);
        return file == null ? null : file.list((FilenameFilter)new WildcardMatcher(string2, false));
    }

    @Override
    public boolean isDirectory(String string) {
        ServiceLogger.logDebug(6650010, string, 6);
        File file = new File(string);
        return file.isDirectory();
    }

    @Override
    public String remoteHomePath() {
        ServiceLogger.logDebug(6650011, ReportEnv.homePath, 6);
        return ReportEnv.homePath;
    }

    @Override
    public boolean exists(String string) {
        ServiceLogger.logDebug(6650012, string, 6);
        File file = new File(string);
        return file.exists();
    }

    @Override
    public boolean setLastModified(String string, long l) {
        ServiceLogger.logDebug(6650013, new String[]{string, String.valueOf(l)}, 6);
        File file = new File(string);
        return file.setLastModified(l);
    }

    @Override
    public boolean mkdir(String string) throws RemoteException {
        File file = new File(string);
        return file.mkdirs();
    }

    @Override
    public boolean mkdirs(String string) throws IOException {
        return SchdTools.mkdirs(string);
    }

    @Override
    public String getCanonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    @Override
    public String getFileSeparator() {
        return File.separator;
    }

    @Override
    public String getName(String string) {
        File file = new File(string);
        return file.getName();
    }

    @Override
    public String getParent(String string) {
        File file = new File(string);
        return file.getParent();
    }

    @Override
    public void copy(String string, String string2) throws RemoteException, IOException {
        File file = WebSecurityUtil.validateFilePath(string);
        File file2 = WebSecurityUtil.validateFilePath(string2);
        if (file != null && file2 != null) {
            SchdTools.copyFile(file, file2);
        }
    }
}

