/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import jet.cs.CSUtil;
import jet.server.api.RemoteFileService;
import jet.server.intf.jrs.RemoteFileAccess;
import jet.server.jrc.JRInputStream;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.SchdTools;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.util.WildcardMatcher;

public class JRRemoteFileService
implements RemoteFileService {
    private static Hashtable SEDU = new Hashtable(2);
    private RemoteFileAccess abs = null;
    private final int append = 512000;
    private boolean close = false;
    private String compareTo = File.separator;
    private StringBuffer copy = new StringBuffer();

    private static String SEDU(String string, String string2) {
        String string3 = string + "-" + string2;
        return string3.toUpperCase();
    }

    public static RemoteFileService getRemoteFileService(String string, String string2) throws Exception {
        String string3 = JRRemoteFileService.SEDU(string, string2);
        RemoteFileService remoteFileService = (RemoteFileService)SEDU.get(string3);
        if (remoteFileService != null) {
            try {
                remoteFileService.getRemoteHomePath();
                return remoteFileService;
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException, 3);
                SEDU.remove(string3);
            }
        }
        remoteFileService = new JRRemoteFileService(string, Integer.parseInt(string2));
        SEDU.put(string3, remoteFileService);
        return remoteFileService;
    }

    public static boolean destroyRemoteFileService(String string, String string2) {
        String string3 = JRRemoteFileService.SEDU(string, string2);
        RemoteFileService remoteFileService = (RemoteFileService)SEDU.get(string3);
        if (remoteFileService == null) {
            return false;
        }
        SEDU.remove(string3);
        return true;
    }

    public JRRemoteFileService() {
        this.close = true;
    }

    public JRRemoteFileService(String string, int n) throws Exception {
        try {
            if (ServerUtil.isLocalAddress(string)) {
                this.close = true;
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError(0x380088, unknownHostException.getMessage(), 3);
        }
        this.abs = (RemoteFileAccess)RemoteObjectFactory.getRemoteObject(string, n, "RemoteFileService");
        this.compareTo = this.abs.getFileSeparator();
    }

    @Override
    public InputStream readFile(String string) throws IOException {
        InputStream inputStream = this.close ? new FileInputStream(WebSecurityUtil.validateFilePath(string)) : new JRInputStream(this.abs, string);
        return inputStream;
    }

    @Override
    public void writeFile(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[512000];
        int n = 0;
        if (this.close) {
            FileOutputStream fileOutputStream = new FileOutputStream(WebSecurityUtil.validateFilePath(string));
            while ((n = inputStream.read(byArray, 0, 512000)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
        } else {
            this.abs.openForWrite(string);
            while ((n = inputStream.read(byArray, 0, 512000)) != -1) {
                this.abs.write(byArray, 0, n, string);
            }
            inputStream.close();
            this.abs.close();
        }
    }

    @Override
    public boolean delete(String string) throws RemoteException {
        boolean bl = false;
        if (this.close) {
            File file = new File(string);
            bl = file.delete();
        } else {
            bl = this.abs.delete(string);
        }
        return bl;
    }

    @Override
    public String getRemoteHomePath() throws RemoteException {
        String string = null;
        if (this.close) {
            return null;
        }
        string = this.abs.remoteHomePath();
        return string;
    }

    @Override
    public boolean exists(String string) throws RemoteException {
        boolean bl = false;
        if (this.close) {
            File file = WebSecurityUtil.validateFilePath(string);
            bl = file.exists();
        } else {
            bl = this.abs.exists(string);
        }
        return bl;
    }

    private boolean abs(long l, long l2) {
        long l3 = l - l2;
        return Math.abs(l3) < 60000L;
    }

    @Override
    public synchronized void copyToRemote(String string, String string2, boolean bl) throws IOException {
        boolean bl2 = bl;
        File file = null;
        int n = -2;
        boolean bl3 = false;
        File file2 = new File(string);
        if (string.indexOf("*") != -1 || string.indexOf("?") != -1) {
            n = string.lastIndexOf(File.separator);
            file = new File(file2.getParent());
            if (!file.exists()) {
                throw new IOException("File not found " + file2.getParent());
            }
            if (string2.indexOf("*") != -1 || string2.indexOf("?") != -1) {
                string2 = CSUtil.getPathAndName(string2)[0];
            }
            bl3 = true;
        } else {
            file = new File(string);
            if (!file.exists()) {
                throw new IOException("File not found " + string);
            }
            bl3 = file.isDirectory();
        }
        if (bl3) {
            if (!string2.endsWith(this.compareTo)) {
                string2 = string2 + this.compareTo;
            }
            if (!this.isDirectory(string2) && !this.mkdir(string2)) {
                throw new IOException("Fail to create folder " + string2);
            }
            String[] stringArray = n == -2 ? file.list(null) : file.list((FilenameFilter)new WildcardMatcher(string.substring(n + 1), false));
            String string3 = file.getAbsolutePath();
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                File file3 = new File(string3 + string4);
                if (!file3.isDirectory()) {
                    this.append(string3 + stringArray[i], string2 + stringArray[i]);
                    continue;
                }
                if (!bl2) continue;
                string4 = string4 + File.separator;
                this.copyToRemote(string3 + string4, string2 + string4);
            }
        } else {
            if (string2.endsWith(this.compareTo)) {
                string2 = string2 + file2.getName();
            }
            this.append(string, string2);
        }
    }

    @Override
    public synchronized void copyToRemote(String string, String string2) throws IOException {
        this.copyToRemote(string, string2, true);
    }

    private synchronized void append(String string, String string2) throws IOException {
        byte[] byArray = new byte[512000];
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(string);
        File file = new File(string);
        if (this.close) {
            File file2 = new File(string2);
            if (file.exists() && file2.length() == file.length() && this.abs(file2.lastModified(), file.lastModified())) {
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n = fileInputStream.read(byArray, 0, 512000)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
            String string3 = System.getProperty("java.version");
            if (string3.compareTo("1.2") >= 0) {
                file2.setLastModified(file.lastModified());
            }
        } else {
            if (file.exists() && this.abs.length(string2) == file.length() && this.abs(this.abs.lastModified(string2), file.lastModified())) {
                this.abs.close();
                return;
            }
            this.abs.openForWrite(string2);
            while ((n = fileInputStream.read(byArray, 0, 512000)) != -1) {
                this.abs.write(byArray, 0, n, string2);
            }
            fileInputStream.close();
            this.abs.close();
            String string4 = System.getProperty("java.version");
            if (string4.compareTo("1.2") >= 0) {
                long l = file.lastModified();
                this.abs.setLastModified(string2, l);
            }
        }
    }

    @Override
    public synchronized void copyFromRemote(String string, String string2, boolean bl) throws IOException {
        boolean bl2 = bl;
        String string3 = null;
        String string4 = null;
        boolean bl3 = false;
        if (string.indexOf("*") != -1 || string.indexOf("?") != -1) {
            string3 = CSUtil.getPathAndName(string)[0];
            string4 = string2.indexOf("*") != -1 || string2.indexOf("?") != -1 ? CSUtil.getPathAndName(string2)[0] : string2;
            bl3 = true;
        } else {
            bl3 = this.isDirectory(string);
            string3 = string;
            string4 = string2;
        }
        if (!this.exists(string3)) {
            throw new IOException("File not found " + string3);
        }
        if (bl3) {
            String[] stringArray;
            if (!string4.endsWith(File.separator)) {
                string4 = string4 + File.separator;
            }
            if (!this.compareTo(string4, true) && !this.mkdir(string4, true)) {
                throw new IOException("Fail to create folder " + string4);
            }
            if (this.close) {
                File file = WebSecurityUtil.validateFilePath(string3);
                stringArray = string3.equals(string) ? file.list(null) : file.list((FilenameFilter)new WildcardMatcher(this.getName(string), false));
            } else {
                stringArray = string3.equals(string) ? this.abs.list(string, "*") : this.abs.list(string3, this.getName(string));
            }
            if (!string3.endsWith(this.compareTo)) {
                string3 = string3 + this.compareTo;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                this.copy.delete(0, this.copy.length());
                this.copy.append(string3).append(string5);
                String string6 = this.copy.toString();
                this.copy.delete(0, this.copy.length());
                this.copy.append(string4).append(string5);
                String string7 = this.copy.toString();
                if (!this.isDirectory(string6)) {
                    this.close(string6, string7);
                    continue;
                }
                if (!bl2) continue;
                this.copyFromRemote(string6, string7);
            }
        } else {
            if (string2.endsWith(File.separator)) {
                string2 = string2 + this.getName(string);
            }
            this.close(string, string2);
        }
    }

    @Override
    public synchronized void copyFromRemote(String string, String string2) throws IOException {
        this.copyFromRemote(string, string2, true);
    }

    private synchronized void close(String string, String string2) throws IOException {
        byte[] byArray = new byte[512000];
        File file = new File(string2);
        if (this.close) {
            File file2 = new File(string);
            if (!file2.exists() || file2.length() == 0L) {
                return;
            }
            if (file.exists()) {
                if (file2.length() == file.length() && this.abs(file2.lastModified(), file.lastModified())) {
                    return;
                }
            } else if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            int n = 0;
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n = fileInputStream.read(byArray, 0, 512000)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
            String string3 = System.getProperty("java.version");
            if (string3.compareTo("1.2") >= 0) {
                file.setLastModified(file2.lastModified());
            }
        } else {
            if (file.exists()) {
                if (this.abs.length(string) == file.length() && this.abs(this.abs.lastModified(string), file.lastModified())) {
                    this.abs.close();
                    return;
                }
            } else if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = null;
            try {
                int n = this.abs.openForRead(string);
                fileOutputStream = new FileOutputStream(string2);
                int n2 = 512000 > n ? n : 512000;
                int n3 = 0;
                while ((byArray = this.abs.read(n3, n2, string)).length != 0) {
                    fileOutputStream.write(byArray);
                    if ((n3 += n2) + n2 <= n) continue;
                    n2 = n - n3;
                }
                fileOutputStream.close();
                String string4 = System.getProperty("java.version");
                if (string4.compareTo("1.2") >= 0) {
                    file.setLastModified(this.abs.lastModified(string));
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                this.abs.close();
            }
        }
    }

    @Override
    public String[] list(String string, String string2) throws IOException {
        if (this.close) {
            return new File(string).list((FilenameFilter)new WildcardMatcher(string2, false));
        }
        return this.abs.list(string, string2);
    }

    private boolean mkdir(String string, boolean bl) throws RemoteException {
        if (bl) {
            File file = new File(string);
            if (!file.exists()) {
                return file.mkdirs();
            }
        } else {
            return this.abs.mkdir(string);
        }
        return false;
    }

    public boolean mkdir(String string) throws RemoteException {
        return this.mkdir(string, this.close);
    }

    @Override
    public boolean mkdirs(String string) throws IOException, RemoteException {
        if (this.close) {
            return SchdTools.mkdirs(string);
        }
        return this.abs.mkdirs(string);
    }

    public String getCanonicalPath(String string) throws IOException {
        if (this.close) {
            return new File(string).getCanonicalPath();
        }
        return this.abs.getCanonicalPath(string);
    }

    private boolean compareTo(String string, boolean bl) throws RemoteException {
        if (bl) {
            File file = WebSecurityUtil.validateFilePath(string);
            return file.isDirectory();
        }
        return this.abs.isDirectory(string);
    }

    @Override
    public boolean isDirectory(String string) throws RemoteException {
        return this.compareTo(string, this.close);
    }

    @Override
    public long lastModified(String string) throws RemoteException {
        if (this.close) {
            File file = new File(string);
            return file.lastModified();
        }
        return this.abs.lastModified(string);
    }

    @Override
    public long length(String string) throws RemoteException {
        if (this.close) {
            File file = WebSecurityUtil.validateFilePath(string);
            return file.length();
        }
        return this.abs.length(string);
    }

    @Override
    public String getName(String string) throws RemoteException {
        if (this.close) {
            File file = new File(string);
            return file.getName();
        }
        return this.abs.getName(string);
    }

    @Override
    public String getParent(String string) throws RemoteException {
        if (this.close) {
            File file = WebSecurityUtil.validateFilePath(string);
            return file.getParent();
        }
        return this.abs.getParent(string);
    }

    @Override
    public String getRemoteFileSeparator() throws RemoteException {
        return this.compareTo;
    }

    @Override
    public void copy(String string, String string2) throws RemoteException, IOException {
        if (this.close) {
            SchdTools.copyFile(WebSecurityUtil.validateFilePath(string), WebSecurityUtil.validateFilePath(string2));
        } else {
            this.abs.copy(string, string2);
        }
    }
}

