/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.TooManyReportsException;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.Member;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.cluster.core.ClusterServer;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MemberListenerAdapter;
import jet.server.cluster.core.MemberService;
import jet.server.intf.jrs.ScheduleTaskManager;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.JRMember;
import jet.server.jrc.JRReportMember;
import jet.server.jrc.JRTaskManager;
import jet.server.jrc.JRTaskRecord;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRActiveTaskRecord;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.rmi.rpc.RpcDispatcher;
import jet.server.rmi.rpc.RpcParam;
import jet.server.schedule.SchdTools;
import jet.server.util.StringUtils;

public class JRScheduleTaskManager
extends MapListenerAdapter
implements ScheduleTaskManager {
    private JRClusterService PUT_INIT;
    private MemberService PUT_RE_RUN;
    private JRMember REMOVE_FAILED;
    private JRTaskManager REMOVE_FINISH_NOTIFY;
    private boolean REMOVE_STOP;
    private ClusterMap RUNNING;
    private Map SCHEDULE_RUNING_TASKS;
    private static final String SEDU = JRScheduleTaskManager.class.getName();
    private volatile RpcDispatcher add;

    public JRScheduleTaskManager(JRTaskManager jRTaskManager) throws ClusterException {
        this.REMOVE_FINISH_NOTIFY = jRTaskManager;
        this.SCHEDULE_RUNING_TASKS = new ConcurrentHashMap();
        this.REMOVE_FAILED = ClusterEnv.getMember();
        this.RUNNING = MapFactory.getMap(MapAttr.SCHEDULE_RUNING_TASKS);
        this.RUNNING.addListener(this);
        this.REMOVE_STOP = ClusterEnv.isClusterEnabled();
        if (this.REMOVE_STOP) {
            this.PUT_INIT = (JRClusterService)jRTaskManager.getClusterService();
            this.PUT_RE_RUN = ClusterServer.getMemberService();
            this.PUT_RE_RUN.addMemberListener(new TaskMemberListener());
            this.REMOVE_FAILED();
            RemoteObjectFactory.registerRpcHandler(SEDU, this);
            this.buildRpcDispatcher();
        }
    }

    private void PUT_INIT(JRTaskRecord jRTaskRecord) {
        CopyOnWriteArrayList<String> copyOnWriteArrayList = (CopyOnWriteArrayList<String>)this.SCHEDULE_RUNING_TASKS.get(jRTaskRecord.getTaskID());
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList<String>();
            this.SCHEDULE_RUNING_TASKS.put(jRTaskRecord.getTaskID(), copyOnWriteArrayList);
        }
        copyOnWriteArrayList.addIfAbsent(jRTaskRecord.getRunTaskID());
    }

    private void PUT_RE_RUN(JRTaskRecord jRTaskRecord) {
        List list = (List)this.SCHEDULE_RUNING_TASKS.get(jRTaskRecord.getTaskID());
        if (list != null) {
            list.remove(jRTaskRecord.getRunTaskID());
            if (list.isEmpty()) {
                this.SCHEDULE_RUNING_TASKS.remove(jRTaskRecord.getTaskID());
            }
        }
    }

    private void REMOVE_FAILED() {
        if (this.RUNNING.isResourceNode()) {
            this.SCHEDULE_RUNING_TASKS.clear();
            for (JRTaskRecord jRTaskRecord : this.RUNNING.values()) {
                this.PUT_INIT(jRTaskRecord);
            }
        }
    }

    void buildRpcDispatcher() {
        this.add = null;
        if (!this.RUNNING.isResourceNode()) {
            try {
                JRMember jRMember = this.PUT_RE_RUN.getDefaultShareMemoryNode();
                this.add = RemoteObjectFactory.getRpcDispatcher(jRMember.getHost(), Integer.valueOf(jRMember.getPort()));
                ServiceLogger.logDebug("JRScheduleTaskManager:: rpcDispatcher=" + jRMember.getID());
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    void notifyTaskFinished(String string) {
        ServiceLogger.logDebug("JRScheduleTaskManager:: notifyTaskFinished, id: " + string, 6);
        if (string == null) {
            return;
        }
        this.RUNNING.remove((Object)string, MapFlags.create(new Object[]{TaskAction.REMOVE_FINISH_NOTIFY}));
    }

    void notifyPenddingReports(int n) {
        if (this.PUT_RE_RUN != null) {
            this.PUT_RE_RUN.setPenddingReports(n);
        }
    }

    JRTaskRecord getTaskRecord(String string) {
        if (string == null) {
            return null;
        }
        return (JRTaskRecord)this.RUNNING.get(string);
    }

    void updateTaskRecord(JRTaskRecord jRTaskRecord) {
        if (this.RUNNING.containsKey(jRTaskRecord.getRunTaskID())) {
            this.RUNNING.put(jRTaskRecord.getRunTaskID(), jRTaskRecord);
        }
    }

    @Override
    public String runTask(Properties properties) throws Exception {
        properties = (Properties)properties.clone();
        String string = SchdTools.getIdBase();
        properties.put("jrs.run_task_id", string);
        JRTaskRecord jRTaskRecord = new JRTaskRecord(properties);
        ServiceLogger.logDebug(6600286, new Object[]{jRTaskRecord.getTaskID(), jRTaskRecord.getRunTaskID()}, 4);
        jRTaskRecord.setStatus(JRTaskRecord.TaskStatus.RUNNING);
        jRTaskRecord.incRunTimes();
        String string2 = jRTaskRecord.getTaskProp().getProperty("jrs.the_name_of_preferred_server");
        this.RUNNING(string2, jRTaskRecord);
        this.RUNNING.put(string, jRTaskRecord, MapFlags.create(new Object[]{TaskAction.PUT_INIT}).forceDests(jRTaskRecord.getMember()));
        return jRTaskRecord.getTaskID();
    }

    @Override
    public Vector getActiveTasks() {
        if (this.add != null) {
            try {
                return (Vector)this.add.call(new RpcParam(SEDU, "getActiveTasks", new Object[0]));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return new Vector();
            }
        }
        Vector<JRActiveTaskRecord> vector = new Vector<JRActiveTaskRecord>();
        for (JRTaskRecord jRTaskRecord : this.RUNNING.values()) {
            if (!jRTaskRecord.isRunning() || jRTaskRecord.getTaskProperty("jrs.task_class").equals("jet.server.schedule.jrtasks.PublishCRDTask")) continue;
            vector.add(jRTaskRecord.getActiveTaskRecord());
        }
        return vector;
    }

    private boolean REMOVE_FINISH_NOTIFY(JRTaskRecord jRTaskRecord, String string) {
        boolean bl;
        if (StringUtils.equals(string, jRTaskRecord.getUid())) {
            return true;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(ServerEnv.getActiveRealm());
        boolean bl2 = bl = securityService.isAdminUser(string) || securityService.isOrganizationAdminUser(string);
        if (bl) {
            return StringUtils.equals(CSUtil.parsePrincipalDisplayName(string)[0], CSUtil.parsePrincipalDisplayName(jRTaskRecord.getUid())[0]);
        }
        return false;
    }

    @Override
    public Vector getActiveTasksByUser(String string) {
        if (this.add != null) {
            try {
                return (Vector)this.add.call(new RpcParam(SEDU, "getActiveTasksByUser", string));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return new Vector();
            }
        }
        Vector<JRActiveTaskRecord> vector = new Vector<JRActiveTaskRecord>();
        for (JRTaskRecord jRTaskRecord : this.RUNNING.values()) {
            if (!jRTaskRecord.isRunning() || !this.REMOVE_FINISH_NOTIFY(jRTaskRecord, string) || jRTaskRecord.getTaskProperty("jrs.task_class").equals("jet.server.schedule.jrtasks.PublishCRDTask")) continue;
            vector.add(jRTaskRecord.getActiveTaskRecord());
        }
        return vector;
    }

    @Override
    public boolean stopActiveTask(String string) {
        if (this.add != null) {
            try {
                return (Boolean)this.add.call(new RpcParam(SEDU, "stopActiveTask", string));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return false;
            }
        }
        ServiceLogger.logDebug(6600287, string, 6);
        List list = (List)this.SCHEDULE_RUNING_TASKS.get(string);
        if (list != null) {
            for (String string2 : list) {
                JRTaskRecord jRTaskRecord = (JRTaskRecord)this.RUNNING.get(string2);
                if (jRTaskRecord == null) continue;
                return this.RUNNING.remove((Object)string2, MapFlags.create(new Object[]{TaskAction.REMOVE_STOP}).forceDests(jRTaskRecord.getMember())) != null;
            }
        }
        return false;
    }

    @Override
    public boolean stopActiveTaskByUser(String string, String string2) {
        if (this.add != null) {
            try {
                return (Boolean)this.add.call(new RpcParam(SEDU, "stopActiveTaskByUser", string, string2));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return false;
            }
        }
        ServiceLogger.logDebug(6600288, new Object[]{string2, string}, 6);
        List list = (List)this.SCHEDULE_RUNING_TASKS.get(string);
        if (list != null) {
            for (String string3 : list) {
                JRTaskRecord jRTaskRecord = (JRTaskRecord)this.RUNNING.get(string3);
                if (jRTaskRecord == null || !jRTaskRecord.getUid().equals(string2)) continue;
                return this.RUNNING.remove((Object)string3, MapFlags.create(new Object[]{TaskAction.REMOVE_STOP}).forceDests(jRTaskRecord.getMember())) != null;
            }
        }
        return false;
    }

    private String REMOVE_STOP(JRTaskRecord jRTaskRecord) throws Exception {
        ServiceLogger.logDebug(4600290, new Object[]{jRTaskRecord.getMember(), jRTaskRecord}, 4);
        jRTaskRecord.setStatus(JRTaskRecord.TaskStatus.RUNNING);
        jRTaskRecord.incRunTimes();
        this.RUNNING(null, jRTaskRecord);
        this.RUNNING.put(jRTaskRecord.getRunTaskID(), jRTaskRecord, MapFlags.create(new Object[]{TaskAction.PUT_RE_RUN}).forceDests(jRTaskRecord.getMember()));
        return jRTaskRecord.getTaskID();
    }

    private void RUNNING(String string, JRTaskRecord jRTaskRecord) throws ClusterException, TooManyReportsException {
        Member member = null;
        if (!this.REMOVE_STOP || !ServerEnv.isLoadBalance()) {
            jRTaskRecord.setMember(this.REMOVE_FAILED.getID());
            return;
        }
        if (member == null && string != null && string.length() > 0) {
            for (JRMember jRMember : this.PUT_RE_RUN.getMembers()) {
                if (!jRMember.getServerName().equals(string)) continue;
                member = jRMember;
                break;
            }
        }
        if (member == null) {
            member = this.PUT_INIT.getMember();
        }
        if (member == null) {
            throw new TooManyReportsException(600021, (Object[])new String[]{String.valueOf(ReportEnv.getR())}, null);
        }
        jRTaskRecord.setMember(member.getID());
        ServiceLogger.logDebug(0x64B666, new Object[]{member.getID(), ((JRReportMember)member).getPenddingReports(), jRTaskRecord.getTaskID(), jRTaskRecord.getRunTaskID()}, 4);
    }

    @Override
    public void afterInit(String string, int n, int n2) {
        if (n2 == 0) {
            ServiceLogger.logError("JRScheduleTaskManager:: lost running schedule tasks info.", 3);
        }
        this.REMOVE_FAILED();
    }

    public void afterPut(String string, int n, String string2, JRTaskRecord jRTaskRecord, JRTaskRecord jRTaskRecord2, MapFlags mapFlags) {
        Object[] objectArray = MapFlags.getUserFlags(mapFlags);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        this.PUT_INIT(jRTaskRecord);
        TaskAction taskAction = (TaskAction)((Object)objectArray[0]);
        if (taskAction == TaskAction.PUT_INIT || taskAction == TaskAction.PUT_RE_RUN) {
            JRReportMember jRReportMember;
            if (this.REMOVE_STOP && (jRReportMember = (JRReportMember)this.PUT_RE_RUN.getMemberById(jRTaskRecord.getMember())) != null) {
                jRReportMember.setPenddingReports(jRReportMember.getPenddingReports() + 1);
            }
            if (!this.REMOVE_STOP || this.REMOVE_FAILED.getID() == jRTaskRecord.getMember()) {
                try {
                    ServiceLogger.logDebug(6600291, jRTaskRecord, 6);
                    this.REMOVE_FINISH_NOTIFY.runTask(null, jRTaskRecord.getTaskProp());
                }
                catch (Exception exception) {
                    this.RUNNING.remove((Object)string2, MapFlags.create(new Object[]{TaskAction.REMOVE_FAILED}));
                    ServiceLogger.logError(exception);
                }
            }
        }
    }

    public void afterRemove(String string, int n, String string2, JRTaskRecord jRTaskRecord, MapFlags mapFlags) {
        if (jRTaskRecord == null) {
            ServiceLogger.logDebug(4600292, string2, 4);
            return;
        }
        this.PUT_RE_RUN(jRTaskRecord);
        Object[] objectArray = MapFlags.getUserFlags(mapFlags);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        TaskAction taskAction = (TaskAction)((Object)objectArray[0]);
        if (!(taskAction != TaskAction.REMOVE_STOP || this.REMOVE_STOP && this.REMOVE_FAILED.getID() != jRTaskRecord.getMember())) {
            ServiceLogger.logDebug(6600293, jRTaskRecord, 6);
            this.REMOVE_FINISH_NOTIFY.stopActiveTask(jRTaskRecord.getTaskID());
        }
    }

    class TaskMemberListener
    extends MemberListenerAdapter {
        TaskMemberListener() {
        }

        @Override
        public void viewAccepted(JRView jRView) {
            JRScheduleTaskManager.this.buildRpcDispatcher();
            if (!JRScheduleTaskManager.this.PUT_RE_RUN.isCoordinator()) {
                return;
            }
            for (JRTaskRecord jRTaskRecord : JRScheduleTaskManager.this.RUNNING.values()) {
                if (jRView.getMemberById(jRTaskRecord.getMember()) != null) continue;
                try {
                    JRScheduleTaskManager.this.REMOVE_STOP(jRTaskRecord);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
        }
    }

    private static enum TaskAction {
        PUT_INIT,
        PUT_RUN_NOTIFY,
        PUT_RE_RUN,
        REMOVE_STOP,
        REMOVE_FAILED,
        REMOVE_FINISH_NOTIFY;

    }
}

