/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.Serializable;
import java.sql.Date;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.jrserver.JRActiveTaskRecord;
import jet.server.schedule.jrtasks.JRTUtil;

class JRTaskRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String taskID;
    private String runTaskID;
    private int member;
    private TaskStatus status = TaskStatus.RUNNING;
    private String paramFile;
    private int runTimes = 0;
    private Properties taskProp;
    private long startedTime;
    private transient JRActiveTaskRecord RUNNING;

    public JRTaskRecord(Properties properties) {
        this.taskProp = properties;
        this.runTaskID = properties.getProperty("jrs.run_task_id");
        this.taskID = properties.getProperty("jrs.task_id");
        this.startedTime = System.currentTimeMillis();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.taskID + "(" + this.runTaskID + ")" + ", status=" + (Object)((Object)this.status) + ", runTimes=" + this.runTimes + ", member=" + this.member + "]";
    }

    public void setRunTaskID(String string) {
        this.runTaskID = string;
    }

    public String getRunTaskID() {
        return this.runTaskID;
    }

    public void setTaskID(String string) {
        this.taskID = string;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setMember(int n) {
        this.member = n;
    }

    public int getMember() {
        return this.member;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus taskStatus) {
        this.status = taskStatus;
    }

    public void incRunTimes() {
        ++this.runTimes;
    }

    public int getRunTimes() {
        return this.runTimes;
    }

    public boolean isRunning() {
        return this.status == TaskStatus.RUNNING;
    }

    public String getUid() {
        return this.taskProp.getProperty("jrs.uid");
    }

    public Properties getTaskProp() {
        return this.taskProp;
    }

    public void setTaskProp(Properties properties) {
        this.taskProp = properties;
    }

    public Object getTaskProperty(String string) {
        return this.taskProp.get(string);
    }

    public void setParamFile(String string) {
        this.RUNNING = null;
        this.paramFile = string;
    }

    public JRActiveTaskRecord getActiveTaskRecord() {
        if (this.RUNNING == null) {
            this.RUNNING = new JRActiveTaskRecord(new Date(this.startedTime), "", this.taskProp.getProperty("jrs.uid"), this.taskID, this.taskProp.getProperty("jrs.task_class"), CSUtil.parseInt(this.taskProp.getProperty("jrs.launch_type"), 0), this.taskProp.getProperty("jrs.catalog"), this.taskProp.getProperty("jrs.report"), this.paramFile, "", this.taskProp.getProperty("jrs.schedule_name"), JRTUtil.parseSheetDisplayNames(this.taskProp), this.runTaskID);
        }
        return this.RUNNING;
    }

    public static enum TaskStatus {
        WAITTING,
        RUNNING,
        FINISHED;

    }
}

