/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.jrc.JRReportMember;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class PredefinedServerList {
    private String SEDU;
    private String add;
    private JRReportMember[] append = new JRReportMember[0];

    public PredefinedServerList(String string, String string2) throws IOException {
        this.SEDU = string;
        this.add = string2;
        this.init();
    }

    public void init() throws IOException {
        File file = new File(this.SEDU);
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, this.add);
        File file3 = new File(file, this.add + ".bak");
        if (file2.exists()) {
            SchdTools.copyFile(file2, file3);
        }
        if (!file2.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1"));
            PredefinedServerList.add(bufferedWriter, new Date().toString());
            bufferedWriter.flush();
        } else {
            this.append(new FileInputStream(file2));
        }
    }

    public void sort() {
    }

    private void SEDU() {
    }

    private static void add(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    private void append(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
        bufferedReader.readLine();
        String string = null;
        boolean bl = false;
        this.append = new JRReportMember[0];
        while ((string = bufferedReader.readLine()) != null) {
            Properties properties = CSUtil.parseQuery(string);
            JRReportMember jRReportMember = new JRReportMember(properties);
            int n = jRReportMember.getBackupPriority();
            if (n < -1) {
                jRReportMember.setBackupPriority(-1);
            }
            String string2 = null;
            string2 = this.add(jRReportMember);
            if (string2 == null) continue;
            bl = true;
            if (!string2.equals("CLUSTER_ERR_5_ERROR_DUPLICATE_PRIORITY")) continue;
            jRReportMember.setBackupPriority(jRReportMember.getBackupPriority() + 1);
            this.add(jRReportMember);
        }
        if (bl) {
            System.out.println(JSvrResource.getMessage("SVR_86"));
            ServiceLogger.logError(6650027, 2);
            this.save();
        }
    }

    public void synchronizeAdminServer(String string, String string2) {
        try {
            JRReportMember jRReportMember = new JRReportMember(string, string2);
            if (!jRReportMember.equals(this.append[0]) || this.append[0].getBackupPriority() != 0) {
                this.append[0] = jRReportMember;
                this.save();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
    }

    public synchronized void save() throws IOException {
        File file = new File(this.SEDU, this.add);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1"));
        int n = this.append.length;
        PredefinedServerList.add(bufferedWriter, new Date().toString());
        for (int i = 0; i < n; ++i) {
            Properties properties = this.append[i].toProperties(null);
            String string = CSUtil.makeNoHeadQuery(properties);
            PredefinedServerList.add(bufferedWriter, string);
        }
        bufferedWriter.flush();
    }

    public boolean isEmpty() {
        return this.append.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String add(JRReportMember jRReportMember) {
        for (int i = 0; i < this.append.length; ++i) {
            if (this.append[i].getServerName().equals(jRReportMember.getServerName())) {
                return "CLUSTER_ERR_3_ERROR_DUPLICATE_NAME";
            }
            if (this.append[i].equals(jRReportMember)) {
                return "CLUSTER_ERR_4_ERROR_DUPLICATE_ADDRESS";
            }
            if (jRReportMember.getBackupPriority() == -1 || this.append[i].getBackupPriority() != jRReportMember.getBackupPriority()) continue;
            return "CLUSTER_ERR_5_ERROR_DUPLICATE_PRIORITY";
        }
        JRReportMember[] jRReportMemberArray = this.append;
        synchronized (this.append) {
            int n = this.append.length;
            if (jRReportMember.getBackupPriority() != -1) {
                int n2 = this.append.length - 1;
                int n3 = 0;
                int n4 = jRReportMember.getBackupPriority();
                while (n3 <= n2) {
                    int n5 = (n2 + n3) / 2;
                    int n6 = this.append[n5].getBackupPriority();
                    if (n6 == -1 || n4 < n6) {
                        n2 = n5 - 1;
                        continue;
                    }
                    n3 = n5 + 1;
                }
                n = n3;
            }
            JRReportMember[] jRReportMemberArray2 = new JRReportMember[this.append.length + 1];
            System.arraycopy(this.append, 0, jRReportMemberArray2, 0, n);
            jRReportMemberArray2[n] = jRReportMember;
            System.arraycopy(this.append, n, jRReportMemberArray2, n + 1, this.append.length - n);
            this.append = jRReportMemberArray2;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JRReportMember remove(String string) {
        int n = this.arraycopy(string);
        if (n != -1) {
            JRReportMember jRReportMember = this.append[n];
            JRReportMember[] jRReportMemberArray = this.append;
            synchronized (this.append) {
                JRReportMember[] jRReportMemberArray2 = new JRReportMember[this.append.length - 1];
                System.arraycopy(this.append, 0, jRReportMemberArray2, 0, n);
                System.arraycopy(this.append, n + 1, jRReportMemberArray2, n, jRReportMemberArray2.length - n);
                this.append = jRReportMemberArray2;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return jRReportMember;
            }
        }
        return null;
    }

    private int arraycopy(String string) {
        int n = -1;
        int n2 = this.append.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.append[i].getServerName().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public JRReportMember getPredefinedServer(JRReportMember jRReportMember) {
        int n = this.append.length;
        for (int i = 0; i < n; ++i) {
            if (!this.append[i].equals(jRReportMember)) continue;
            return this.append[i];
        }
        return null;
    }

    public JRReportMember[] getServerList() {
        return this.append;
    }
}

