/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.engine;

import java.io.Serializable;
import jet.JSRuntimeException;
import jet.cs.CSUtil;
import jet.server.util.ThreadQueueElement;

public class EngineQueueElement
implements ThreadQueueElement,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4688962976570459980L;
    private int state = 0;
    private String rptName = null;
    private String userName = null;
    private String orgName = null;
    private String taskID;
    private int engineID;
    private String seqID;
    private int priority;
    private long joinTime;
    private long adjustTime;

    public EngineQueueElement(String string, String string2) {
        this.rptName = string;
        this.userName = string2;
        this.orgName = CSUtil.parsePrincipalDisplayName(string2)[0];
    }

    public String getReportName() {
        return this.rptName;
    }

    @Override
    public String getOrganizationName() {
        return this.orgName;
    }

    @Override
    public void enqueue() {
        this.state = 3;
    }

    @Override
    public int getStatus() {
        return this.state;
    }

    @Override
    public void dequeue() {
        this.state = 4;
    }

    @Override
    public void startWait() {
        this.state = 1;
    }

    @Override
    public void startReady() {
        this.state = 2;
    }

    @Override
    public void setTaskID(String string) {
        this.taskID = string;
    }

    @Override
    public String getTaskID() {
        return this.taskID;
    }

    @Override
    public void setEngineID(int n) {
        this.engineID = n;
    }

    @Override
    public int getEngineID() {
        return this.engineID;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setJoinTime(long l) {
        this.joinTime = l;
    }

    @Override
    public long getJoinTime() {
        return this.joinTime;
    }

    @Override
    public void setAdjustTime(long l) {
        this.adjustTime = l;
    }

    @Override
    public long getAdjustTime() {
        return this.adjustTime;
    }

    public String toString() {
        return "[" + super.toString() + ": rptName=" + this.rptName + ", userName=" + this.userName + ", taskID=" + this.taskID + ", sequenceID=" + this.seqID + ", engineID=" + this.engineID + ", priority=" + this.priority + ", joinTime=" + this.joinTime + ", adjustTime=" + this.adjustTime + "]";
    }

    @Override
    public void setSequenceID(String string) {
        this.seqID = string;
    }

    @Override
    public String getSequenceID() {
        return this.seqID;
    }

    public Object clone() {
        try {
            EngineQueueElement engineQueueElement = (EngineQueueElement)super.clone();
            engineQueueElement.rptName = this.rptName;
            engineQueueElement.userName = this.userName;
            engineQueueElement.orgName = CSUtil.parsePrincipalDisplayName(this.userName)[0];
            engineQueueElement.state = this.state;
            engineQueueElement.taskID = this.taskID;
            engineQueueElement.engineID = this.engineID;
            engineQueueElement.seqID = this.seqID;
            engineQueueElement.priority = this.priority;
            engineQueueElement.joinTime = this.joinTime;
            engineQueueElement.adjustTime = this.adjustTime;
            return engineQueueElement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new JSRuntimeException();
        }
    }
}

