/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.engine;

import com.jinfonet.api.crd.ApplyCubeListener;
import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.api.objectmanager.CatalogKeyImp;
import com.jinfonet.common.impl.DriverConfigFactory;
import com.jinfonet.resstore.ResourceStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.bean.EngineProperties;
import jet.bean.JREngine;
import jet.bean.ReportInfo;
import jet.cs.CSUtil;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlock;
import jet.dataengine.api.DataBlockSet;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.dataservice.api.JDataService;
import jet.datasource.InputStreamFactory;
import jet.datasource.JRExternalQueryRunner;
import jet.datastream.Communicator;
import jet.jetc.ReadFailureException;
import jet.report.JetRptReportPanel;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.rptengine.EngineMsgListener;
import jet.rptservice.api.ISecurityProvider;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.pub.JROAttributes;
import jet.security.PageACL;
import jet.server.ServerEnv;
import jet.server.api.CatalogVersionRecord;
import jet.server.api.ReportSheetInfo;
import jet.server.api.SecurityContext;
import jet.server.api.ServerInfo;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpUtil;
import jet.server.crd.ApplyCubeListenerImpl;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.server.intf.engine.EngineContext;
import jet.server.intf.engine.ReportEngine;
import jet.server.intf.engine.ReportSetEngine;
import jet.server.jrc.engine.EngineManager;
import jet.server.jrc.engine.EngineQueueElement;
import jet.server.jrc.engine.JRRemoteTaskListener;
import jet.server.jrc.engine.JRReportEngine;
import jet.server.jrc.engine.JRReportSetEngine;
import jet.server.jrc.engine.NonBurstingResultTaskThread;
import jet.server.jrc.engine.PrepareBurstingDataThread;
import jet.server.jrc.engine.RemoteEngineBase;
import jet.server.jrc.engine.ReportSetEngineFactory;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRReportSheetInfo;
import jet.server.jrserver.JRResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.objmanager.ObjectManagerImpl;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.schedule.SchdTools;
import jet.server.schedule.bursting.MultiBurstingExecutor;
import jet.server.schedule.bursting.SubTaskThreadListener;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.TaskCanceledException;
import jet.server.util.ServerUtil;
import jet.server.util.ThreadQueueController;
import jet.universe.JetUUniverse;
import jet.util.EngineErrorListener;
import jet.util.EngineRuntimeInfo;
import jet.util.NLSBundleInfo;
import jet.util.RuntimeInfo;
import jet.util.nls.NLSApplyParam;

public class JREngineContext
extends RemoteEngineBase
implements EngineMsgListener,
EngineContext,
EngineErrorListener {
    private static final int SEDU = 32768;
    protected JREngine jrengine = null;
    private JRReportSetEngine ThreadException = null;
    String _rpt = null;
    String _cat = null;
    boolean isWebReport = false;
    CatalogKey catKey = null;
    private String add = null;
    private String[] addEngineListener = null;
    private EngineQueueElement[] addNonBurstingResultListener = null;
    private ReportEngine[] append = null;
    private PageACL arraycopy = null;
    private ServerInfo available = null;
    private boolean clear = false;
    MultiBurstingExecutor burstingExecutor = null;
    private PrepareBurstingDataThread clone = null;
    private NonBurstingResultTaskThread close = null;
    private String[] containsKey = null;
    private JetUUniverse copyFromRemote;
    private boolean createDefaultRuntimeInfo = false;
    private String createEngine = null;
    private String createRemoteTaskListener = null;
    private ThreadQueueController currentThread = null;
    private boolean decRptEngineRef = false;
    private EngineQueueElement[] decRptSetEngineRef = null;
    private Hashtable delete;
    private Hashtable dequeueEngine;
    private String elementAt;
    private boolean elements = true;
    private String endsWith;
    private String engineExit;
    private int engineMassage = -1;
    private Hashtable equals = new Hashtable();
    private Hashtable exit;
    private boolean exportObject = false;
    private String failToPrepareData = null;
    private SubTaskThreadListener finished = null;

    public JREngineContext(JRResourceManager jRResourceManager, EngineManager engineManager, String string) throws RemoteException {
        super(jRResourceManager, engineManager);
        this.createEngine = string;
        this.createRemoteTaskListener = CSUtil.parsePrincipalDisplayName(string)[0];
    }

    public JREngineContext(String string, String string2, JRResourceManager jRResourceManager, String string3) throws RemoteException {
        super(string, string2, jRResourceManager);
        this.createEngine = string3;
        this.createRemoteTaskListener = CSUtil.parsePrincipalDisplayName(string3)[0];
    }

    public JREngine getJREngine() {
        return this.jrengine;
    }

    @Override
    public ReportEngine createReportEngine(String string) throws TaskCanceledException, JRScheduleException, RemoteException {
        if (this.addEngineListener == null) {
            this.addEngineListener = new String[1];
            this.addEngineListener[0] = string;
        }
        JRReportEngine jRReportEngine = new JRReportEngine(this, this.ThreadException, string);
        jRReportEngine.createEngine(this.ThreadException(string));
        this.append[this.SEDU((String)string)] = jRReportEngine;
        return jRReportEngine;
    }

    private int SEDU(String string) {
        int n;
        for (n = 0; n < this.addEngineListener.length && !this.addEngineListener[n].equals(string); ++n) {
        }
        if (n >= this.addEngineListener.length) {
            n = 0;
        }
        return n;
    }

    @Override
    public void decRptEngineRef() {
        super.decRptEngineRef(this.append[0], this.addNonBurstingResultListener[0]);
    }

    @Override
    public void setRunningSheets(String[] stringArray) {
        this.addEngineListener = stringArray;
        if (stringArray == null) {
            this.append = new ReportEngine[1];
            this.addNonBurstingResultListener = new EngineQueueElement[1];
            this.addNonBurstingResultListener[0] = new EngineQueueElement(null, this.createEngine);
        } else {
            this.append = new ReportEngine[stringArray.length];
            this.addNonBurstingResultListener = new EngineQueueElement[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.addNonBurstingResultListener[i] = new EngineQueueElement(stringArray[i], this.createEngine);
            }
        }
    }

    @Override
    public void setRunningSheets(String[] stringArray, int n) throws RemoteException {
        this.engineMassage = n;
        this.setRunningSheets(stringArray);
        for (int i = 0; i < this.addNonBurstingResultListener.length; ++i) {
            this.addNonBurstingResultListener[i].setPriority(n);
            this.addNonBurstingResultListener[i].setTaskID(this.getTaskID());
            this.addNonBurstingResultListener[i].setSequenceID(this.getSequenceID());
        }
    }

    private EngineQueueElement ThreadException(String string) {
        if (this.addEngineListener == null) {
            return this.addNonBurstingResultListener[0];
        }
        for (int i = 0; i < this.addEngineListener.length; ++i) {
            if (!this.addEngineListener[i].equals(string)) continue;
            return this.addNonBurstingResultListener[i];
        }
        return null;
    }

    @Override
    public void createJREngine(String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws TaskCanceledException, RemoteException {
        int n;
        Object object;
        Object object2;
        this.elementAt = string2;
        this.decRptEngineRef = bl2;
        if (this.localManager.incThreadQueueController(this.addNonBurstingResultListener) && !this.clear) {
            object2 = DriverConfigFactory.getJdbcDriversConfig();
            object = CSUtil.parsePrincipalDisplayName(string);
            EngineProperties engineProperties = new EngineProperties(string2, string3, string4, object2, object[0] == null ? ServerEnv.getCompressIO() : HttpUtil.getHttpRptServer().getAdminService().getConfigService().getOrgConfiguration(object[0]).isCompressSwapFiles());
            engineProperties.setResourceStore((ResourceStore)ServerResourceStoreFactory.getInstance().getResourceStoreByUser(string));
            this.jrengine = new JREngine(engineProperties);
            ServiceLogger.logDebug(4600195, new Object[]{new Integer(this.jrengine.getID())}, 4);
            if (bl2) {
                EngineQueueElement engineQueueElement;
                n = 0;
                EngineQueueElement[] engineQueueElementArray = this.addNonBurstingResultListener;
                int n2 = engineQueueElementArray.length;
                for (int i = 0; i < n2 && (engineQueueElement = engineQueueElementArray[i]).getStatus() == 3; ++i) {
                    ++n;
                }
                int n3 = this.addNonBurstingResultListener.length;
                if (n < n3) {
                    this.decRptSetEngineRef = this.addNonBurstingResultListener;
                    this.addNonBurstingResultListener = new EngineQueueElement[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.addNonBurstingResultListener[n2] = (EngineQueueElement)this.decRptSetEngineRef[n2].clone();
                    }
                    this.currentThread = new ThreadQueueController(n, false);
                    this.currentThread.queueUp(this.addNonBurstingResultListener);
                }
            }
        } else {
            throw new TaskCanceledException(600032);
        }
        object2 = null;
        object = null;
        try {
            object2 = this.getSequenceID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = this.getCurrentReport() == null ? this._rpt : this.getCurrentReport().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ServiceLogger.isLoggable(6, 5)) {
            ServiceLogger.logDump(5600151, new Object[]{String.valueOf(this.jrengine.getID()), object2, object}, 5);
        }
        int n4 = this.jrengine.getID();
        for (n = 0; n < this.addNonBurstingResultListener.length; ++n) {
            this.addNonBurstingResultListener[n].setEngineID(n4);
        }
        this.localManager.incRptSetEngineRef(this.jrengine);
    }

    @Override
    public boolean hasPageSecurity() throws RemoteException {
        return this.jrengine.hasPageSecurity();
    }

    @Override
    public void setSingleThread(boolean bl) throws RemoteException {
        this.elements = bl;
        this.jrengine.setSingleThread(bl);
    }

    @Override
    public void setPriority(int n) throws RemoteException {
        this.jrengine.setPriority(n);
    }

    @Override
    public void setEnableNLS(boolean bl) throws RemoteException {
        int n = bl ? 1 : 2;
        NLSApplyParam nLSApplyParam = new NLSApplyParam();
        nLSApplyParam.setNLSModel(n);
        this.jrengine.setNLSApplyParamInfo(nLSApplyParam);
        if (bl) {
            this.jrengine.getNLSApplyParamInfo().setDictionary(NLSUtil.getGlobalNLSDictionary());
        }
    }

    @Override
    public void setLocale(Locale locale) throws RemoteException {
        this.jrengine.setLocale(locale);
        this.jrengine.getNLSApplyParamInfo().setLocale(locale);
    }

    @Override
    public void setLocale(String string) throws RemoteException {
        this.setLocale(ServerUtil.getLocale(string));
    }

    @Override
    public void setEncoding(String string) throws RemoteException {
        this.jrengine.setEncoding(string);
    }

    @Override
    public void setConvertEncoding(int n, int n2) throws RemoteException {
        this.jrengine.setConvertEncoding(n, n2);
    }

    @Override
    public void setStyleGroup(String string) throws RemoteException {
        this.jrengine.setStyleGroup(string);
    }

    @Override
    public void setUserName(String string) throws RemoteException {
        this.jrengine.setUserName(string);
    }

    @Override
    public void setClientName(String string) throws RemoteException {
        this.jrengine.setClientName(string);
    }

    @Override
    public void setParamFile(String string) throws RemoteException {
        boolean bl = this.isSharedDir(string);
        String string2 = this.getLocalName(string);
        if (!bl) {
            string2 = this.getLocalName(string);
            try {
                if (!this.isLocal) {
                    this.fileService.copyFromRemote(string, string2);
                }
                this.add = string;
            }
            catch (Exception exception) {
                throw new RemoteException("", exception);
            }
        } else {
            string2 = string;
        }
        this.jrengine.setParamFile(string2);
    }

    @Override
    public void deleteParamFile() throws RemoteException {
        if (this.add != null) {
            File file = new File(this.add);
            file.delete();
        }
    }

    @Override
    public void setConnection(String string, String string2, String string3, String string4, boolean bl) throws RemoteException {
        this.jrengine.setConnection(string, string2, string3, string4, bl);
    }

    @Override
    public void setDatabaseMetadataInfo(String string, DatabaseMetadataInfo databaseMetadataInfo) {
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JREntineContext:setDatabaseMetadataInfo: jrengine.setRuntimeDatabaseMetadataInfo... [dataSourceName = %s, databaseMetadataInfo = %s]", string, databaseMetadataInfo);
        }
        if (string == null || string.trim().length() == 0) {
            this.jrengine.setRuntimeDatabaseMetadataInfo(databaseMetadataInfo);
        } else {
            this.jrengine.setRuntimeDatabaseMetadataInfo(string, null, databaseMetadataInfo);
        }
    }

    @Override
    public void setDatabaseMetadataInfo(String string, String string2, DatabaseMetadataInfo databaseMetadataInfo) {
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("JREntineContext:setDatabaseMetadataInfo: jrengine.setRuntimeDatabaseMetadataInfo... [dataSourceName = %s, connectionName = %s, databaseMetadataInfo = %s]", string, string2, databaseMetadataInfo);
        }
        if (string == null || string.trim().length() == 0 || null == string2 || string2.isEmpty()) {
            this.jrengine.setRuntimeDatabaseMetadataInfo(databaseMetadataInfo);
        } else {
            this.jrengine.setRuntimeDatabaseMetadataInfo(string, string2, databaseMetadataInfo);
        }
    }

    @Override
    public void setConnection(Connection connection, boolean bl) throws RemoteException {
        this.jrengine.setConnection(connection, bl);
    }

    @Override
    public void setConnection(String string, Connection connection) throws RemoteException {
        this.jrengine.setConnection(string, connection);
    }

    @Override
    public void setConnection(String string, String string2, String string3) throws RemoteException {
        this.jrengine.setConnection(string, string2, string3);
    }

    @Override
    public void setConnection(String string, String string2, String string3, String string4, String string5) throws RemoteException {
        this.jrengine.setConnection(string, string2, string3, string4, string5);
    }

    @Override
    public void setConnection(String string, String string2, String string3, String string4, String string5, String string6) throws RemoteException {
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("dataSourceName=" + string + ",connName=" + string2 + ",strURL=" + string3 + ",strUID=" + string4 + ",strPSWD=******" + ",strJdbcDriver=" + string6, new Object[0]);
        }
        this.jrengine.setConnection(string, string2, string3, string4, string5, string6);
    }

    @Override
    public void setThrowException(boolean bl) throws RemoteException {
        this.jrengine.setThrowException(bl);
    }

    @Override
    public void addEngineListener(String string) throws RemoteException {
        if (this.taskListener == null) {
            this.taskListener = this.manager.createRemoteTaskListener(string);
        }
        this.jrengine.addEngineListener((EngineErrorListener)this);
    }

    @Override
    public void setServerInfo(ServerInfo serverInfo) throws RemoteException {
        this.jrengine.setServerInfo(serverInfo);
        this.available = serverInfo;
    }

    public ServerInfo getServerInfo() throws RemoteException {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReportName(String string, String string2, int n, String string3, int n2) throws TaskCanceledException, UnknownResource, Exception {
        try {
            Object object;
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            String string4 = this.rscMan.getRptRealPath(string, string3, n2);
            this.isWebReport = string4.endsWith(".wls");
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            ObjectManagerImpl objectManagerImpl = ObjectManagerImpl.getInstance();
            JDataService jDataService = UserDataToolkit.getJDataService(this.createRemoteTaskListener);
            ObjectManagerImpl objectManagerImpl2 = objectManagerImpl;
            synchronized (objectManagerImpl2) {
                if (!string4.toLowerCase().endsWith(".clx")) {
                    this._cat = object = this.rscMan.getRealPath(string, string2, n);
                    CatalogVersionRecord catalogVersionRecord = this.rscMan.getCatalogVersion(string, string2, n);
                    long l = new File(catalogVersionRecord.getRealPath()).lastModified();
                    this.catKey = new CatalogKeyImp(string2, l, n);
                    this.copyFromRemote = JRTUtil.getCatalog(this.catKey, string);
                } else {
                    object = this.rscMan.getReportVersion(string, string3, n2);
                    long l = new File(object.getRealPath()).lastModified();
                    this.catKey = new CatalogKeyImp(string3, l, n2);
                    this.copyFromRemote = JRTUtil.getCatalogFromClx(this.catKey, string);
                    this.createDefaultRuntimeInfo = true;
                }
                jDataService.registCatalog(this.catKey, this.copyFromRemote);
            }
            this.jrengine.setDataService(this.catKey, this.copyFromRemote, jDataService);
            objectManagerImpl2 = new JROAttributes();
            objectManagerImpl2.setDiskPath(this._cat);
            objectManagerImpl2.setServerPath(string2);
            this.jrengine.setUnvAttributes((JROAttributes)objectManagerImpl2);
            object = new JROAttributes();
            object.setDiskPath(string4);
            object.setServerPath(string3);
            this.jrengine.setReportSetAttributes((JROAttributes)object);
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            this.jrengine.setReportName(string4);
            this._rpt = string4;
            if (this.isWebReport) {
                this.jrengine.setApplyCubeListener((ApplyCubeListener)ApplyCubeListenerImpl.newInstance(this.catKey, string3, 1, null, string));
            }
            ServiceLogger.logDebug(6600165, new Object[]{this._rpt, this._cat}, 6);
        }
        catch (TaskCanceledException taskCanceledException) {
            throw taskCanceledException;
        }
        catch (UnknownResource unknownResource) {
            throw unknownResource;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    @Override
    public void setParamValues(String string) throws RemoteException {
        this.jrengine.setParamValues(string);
    }

    @Override
    public void setParamValues(Properties properties) throws RemoteException {
        this.jrengine.setParamValues(properties);
    }

    public void setParamDescs(Vector vector) {
        this.jrengine.setParamDescs(vector);
    }

    @Override
    public void setNamedWherePortion(String string) throws RemoteException {
        this.jrengine.setNamedWherePortion(string);
    }

    @Override
    public void setWherePortion(String string) throws RemoteException {
        this.jrengine.setWherePortion(string);
    }

    public void setExternalQueryRunner(JRExternalQueryRunner jRExternalQueryRunner) {
        this.jrengine.setExternalQueryRunner(jRExternalQueryRunner);
    }

    @Override
    public void setDHTML(boolean bl) throws RemoteException {
        this.jrengine.setDHTML(bl);
    }

    @Override
    public boolean loadReport() throws Exception {
        try {
            boolean bl = false;
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            bl = this.jrengine.loadReport();
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            return bl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
    }

    @Override
    public String getStatus() throws RemoteException {
        if (this.jrengine != null) {
            return this.jrengine.getStatus();
        }
        return null;
    }

    @Override
    public String getReason() throws RemoteException {
        if (this.jrengine != null) {
            return this.jrengine.getReason();
        }
        return null;
    }

    @Override
    public String getReasonWithThrowable() throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer(this.jrengine.getReason());
        Throwable throwable = this.jrengine.getThrowable();
        if (throwable != null) {
            stringBuffer.append("\n").append(SchdTools.getStackTraceString(throwable));
        }
        return stringBuffer.toString();
    }

    @Override
    public void getPageAcl() throws RemoteException {
        this.arraycopy = this.jrengine.getPageACL();
    }

    @Override
    public boolean isPageAcl() throws RemoteException {
        return this.arraycopy != null;
    }

    @Override
    public void writeACL(String string) throws RemoteException, Exception {
        this.arraycopy.write((OutputStream)new FileOutputStream(string));
    }

    @Override
    public int[] getPages() throws RemoteException {
        return this.jrengine.getPages();
    }

    @Override
    public void engineExit() throws RemoteException {
        if (this.clear) {
            return;
        }
        this.engineExit(false, true);
    }

    @Override
    public synchronized void engineExit(boolean bl, boolean bl2) throws RemoteException {
        this.clear = bl;
        try {
            if (this.catKey != null) {
                UserDataToolkit.getJDataService(this.createRemoteTaskListener).unregistCatalog(this.catKey);
            }
        }
        catch (DSException dSException) {
            ServiceLogger.logError(dSException, 3);
        }
        if (!this.createDefaultRuntimeInfo && this.copyFromRemote != null) {
            this.copyFromRemote.free();
        }
        this.copyFromRemote = null;
        if (this.ThreadException != null && bl2) {
            try {
                this.ThreadException.free(bl);
                this.ThreadException = null;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        if (bl) {
            this.interruptNonBurstingThread();
        }
        if (this.jrengine != null) {
            this.jrengine.removeEngineListener((EngineErrorListener)this);
            if (bl2) {
                try {
                    this.jrengine.exit();
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            ServiceLogger.logDebug(4600196, new Object[]{new Integer(this.jrengine.getID())}, 4);
        }
        if (this.burstingExecutor != null) {
            this.burstingExecutor.exit();
        } else {
            this.dequeueEngine();
        }
        if (this.taskListener != null) {
            this.taskListener.quit();
            if (this.taskListener instanceof JRRemoteTaskListener) {
                try {
                    UnicastRemoteObject.unexportObject(this.taskListener, false);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    ServiceLogger.logError(noSuchObjectException, 3);
                }
            }
            this.taskListener = null;
        }
        if (this.append != null) {
            for (int i = 0; i < this.append.length; ++i) {
                if (this.append[i] == null) continue;
                this.append[i] = null;
            }
            if (this.burstingExecutor == null) {
                this.append = null;
            }
        }
        this.burstingExecutor = null;
        this.jrengine = null;
        this.available = null;
        if (this.equals != null) {
            this.equals.clear();
            this.equals = null;
        }
    }

    public void dequeueEngine() {
        this.decRptSetEngineRef();
        EngineQueueElement[] engineQueueElementArray = null;
        engineQueueElementArray = this.currentThread == null ? this.addNonBurstingResultListener : this.decRptSetEngineRef;
        for (int i = 0; i < engineQueueElementArray.length; ++i) {
            if (engineQueueElementArray[i].getStatus() == 4) continue;
            this.decRptEngineRef(this.append[i], engineQueueElementArray[i]);
        }
    }

    @Override
    public void stopEngineReport() throws RemoteException {
        this.jrengine.stopReport();
    }

    @Override
    public int getIOTime() throws RemoteException {
        return 0;
    }

    @Override
    public int getProcessTime() throws RemoteException {
        return 0;
    }

    @Override
    public boolean getBooleanReturnValue(String string) throws RemoteException {
        return this.jrengine.getBooleanReturnValue(string);
    }

    private int _cat() {
        int n = 0;
        for (String string : this.addEngineListener) {
            if (string == null) continue;
            int n2 = 0;
            Communicator communicator = this.jrengine.getCommunicator(string);
            if (communicator == null || (n2 = communicator.getPageNum()) <= 0) continue;
            n += n2;
        }
        return n;
    }

    @Override
    public Hashtable getJREngineProperty() {
        if (this.jrengine == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SingleThread", String.valueOf(this.jrengine.getSingleThread()));
        String string = this.jrengine.getSID();
        if (string != null) {
            hashtable.put("SID", string);
        }
        int n = 0;
        if (this.burstingExecutor == null) {
            if (this.addEngineListener != null) {
                n = this._cat();
            } else {
                n = this.jrengine.getTotalPageNumber();
                if (n < 0) {
                    n = 0;
                }
            }
        }
        hashtable.put("totalPageNumber", String.valueOf(n));
        hashtable.put("reason", String.valueOf(this.jrengine.getReason()));
        hashtable.put("IOTime", "0");
        hashtable.put("processTime", "0");
        hashtable.put("status", this.jrengine.getStatus());
        return hashtable;
    }

    @Override
    public void setAllowFFP(boolean bl) throws RemoteException {
        this.jrengine.setAllowFFP(bl);
    }

    @Override
    public void setSecurityContext(SecurityContext securityContext) throws RemoteException {
        this.jrengine.setSecurityContext(securityContext);
    }

    @Override
    public void setStableSecurityData(SecurityData securityData) throws RemoteException {
        this.jrengine.setEngineStableSecurityData(securityData);
    }

    @Override
    public void setAuthencatorMessage(String string, String string2, String string3) throws RemoteException {
        this.jrengine.setAuthencatorMessage(string, string2, string3);
    }

    @Override
    public void setJndiConnection(String string, String string2, String string3, String string4) throws RemoteException, Exception {
        this.jrengine.setJNDIConnection(string, string2, string3, string4);
    }

    @Override
    public void setJndiConnection(String string, String string2, String string3, String string4, String string5) throws RemoteException, Exception {
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("catDS=" + string + ",connName=" + string2 + ",jndiDS=" + string3 + ",dsUser=" + string4 + ",dsPswd=******", new Object[0]);
        }
        this.jrengine.setJNDIConnection(string, string2, string3, string4, string5);
    }

    @Override
    public void setConnectionInfoProvider(ConnectionInfoProvider connectionInfoProvider) throws RemoteException {
        this.jrengine.setConnectionInfoProvider(connectionInfoProvider);
    }

    @Override
    public ReportSheetInfo getCurrentReport() throws RemoteException {
        ReportInfo reportInfo = this.jrengine.getCurrentReport();
        if (reportInfo != null) {
            return new JRReportSheetInfo(reportInfo);
        }
        return null;
    }

    @Override
    public Vector getReportsOfReportSet() throws RemoteException {
        Vector vector;
        Vector<JRReportSheetInfo> vector2 = null;
        try {
            vector = this.jrengine.getReportsOfReportSet();
        }
        catch (ReadFailureException readFailureException) {
            throw new RemoteException(readFailureException.getMessage());
        }
        if (vector != null) {
            vector2 = new Vector<JRReportSheetInfo>();
            for (int i = 0; i < vector.size(); ++i) {
                ReportInfo reportInfo = (ReportInfo)vector.elementAt(i);
                vector2.add(new JRReportSheetInfo(reportInfo));
            }
        }
        return vector2;
    }

    @Override
    public ReportSetEngine getReportSetEngine(String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception, RemoteException {
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        if (this.ThreadException == null) {
            this.ThreadException = new JRReportSetEngine(this, ReportSetEngineFactory.getReportSetEngine(this.jrengine, stringArray, stringArray2, stringArray3));
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)this.ThreadException, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
        }
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        return this.ThreadException;
    }

    private String[] _rpt(String[] stringArray, boolean[] blArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                bl = blArray[i];
                if (!bl) {
                    bl = this.isSharedDir(stringArray[i]);
                }
                stringArray2[i] = !bl ? this.getLocalName(stringArray[i]) : stringArray[i];
            }
        }
        return stringArray2;
    }

    @Override
    public ReportSetEngine getReportSetEngine(String[] stringArray, String[] stringArray2, boolean[] blArray, boolean[] blArray2, String[] stringArray3, boolean[] blArray3, boolean[] blArray4, String string, boolean bl) throws Exception, RemoteException {
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        if (this.ThreadException == null) {
            String[] stringArray4 = this._rpt(stringArray2, blArray2);
            String[] stringArray5 = this._rpt(stringArray3, blArray4);
            this.ThreadException = new JRReportSetEngine(this, ReportSetEngineFactory.getReportSetEngine(this.jrengine, stringArray, stringArray4, blArray, stringArray5, blArray3, string, bl));
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)this.ThreadException, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
        }
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        return this.ThreadException;
    }

    public ReportSetEngine getBurstingReportSetEngine(String[] stringArray, boolean[] blArray, boolean[] blArray2, String[] stringArray2, boolean[] blArray3, boolean[] blArray4, DataBlock[] dataBlockArray, boolean bl, String string) throws Exception, RemoteException {
        String[] stringArray3;
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        String[] stringArray4 = this._rpt(stringArray, blArray2);
        String[] stringArray5 = this._rpt(stringArray2, blArray4);
        if (bl) {
            stringArray3 = this.containsKey;
        } else {
            String[] stringArray6 = new String[1];
            stringArray3 = stringArray6;
            stringArray6[0] = string;
        }
        this.ThreadException = new JRReportSetEngine(this, ReportSetEngineFactory.getBurstingReportSetEngine(this.jrengine, this.failToPrepareData, stringArray4, blArray, stringArray5, blArray3, stringArray3, dataBlockArray, bl));
        if (ServerEnv.shouldStartRMI()) {
            UnicastRemoteObject.exportObject((Remote)this.ThreadException, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        }
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        return this.ThreadException;
    }

    public void getTaskListener(String string) throws RemoteException {
        if (this.taskListener == null) {
            this.taskListener = this.manager.createRemoteTaskListener(string);
        }
    }

    public String getReportName() {
        return this._rpt;
    }

    public void noteError(Thread thread, Throwable throwable, int n, String string) {
        try {
            String string2 = "errorType=" + n + ";detectorThread=" + thread + ";msg=" + string;
            ServiceLogger.logError(throwable);
            if (this.taskListener != null) {
                this.taskListener.noteError(string2, throwable, n);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void notifyReceiver(EngineErrorListener engineErrorListener) {
    }

    public void ThreadException(Thread thread, Throwable throwable) {
        try {
            if (thread != null) {
                this.taskListener.ThreadException(thread.toString(), throwable);
            } else {
                this.taskListener.ThreadException(null, throwable);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void engineMassage(String string) {
        try {
            this.taskListener.engineMassage(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void started() {
        try {
            this.taskListener.started();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
        }
    }

    public void finished() {
        try {
            this.taskListener.finished();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void setUnvAndRpt(JetUUniverse jetUUniverse, JetRptReportPanel jetRptReportPanel) {
        this.jrengine.setUnvAndRpt(jetUUniverse, jetRptReportPanel);
    }

    public String toString() {
        return super.toString() + "-[jrengine:" + this.jrengine + "]";
    }

    public String getTempDir() {
        return this.rscMan.getTempDir();
    }

    @Override
    public void setIsHtmlPipeLine(boolean bl) {
        this.jrengine.setIsPipe(bl);
    }

    @Override
    public void setNLSBundleInfo(NLSBundleInfo nLSBundleInfo) throws RemoteException {
        this.jrengine.getNLSApplyParamInfo().setNLSBoundleInfo(nLSBundleInfo);
    }

    @Override
    public RuntimeInfo getRuntimeInfo(String string) {
        RuntimeInfo runtimeInfo = this.jrengine.getRuntimeInfo(string);
        if (runtimeInfo == null) {
            runtimeInfo = EngineRuntimeInfo.createDefaultRuntimeInfo();
        }
        return runtimeInfo;
    }

    @Override
    public void setRuntimeInfo(String string, boolean bl, String string2) throws RemoteException {
        RuntimeInfo runtimeInfo = this.jrengine.getRuntimeInfo(string);
        if (runtimeInfo == null) {
            runtimeInfo = EngineRuntimeInfo.createDefaultRuntimeInfo();
        }
        runtimeInfo.setHighPrecision(bl);
        runtimeInfo.setExportStyleGroup(string2);
        this.jrengine.setRuntimeInfo(string, runtimeInfo);
    }

    @Override
    public void setIsLinkReport(String string, boolean bl) throws RemoteException {
        this.jrengine.setIsLinkReport(string, bl);
    }

    @Override
    public void setXmlStreamFactory(String string, InputStreamFactory inputStreamFactory) throws RemoteException {
        try {
            this.jrengine.setXmlStreamFactory(string, inputStreamFactory);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RemoteException(jRScheduleException.getMessage());
        }
    }

    @Override
    public void setHDSStreamFactory(String string, String string2, InputStreamFactory inputStreamFactory) throws RemoteException {
        try {
            this.jrengine.setHDSStreamFactory(string, string2, inputStreamFactory);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RemoteException(jRScheduleException.getMessage());
        }
    }

    @Override
    public boolean prepareBurstingData(String string, String[] stringArray, Properties properties, boolean bl, Properties properties2) throws ReadFailureException {
        this.endsWith = string;
        this.engineExit = this.add(this.endsWith);
        try {
            this.jrengine.initBurstingReportSetEngine(string);
        }
        catch (JRScheduleException jRScheduleException) {
            ServiceLogger.logError(2600231, jRScheduleException.getMessage(), 2);
            ServiceLogger.logError(jRScheduleException, 3);
            return false;
        }
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        if (stringArray2 == null) {
            bl2 = true;
            ReportInfo reportInfo = JRTUtil.getReportOfReportSet(this.jrengine, this.endsWith);
            BurstingSchema[] burstingSchemaArray = reportInfo.getBurstingSchemas();
            stringArray2 = new String[]{burstingSchemaArray[0].getName()};
        }
        this.burstingExecutor = new MultiBurstingExecutor(this.jrengine, this.elementAt, this.catKey, this.elements, string, properties, stringArray2, bl, bl2);
        if (bl) {
            this.close = new NonBurstingResultTaskThread(properties2, stringArray2, this);
            this.burstingExecutor.addNonBurstingResultListener(this.close);
        }
        this.burstingExecutor.setMaxFileNumberInFolder(ServerEnv.getMaxTempFileNumberInFolder());
        this.delete = new Hashtable();
        this.dequeueEngine = new Hashtable();
        this.exit = new Hashtable();
        this.clone = new PrepareBurstingDataThread(this);
        this.clone.setPriority(this.engineMassage);
        this.clone.start();
        if (this.close != null) {
            this.close.setPriority(this.engineMassage - 1);
            this.close.setName(Thread.currentThread().getName() + " Non-Bursting Result");
            this.close.start();
        }
        return true;
    }

    public void interruptNonBurstingThread() {
        if (this.close != null) {
            if (this.close.isStarted()) {
                this.close.stopExec();
            } else {
                this.close.interrupt();
            }
            this.close = null;
        }
    }

    @Override
    public String getDefaultSchema(String string) throws ReadFailureException {
        ReportInfo reportInfo = JRTUtil.getReportOfReportSet(this.jrengine, string);
        BurstingSchema[] burstingSchemaArray = reportInfo.getBurstingSchemas();
        return burstingSchemaArray[0].getName();
    }

    @Override
    public void setSelectedSchemas(String[] stringArray) throws RemoteException {
        this.containsKey = stringArray;
    }

    @Override
    public Object[] hasNextDataBlockSet() throws DSException {
        DataBlockSet dataBlockSet = this.burstingExecutor.getNextBurstingDataBlockSet();
        if (dataBlockSet != null) {
            Object[] objectArray = new Object[]{new Integer(dataBlockSet.getId()), dataBlockSet.getRecipients(), new Integer(dataBlockSet.getDataBlocks().length), this.addNonBurstingResultListener(dataBlockSet.getKeyStr()), dataBlockSet.getBurstingSchemaName()};
            ServiceLogger.logDebug(6600239, new Object[]{objectArray[0], dataBlockSet.getKeyStr(), objectArray[2]}, 6);
            this.delete.put(objectArray[0], dataBlockSet);
            DataBlock[] dataBlockArray = dataBlockSet.getDataBlocks();
            InputStream[] inputStreamArray = new InputStream[dataBlockArray.length];
            for (int i = 0; i < dataBlockArray.length; ++i) {
                try {
                    inputStreamArray[i] = dataBlockArray[i].getStream();
                    continue;
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 2);
                }
            }
            this.dequeueEngine.put(objectArray[0], inputStreamArray);
            return objectArray;
        }
        return null;
    }

    private String add(String string) {
        Vector vector;
        try {
            vector = this.jrengine.getReportsOfReportSet();
        }
        catch (ReadFailureException readFailureException) {
            return "";
        }
        for (int i = 0; i < vector.size(); ++i) {
            ReportInfo reportInfo = (ReportInfo)vector.elementAt(i);
            if (!reportInfo.getRptName().equals(string)) continue;
            return reportInfo.getRptDisplayName();
        }
        return "";
    }

    private String addNonBurstingResultListener(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.engineExit);
        stringBuffer.append("_").append(string);
        String string2 = stringBuffer.length() <= 60 ? stringBuffer.toString() : stringBuffer.substring(0, 60);
        return string2;
    }

    @Override
    public byte[] readDataBlock(int n, int n2) throws IOException {
        InputStream[] inputStreamArray = (InputStream[])this.dequeueEngine.get(new Integer(n));
        return this.append(inputStreamArray[n2]);
    }

    private byte[] append(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[32768];
        int n = inputStream.read(byArray, 0, 32768);
        if (n <= 32768) {
            if (n == -1) {
                n = 0;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    @Override
    public String getDataSetName(int n, int n2) throws RemoteException {
        DataBlockSet dataBlockSet = (DataBlockSet)this.delete.get(new Integer(n));
        DataBlock dataBlock = dataBlockSet.getDataBlocks()[n2];
        return dataBlock.getDataSetName();
    }

    @Override
    public String getSharedDataSetName(String string, int n) throws Exception, RemoteException {
        DataBlock[] dataBlockArray = this.burstingExecutor.getSharedDataBlocks(string);
        if (dataBlockArray[n] != null) {
            return dataBlockArray[n].getDataSetName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readSharedDataBlock(String string, int n, int n2) throws Exception, RemoteException {
        BufferedInputStream[] bufferedInputStreamArray;
        Object object;
        Object object2 = this.exit;
        synchronized (object2) {
            if (!this.exit.containsKey(string)) {
                object = this.burstingExecutor.getSharedDataBlocks(string);
                bufferedInputStreamArray = new BufferedInputStream[((DataBlock[])object).length];
                for (int i = 0; i < ((DataBlock[])object).length; ++i) {
                    if (object[i] == null) continue;
                    bufferedInputStreamArray[i] = new BufferedInputStream(object[i].getStream());
                    bufferedInputStreamArray[i].mark(bufferedInputStreamArray[i].available() + 1);
                }
                this.exit.put(string, bufferedInputStreamArray);
            }
            bufferedInputStreamArray = (BufferedInputStream[])this.exit.get(string);
        }
        object2 = bufferedInputStreamArray[n];
        if (object2 != null) {
            object = object2;
            synchronized (object) {
                ((BufferedInputStream)object2).reset();
                ((BufferedInputStream)object2).skip(n2);
                return this.append((InputStream)object2);
            }
        }
        return null;
    }

    @Override
    public int getSharedDataBlockNumber(String string) throws Exception, RemoteException {
        DataBlock[] dataBlockArray = this.burstingExecutor.getSharedDataBlocks(string);
        return dataBlockArray.length;
    }

    @Override
    public void notifyFinishedRunDataBlock(int n) throws RemoteException {
        this.delete.remove(new Integer(n));
        InputStream[] inputStreamArray = (InputStream[])this.dequeueEngine.remove(new Integer(n));
        for (int i = 0; i < inputStreamArray.length; ++i) {
            if (inputStreamArray[i] == null) continue;
            try {
                inputStreamArray[i].close();
                continue;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        this.burstingExecutor.runBurstingDataBlockFinished(n);
    }

    void failToPrepareData(Exception exception) throws RemoteException {
        if (this.taskListener != null) {
            this.taskListener.failToPrepareData(exception);
        }
    }

    public void setIsSubBurstingTask(String string) {
        this.exportObject = true;
        this.failToPrepareData = string;
    }

    public void setIsNonBurstingTask(String string) {
        this.failToPrepareData = string;
    }

    public boolean getIsSubBurstingTask() {
        return this.exportObject;
    }

    public void addSubTaskThreadListener(SubTaskThreadListener subTaskThreadListener) {
        this.finished = subTaskThreadListener;
    }

    @Override
    public boolean[][] isHasPLSandSecConstraint(String[] stringArray) throws RemoteException {
        boolean[][] blArray = new boolean[2][stringArray.length];
        try {
            Vector vector = this.jrengine.getReportsOfReportSet();
            if (vector != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        ReportInfo reportInfo = (ReportInfo)enumeration.nextElement();
                        if (!reportInfo.getRptName().equals(stringArray[i])) continue;
                        blArray[0][i] = reportInfo.hasPLS();
                        blArray[1][i] = reportInfo.hasCLS() || reportInfo.hasRLS();
                    }
                }
            }
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
        }
        return blArray;
    }

    @Override
    public ResourceStore getResourceStore() {
        return JRServerResourceStoreFactory.getInstance().getResourceStore(this.createRemoteTaskListener);
    }

    @Override
    public void setSecurityProvider(ISecurityProvider iSecurityProvider) {
        this.jrengine.setSecurityProvider(iSecurityProvider);
    }

    public ThreadQueueController getThreadQueueController() {
        return this.currentThread;
    }
}

