/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.http;

import jet.server.api.SystemPerformanceInfo;
import jet.server.api.cluster.Member;

class PerformanceLoad {
    private Member SEDU;
    private int append = -1;
    private int doubleValue;
    private int getClass;
    private boolean getID;
    private SystemPerformanceInfo getMaxMemory;

    public PerformanceLoad(SystemPerformanceInfo systemPerformanceInfo) {
        this.getMaxMemory = systemPerformanceInfo;
        if (!(systemPerformanceInfo.getSystemLoadAverage() < 0.0)) {
            this.append = this.percent(systemPerformanceInfo.getSystemLoadAverage(), 1);
        } else {
            this.getID = true;
        }
        this.getClass = systemPerformanceInfo.getThreadCount();
        this.getClass = this.getClass < 1 ? 1 : this.getClass;
        this.doubleValue = this.percent(systemPerformanceInfo.getUsedMemory(), systemPerformanceInfo.getMaxMemory() == 0L ? 1L : systemPerformanceInfo.getMaxMemory());
    }

    private int percent(Number number, Number number2) {
        int n = (int)(100.0 * number.doubleValue() / number2.doubleValue());
        n = Math.max(0, n);
        n = Math.min(100, n);
        return n;
    }

    public void adjustCpu(PerformanceLoad performanceLoad) {
        if (this.append == -1) {
            if (performanceLoad == this) {
                this.append = 50;
            } else {
                int n = this.percent(this.getThreadCount(), performanceLoad.getThreadCount());
                this.append = n * performanceLoad.append / 100;
            }
        }
    }

    public void setMember(Member member) {
        this.SEDU = member;
    }

    public Member getMember() {
        return this.SEDU;
    }

    public int getCpuUsage() {
        return this.append;
    }

    public int getMemoryUsage() {
        return this.doubleValue;
    }

    public int getThreadCount() {
        return this.getClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": mbr=" + (this.SEDU == null ? "" : Integer.valueOf(this.SEDU.getID())) + ", cpu=" + this.append + (this.getID ? "*" : "") + ", memory=" + this.doubleValue + ", performanceInfo=" + this.getMaxMemory;
    }
}

