/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.param;

import java.io.File;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.RptServerException;
import jet.server.jrc.param.DecisionManager;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;

public class ParameterFileManager {
    private DecisionManager HISTORY;
    private String SEDU;
    private JRRptServer add;
    private static ParameterFileManager append;

    public static ParameterFileManager getInstance(JRRptServer jRRptServer) {
        if (append == null) {
            append = new ParameterFileManager(jRRptServer);
        }
        return append;
    }

    public static ParameterFileManager getInstance() {
        return append;
    }

    private void HISTORY() {
        this.HISTORY = new DecisionManager(this.add);
        this.SEDU = this.add.getResourceManager().getHistDir();
    }

    private ParameterFileManager(JRRptServer jRRptServer) {
        this.add = jRRptServer;
        this.HISTORY();
    }

    public void promoteToShareMemoryNode() {
        this.HISTORY.promoteToShareMemoryNode();
    }

    public void delete(String string) throws RptServerException {
        if (string != null && string.trim().length() > 0) {
            File file = null;
            try {
                file = StorageEnv.getStorage().get(Storage.StorageRoot.HISTORY, string);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
            if (file == null) {
                File file2 = new File(this.SEDU, string);
                file2.delete();
            } else if (this.HISTORY.decideDelete(string)) {
                File file3 = new File(this.SEDU, string);
                file3.delete();
                try {
                    StorageEnv.getStorage().delete(Storage.StorageRoot.HISTORY, string);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable, 3);
                }
            }
        }
    }

    public void delete(String string, boolean bl) throws RptServerException {
        if (string != null && string.trim().length() > 0) {
            File file = null;
            try {
                file = StorageEnv.getStorage().get(Storage.StorageRoot.HISTORY, string);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
            if (file == null) {
                File file2 = new File(this.SEDU, string);
                file2.delete();
            } else if (this.HISTORY.decideDelete(string, bl)) {
                File file3 = new File(this.SEDU, string);
                file3.delete();
                try {
                    StorageEnv.getStorage().delete(Storage.StorageRoot.HISTORY, string);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable, 3);
                }
            }
        }
    }

    public void deleteUnused() throws RptServerException {
        try {
            File file = new File(this.SEDU);
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) continue;
                String string = file2.getName();
                if (CSUtil.getExtName(string).equalsIgnoreCase(".param")) {
                    this.delete(string, true);
                    continue;
                }
                if (!CSUtil.getExtName(string).equalsIgnoreCase(".dparam")) continue;
                this.delete(string, true);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    public void deleteUnused(boolean bl) throws RptServerException {
        Vector vector = new Vector();
        try {
            long l = System.currentTimeMillis();
            File file = new File(this.SEDU);
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) continue;
                String string = file2.getName();
                if (CSUtil.getExtName(string).equalsIgnoreCase(".param")) {
                    vector.add(string);
                    continue;
                }
                if (!CSUtil.getExtName(string).equalsIgnoreCase(".dparam")) continue;
                vector.add(string);
            }
            long l2 = System.currentTimeMillis();
            ServiceLogger.logDebug("List files consume time=" + (l2 - l));
            l = l2;
            vector = this.HISTORY.getCanDeleteFiles(vector);
            l2 = System.currentTimeMillis();
            ServiceLogger.logDebug("Filt files consume time=" + (l2 - l));
            l = l2;
            for (String string : vector) {
                File file3;
                if (string.trim().length() <= 0) continue;
                File file4 = null;
                try {
                    file4 = StorageEnv.getStorage().get(Storage.StorageRoot.HISTORY, string);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable, 3);
                }
                if (file4 == null) {
                    file3 = new File(this.SEDU, string);
                    file3.delete();
                    continue;
                }
                file3 = new File(this.SEDU, string);
                file3.delete();
                try {
                    StorageEnv.getStorage().delete(Storage.StorageRoot.HISTORY, string);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable, 3);
                }
            }
            l2 = System.currentTimeMillis();
            ServiceLogger.logDebug("Delete files consume time=" + (l2 - l));
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    public DecisionManager getDecisionManager() {
        return this.HISTORY;
    }

    public void setDecisionManager(DecisionManager decisionManager) {
        this.HISTORY = decisionManager;
    }

    public String getHistoryDir() {
        return this.SEDU;
    }

    public void setHistoryDir(String string) {
        this.SEDU = string;
    }

    public JRRptServer getRptServer() {
        return this.add;
    }

    public void setRptServer(JRRptServer jRRptServer) {
        this.add = jRRptServer;
    }
}

