/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.param;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.Dbs;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.version.ResultVersionTableImpl;
import jet.server.jrc.param.DeleteDecisionVoter;
import jet.server.log.ServiceLogger;

public class ResultVersionVotor
implements DeleteDecisionVoter {
    private Database EMPTY;
    private Hashtable SEDU;
    private final String add;

    public ResultVersionVotor(Database database) {
        this.EMPTY = database;
        this.add = Dbs.fullTableName(database.getProperty("schema"), "RESULTVERSION_3");
    }

    @Override
    public int voteDelete(Object object, boolean bl) throws RptServerException {
        if (ServerEnv.isRetainVersionParamFile()) {
            return -1;
        }
        Table table = this.EMPTY.tables(this.add);
        try {
            if (this.SEDU == null) {
                this.SEDU = new Hashtable();
                String string = ResultVersionTableImpl.colNames[12];
                Field[] fieldArray = new Field[]{table.fields(string).createClone()};
                Recordset recordset = table.query(fieldArray, null, ParameterMetaInfo.EMPTY, true);
                try {
                    while (recordset.next()) {
                        String string2 = recordset.getString(string);
                        if (string2 == null || string2.trim().length() == 0) continue;
                        this.SEDU.put(string2, string2);
                    }
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                finally {
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        recordset = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            if (this.SEDU.containsKey("" + object)) {
                return -1;
            }
            return 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    @Override
    public int voteDelete(Object object) throws RptServerException {
        if (this.SEDU != null) {
            this.SEDU.clear();
            this.SEDU = null;
        }
        if (ServerEnv.isRetainVersionParamFile()) {
            return -1;
        }
        Table table = this.EMPTY.tables(this.add);
        try {
            String string = ResultVersionTableImpl.colNames[1];
            String string2 = " where " + ResultVersionTableImpl.colNames[12] + " like ?";
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("fileName", object, 12);
            int n = table.queryCountValue(string, string2, parameterMetaInfo, true);
            if (n > 0) {
                return -1;
            }
            return 1;
        }
        catch (SQLException sQLException) {
            return -1;
        }
    }

    public Database getDatabase() {
        return this.EMPTY;
    }

    public void setDatabase(Database database) {
        this.EMPTY = database;
    }

    @Override
    public Vector getCanDeleteFiles(Vector vector) throws RptServerException {
        Vector<String> vector2 = new Vector<String>();
        if (ServerEnv.isRetainVersionParamFile()) {
            return vector2;
        }
        Table table = this.EMPTY.tables(this.add);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        try {
            String string = ResultVersionTableImpl.colNames[12];
            Field[] fieldArray = new Field[]{table.fields(string).createClone()};
            Recordset recordset = table.query(fieldArray, null, true);
            try {
                while (recordset.next()) {
                    String string2 = recordset.getString(string);
                    if (string2 == null || string2.trim().length() == 0) continue;
                    hashtable.put(string2, string2);
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                    recordset = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
            for (String string3 : vector) {
                if (hashtable.containsKey(string3)) continue;
                vector2.add(string3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return vector2;
    }
}

