/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.quartz;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.schedule.ExeTimeInfo;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JRCRDExpireQuartzTrigger
extends JRTrigger {
    private static final long serialVersionUID = 1324789560L;
    private static final int SEDU = 2299;
    private static final String before = "startTime";
    private static final String booleanValue = "endTime";
    private static final String currentTimeMillis = "nextFireTime";
    private static final String get = "previousFireTime";
    private static final String getDefaultTimeZone = "timesTriggered";
    private static final String getFireTimeAfter = "complete";
    private static final String getGC = "timezone";
    private static final String getInstance = "exeTime";
    private static final String getNextFireTime = "ht";
    private transient Date getProperty = null;
    private transient Date getStartTime = null;
    private transient Date getTime = null;
    private transient Date intValue = null;
    private transient int isTimeIncluded = 0;
    private transient boolean mayFireAgain = false;
    private transient String parseLong = CSUtil.getDefaultTimeZone();
    private transient GregorianCalendar put = null;
    private transient Properties refireImmediately = null;

    public JRCRDExpireQuartzTrigger(String string, String string2) {
        super(string, string2);
    }

    public void init(Properties properties, ExeTimeInfo exeTimeInfo) {
        this.refireImmediately = properties;
        if (exeTimeInfo != null) {
            this.put = exeTimeInfo.getGC();
        }
        String string = properties.getProperty("jrs.submit_time");
        long l = CSUtil.parseLong(string, System.currentTimeMillis());
        this.setStartTime(new Date(l));
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.getTime = this.getStartTime();
        this.getTime = this.getFireTimeAfter(this.getTime);
        while (this.getTime != null && calendar != null && !calendar.isTimeIncluded(this.getTime.getTime())) {
            this.getTime = this.getFireTimeAfter(this.getTime);
            if (this.getTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.getTime);
            if (calendar2.get(1) <= 2299) continue;
            return null;
        }
        return this.getTime;
    }

    public int executionComplete(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        if (jobExecutionException != null && jobExecutionException.refireImmediately()) {
            return 1;
        }
        if (jobExecutionException != null && jobExecutionException.unscheduleFiringTrigger()) {
            return 2;
        }
        if (jobExecutionException != null && jobExecutionException.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public Date getEndTime() {
        return this.getStartTime;
    }

    public Date getFinalFireTime() {
        return this.getProperty;
    }

    public Date getFireTimeAfter(Date date) {
        if (date.before(this.put.getTime())) {
            return this.put.getTime();
        }
        return date;
    }

    public Date getNextFireTime() {
        return this.getTime;
    }

    public Date getPreviousFireTime() {
        return this.intValue;
    }

    public Date getStartTime() {
        return this.getProperty;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public void setEndTime(Date date) {
        this.getStartTime = date;
    }

    public void setStartTime(Date date) {
        this.getProperty = date;
    }

    public void triggered(Calendar calendar) {
        ++this.isTimeIncluded;
        this.intValue = this.getTime;
        this.getTime = null;
    }

    public void updateAfterMisfire(Calendar calendar) {
        this.SEDU(null);
    }

    private void SEDU(Date date) {
        this.getTime = date;
    }

    public void updateWithNewCalendar(Calendar calendar, long l) {
        if (this.isTimeIncluded > 0 || calendar == null) {
            return;
        }
        Date date = new Date();
        if (date.before(this.put.getTime())) {
            this.getTime = this.put.getTime();
        } else {
            long l2 = date.getTime() - this.put.getTime().getTime();
            if (l2 <= l) {
                this.getTime = date;
            }
        }
    }

    protected boolean validateMisfireInstruction(int n) {
        return n == 0;
    }

    @Override
    protected void toProp() {
        super.toProp();
        if (null != this.getProperty) {
            this.props.put(before, this.getProperty);
        }
        if (null != this.getStartTime) {
            this.props.put(booleanValue, this.getStartTime);
        }
        if (null != this.getTime) {
            this.props.put(currentTimeMillis, this.getTime);
        }
        if (null != this.intValue) {
            this.props.put(get, this.intValue);
        }
        this.props.put(getDefaultTimeZone, (Object)this.isTimeIncluded);
        this.props.put(getFireTimeAfter, (Object)this.mayFireAgain);
        if (null != this.parseLong) {
            this.props.put(getGC, this.parseLong);
        }
        if (null != this.put) {
            this.props.put(getInstance, this.put);
        }
        if (null != this.refireImmediately) {
            this.props.put(getNextFireTime, this.refireImmediately);
        }
    }

    @Override
    protected void restoreFromProp() {
        super.restoreFromProp();
        this.getProperty = (Date)this.props.get(before);
        this.getStartTime = (Date)this.props.get(booleanValue);
        this.getTime = (Date)this.props.get(currentTimeMillis);
        this.intValue = (Date)this.props.get(get);
        this.isTimeIncluded = (Integer)this.props.get(getDefaultTimeZone);
        this.mayFireAgain = (Boolean)this.props.get(getFireTimeAfter);
        this.parseLong = (String)this.props.get(getGC);
        this.put = (GregorianCalendar)this.props.get(getInstance);
        this.refireImmediately = (Properties)this.props.get(getNextFireTime);
    }
}

