/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.quartz;

import guitools.toolkit.JDebug;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.log.ServiceLogger;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JRRepeatQuartzTrigger
extends JRTrigger {
    private static final long serialVersionUID = 134567854652478L;
    private static final int LINE = 2299;
    private static final String SEDU = "startTime";
    private static final String WARNING = "endTime";
    private static final String add = "nextFireTime";
    private static final String after = "previousFireTime";
    private static final String append = "timesTriggered";
    private static final String appendScript = "complete";
    private static final String before = "daysId";
    private static final String booleanValue = "isWeekday";
    private static final String charAt = "day";
    private static final String clone = "week";
    private static final String currentTimeMillis = "weekdays";
    private static final String digit = "isDay";
    private static final String equals = "month";
    private static final String get = "weekday";
    private static final String getBoolean = "isHourly";
    private static final String getDebugLevel = "isBetween";
    private static final String getDefaultTimeZone = "isBefore";
    private static final String getFireTimeAfter = "isMinutely";
    private static final String getID = "isAfter";
    private static final String getInstance = "hours";
    private static final String getMessage = "minutes";
    private static final String getMinimum = "atMin";
    private static final String getNextFireTime = "hour";
    private static final String getNextTime = "min";
    private static final String getStartTime = "isPM";
    private static final String getTime = "hour2";
    private static final String getTimeZone = "min2";
    private static final String intValue = "isPM2";
    private static final String isDigit = "afterYear";
    private static final String isEnable = "afterMonth";
    private static final String isTimeIncluded = "afterDay";
    private static final String length = "afterHour";
    private static final String logError = "afterMinute";
    private static final String longValue = "ceaseYear";
    private static final String mayFireAgain = "ceaseMonth";
    private static final String parseInt = "ceaseDay";
    private static final String parseLong = "ceaseHour";
    private static final String put = "ceaseMinute";
    private static final String refireImmediately = "submitTime";
    private static final String restoreFromProp = "timezone";
    private static final String set = "lastExeTime";
    private transient Date setNextFireTime = null;
    private transient Date setTime = null;
    private transient Date size = null;
    private transient Date toProp = null;
    private transient int toProperties = 0;
    private transient boolean toString = false;
    private transient int trim = 0;
    private transient boolean unscheduleAllTriggers = false;
    private transient int unscheduleFiringTrigger = 1;
    private transient int valueOf = 1;
    private transient boolean[] I = new boolean[]{false, true, false, false, false, false, false};
    private transient boolean Z = true;
    private transient int C = 1;
    private transient int B = 2;
    private transient boolean D = false;
    private transient boolean F = false;
    private transient boolean J = false;
    private transient boolean S = true;
    private transient boolean A = false;
    private transient int E = 1;
    private transient int G = 5;
    private transient int H = 0;
    private transient int K = 9;
    private transient int L = 0;
    private transient boolean M = false;
    private transient int N = 5;
    private transient int O = 0;
    private transient boolean P = true;
    private transient int Q = 0;
    private transient int R = 0;
    private transient int T = 0;
    private transient int U = 0;
    private transient int V = 0;
    private transient int W = 0;
    private transient int X = 0;
    private transient int Y = 0;
    private transient int i = 0;
    private transient int z = 0;
    private transient long c = 0L;
    private transient String b = CSUtil.getDefaultTimeZone();
    private transient long d = 0L;

    public JRRepeatQuartzTrigger(String string, String string2) {
        super(string, string2);
    }

    public Date computeFirstFireTime(Calendar calendar) {
        if (null == this.size) {
            this.size = this.getStartTime();
            this.size = this.getFireTimeAfter(this.size);
            Date date = new Date();
            while (null != this.size && date.after(this.size)) {
                this.size = this.getFireTimeAfter(this.size);
            }
            while (this.size != null && calendar != null && !calendar.isTimeIncluded(this.size.getTime())) {
                this.size = this.getFireTimeAfter(this.size);
                if (this.size == null) break;
                java.util.Calendar calendar2 = java.util.Calendar.getInstance();
                calendar2.setTime(this.size);
                if (calendar2.get(1) <= 2299) continue;
                return null;
            }
        }
        return this.size;
    }

    public int executionComplete(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        if (jobExecutionException != null && jobExecutionException.refireImmediately()) {
            return 1;
        }
        if (jobExecutionException != null && jobExecutionException.unscheduleFiringTrigger()) {
            return 2;
        }
        if (jobExecutionException != null && jobExecutionException.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public Date getEndTime() {
        return this.setTime;
    }

    public Date getFinalFireTime() {
        if (this.setTime == null) {
            return null;
        }
        Date date = null;
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(this.setTime);
        while (date == null && this.setNextFireTime.before(calendar.getTime())) {
            calendar.add(5, -1);
            date = this.getFireTimeAfter(calendar.getTime());
        }
        return date;
    }

    public Date getFireTimeAfter(Date date) {
        if (date == null) {
            date = new Date();
        }
        if (this.toString) {
            return null;
        }
        GregorianCalendar gregorianCalendar = this.b == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.b));
        gregorianCalendar.setTime(date);
        return this.getNextTime(gregorianCalendar);
    }

    public Date getNextFireTime() {
        return this.size;
    }

    public Date getPreviousFireTime() {
        return this.toProp;
    }

    public void setPreviousFireTime(Date date) {
        this.toProp = date;
    }

    public Date getStartTime() {
        return this.setNextFireTime;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public void setEndTime(Date date) {
        this.setTime = date;
    }

    public void setStartTime(Date date) {
        this.setNextFireTime = date;
    }

    private void LINE(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(1) > 2299) {
            date = null;
        }
    }

    public void triggered(Calendar calendar) {
        ++this.toProperties;
        this.toProp = this.size;
        this.size = this.getFireTimeAfter(this.size);
        Date date = new Date();
        while (null != this.size && date.after(this.size)) {
            this.size = this.getFireTimeAfter(this.size);
        }
        while (this.size != null && calendar != null && !calendar.isTimeIncluded(this.size.getTime())) {
            this.size = this.getFireTimeAfter(this.size);
            if (this.size == null) break;
            this.LINE(this.size);
        }
    }

    public void updateAfterMisfire(Calendar calendar) {
        Date date = this.getFireTimeAfter(this.getNextFireTime());
        Date date2 = new Date();
        while (null != date && date2.after(date)) {
            date = this.getFireTimeAfter(date);
        }
        while (date != null && calendar != null && !calendar.isTimeIncluded(date.getTime()) && (date = this.getFireTimeAfter(date)) != null) {
            this.LINE(date);
        }
        this.setNextFireTime(date);
    }

    public void setNextFireTime(Date date) {
        this.size = date;
    }

    public void updateWithNewCalendar(Calendar calendar, long l) {
        this.size = this.getFireTimeAfter(this.toProp);
        if (this.size == null || calendar == null) {
            return;
        }
        Date date = new Date();
        while (this.size != null && !calendar.isTimeIncluded(this.size.getTime())) {
            long l2;
            this.size = this.getFireTimeAfter(this.size);
            if (this.size == null) break;
            this.LINE(this.size);
            if (this.size == null || !this.size.before(date) || (l2 = date.getTime() - this.size.getTime()) < l) continue;
            this.size = this.getFireTimeAfter(this.size);
        }
    }

    protected boolean validateMisfireInstruction(int n) {
        return n == 0;
    }

    public String setSchedule(Hashtable hashtable) {
        try {
            String string = (String)hashtable.get("jrs.days_id");
            this.trim = CSUtil.parseInt(string, 0);
            string = (String)hashtable.get("jrs.submit_time");
            this.c = CSUtil.parseLong(string, System.currentTimeMillis());
            switch (this.trim) {
                case 0: {
                    string = (String)hashtable.get("jrs.is_weekday");
                    this.unscheduleAllTriggers = CSUtil.getBoolean(string);
                    if (this.unscheduleAllTriggers) break;
                    string = (String)hashtable.get("jrs.day");
                    this.unscheduleFiringTrigger = CSUtil.parseInt(string, 1);
                    break;
                }
                case 1: {
                    int n;
                    string = (String)hashtable.get("jrs.week");
                    this.valueOf = CSUtil.parseInt(string, 1);
                    string = (String)hashtable.get("jrs.weekdays");
                    for (n = 0; n < 7; ++n) {
                        this.I[n] = false;
                    }
                    if (string == null) break;
                    n = -1;
                    int n2 = string.length();
                    for (int i = 0; i < n2; ++i) {
                        char c = string.charAt(i);
                        if (!Character.isDigit(c) || (n = Character.digit(c, 10)) < 0 || n >= 7) continue;
                        this.I[n] = true;
                    }
                    break;
                }
                case 2: {
                    string = (String)hashtable.get("jrs.is_day");
                    this.Z = CSUtil.getBoolean(string);
                    if (this.Z) {
                        string = (String)hashtable.get("jrs.day");
                        this.unscheduleFiringTrigger = CSUtil.parseInt(string, 1);
                    } else {
                        string = (String)hashtable.get("jrs.week");
                        this.valueOf = CSUtil.parseInt(string, 1);
                        string = (String)hashtable.get("jrs.weekday");
                        this.B = CSUtil.parseInt(string, 2);
                    }
                    string = (String)hashtable.get("jrs.month");
                    this.C = CSUtil.parseInt(string, 1);
                    break;
                }
                default: {
                    return JCliResource.getMessage("CS_ERR_72");
                }
            }
            if ((string = (String)hashtable.get("jrs.timezone")) != null && string.trim().length() > 0) {
                this.b = string;
            }
            string = (String)hashtable.get("jrs.is_hourly");
            this.D = CSUtil.getBoolean(string);
            if (this.D) {
                string = (String)hashtable.get("jrs.hours");
                this.E = CSUtil.parseInt(string, 1);
                string = (String)hashtable.get("jrs.at_min");
                this.H = CSUtil.parseInt(string, 0);
            } else {
                string = (String)hashtable.get("jrs.is_minutely");
                this.S = CSUtil.getBoolean(string);
                if (this.S) {
                    string = (String)hashtable.get("jrs.minutes");
                    this.G = CSUtil.parseInt(string, 5);
                }
            }
            if (this.D || this.S) {
                string = (String)hashtable.get("jrs.is_between");
                this.F = CSUtil.getBoolean(string);
                if (this.F) {
                    string = (String)hashtable.get("jrs.hour");
                    this.K = CSUtil.parseInt(string, 9);
                    string = (String)hashtable.get("jrs.min");
                    this.L = CSUtil.parseInt(string, 0);
                    string = (String)hashtable.get("jrs.is_pm");
                    this.M = CSUtil.getBoolean(string);
                    string = (String)hashtable.get("jrs.hour2");
                    this.N = CSUtil.parseInt(string, 5);
                    string = (String)hashtable.get("jrs.min2");
                    this.O = CSUtil.parseInt(string, 0);
                    string = (String)hashtable.get("jrs.is_pm2");
                    this.P = CSUtil.getBoolean(string, true);
                }
            } else {
                string = (String)hashtable.get("jrs.hour");
                this.K = CSUtil.parseInt(string, 12);
                string = (String)hashtable.get("jrs.min");
                this.L = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.is_pm");
                this.M = CSUtil.getBoolean(string);
            }
            string = (String)hashtable.get("jrs.is_after");
            this.A = CSUtil.getBoolean(string);
            if (this.A) {
                string = (String)hashtable.get("jrs.exe_year");
                this.Q = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.exe_month");
                this.R = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.exe_day");
                this.T = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.exe_hour");
                this.U = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.exe_min");
                this.V = CSUtil.parseInt(string, 0);
                GregorianCalendar gregorianCalendar = this.b == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.b));
                gregorianCalendar.set(this.Q, this.R - 1, this.T, this.U, this.V, gregorianCalendar.getMinimum(13));
                this.setNextFireTime = gregorianCalendar.getTime();
            } else {
                this.setNextFireTime = new Date(this.c);
            }
            string = (String)hashtable.get("jrs.is_before");
            this.J = CSUtil.getBoolean(string);
            if (this.J) {
                string = (String)hashtable.get("jrs.cease_year");
                this.W = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.cease_month");
                this.X = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.cease_day");
                this.Y = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.cease_hour");
                this.i = CSUtil.parseInt(string, 0);
                string = (String)hashtable.get("jrs.cease_min");
                this.z = CSUtil.parseInt(string, 0);
                GregorianCalendar gregorianCalendar = this.b == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.b));
                gregorianCalendar.set(this.W, this.X - 1, this.Y, this.i, this.z, gregorianCalendar.getMinimum(13));
                this.setTime = gregorianCalendar.getTime();
            }
        }
        catch (Exception exception) {
            if (JDebug.getDebugLevel() != 0) {
                JDebug.WARNING((Throwable)exception);
            } else {
                ServiceLogger.logError(exception);
            }
            return JCliResource.getMessage("CS_ERR_72");
        }
        if (this.getNextTime() == null) {
            return JCliResource.getMessage("CS_ERR_71");
        }
        return null;
    }

    public Date getNextTime() {
        GregorianCalendar gregorianCalendar = this.b == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.b));
        return this.getNextTime(gregorianCalendar);
    }

    public Date getNextTime(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        if (this.A) {
            gregorianCalendar2 = this.booleanValue(gregorianCalendar2);
        }
        this.SEDU(gregorianCalendar2);
        GregorianCalendar gregorianCalendar3 = (GregorianCalendar)gregorianCalendar2.clone();
        gregorianCalendar3.set(14, gregorianCalendar3.getMinimum(14));
        gregorianCalendar3.set(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5), gregorianCalendar3.get(11), gregorianCalendar3.get(12), gregorianCalendar3.getMinimum(13));
        int n = 0;
        block5: do {
            switch (this.trim) {
                case 0: {
                    if (!this.unscheduleAllTriggers || this.isWeekday(gregorianCalendar3)) break;
                    gregorianCalendar3 = this.clone(gregorianCalendar3);
                    continue block5;
                }
                case 1: {
                    if (this.currentTimeMillis(gregorianCalendar3)) break;
                    gregorianCalendar3 = this.digit(gregorianCalendar3);
                    continue block5;
                }
                case 2: {
                    if (this.Z) {
                        if (this.equals(gregorianCalendar3)) break;
                        gregorianCalendar3 = this.get(gregorianCalendar3);
                        continue block5;
                    }
                    if (this.getBoolean(gregorianCalendar3)) break;
                    gregorianCalendar3 = this.getDebugLevel(gregorianCalendar3);
                    continue block5;
                }
                default: {
                    Properties properties = this.toProperties(null);
                    Exception exception = new Exception("Invailid value of jrs.days_id: " + this.trim + "! \n" + properties + "\ncurr=" + gregorianCalendar2 + " \ncurr.getTime()=" + gregorianCalendar2.getTime() + "\nnext=" + gregorianCalendar3 + "\nnext.getTime()=" + gregorianCalendar3.getTime());
                    if (JDebug.getDebugLevel() != 0) {
                        JDebug.WARNING((Throwable)exception);
                    } else {
                        ServiceLogger.logError(exception);
                    }
                    return null;
                }
            }
            if (this.D || this.S) {
                if (this.D && !this.WARNING(gregorianCalendar3)) {
                    this.add(gregorianCalendar3);
                    continue;
                }
                if (this.F && !this.isBetween(gregorianCalendar3)) {
                    gregorianCalendar3 = this.charAt(gregorianCalendar3);
                    continue;
                }
                if (this.D && !this.WARNING(gregorianCalendar3)) {
                    this.add(gregorianCalendar3);
                    continue;
                }
                if (!gregorianCalendar3.before(gregorianCalendar2) && !gregorianCalendar3.equals(gregorianCalendar2)) break;
                if (this.D) {
                    gregorianCalendar3.add(11, this.E);
                } else {
                    gregorianCalendar3.add(12, this.G);
                }
                gregorianCalendar3.set(14, gregorianCalendar3.getMinimum(14));
                gregorianCalendar3.set(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5), gregorianCalendar3.get(11), gregorianCalendar3.get(12), gregorianCalendar3.getMinimum(13));
                continue;
            }
            if (!this.after(gregorianCalendar3)) {
                this.append(gregorianCalendar3);
                continue;
            }
            if (!gregorianCalendar3.before(gregorianCalendar2) && !gregorianCalendar3.equals(gregorianCalendar2)) break;
            gregorianCalendar3.add(5, this.getID());
            gregorianCalendar3.set(14, gregorianCalendar3.getMinimum(14));
            gregorianCalendar3.set(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5), gregorianCalendar3.getMinimum(11), gregorianCalendar3.getMinimum(12), gregorianCalendar3.getMinimum(13));
        } while (n++ < 2000);
        if (n > 2000) {
            Exception exception = new Exception("Can not get the next time of the schedule: " + this.toProperties(null) + "\ncurr=" + gregorianCalendar2 + " \ncurr.getTime()=" + gregorianCalendar2.getTime() + "\nnext=" + gregorianCalendar3 + "\nnext.getTime()=" + gregorianCalendar3.getTime());
            if (JDebug.getDebugLevel() != 0) {
                JDebug.WARNING((Throwable)exception);
            } else {
                ServiceLogger.logError(exception);
            }
            return null;
        }
        if (this.J) {
            GregorianCalendar gregorianCalendar4 = this.b == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.b));
            gregorianCalendar4.set(this.W, this.X - 1, this.Y, this.i, this.z, gregorianCalendar4.getMinimum(13));
            if (gregorianCalendar3.after(gregorianCalendar4)) {
                Exception exception = new Exception("next time [" + gregorianCalendar3.getTime() + "] after cease time [" + gregorianCalendar4.getTime() + "].");
                if (JDebug.getDebugLevel() != 0) {
                    JDebug.WARNING((Throwable)exception);
                } else {
                    ServiceLogger.logError(exception);
                }
                return null;
            }
        }
        return gregorianCalendar3.getTime();
    }

    private void SEDU(GregorianCalendar gregorianCalendar) {
        if (this.trim == 1) {
            int n;
            for (n = 0; n < 7 && !this.I[n]; ++n) {
            }
            if (n >= 7) {
                this.I[gregorianCalendar.get((int)7) - 1] = true;
            }
        }
    }

    private boolean WARNING(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(12) == this.H;
    }

    private GregorianCalendar add(GregorianCalendar gregorianCalendar) {
        gregorianCalendar.set(14, gregorianCalendar.getMinimum(14));
        gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), gregorianCalendar.get(11), this.H, gregorianCalendar.getMinimum(13));
        return gregorianCalendar;
    }

    private boolean after(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(11);
        int n2 = this.getFireTimeAfter(this.K, this.M);
        int n3 = gregorianCalendar.get(12);
        if (n == n2 && n3 == this.L) {
            return true;
        }
        if (1 == n - n2) {
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
            gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5), n2, gregorianCalendar2.get(12), gregorianCalendar2.getMinimum(13));
            int n4 = gregorianCalendar2.get(11);
            if (n2 != n4 && n == n4) {
                return true;
            }
        }
        return false;
    }

    private GregorianCalendar append(GregorianCalendar gregorianCalendar) {
        gregorianCalendar.set(14, gregorianCalendar.getMinimum(14));
        gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), this.getFireTimeAfter(this.K, this.M), this.L, gregorianCalendar.getMinimum(13));
        return gregorianCalendar;
    }

    private GregorianCalendar appendScript(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5), this.getFireTimeAfter(this.K, this.M), this.L, gregorianCalendar2.getMinimum(13));
        return gregorianCalendar2;
    }

    private GregorianCalendar before(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5), this.getFireTimeAfter(this.N, this.P), this.O, gregorianCalendar2.getMinimum(13));
        return gregorianCalendar2;
    }

    private GregorianCalendar booleanValue(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        if (this.A) {
            GregorianCalendar gregorianCalendar3 = (GregorianCalendar)gregorianCalendar2.clone();
            gregorianCalendar3.set(this.Q, this.R - 1, this.T, this.U, this.V, gregorianCalendar3.getMinimum(13));
            if (gregorianCalendar2.before(gregorianCalendar3)) {
                gregorianCalendar2 = gregorianCalendar3;
            }
        }
        return gregorianCalendar2;
    }

    private boolean isBetween(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        if ((this.D || this.S) && this.F) {
            GregorianCalendar gregorianCalendar3 = this.appendScript(gregorianCalendar);
            GregorianCalendar gregorianCalendar4 = this.before(gregorianCalendar);
            if (gregorianCalendar4.after(gregorianCalendar3) ? !(!gregorianCalendar2.after(gregorianCalendar3) && !gregorianCalendar2.equals(gregorianCalendar3) || !gregorianCalendar2.before(gregorianCalendar4) && !gregorianCalendar2.equals(gregorianCalendar4)) : gregorianCalendar2.after(gregorianCalendar3) || gregorianCalendar2.equals(gregorianCalendar3) || gregorianCalendar2.before(gregorianCalendar4) || gregorianCalendar2.equals(gregorianCalendar4)) {
                return true;
            }
        }
        return false;
    }

    private GregorianCalendar charAt(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        if ((this.D || this.S) && this.F) {
            GregorianCalendar gregorianCalendar3 = this.appendScript(gregorianCalendar);
            GregorianCalendar gregorianCalendar4 = this.before(gregorianCalendar);
            if (gregorianCalendar4.after(gregorianCalendar3)) {
                if (gregorianCalendar2.before(gregorianCalendar3)) {
                    gregorianCalendar2 = gregorianCalendar3;
                    if (this.D && gregorianCalendar2.get(12) > this.H) {
                        gregorianCalendar2.add(11, 1);
                        gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5), gregorianCalendar2.get(11), this.H, gregorianCalendar2.getMinimum(13));
                    }
                } else if (gregorianCalendar2.after(gregorianCalendar4)) {
                    gregorianCalendar2.add(5, this.getID());
                    gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5), this.getFireTimeAfter(this.K, this.M), this.L, gregorianCalendar2.getMinimum(13));
                }
            } else if (gregorianCalendar2.after(gregorianCalendar4) && gregorianCalendar2.before(gregorianCalendar3)) {
                gregorianCalendar2 = gregorianCalendar3;
                if (this.D && gregorianCalendar2.get(12) > this.H) {
                    gregorianCalendar2.add(11, 1);
                    gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5), gregorianCalendar2.get(11), this.H, gregorianCalendar2.getMinimum(13));
                }
            }
        }
        return gregorianCalendar2;
    }

    private boolean isWeekday(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(7);
        return n >= 2 && n <= 6;
    }

    private GregorianCalendar clone(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        int n = gregorianCalendar2.get(7);
        while (n < 2 || n > 6) {
            gregorianCalendar2.add(5, 1);
            n = gregorianCalendar2.get(7);
        }
        gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5), gregorianCalendar2.getMinimum(11), gregorianCalendar2.getMinimum(12), gregorianCalendar2.getMinimum(13));
        return gregorianCalendar2;
    }

    private boolean currentTimeMillis(GregorianCalendar gregorianCalendar) {
        return this.I[gregorianCalendar.get(7) - 1];
    }

    private GregorianCalendar digit(GregorianCalendar gregorianCalendar) {
        int n;
        gregorianCalendar.add(5, 1);
        int n2 = n = gregorianCalendar.get(7) - 1;
        if (n > 0) {
            while (n < 7 && !this.I[n]) {
                gregorianCalendar.add(5, 1);
                ++n;
            }
        }
        if (n == 0 || n >= 7) {
            for (n = 0; n < 7 && !this.I[n]; ++n) {
                gregorianCalendar.add(5, 1);
            }
        }
        if (n2 > gregorianCalendar.get(7)) {
            gregorianCalendar.add(4, this.valueOf - 1);
        }
        gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), gregorianCalendar.getMinimum(11), gregorianCalendar.getMinimum(12), gregorianCalendar.getMinimum(13));
        return gregorianCalendar;
    }

    private boolean equals(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(5);
        int n2 = this.getDefaultTimeZone(gregorianCalendar);
        return n == this.unscheduleFiringTrigger || this.unscheduleFiringTrigger > n2 && n == n2;
    }

    private GregorianCalendar get(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(5);
        int n2 = this.getDefaultTimeZone(gregorianCalendar);
        if (this.unscheduleFiringTrigger > n2) {
            if (n != n2) {
                gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), n2, gregorianCalendar.getMinimum(11), gregorianCalendar.getMinimum(12), gregorianCalendar.getMinimum(13));
            }
        } else if (n < this.unscheduleFiringTrigger) {
            gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), this.unscheduleFiringTrigger, gregorianCalendar.getMinimum(11), gregorianCalendar.getMinimum(12), gregorianCalendar.getMinimum(13));
        } else if (n > this.unscheduleFiringTrigger) {
            gregorianCalendar.add(2, this.C);
            n2 = this.getDefaultTimeZone(gregorianCalendar);
            gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), this.unscheduleFiringTrigger > n2 ? n2 : this.unscheduleFiringTrigger, gregorianCalendar.getMinimum(11), gregorianCalendar.getMinimum(12), gregorianCalendar.getMinimum(13));
        }
        return gregorianCalendar;
    }

    private boolean getBoolean(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(5);
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.getMinimum(5), gregorianCalendar2.getMinimum(11), gregorianCalendar2.getMinimum(12), gregorianCalendar2.getMinimum(13));
        int n2 = -1;
        int n3 = -1;
        int n4 = gregorianCalendar2.get(2);
        do {
            if (gregorianCalendar2.get(7) == this.B) {
                n3 = gregorianCalendar2.get(5);
                if (this.valueOf < 4 && ++n2 == this.valueOf) break;
            }
            gregorianCalendar2.add(5, 1);
        } while (gregorianCalendar2.get(2) == n4);
        return n3 == n;
    }

    private GregorianCalendar getDebugLevel(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(5);
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.getMinimum(5), gregorianCalendar2.getMinimum(11), gregorianCalendar2.getMinimum(12), gregorianCalendar2.getMinimum(13));
        int n2 = -1;
        int n3 = -1;
        int n4 = gregorianCalendar2.get(2);
        do {
            if (gregorianCalendar2.get(7) == this.B) {
                n3 = gregorianCalendar2.get(5);
                if (this.valueOf < 4 && ++n2 == this.valueOf) break;
            }
            gregorianCalendar2.add(5, 1);
        } while (gregorianCalendar2.get(2) == n4);
        if (n > n3) {
            gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.getMinimum(5), gregorianCalendar.getMinimum(11), gregorianCalendar.getMinimum(12), gregorianCalendar.getMinimum(13));
            gregorianCalendar.add(2, this.C);
        } else {
            gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), n3, gregorianCalendar.getMinimum(11), gregorianCalendar.getMinimum(12), gregorianCalendar.getMinimum(13));
        }
        return gregorianCalendar;
    }

    private int getDefaultTimeZone(GregorianCalendar gregorianCalendar) {
        int n;
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        int n2 = gregorianCalendar2.get(2);
        for (n = 29; n < 32; ++n) {
            gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), n, gregorianCalendar2.getMinimum(11), gregorianCalendar2.get(12), gregorianCalendar2.get(13));
            if (n2 == gregorianCalendar2.get(2)) continue;
            --n;
            break;
        }
        return n > 31 ? 31 : n;
    }

    private int getFireTimeAfter(int n, boolean bl) {
        int n2 = n == 12 ? 0 : n;
        return bl ? n2 + 12 : n2;
    }

    private int getID() {
        if (this.trim == 2 && this.Z && this.unscheduleFiringTrigger > 27) {
            return 27;
        }
        return this.unscheduleFiringTrigger;
    }

    public Properties toProperties(Properties properties) {
        Object object;
        boolean bl = false;
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("jrs.is_enabled", String.valueOf(super.isEnable()));
        properties.put("jrs.days_id", String.valueOf(this.trim));
        switch (this.trim) {
            case 0: {
                properties.put("jrs.is_weekday", String.valueOf(this.unscheduleAllTriggers));
                if (this.unscheduleAllTriggers) break;
                properties.put("jrs.day", String.valueOf(this.unscheduleFiringTrigger));
                break;
            }
            case 1: {
                properties.put("jrs.week", String.valueOf(this.valueOf));
                object = "";
                for (int i = 0; i < 7; ++i) {
                    if (!this.I[i]) continue;
                    object = (String)object + String.valueOf(i);
                }
                properties.put("jrs.weekdays", String.valueOf(object));
                break;
            }
            case 2: {
                properties.put("jrs.is_day", String.valueOf(this.Z));
                if (this.Z) {
                    properties.put("jrs.day", String.valueOf(this.unscheduleFiringTrigger));
                } else {
                    properties.put("jrs.week", String.valueOf(this.valueOf));
                    properties.put("jrs.weekday", String.valueOf(this.B));
                }
                properties.put("jrs.month", String.valueOf(this.C));
                break;
            }
            default: {
                bl = true;
            }
        }
        properties.put("jrs.is_hourly", String.valueOf(this.D));
        if (this.D) {
            properties.put("jrs.hours", String.valueOf(this.E));
            properties.put("jrs.at_min", String.valueOf(this.H));
        } else {
            properties.put("jrs.is_minutely", String.valueOf(this.S));
            if (this.S) {
                properties.put("jrs.minutes", String.valueOf(this.G));
            }
        }
        if (this.D || this.S) {
            properties.put("jrs.is_between", String.valueOf(this.F));
            if (this.F) {
                properties.put("jrs.hour", String.valueOf(this.K));
                properties.put("jrs.min", String.valueOf(this.L));
                properties.put("jrs.is_pm", String.valueOf(this.M));
                properties.put("jrs.hour2", String.valueOf(this.N));
                properties.put("jrs.min2", String.valueOf(this.O));
                properties.put("jrs.is_pm2", String.valueOf(this.P));
            }
        } else {
            properties.put("jrs.hour", String.valueOf(this.K));
            properties.put("jrs.min", String.valueOf(this.L));
            properties.put("jrs.is_pm", String.valueOf(this.M));
        }
        properties.put("jrs.is_after", String.valueOf(this.A));
        if (this.A) {
            properties.put("jrs.exe_year", String.valueOf(this.Q));
            properties.put("jrs.exe_month", String.valueOf(this.R));
            properties.put("jrs.exe_day", String.valueOf(this.T));
            properties.put("jrs.exe_hour", String.valueOf(this.U));
            properties.put("jrs.exe_min", String.valueOf(this.V));
        }
        properties.put("jrs.is_before", String.valueOf(this.J));
        if (this.J) {
            properties.put("jrs.cease_year", String.valueOf(this.W));
            properties.put("jrs.cease_month", String.valueOf(this.X));
            properties.put("jrs.cease_day", String.valueOf(this.Y));
            properties.put("jrs.cease_hour", String.valueOf(this.i));
            properties.put("jrs.cease_min", String.valueOf(this.z));
        }
        if (this.b != null) {
            object = new GregorianCalendar(TimeZone.getTimeZone(this.b));
            properties.put("jrs.timezone", ((GregorianCalendar)object).getTimeZone().getID());
        }
        if (bl) {
            object = new Exception("Invailid value of jrs.days_id: " + this.trim + "! \n" + properties);
            if (JDebug.getDebugLevel() != 0) {
                JDebug.WARNING((Throwable)object);
            } else {
                ServiceLogger.logError((Throwable)object);
            }
        }
        return properties;
    }

    public static String filterRepeatQuartzTriggerScriptItems(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector();
        CSUtil.appendScript(vector, hashtable, "jrs.launch_type", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_enabled", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_successful", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.timezone", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_after", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_minute", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_before", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_minute", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.days_id", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_weekday", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.week", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.weekdays", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_hourly", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hours", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.at_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_minutely", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.minutes", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_between", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_pm", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hour2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.min2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_pm2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.next_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_stat", true, bl);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.get(i)).append(CSUtil.LINE);
        }
        return stringBuffer.toString();
    }

    public long getLastExeTime() {
        return this.d;
    }

    public void setLastExeTime(long l) {
        this.d = l;
    }

    @Override
    protected void toProp() {
        super.toProp();
        if (null != this.setNextFireTime) {
            this.props.put(SEDU, this.setNextFireTime);
        }
        if (null != this.setTime) {
            this.props.put(WARNING, this.setTime);
        }
        if (null != this.size) {
            this.props.put(add, this.size);
        }
        if (null != this.toProp) {
            this.props.put(after, this.toProp);
        }
        this.props.put(append, (Object)this.toProperties);
        this.props.put(appendScript, (Object)this.toString);
        this.props.put(before, (Object)this.trim);
        this.props.put(booleanValue, (Object)this.unscheduleAllTriggers);
        this.props.put(charAt, (Object)this.unscheduleFiringTrigger);
        this.props.put(clone, (Object)this.valueOf);
        if (null != this.I) {
            this.props.put(currentTimeMillis, this.I);
        }
        this.props.put(digit, (Object)this.Z);
        this.props.put(equals, (Object)this.C);
        this.props.put(get, (Object)this.B);
        this.props.put(getBoolean, (Object)this.D);
        this.props.put(getDebugLevel, (Object)this.F);
        this.props.put(getDefaultTimeZone, (Object)this.J);
        this.props.put(getFireTimeAfter, (Object)this.S);
        this.props.put(getID, (Object)this.A);
        this.props.put(getInstance, (Object)this.E);
        this.props.put(getMessage, (Object)this.G);
        this.props.put(getMinimum, (Object)this.H);
        this.props.put(getNextFireTime, (Object)this.K);
        this.props.put(getNextTime, (Object)this.L);
        this.props.put(getStartTime, (Object)this.M);
        this.props.put(getTime, (Object)this.N);
        this.props.put(getTimeZone, (Object)this.O);
        this.props.put(intValue, (Object)this.P);
        this.props.put(isDigit, (Object)this.Q);
        this.props.put(isEnable, (Object)this.R);
        this.props.put(isTimeIncluded, (Object)this.T);
        this.props.put(length, (Object)this.U);
        this.props.put(logError, (Object)this.V);
        this.props.put(longValue, (Object)this.W);
        this.props.put(mayFireAgain, (Object)this.X);
        this.props.put(parseInt, (Object)this.Y);
        this.props.put(parseLong, (Object)this.i);
        this.props.put(put, (Object)this.z);
        this.props.put(refireImmediately, (Object)this.c);
        if (null != this.b) {
            this.props.put(restoreFromProp, this.b);
        }
        this.props.put(set, (Object)this.d);
    }

    @Override
    protected void restoreFromProp() {
        super.restoreFromProp();
        this.setNextFireTime = (Date)this.props.get(SEDU);
        this.setTime = (Date)this.props.get(WARNING);
        this.size = (Date)this.props.get(add);
        this.toProp = (Date)this.props.get(after);
        this.toProperties = (Integer)this.props.get(append);
        this.toString = (Boolean)this.props.get(appendScript);
        this.trim = (Integer)this.props.get(before);
        this.unscheduleAllTriggers = (Boolean)this.props.get(booleanValue);
        this.unscheduleFiringTrigger = (Integer)this.props.get(charAt);
        this.valueOf = (Integer)this.props.get(clone);
        this.I = (boolean[])this.props.get(currentTimeMillis);
        this.Z = (Boolean)this.props.get(digit);
        this.C = (Integer)this.props.get(equals);
        this.B = (Integer)this.props.get(get);
        this.D = (Boolean)this.props.get(getBoolean);
        this.F = (Boolean)this.props.get(getDebugLevel);
        this.J = (Boolean)this.props.get(getDefaultTimeZone);
        this.S = (Boolean)this.props.get(getFireTimeAfter);
        this.A = (Boolean)this.props.get(getID);
        this.E = (Integer)this.props.get(getInstance);
        this.G = (Integer)this.props.get(getMessage);
        this.H = (Integer)this.props.get(getMinimum);
        this.K = (Integer)this.props.get(getNextFireTime);
        this.L = (Integer)this.props.get(getNextTime);
        this.M = (Boolean)this.props.get(getStartTime);
        this.N = (Integer)this.props.get(getTime);
        this.O = (Integer)this.props.get(getTimeZone);
        this.P = (Boolean)this.props.get(intValue);
        this.Q = (Integer)this.props.get(isDigit);
        this.R = (Integer)this.props.get(isEnable);
        this.T = (Integer)this.props.get(isTimeIncluded);
        this.U = (Integer)this.props.get(length);
        this.V = (Integer)this.props.get(logError);
        this.W = (Integer)this.props.get(longValue);
        this.X = (Integer)this.props.get(mayFireAgain);
        this.Y = (Integer)this.props.get(parseInt);
        this.i = (Integer)this.props.get(parseLong);
        this.z = (Integer)this.props.get(put);
        this.c = (Long)this.props.get(refireImmediately);
        this.b = (String)this.props.get(restoreFromProp);
        this.d = (Long)this.props.get(set);
    }
}

