/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.lc;

import java.io.Serializable;
import java.util.Arrays;
import jet.server.api.lc.FieldInfo;
import jet.server.util.MD5;

public class JRFieldInfo
implements FieldInfo,
Serializable {
    private static final long serialVersionUID = 1103862182806968500L;
    private static final String SEDU = "/";
    private String catalog;
    private String dataSource;
    private String query;
    private String[] fieldDetails;
    private String fullPath;
    private String fieldName;
    private int type = 1;
    private String signature = null;

    public JRFieldInfo(String string, String string2, String string3, String[] stringArray) {
        if (string == null || string2 == null || string3 == null || stringArray == null || stringArray.length < 2) {
            throw new IllegalArgumentException();
        }
        this.catalog = string;
        this.dataSource = string2;
        this.query = string3;
        this.fieldDetails = stringArray;
        this.fieldName = stringArray[stringArray.length - 1];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(SEDU).append(string2).append(SEDU).append(string3);
        for (String string4 : stringArray) {
            stringBuilder.append(SEDU).append(string4);
        }
        this.fullPath = stringBuilder.toString();
        this.signature = MD5.getMD5Digest(this.fullPath);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JRFieldInfo)) {
            return false;
        }
        JRFieldInfo jRFieldInfo = (JRFieldInfo)object;
        if (this.catalog.equals(jRFieldInfo.catalog) && this.dataSource.equals(jRFieldInfo.dataSource) && this.query.equals(jRFieldInfo.query)) {
            return Arrays.equals(this.fieldDetails, jRFieldInfo.fieldDetails);
        }
        return false;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public String toString() {
        return this.fullPath;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String[] getFieldDetails() {
        return this.fieldDetails;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public int getType() {
        return this.type;
    }

    public String getSignature() {
        return this.signature;
    }
}

