/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.nls;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import jet.cs.CSUtil;
import jet.server.api.cluster.ClusterException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.nls.NLSType;
import jet.server.api.nls.TextNLSEntry;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.db.nls.ResourceNLSRecord;
import jet.server.db.nls.ResourceNLSTable;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.RemoteResourceNLSManager;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.JRDataService;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.security.admin.JOrganizationImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtils;

public class RemoteResourceNLSManagerImpl
implements RemoteResourceNLSManager {
    private static final String RESOURCE_NLS_MAP = "$";
    private static final String SEDU = "Root";
    private static final int UNDEFINED = -2;
    private ResourceNLSTable add = null;
    private ClusterMap addListener = null;
    private Map append = null;
    private List asList = null;
    private SecurityService contains;
    private ResourceTreeManagerImpl containsKey;

    public RemoteResourceNLSManagerImpl(JRDataService jRDataService, SecurityService securityService, final ResourceTreeManagerImpl resourceTreeManagerImpl) {
        this.contains = securityService;
        this.containsKey = resourceTreeManagerImpl;
        this.add = jRDataService.getResourceNLSTable();
        this.append = new ConcurrentHashMap();
        try {
            this.addListener = MapFactory.getMap(MapAttr.RESOURCE_NLS_MAP);
            this.addListener.addListener(new MapListenerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPut(String string, int n, String string2, ArrayList arrayList, ArrayList arrayList2, MapFlags mapFlags) {
                    if (1.isLocalEvent(n)) {
                        return;
                    }
                    ServiceLogger.logDebug("ResourceNLSManager: listened resourceNlsMap.afterPut: key is " + string2 + ",value is " + arrayList + ",prev is " + arrayList2, 7);
                    ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, ArrayList>> concurrentHashMap = null;
                    int n2 = string2.indexOf(RemoteResourceNLSManagerImpl.RESOURCE_NLS_MAP);
                    int n3 = Integer.parseInt(string2.substring(0, n2));
                    Node node = resourceTreeManagerImpl.getNodeByID(n3);
                    String string3 = node.getAbsolutePath();
                    String[] stringArray = CSUtil.parseVirtualResourcePath(string3);
                    Object object = RemoteResourceNLSManagerImpl.this.append;
                    synchronized (object) {
                        concurrentHashMap = (ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, ArrayList>>)RemoteResourceNLSManagerImpl.this.append.get(stringArray[0]);
                        if (concurrentHashMap == null) {
                            concurrentHashMap = new ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, ArrayList>>();
                            RemoteResourceNLSManagerImpl.this.append.put(stringArray[0], concurrentHashMap);
                        }
                    }
                    object = string2.substring(n2 + 1);
                    Locale locale = ServerUtil.getLocale((String)object);
                    ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, ArrayList>> concurrentHashMap2 = concurrentHashMap;
                    synchronized (concurrentHashMap2) {
                        ConcurrentHashMap<Integer, ArrayList> concurrentHashMap3 = (ConcurrentHashMap<Integer, ArrayList>)concurrentHashMap.get(locale);
                        if (concurrentHashMap3 == null) {
                            concurrentHashMap3 = new ConcurrentHashMap<Integer, ArrayList>();
                            concurrentHashMap.put(locale, concurrentHashMap3);
                        }
                        concurrentHashMap3.put(n3, arrayList);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRemove(String string, int n, String string2, ArrayList arrayList, MapFlags mapFlags) {
                    if (1.isLocalEvent(n)) {
                        return;
                    }
                    ServiceLogger.logDebug("ResourceNLSManager: listened resourceNlsMap.afterRemove: key is " + string2 + ",value is " + arrayList, 6);
                    int n2 = string2.indexOf(RemoteResourceNLSManagerImpl.RESOURCE_NLS_MAP);
                    int n3 = Integer.parseInt(string2.substring(0, n2));
                    Node node = resourceTreeManagerImpl.getNodeByID(n3);
                    String string3 = node.getAbsolutePath();
                    String[] stringArray = CSUtil.parseVirtualResourcePath(string3);
                    String string4 = string2.substring(n2 + 1);
                    Locale locale = ServerUtil.getLocale(string4);
                    Map map = null;
                    Map map2 = RemoteResourceNLSManagerImpl.this.append;
                    synchronized (map2) {
                        map = (Map)RemoteResourceNLSManagerImpl.this.append.get(stringArray[0]);
                    }
                    if (map != null) {
                        map2 = map;
                        synchronized (map2) {
                            Map map3 = (Map)map.get(locale);
                            if (map3 != null) {
                                map3.remove(n3);
                            }
                        }
                    }
                }
            });
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        this.RESOURCE_NLS_MAP();
    }

    private void RESOURCE_NLS_MAP() {
        try {
            HashMap hashMap = this.add.queryNLSLocales();
            for (String string : hashMap.keySet()) {
                ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                this.append.put(string, concurrentHashMap);
                List list = (List)hashMap.get(string);
                for (Locale locale : list) {
                    concurrentHashMap.put(locale, new ConcurrentHashMap());
                }
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public boolean isLegalLocale(Locale locale) {
        return this.getAvailableLocalesOfNLS().contains(locale);
    }

    public List getAvailableLocalesOfNLS() {
        Locale locale;
        if (this.asList != null) {
            return this.asList;
        }
        List<Locale> list = Arrays.asList(NLSUtil.sortLocale(Locale.getAvailableLocales()));
        ArrayList<Locale> arrayList = new ArrayList<Locale>(list);
        if (!arrayList.contains(locale = new Locale("", "", ""))) {
            arrayList.add(0, locale);
        }
        this.asList = arrayList;
        return arrayList;
    }

    @Override
    public List getAvailableLocales(String string) throws NoPrivilegeException, RemoteException {
        if (!this.contains.isAdminUser(string) && !this.contains.isOrganizationAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        Map map = (Map)this.append.get(string2);
        if (map != null) {
            LinkedList<Locale> linkedList = new LinkedList<Locale>();
            for (Locale locale : map.keySet()) {
                linkedList.add(locale);
            }
            return linkedList;
        }
        return null;
    }

    @Override
    public boolean containsLocale(Locale locale, String string) throws NoPrivilegeException, RemoteException {
        if (!this.contains.isAdminUser(string) && !this.contains.isOrganizationAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        Map map = (Map)this.append.get(string2);
        if (map != null) {
            return map.containsKey(locale);
        }
        return false;
    }

    private void SEDU(String string, String string2) throws NoPrivilegeException {
        String[] stringArray;
        boolean bl = false;
        String[] stringArray2 = CSUtil.parseVirtualResourcePath(string);
        if (StringUtils.equals(stringArray2[0], (stringArray = CSUtil.parsePrincipalDisplayName(string2))[0])) {
            bl = stringArray2[0] == null ? this.contains.isAdminUser(string2) : this.contains.isOrganizationAdminUser(string2);
        }
        if (!bl) {
            throw new NoPrivilegeException(630106, new Object[]{string2, string}, null);
        }
    }

    @Override
    public List getNLSEntriesInPath(Locale locale, String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.SEDU(string, string2);
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        String string3 = stringArray[0] == null ? "" : stringArray[0];
        Map map = (Map)this.append.get(string3);
        if (map == null || !map.containsKey(locale)) {
            return null;
        }
        Node node = this.containsKey.getNodeByPath(string);
        if (node.getNodeType() != 1) {
            return null;
        }
        ArrayList arrayList = this.UNDEFINED(locale, string3, node.getID());
        LinkedList<TextNLSEntry> linkedList = new LinkedList<TextNLSEntry>();
        if (arrayList != null) {
            for (TextNLSEntry textNLSEntry : arrayList) {
                TextNLSEntry textNLSEntry2 = new TextNLSEntry(NLSType.UNDEFINED, textNLSEntry.getKeyText(), textNLSEntry.getValueText());
                linkedList.add(textNLSEntry2);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList UNDEFINED(Locale locale, String string, int n) {
        ArrayList<TextNLSEntry> arrayList;
        ConcurrentHashMap concurrentHashMap;
        if (!this.isLegalLocale(locale)) {
            return null;
        }
        boolean bl = false;
        String string2 = string == null ? "" : string;
        ConcurrentHashMap concurrentHashMap2 = this.append;
        synchronized (concurrentHashMap2) {
            concurrentHashMap = (ConcurrentHashMap)this.append.get(string2);
            if (concurrentHashMap == null) {
                concurrentHashMap = new ConcurrentHashMap();
                this.append.put(string2, concurrentHashMap);
            }
        }
        concurrentHashMap2 = concurrentHashMap;
        synchronized (concurrentHashMap2) {
            ConcurrentHashMap concurrentHashMap3 = (ConcurrentHashMap)concurrentHashMap.get(locale);
            if (concurrentHashMap3 == null) {
                concurrentHashMap3 = new ConcurrentHashMap();
                concurrentHashMap.put(locale, concurrentHashMap3);
            }
            if ((arrayList = (ArrayList<TextNLSEntry>)concurrentHashMap3.get(n)) == null) {
                List list = null;
                try {
                    list = this.add.queryNLS(locale, n, string);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    return null;
                }
                arrayList = new ArrayList<TextNLSEntry>();
                for (ResourceNLSRecord resourceNLSRecord : list) {
                    arrayList.add(new TextNLSEntry(NLSType.UNDEFINED, resourceNLSRecord.getKeyText(), resourceNLSRecord.getValueText()));
                }
                concurrentHashMap3.put(n, arrayList);
                if (arrayList.size() > 0) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.addListener.put(this.add(locale, n), arrayList);
        }
        return arrayList;
    }

    private String add(Locale locale, int n) {
        return n + RESOURCE_NLS_MAP + locale.toString();
    }

    @Override
    public TextNLSEntry getNLSEntry(Locale locale, String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.SEDU(string, string2);
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        String string3 = stringArray[0] == null ? "" : stringArray[0];
        Map map = (Map)this.append.get(string3);
        if (map == null || !map.containsKey(locale)) {
            return null;
        }
        Node node = this.containsKey.getNodeByPath(string);
        String string4 = node.getName();
        Node node2 = node.getParent();
        if (node2.getNodeType() != 1) {
            return null;
        }
        int n = -1;
        if (!node.isRoot()) {
            n = node2.getID();
        }
        ArrayList arrayList = this.UNDEFINED(locale, string3, n);
        for (TextNLSEntry textNLSEntry : arrayList) {
            if (!textNLSEntry.getKeyText().equalsIgnoreCase(string4)) continue;
            return new TextNLSEntry(NLSType.UNDEFINED, textNLSEntry.getKeyText(), textNLSEntry.getValueText());
        }
        return null;
    }

    @Override
    public TextNLSEntry getRootNLSEntry(Locale locale, String string) throws NoPrivilegeException, RemoteException {
        if (!this.contains.isAdminUser(string) && !this.contains.isOrganizationAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        return this.getRootNLSEntry(locale);
    }

    public TextNLSEntry getRootNLSEntry(Locale locale) {
        Map map = (Map)this.append.get("");
        if (map == null || !map.containsKey(locale)) {
            return null;
        }
        ArrayList arrayList = this.UNDEFINED(locale, "", -2);
        for (TextNLSEntry textNLSEntry : arrayList) {
            if (!textNLSEntry.getKeyText().equalsIgnoreCase(SEDU)) continue;
            return new TextNLSEntry(NLSType.UNDEFINED, textNLSEntry.getKeyText(), textNLSEntry.getValueText());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLocale(Locale locale, String string) throws NoPrivilegeException, RemoteException {
        if (!this.contains.isAdminUser(string) && !this.contains.isOrganizationAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        Map map = (Map)this.append.get(string2);
        if (map != null && map.containsKey(locale)) {
            Map map2;
            ServiceLogger.logDebug("ResourceNLSManager.removeLocale(): locale=" + locale + ", submitter=" + string, 6);
            Object object = map;
            synchronized (object) {
                map2 = (Map)map.remove(locale);
            }
            if (map2 != null) {
                object = map2.keySet().iterator();
                while (object.hasNext()) {
                    int n = (Integer)object.next();
                    this.addListener.remove(this.add(locale, n));
                }
            }
            try {
                this.add.deleteNLS(locale, string2);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeNLSEntriesInPath(Locale locale, String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.SEDU(string, string2);
        Node node = this.containsKey.getNodeByPath(string);
        if (node.getNodeType() != 1) {
            return false;
        }
        int n = node.getID();
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        String string3 = stringArray[0] == null ? "" : stringArray[0];
        Map map = (Map)this.append.get(string3);
        if (map != null && this.append.containsKey(string3)) {
            ArrayList arrayList;
            ServiceLogger.logDebug("ResourceNLSManager.removeEntries(): locale=" + locale + ", path=" + string + ", submitter=" + string2, 6);
            Map map2 = (Map)map.get(locale);
            if (map2 != null && (arrayList = (ArrayList)map2.remove(n)) != null) {
                this.addListener.remove(this.add(locale, n));
                try {
                    this.add.deleteNLS(locale, n);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeNLSEntry(Locale locale, String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        String[] stringArray;
        this.SEDU(string, string2);
        Node node = this.containsKey.getNodeByPath(string);
        Node node2 = node.getParent();
        if (node2.getNodeType() != 1) {
            return false;
        }
        int n = -1;
        if (!node.isRoot()) {
            n = node2.getID();
        }
        String string3 = (stringArray = CSUtil.parseVirtualResourcePath(string))[0] == null ? "" : stringArray[0];
        ServiceLogger.logDebug("ResourceNLSManager.removeEntry(): locale=" + locale + ", resourcePath=" + string, 6);
        return this.addListener(locale, string3, n, node.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addListener(Locale locale, String string, int n, String string2) {
        ArrayList arrayList;
        Map map;
        Map map2 = (Map)this.append.get(string);
        boolean bl = false;
        if (map2 != null && map2.containsKey(locale) && (map = (Map)map2.get(locale)) != null && (arrayList = (ArrayList)map.remove(n)) != null) {
            TextNLSEntry textNLSEntry = null;
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                for (TextNLSEntry textNLSEntry2 : arrayList) {
                    if (!textNLSEntry2.getKeyText().equalsIgnoreCase(string2)) continue;
                    textNLSEntry = textNLSEntry2;
                    break;
                }
                if (textNLSEntry != null) {
                    bl = arrayList.remove(textNLSEntry);
                }
            }
            if (bl) {
                this.addListener.put(this.add(locale, n), arrayList);
                try {
                    this.add.deleteNLS(new ResourceNLSRecord(locale, n, textNLSEntry.getKeyText(), ""));
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeRootNLSEntry(Locale locale, String string) throws NoPrivilegeException, RemoteException {
        if (!this.contains.isAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        ServiceLogger.logDebug("ResourceNLSManager.removeRootNLS(): locale=" + locale, 6);
        return this.addListener(locale, "", -2, SEDU);
    }

    @Override
    public boolean updateNLSEntriesInPath(Locale locale, String string, List arrayList, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        TextNLSEntry textNLSEntry;
        String string3;
        Node node;
        this.SEDU(string, string2);
        if (!this.isLegalLocale(locale)) {
            return false;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<TextNLSEntry>();
        }
        if ((node = this.containsKey.getNodeByPath(string)).getNodeType() != 1) {
            return false;
        }
        int n = node.getID();
        ServiceLogger.logDebug("ResourceNLSManager.updateNLSEntries(): locale=" + locale + ", path=" + string, 6);
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        String string4 = string3 = stringArray[0] == null ? "" : stringArray[0];
        if (node.isRoot() && (textNLSEntry = this.getNLSEntry(locale, CSUtil.getVirtualResourcePathPrefix(stringArray[0]) + "/COMPONENT_LIB", string2)) != null && !arrayList.contains(textNLSEntry)) {
            arrayList.add(textNLSEntry);
        }
        this.append(locale, string3, n, arrayList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int append(Locale locale, String string, int n, List list) {
        ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, Object>> concurrentHashMap;
        Object object = this.append;
        synchronized (object) {
            concurrentHashMap = (ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, Object>>)this.append.get(string);
            if (concurrentHashMap == null) {
                concurrentHashMap = new ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, Object>>();
                this.append.put(string, concurrentHashMap);
            }
        }
        object = new ArrayList(list.size());
        ArrayList<ResourceNLSRecord> arrayList = new ArrayList<ResourceNLSRecord>(list.size());
        for (ConcurrentHashMap<Integer, Object> concurrentHashMap2 : list) {
            ((ArrayList)object).add(new TextNLSEntry(NLSType.UNDEFINED, ((TextNLSEntry)((Object)concurrentHashMap2)).getKeyText(), ((TextNLSEntry)((Object)concurrentHashMap2)).getValueText()));
            arrayList.add(new ResourceNLSRecord(locale, n, ((TextNLSEntry)((Object)concurrentHashMap2)).getKeyText(), ((TextNLSEntry)((Object)concurrentHashMap2)).getValueText()));
        }
        ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, Object>> concurrentHashMap3 = concurrentHashMap;
        synchronized (concurrentHashMap3) {
            ConcurrentHashMap<Integer, Object> concurrentHashMap2;
            concurrentHashMap2 = (Map)concurrentHashMap.get(locale);
            if (concurrentHashMap2 == null) {
                concurrentHashMap2 = new ConcurrentHashMap<Integer, Object>();
                concurrentHashMap.put(locale, concurrentHashMap2);
            }
            concurrentHashMap2.put(n, object);
        }
        this.addListener.put(this.add(locale, n), object);
        int n2 = 0;
        try {
            n2 = this.add.saveNLS(locale, string, n, arrayList);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n2;
    }

    @Override
    public boolean updateNLSEntry(Locale locale, String string, TextNLSEntry textNLSEntry, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.SEDU(string, string2);
        Node node = this.containsKey.getNodeByPath(string);
        Node node2 = node.getParent();
        if (node2.getNodeType() != 1) {
            return false;
        }
        int n = -1;
        if (!node.isRoot()) {
            n = node2.getID();
        }
        ServiceLogger.logDebug("ResourceNLSManager.updateNLSEntry(): locale=" + locale + ", resourcePath=" + string + ", entry=" + textNLSEntry, 6);
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        String string3 = stringArray[0] == null ? "" : stringArray[0];
        return this.asList(locale, string3, n, textNLSEntry);
    }

    private boolean asList(Locale locale, String string, int n, TextNLSEntry textNLSEntry) {
        Object object;
        TextNLSEntry textNLSEntry2 = null;
        ResourceNLSRecord resourceNLSRecord = null;
        if (textNLSEntry != null) {
            textNLSEntry2 = new TextNLSEntry(NLSType.UNDEFINED, textNLSEntry.getKeyText(), textNLSEntry.getValueText());
            resourceNLSRecord = new ResourceNLSRecord(locale, n, textNLSEntry.getKeyText(), textNLSEntry.getValueText());
        }
        ArrayList arrayList = this.UNDEFINED(locale, string, n);
        if (textNLSEntry2 != null) {
            arrayList.remove(textNLSEntry2);
            arrayList.add(textNLSEntry2);
            object = (Map)this.append.get(string);
            Map map = (Map)object.get(locale);
            map.put(n, arrayList);
            this.addListener.put(this.add(locale, n), arrayList);
        }
        object = new ArrayList(arrayList.size());
        for (TextNLSEntry textNLSEntry3 : arrayList) {
            ((ArrayList)object).add(new ResourceNLSRecord(locale, n, textNLSEntry3.getKeyText(), textNLSEntry3.getValueText()));
        }
        try {
            this.add.saveNLS(locale, string, n, (List)object);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return true;
    }

    @Override
    public boolean updateRootNLSEntry(Locale locale, TextNLSEntry textNLSEntry, String string) throws NoPrivilegeException, RemoteException {
        if (!this.contains.isAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        ServiceLogger.logDebug("ResourceNLSManager.updateRootNLSEntry(): locale=" + locale + ", entry=" + textNLSEntry, 6);
        return this.asList(locale, "", -2, textNLSEntry);
    }

    public void removeOrganization(String string) {
        ServiceLogger.logDebug("ResourceNLSManager.removeOrganization(): organization=" + string, 6);
        String string2 = string == null ? "" : string;
        Map map = (Map)this.append.remove(string2);
        if (map != null) {
            for (Locale locale : map.keySet()) {
                Map map2 = (Map)map.remove(locale);
                if (map2 == null) continue;
                Iterator iterator = map2.keySet().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    this.addListener.remove(this.add(locale, n));
                }
            }
        }
        try {
            this.add.deleteNLS(string2);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNLSDisplaysInPath(String string, int n) {
        ServiceLogger.logDebug("ResourceNLSManager.removeNLSDisplaysInPath(): organization=" + string + ", folderID=" + n, 6);
        String string2 = string == null ? "" : string;
        Map map = (Map)this.append.get(string2);
        if (map != null) {
            for (Locale locale : map.keySet()) {
                Map map2 = (Map)map.get(locale);
                if (map2 == null) continue;
                Map map3 = map2;
                synchronized (map3) {
                    map2.remove(n);
                }
                this.addListener.remove(this.add(locale, n));
            }
        }
        try {
            this.add.deleteNLS(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public void removeNLSDisplays(String string, int n, String string2) {
        ServiceLogger.logDebug("ResourceNLSManager.removeNLSDisplays(): organization=" + string + ", folderID=" + n + ", name=" + string2, 6);
        String string3 = string == null ? "" : string;
        Map map = (Map)this.append.get(string3);
        boolean bl = false;
        if (map != null) {
            for (Locale locale : map.keySet()) {
                boolean bl2;
                ArrayList arrayList;
                Map map2 = (Map)map.get(locale);
                if (map2 == null || (arrayList = (ArrayList)map2.get(n)) == null || !(bl2 = arrayList.remove(new TextNLSEntry(NLSType.UNDEFINED, string2)))) continue;
                this.addListener.put(this.add(locale, n), arrayList);
                bl = true;
            }
        }
        if (bl) {
            try {
                this.add.deleteNLS(n, string2);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
    }

    public Map getNLSDisplays(String string, int n, String string2) {
        String string3 = string == null ? "" : string;
        HashMap<Locale, String> hashMap = new HashMap<Locale, String>();
        Map map = (Map)this.append.get(string3);
        if (map != null) {
            block0: for (Locale locale : map.keySet()) {
                ArrayList arrayList = this.UNDEFINED(locale, string3, n);
                if (arrayList == null) continue;
                for (TextNLSEntry textNLSEntry : arrayList) {
                    if (!textNLSEntry.getKeyText().equalsIgnoreCase(string2)) continue;
                    hashMap.put(locale, textNLSEntry.getValueText());
                    continue block0;
                }
            }
        }
        return hashMap;
    }

    @Override
    public Map exportNLSDisplays(Locale locale, String string) throws NoPrivilegeException, RemoteException {
        Object object;
        Object object22;
        Object object3;
        ServiceLogger.logDebug("ResourceNLSManager.export(), locale=" + locale + ", submitter=" + string, 6);
        if (!this.contains.isAdminUser(string) && !this.contains.isOrganizationAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        String string3 = CSUtil.getVirtualResourcePathPrefix(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        TextNLSEntry textNLSEntry = this.getRootNLSEntry(locale);
        hashMap.put(SEDU, textNLSEntry == null ? "" : textNLSEntry.getValueText());
        this.contains(locale, string2, string3 + "/", hashMap);
        this.contains(locale, string2, string3 + "/COMPONENT_LIB", hashMap);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (stringArray[0] == null) {
            object3 = this.contains.getAllUsersName();
            object22 = ((Vector)object3).iterator();
            while (object22.hasNext()) {
                object = (String)object22.next();
                if (((String)object).indexOf("\\") != -1) continue;
                arrayList.add(object);
            }
        } else {
            object3 = null;
            try {
                object3 = (JOrganizationImpl)this.contains.getOrganization(string2);
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException), 6);
            }
            object22 = ((JOrganizationImpl)object3).getUsers();
            object = ((Vector)object22).iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                arrayList.add(string4);
            }
        }
        for (Object object22 : arrayList) {
            this.contains(locale, string2, string3 + "/USERFOLDERPATH" + "/" + (String)object22, hashMap);
            this.contains(locale, string2, string3 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + (String)object22, hashMap);
        }
        ServiceLogger.logDebug("ResourceNLSManager.export(), locale=" + locale + ", submitter=" + string + ", exported entry number" + hashMap.size(), 6);
        return hashMap;
    }

    private void contains(Locale locale, String string, String string2, Map map) {
        try {
            Node node = this.containsKey.getNodeByPath(string2);
            if (node != null) {
                this.deleteNLS(locale, string, node, map);
                if (node.getNodeType() != 1) {
                    return;
                }
                this.containsKey(locale, string, (Folder)node, map);
            } else {
                map.put(string2, "");
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 6);
        }
    }

    private void containsKey(Locale locale, String string, Folder folder, Map map) throws NoPrivilegeException {
        Vector vector = this.containsKey.getChildren(folder, null, false, true, true);
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        ArrayList arrayList2 = this.UNDEFINED(locale, string, folder.getID());
        for (Node node : vector) {
            if (node.getNodeType() == 1) {
                arrayList.add((Folder)node);
            }
            map.put(node.getAbsolutePath(), this.equals(arrayList2, node.getName()));
        }
        for (Folder folder2 : arrayList) {
            this.containsKey(locale, string, folder2, map);
        }
    }

    private void deleteNLS(Locale locale, String string, Node node, Map map) {
        Node node2 = node.getParent();
        if (node2.getNodeType() != 1) {
            return;
        }
        ArrayList arrayList = this.UNDEFINED(locale, string, node.isRoot() ? -1 : node2.getID());
        map.put(node.getAbsolutePath(), this.equals(arrayList, node.getName()));
    }

    private String equals(List list, String string) {
        if (list != null) {
            for (TextNLSEntry textNLSEntry : list) {
                if (!textNLSEntry.getKeyText().equals(string)) continue;
                return textNLSEntry.getValueText();
            }
        }
        return "";
    }

    @Override
    public int importNLSDisplays(Locale locale, Map map, String string) throws NoPrivilegeException, RemoteException {
        ArrayList<TextNLSEntry> arrayList;
        Object object;
        ServiceLogger.logDebug("ResourceNLSManager.import(), locale=" + locale + ", submitter=" + string + ", entry number: " + map.size(), 6);
        if (!this.contains.isAdminUser(string) && !this.contains.isOrganizationAdminUser(string)) {
            throw new NoPrivilegeException(600036);
        }
        int n = 0;
        if (map == null || !this.isLegalLocale(locale)) {
            return n;
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        String string3 = CSUtil.getVirtualResourcePathPrefix(stringArray[0]);
        String string4 = (String)map.remove(SEDU);
        String string5 = (String)map.remove(string3 + "/");
        HashMap hashMap = new HashMap();
        for (String string6 : map.keySet()) {
            String string7;
            String[] stringArray2 = CSUtil.parseVirtualResourcePath(string6);
            if (!StringUtils.equals(stringArray[0], stringArray2[0])) continue;
            object = this.equalsIgnoreCase(string6);
            if (object != null) {
                try {
                    this.contains.getUser(CSUtil.getPrincipalDisplayName(stringArray[0], (String)object));
                }
                catch (NoSuchUserException noSuchUserException) {
                    continue;
                }
            }
            int n2 = string6.lastIndexOf("/");
            String string8 = string6.substring(n2 + 1);
            String string9 = string6.substring(0, n2);
            if (string9.equals(string3)) {
                string9 = string9 + "/";
            }
            if ((arrayList = (ArrayList)hashMap.get(string9)) == null) {
                arrayList = new ArrayList<TextNLSEntry>();
                hashMap.put(string9, arrayList);
            }
            if ((string7 = (String)map.get(string6)) == null || string7.trim().length() == 0) continue;
            arrayList.add(new TextNLSEntry(NLSType.UNDEFINED, string8, string7));
        }
        if (stringArray[0] == null && string4 != null && string4.trim().length() != 0 && this.asList(locale, string2, -2, new TextNLSEntry(NLSType.UNDEFINED, SEDU, string4))) {
            ++n;
        }
        if (string5 != null && string5.trim().length() != 0 && this.asList(locale, string2, -1, new TextNLSEntry(NLSType.UNDEFINED, "", string5))) {
            ++n;
        }
        for (String string6 : hashMap.keySet()) {
            try {
                object = this.containsKey.getNodeByPath(string6);
                arrayList = this.UNDEFINED(locale, string2, object.getID());
                ArrayList<TextNLSEntry> arrayList2 = (ArrayList<TextNLSEntry>)hashMap.get(string6);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<TextNLSEntry>();
                }
                if (arrayList != null) {
                    for (TextNLSEntry textNLSEntry : arrayList) {
                        if (!this.equals(arrayList2, textNLSEntry.getKeyText()).equals("")) continue;
                        arrayList2.add(textNLSEntry);
                    }
                }
                n += this.append(locale, string2, object.getID(), arrayList2);
            }
            catch (UnknownResource unknownResource) {
                ServiceLogger.logError((Throwable)((Object)unknownResource), 3);
            }
        }
        ServiceLogger.logDebug("ResourceNLSManager.import(), locale=" + locale + ", submitter=" + string + ", imported entry number: " + n, 6);
        return n;
    }

    private String equalsIgnoreCase(String string) {
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        String string3 = CSUtil.getPrincipalDisplayName(stringArray[0], string2);
        String string4 = "/COMPONENT_LIB/USERFOLDERPATH";
        int n = 0;
        int n2 = 0;
        if (stringArray[1].startsWith(string4)) {
            n = string4.length() + 1;
        } else if (stringArray[1].startsWith("/USERFOLDERPATH")) {
            n = "/USERFOLDERPATH".length() + 1;
        } else {
            return null;
        }
        n2 = stringArray[1].indexOf("/", n);
        if (n2 == -1) {
            n2 = stringArray[1].length();
        }
        return stringArray[1].substring(n, n2);
    }
}

