/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Vector;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.RoleExistsException;
import jet.server.intf.security.Role;
import jet.server.jrc.security.RoleDataManager;
import jet.server.jrc.security.custom.db.user.UserProviderDBImpl;

public class RoleManager {
    private RoleDataManager SEDU = null;

    public RoleManager(RoleDataManager roleDataManager) {
        this.SEDU = roleDataManager;
    }

    public String addNewRole(String string, String string2, String string3, int n) throws RoleExistsException {
        if (string2 == null || string2.length() == 0) {
            return "SECURITY_ERR_20_ROLE_NAME_NULL";
        }
        if (!this.isValidName(string2)) {
            return "SECURITY_ERR_ROLE_NAME_INVALID";
        }
        return this.SEDU.addNewRole(string == null ? string2 : string + "\\" + string2, string3, n);
    }

    public String removeRole(String string) throws NoSuchRoleException, InUseException {
        if (string.equals("administrators") || string.endsWith("\\administrators")) {
            return "SECURITY_ERR_53_REMOVE_ADMIN_ROLE";
        }
        if (string.equals("everyone") || string.endsWith("\\everyone")) {
            return "SECURITY_ERR_54_REMOVE_ECERYONE_ROLE";
        }
        Role role = this.getRole(string);
        int n = role.getSubRoleNames().size();
        int n2 = role.getParentRoleNames().size();
        int n3 = role.getSubUserNames().size();
        int n4 = role.getGroupNames().size();
        if (n2 > 0) {
            throw new InUseException(630034, (Object[])new String[]{string}, null);
        }
        if (n > 0) {
            throw new InUseException(630035, (Object[])new String[]{string}, null);
        }
        if (n4 > 0) {
            throw new InUseException(630036, (Object[])new String[]{string}, null);
        }
        if (n3 > 0) {
            throw new InUseException(630037, (Object[])new String[]{string}, null);
        }
        return this.SEDU.removeRole(string);
    }

    public Role getRole(String string) throws NoSuchRoleException {
        Role role = this.SEDU.getRole(string);
        return role;
    }

    public String removeRoleFromParentRole(String string, String string2) throws NoSuchRoleException {
        return this.SEDU.removeRoleFromParentRole(string, string2);
    }

    public String addRoleToParentRole(String string, String string2) throws NoSuchRoleException {
        this.getRole(string);
        Role role = this.getRole(string2);
        if (string.equals(string2)) {
            return "SECURITY_ERR_23_SAME_PARENT_ROLE_NAME";
        }
        if (this.isPosterity(string, string2)) {
            return "SECURITY_ERR_24_IN_ROLE_POSTERITY";
        }
        Vector vector = role.getSubRoleNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            if (!string.equals(string3)) continue;
            return "SECURITY_ERR_25_IS_ROLE_SON";
        }
        return this.SEDU.addRoleToParentRole(string, string2);
    }

    public synchronized boolean isPosterity(String string, String string2) {
        Role role;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return false;
        }
        Vector vector = role.getSubRoleNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            if (string2.equalsIgnoreCase(string3)) {
                return true;
            }
            try {
                Role role2 = this.getRole(string3);
                String string4 = role2.getName();
                if (!this.isPosterity(string4, string2)) continue;
                return true;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
        }
        return false;
    }

    public String removeGroupFromRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.SEDU.removeGroupFromRole(string, string2);
    }

    public String addGroupIntoRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.SEDU.addGroupIntoRole(string, string2);
    }

    public Enumeration getAllRoles() {
        return this.SEDU.getAllRoles();
    }

    public Enumeration getAllRoleNames() {
        return this.SEDU.getAllRoleNames();
    }

    public Vector getSubUserNames(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getSubUserNames();
    }

    public Vector getSubRoleNames(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getSubRoleNames();
    }

    public Vector getParentRoleNames(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getParentRoleNames();
    }

    public int getMembersCount(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getMembersCount();
    }

    public boolean isValidName(String string) {
        if (string.length() <= 0 || string.length() > 32) {
            return false;
        }
        return UserProviderDBImpl.isValidPrincipalName(string);
    }
}

