/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.rmi.RemoteException;
import java.security.acl.Permission;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.server.api.admin.security.JOrganization;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityAdapter;
import jet.server.intf.security.User;
import jet.server.log.ServiceLogger;

public class SecurityDataRemoteImpl
implements ExSecurityData {
    private SecurityAdapter SEDU;

    public SecurityDataRemoteImpl(SecurityAdapter securityAdapter) {
        this.SEDU = securityAdapter;
    }

    @Override
    public Vector getAllUsers(String string) {
        try {
            return this.SEDU.getAllUsers(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
            return null;
        }
    }

    @Override
    public Vector getAllRoles(String string) {
        try {
            return this.SEDU.getAllRoles(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
            return null;
        }
    }

    @Override
    public Vector getAllGroups(String string) {
        try {
            return this.SEDU.getAllGroups(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
            return null;
        }
    }

    @Override
    public User[] getAllUsers() {
        User[] userArray = null;
        try {
            Vector vector = this.SEDU.getAllUsers("admin");
            userArray = new User[vector.size()];
            vector.toArray(userArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
        }
        return userArray;
    }

    @Override
    public Role[] getAllRoles() {
        Role[] roleArray = null;
        try {
            Vector vector = this.SEDU.getAllRoles("admin");
            roleArray = new Role[vector.size()];
            vector.toArray(roleArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
        }
        return roleArray;
    }

    @Override
    public Group[] getAllGroups() {
        Group[] groupArray = null;
        try {
            Vector vector = this.SEDU.getAllGroups("admin");
            groupArray = new Group[vector.size()];
            vector.toArray(groupArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
        }
        return groupArray;
    }

    @Override
    public JAcl getAcl(String string, int n) {
        return null;
    }

    @Override
    public JAcl getExtendAcl() {
        return null;
    }

    @Override
    public Permission[] getUserPermissions(String string, String string2, int n) {
        return new Permission[0];
    }

    @Override
    public BaseRole getRole(String string) {
        try {
            return this.SEDU.getRole(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
            return null;
        }
    }

    @Override
    public BaseUser getUser(String string) {
        try {
            return this.SEDU.getUser(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
            return null;
        }
    }

    @Override
    public BaseGroup getGroup(String string) {
        try {
            return this.SEDU.getGroup(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
            return null;
        }
    }

    @Override
    public JOrganization[] getAllOrganizations() {
        return null;
    }
}

