/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.cache;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.JSRuntimeException;
import jet.cs.CSUtil;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEntryImpl;
import jet.cs.jacl.JAclImpl;
import jet.server.ServerEnv;
import jet.server.api.admin.security.JOrganization;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.AuthorizationProvider;
import jet.server.api.custom.security.group.GroupPermissionProvider;
import jet.server.api.custom.security.group.GroupPrivilegeProvider;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.custom.security.organization.OrganizationProvider;
import jet.server.api.custom.security.relation.GroupUserRelationProvider;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.custom.security.role.RolePermissionProvider;
import jet.server.api.custom.security.role.RolePrivilegeProvider;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.custom.security.user.UserPermissionProvider;
import jet.server.api.custom.security.user.UserPrivilegeProvider;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.PrincipalListener;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.jrc.security.GroupImpl;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.RoleImpl;
import jet.server.jrc.security.UserImpl;
import jet.server.jrc.security.admin.JOrganizationImpl;
import jet.server.jrc.security.cache.SecurityCache;
import jet.server.jrc.security.config.intf.SecurityProvidersManager;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.jrc.security.custom.db.group.GroupProviderDBImpl;
import jet.server.jrc.security.custom.db.role.RoleProviderDBImpl;
import jet.server.log.ServiceLogger;

public class CachedSecurityDataImpl
implements ExSecurityData {
    protected SecurityCache securityCache;
    protected String realmName;
    protected SecurityProvidersManager securityProvidersManager;
    protected AuthenticationProvider authenticationProvider;
    protected AuthorizationProvider authorizationProvider;
    protected OrganizationProvider orgProvider;
    protected UserProvider userProvider;
    protected UserPermissionProvider userPermissionProvider;
    protected UserPrivilegeProvider userPrivilegeProvider;
    protected GroupProvider groupProvider;
    protected GroupPermissionProvider groupPermissionProvider;
    protected GroupPrivilegeProvider groupPrivilegeProvider;
    protected RoleProvider roleProvider;
    protected RolePermissionProvider rolePermissionProvider;
    protected RolePrivilegeProvider rolePrivilegeProvider;
    protected RoleGroupRelationProvider roleGroupRelationProvider;
    protected RoleUserRelationProvider roleUserRelationProvider;
    protected GroupUserRelationProvider groupUserRelationProvider;
    protected ArrayList principalListeners = new ArrayList();
    protected Hashtable subGroupMap = new Hashtable();
    protected Hashtable groupUserMap = new Hashtable();
    protected Hashtable subRoleMap = new Hashtable();
    protected Hashtable roleUserMap = new Hashtable();
    protected Hashtable roleGroupMap = new Hashtable();

    public CachedSecurityDataImpl(String string, SecurityProvidersManager securityProvidersManager) {
        this.realmName = string;
        this.securityProvidersManager = securityProvidersManager;
        this.SEDU();
        this.TAG_GROUP_DB_TYPE();
        this.addPermissionToAclEntry();
        this.TAG_ROLE_DB_TYPE();
        this.add();
        this.addRole();
        this.addPrivilegeToAclEntry();
    }

    public SecurityProvidersManager getSecurityProvidersManager() {
        return this.securityProvidersManager;
    }

    @Override
    public BaseUser getUser(String string) {
        User user = this.securityCache.getUser(string);
        if (user == null && (user = this.createAclName(string)) != null) {
            this.securityCache.updateUser(user);
        }
        return user;
    }

    @Override
    public BaseRole getRole(String string) {
        Role role = this.securityCache.getRole(string);
        if (role == null && (role = this.addEntry(string)) != null) {
            this.securityCache.updateRole(role);
        }
        return role;
    }

    @Override
    public BaseGroup getGroup(String string) {
        Group group = this.securityCache.getGroup(string);
        if (group == null && (group = this.addSubUser(string)) != null) {
            this.securityCache.updateGroup(group);
        }
        return group;
    }

    @Override
    public User[] getAllUsers() {
        Object object;
        Vector<User> vector = new Vector<User>();
        Iterator iterator = null;
        try {
            iterator = this.userProvider.getAllUsers(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                User user = this.getIntegrityUser((String)object);
                if (user == null) continue;
                vector.add(user);
            }
        }
        object = new User[vector.size()];
        return vector.toArray((T[])object);
    }

    @Override
    public Role[] getAllRoles() {
        Object object;
        Vector<Role> vector = new Vector<Role>();
        Iterator iterator = null;
        try {
            iterator = this.roleProvider.getAllRoles(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Role role = this.getIntegrityRole((String)object);
                if (role == null) continue;
                vector.add(role);
            }
        }
        object = new Role[vector.size()];
        return vector.toArray((T[])object);
    }

    @Override
    public Group[] getAllGroups() {
        Object object;
        Vector<Group> vector = new Vector<Group>();
        Iterator iterator = null;
        try {
            iterator = this.groupProvider.getAllGroups(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Group group = this.getIntegrityGroup((String)object);
                if (group == null) continue;
                vector.add(group);
            }
        }
        object = new Group[vector.size()];
        return vector.toArray((T[])object);
    }

    public User getIntegrityUser(String string) {
        User user = this.securityCache.getUser(string);
        if (user == null) {
            user = this.createAclName(string);
            if (user != null) {
                this.securityCache.updateUser(user);
            }
        } else {
            this.equalsIgnoreCase(user);
        }
        return user;
    }

    public Role getIntegrityRole(String string) {
        Role role = this.securityCache.getRole(string);
        if (role == null) {
            role = this.addEntry(string);
            if (role != null) {
                this.securityCache.updateRole(role);
            }
        } else {
            this.addGroup(role);
        }
        return role;
    }

    public Group getIntegrityGroup(String string) {
        Group group = this.securityCache.getGroup(string);
        if (group == null) {
            group = this.addSubUser(string);
            if (group != null) {
                this.securityCache.updateGroup(group);
            }
        } else {
            this.addUser(group);
        }
        return group;
    }

    @Override
    public JAcl getAcl(String string, int n) {
        String string2 = SecurityUtil.createAclName(string, n);
        JAcl jAcl = this.securityCache.getAcl(string2);
        if (jAcl == null && (jAcl = this.getAllRoles(string, n)) != null) {
            this.securityCache.updateAcl(jAcl);
        }
        return jAcl;
    }

    @Override
    public JAcl getExtendAcl() {
        JAcl jAcl = this.securityCache.getExtendAcl();
        if (jAcl == null && (jAcl = this.getGroup()) != null) {
            this.securityCache.updateExtendAcl(jAcl);
        }
        return jAcl;
    }

    @Override
    public Permission[] getUserPermissions(String string, String string2, int n) {
        return new Permission[0];
    }

    @Override
    public Vector getAllUsers(String string) {
        Vector<User> vector = new Vector<User>();
        boolean bl = false;
        bl = this.authenticationProvider.isAdminUser(this.realmName, string);
        if (!bl) {
            return vector;
        }
        Iterator iterator = null;
        try {
            iterator = this.userProvider.getAllUsers(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                User user = this.getIntegrityUser(string2);
                if (user == null) continue;
                vector.add(user);
            }
        }
        return vector;
    }

    @Override
    public Vector getAllRoles(String string) {
        Vector<Role> vector = new Vector<Role>();
        boolean bl = false;
        bl = this.authenticationProvider.isAdminUser(this.realmName, string);
        if (!bl) {
            return vector;
        }
        Iterator iterator = null;
        try {
            iterator = this.roleProvider.getAllRoles(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Role role = this.getIntegrityRole(string2);
                if (role == null) continue;
                vector.add(role);
            }
        }
        return vector;
    }

    @Override
    public Vector getAllGroups(String string) {
        Vector<Group> vector = new Vector<Group>();
        boolean bl = false;
        bl = this.authenticationProvider.isAdminUser(this.realmName, string);
        if (!bl) {
            return vector;
        }
        Iterator iterator = null;
        try {
            iterator = this.groupProvider.getAllGroups(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Group group = this.getIntegrityGroup(string2);
                if (group == null) continue;
                vector.add(group);
            }
        }
        return vector;
    }

    private void SEDU() {
        try {
            int n = ServerEnv.getSecurityUserCacheSize();
            int n2 = ServerEnv.getSecurityRoleCacheSize();
            int n3 = ServerEnv.getSecurityGroupCacheSize();
            int n4 = ServerEnv.getSecurityProtectionCacheSize();
            this.securityCache = new SecurityCache(n, n2, n3, n4);
        }
        catch (Exception exception) {
            this.securityCache = new SecurityCache();
        }
    }

    private void TAG_GROUP_DB_TYPE() {
        try {
            this.authenticationProvider = this.securityProvidersManager.getAuthenticationProvider();
            this.authorizationProvider = this.securityProvidersManager.getAuthorizationProvider();
            this.orgProvider = this.securityProvidersManager.getOrganizationProvider();
            this.userProvider = this.securityProvidersManager.getUserProvider();
            this.userPermissionProvider = this.securityProvidersManager.getUserPermissionProvider();
            this.userPrivilegeProvider = this.securityProvidersManager.getUserPrivilegeProvider();
            this.roleProvider = this.securityProvidersManager.getRoleProvider();
            this.rolePermissionProvider = this.securityProvidersManager.getRolePermissionProvider();
            this.rolePrivilegeProvider = this.securityProvidersManager.getRolePrivilegeProvider();
            this.groupProvider = this.securityProvidersManager.getGroupProvider();
            this.groupPermissionProvider = this.securityProvidersManager.getGroupPermissinProvider();
            this.groupPrivilegeProvider = this.securityProvidersManager.getGroupPrivilegeProvider();
            this.roleGroupRelationProvider = this.securityProvidersManager.getRoleGroupRelationProvider();
            this.roleUserRelationProvider = this.securityProvidersManager.getRoleUserRelationProvider();
            this.groupUserRelationProvider = this.securityProvidersManager.getGroupUserRelationProvider();
        }
        catch (ClassCastException classCastException) {
            ServiceLogger.logError(classCastException);
            throw new JSRuntimeException(classCastException);
        }
    }

    private Vector TAG_ROLE_DB_BUILDIN(Iterator iterator) {
        Vector<String> vector = new Vector<String>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                vector.add((String)iterator.next());
            }
        }
        return vector;
    }

    private void TAG_ROLE_DB_TYPE() {
        try {
            Vector vector;
            Vector vector2;
            Vector vector3 = this.TAG_ROLE_DB_BUILDIN(this.groupProvider.getAllGroups(this.realmName));
            Vector vector4 = this.TAG_ROLE_DB_BUILDIN(this.roleProvider.getAllRoles(this.realmName));
            for (String string : vector3) {
                try {
                    vector2 = this.TAG_ROLE_DB_BUILDIN(this.groupProvider.getSubGroups(this.realmName, string));
                    if (vector2.size() > 0) {
                        this.subGroupMap.put(string, vector2);
                    }
                    if ((vector = this.TAG_ROLE_DB_BUILDIN(this.groupUserRelationProvider.getSubUsers(this.realmName, string))).size() <= 0) continue;
                    this.groupUserMap.put(string, vector);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException), 3);
                }
            }
            for (String string : vector4) {
                try {
                    Vector vector5;
                    vector2 = this.TAG_ROLE_DB_BUILDIN(this.roleProvider.getSubRoles(this.realmName, string));
                    if (vector2.size() > 0) {
                        this.subRoleMap.put(string, vector2);
                    }
                    if ((vector = this.TAG_ROLE_DB_BUILDIN(this.roleGroupRelationProvider.getGroupsByRole(this.realmName, string))).size() > 0) {
                        this.roleGroupMap.put(string, vector);
                    }
                    if ((vector5 = this.TAG_ROLE_DB_BUILDIN(this.roleUserRelationProvider.getUsersByRole(this.realmName, string))).size() <= 0) continue;
                    this.roleUserMap.put(string, vector5);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException), 3);
                }
            }
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
    }

    private void add() {
        Iterator iterator = null;
        try {
            iterator = this.roleProvider.getAllRoles(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Role role = this.addEntry(string);
                if (role == null) continue;
                this.securityCache.updateRole(role);
            }
        }
    }

    private Role addEntry(String string) {
        Principal principal;
        Properties properties;
        String string2;
        String string3;
        Properties properties2 = null;
        try {
            properties2 = this.roleProvider.getRoleProperties(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException), 3);
            return null;
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logDebug(noSuchRoleException.getMessage(), 6);
            return null;
        }
        if (properties2 == null || properties2.size() == 0) {
            return null;
        }
        String string4 = properties2.getProperty("role_description", "");
        boolean bl = false;
        int n = 0;
        String string5 = properties2.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_TYPE);
        boolean bl2 = false;
        if (string5 != null && string5.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if (bl2) {
            n = 1;
        }
        if ((string3 = properties2.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_BUILDIN)) != null && string3.equalsIgnoreCase("true")) {
            bl = true;
        }
        RoleImpl roleImpl = new RoleImpl(string, bl, string4, n);
        Iterator iterator = null;
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        Iterator iterator4 = null;
        Vector vector = (Vector)this.subRoleMap.get(string);
        if (vector != null) {
            iterator = vector.iterator();
        }
        iterator2 = this.authorizationProvider(string, this.subRoleMap);
        vector = (Vector)this.roleGroupMap.get(string);
        if (vector != null) {
            iterator3 = vector.iterator();
        }
        if ((vector = (Vector)this.roleUserMap.get(string)) != null) {
            iterator4 = vector.iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                block30: {
                    string2 = (String)iterator.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getRole(string2);
                        if (principal != null) break block30;
                        properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                roleImpl.addSubRole(string2);
            }
        }
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                block31: {
                    string2 = (String)iterator2.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getRole(string2);
                        if (principal != null) break block31;
                        properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                roleImpl.addParentRole(string2);
            }
        }
        if (iterator3 != null) {
            while (iterator3.hasNext()) {
                block32: {
                    string2 = (String)iterator3.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getGroup(string2);
                        if (principal != null) break block32;
                        properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                roleImpl.addGroup(string2);
            }
        }
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                block33: {
                    string2 = (String)iterator4.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getUser(string2);
                        if (principal != null) break block33;
                        properties = this.userProvider.getUserProperties(this.realmName, string2);
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                roleImpl.addSubUser(string2);
            }
        }
        return roleImpl;
    }

    private void addGroup(Role role) {
        String string;
        Properties properties = null;
        try {
            properties = this.roleProvider.getRoleProperties(this.realmName, role.getName());
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return;
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
            return;
        }
        String string2 = properties.getProperty("role_description", "");
        boolean bl = false;
        int n = 0;
        String string3 = properties.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_TYPE);
        boolean bl2 = false;
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if (bl2) {
            n = 1;
        }
        if ((string = properties.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_BUILDIN)) != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        role.setDescription(string2);
        role.setType(n);
        role.setBuildin(bl);
    }

    private Iterator addParentRole(String string) throws NoSuchRoleException, JRCustomerException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = this.roleProvider.getAllRoles(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Role role = this.securityCache.getRole((String)object);
                if (role != null) {
                    if (!role.isHaveSubRole(string)) continue;
                    vector.add(object);
                    continue;
                }
                Iterator iterator2 = this.roleProvider.getSubRoles(this.realmName, (String)object);
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string2.equals(string)) continue;
                    vector.add(object);
                }
            }
        }
        object = vector.iterator();
        return object;
    }

    private void addPermissionToAclEntry() {
        JOrganization[] jOrganizationArray;
        for (JOrganization jOrganization : jOrganizationArray = this.getAllOrganizations()) {
            this.securityCache.updateOrganization(jOrganization);
        }
    }

    private void addPrivilegeToAclEntry() {
        User[] userArray;
        for (User user : userArray = this.getAllUsers()) {
            JOrganizationImpl jOrganizationImpl;
            this.securityCache.updateUser(user);
            String[] stringArray = CSUtil.parsePrincipalDisplayName(user.getName());
            if (stringArray[0] == null || (jOrganizationImpl = this.securityCache.getOrganization(stringArray[0])) == null) continue;
            jOrganizationImpl.addUser(stringArray[1]);
        }
    }

    private void addRole() {
        Iterator iterator = null;
        try {
            iterator = this.groupProvider.getAllGroups(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Group group = this.addSubUser(string);
                if (group == null) continue;
                this.securityCache.updateGroup(group);
            }
        }
    }

    private Group addSubUser(String string) {
        Principal principal;
        Properties properties;
        String string2;
        Properties properties2 = null;
        try {
            properties2 = this.groupProvider.getGroupProperties(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return null;
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logDebug(noSuchGroupException.getMessage(), 6);
            return null;
        }
        if (properties2 == null || properties2.size() == 0) {
            return null;
        }
        String string3 = properties2.getProperty("group_description", "");
        boolean bl = false;
        int n = 0;
        String string4 = properties2.getProperty(GroupProviderDBImpl.TAG_GROUP_DB_TYPE);
        boolean bl2 = false;
        if (string4 != null && string4.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if (bl2) {
            n = 1;
        }
        GroupImpl groupImpl = new GroupImpl(string, bl, string3, n);
        Iterator iterator = null;
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        Iterator iterator4 = null;
        Vector vector = (Vector)this.subGroupMap.get(string);
        if (vector != null) {
            iterator = vector.iterator();
        }
        iterator2 = this.authorizationProvider(string, this.subGroupMap);
        iterator3 = this.authorizationProvider(string, this.roleGroupMap);
        vector = (Vector)this.groupUserMap.get(string);
        if (vector != null) {
            iterator4 = vector.iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                block28: {
                    string2 = (String)iterator.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getGroup(string2);
                        if (principal != null) break block28;
                        properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                groupImpl.addSubGroup(string2);
            }
        }
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                block29: {
                    string2 = (String)iterator2.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getGroup(string2);
                        if (principal != null) break block29;
                        properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                groupImpl.addParentGroup(string2);
            }
        }
        if (iterator3 != null) {
            while (iterator3.hasNext()) {
                block30: {
                    string2 = (String)iterator3.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getRole(string2);
                        if (principal != null) break block30;
                        properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                groupImpl.addRole(string2);
            }
        }
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                block31: {
                    string2 = (String)iterator4.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getUser(string2);
                        if (principal != null) break block31;
                        properties = this.userProvider.getUserProperties(this.realmName, string2);
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                groupImpl.addUser(string2);
            }
        }
        return groupImpl;
    }

    private void addUser(Group group) {
        Properties properties = null;
        try {
            properties = this.groupProvider.getGroupProperties(this.realmName, group.getName());
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return;
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
            return;
        }
        String string = properties.getProperty("group_description", "");
        int n = 0;
        String string2 = properties.getProperty(GroupProviderDBImpl.TAG_GROUP_DB_TYPE);
        boolean bl = false;
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            bl = true;
        }
        if (bl) {
            n = 1;
        }
        group.setDescription(string);
        group.setType(n);
    }

    private Iterator authenticationProvider(String string) throws NoSuchGroupException, JRCustomerException {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.groupProvider.getAllGroups(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = null;
                Group group = this.securityCache.getGroup(string2);
                if (group != null) {
                    if (!group.isHaveSubGroup(string)) continue;
                    vector.add(string2);
                    continue;
                }
                iterator2 = this.groupProvider.getSubGroups(this.realmName, string2);
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!string3.equals(string)) continue;
                    vector.add(string2);
                }
            }
        }
        return vector.iterator();
    }

    private Iterator authorizationProvider(String string, Hashtable hashtable) {
        Vector<String> vector = new Vector<String>();
        for (String string2 : hashtable.keySet()) {
            Vector vector2 = (Vector)hashtable.get(string2);
            if (!vector2.contains(string)) continue;
            vector.add(string2);
        }
        return vector.iterator();
    }

    private Iterator contains(String string) throws JRCustomerException, NoSuchRoleException {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.roleProvider.getAllRoles(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = null;
                Role role = this.securityCache.getRole(string2);
                if (role != null) {
                    if (!role.isHaveGroup(string)) continue;
                    vector.add(string2);
                    continue;
                }
                iterator2 = this.roleGroupRelationProvider.getGroupsByRole(this.realmName, string2);
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!string3.equals(string)) continue;
                    vector.add(string2);
                }
            }
        }
        return vector.iterator();
    }

    private User createAclName(String string) {
        Principal principal;
        Properties properties;
        String string2;
        Properties properties2 = null;
        try {
            properties2 = this.userProvider.getUserProperties(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException), 3);
            return null;
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logDebug(noSuchUserException.getMessage(), 6);
            return null;
        }
        if (properties2 == null || properties2.size() == 0) {
            return null;
        }
        UserImpl userImpl = new UserImpl();
        userImpl.setName(string);
        this.get(userImpl, properties2);
        Iterator iterator = this.authorizationProvider(string, this.roleUserMap);
        Iterator iterator2 = this.authorizationProvider(string, this.groupUserMap);
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                block14: {
                    string2 = (String)iterator2.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getGroup(string2);
                        if (principal != null) break block14;
                        properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                userImpl.addGroup(string2);
            }
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                block15: {
                    string2 = (String)iterator.next();
                    properties = null;
                    principal = null;
                    try {
                        principal = this.securityCache.getRole(string2);
                        if (principal != null) break block15;
                        properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        continue;
                    }
                    catch (JRCustomerException jRCustomerException) {
                        continue;
                    }
                }
                if (principal == null && (properties == null || properties.size() == 0)) continue;
                userImpl.addParentRole(string2);
            }
        }
        return userImpl;
    }

    private int currentTimeMillis(String string, int n, String string2) {
        int n2 = n;
        if (string != null && string.length() > 0) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logDebug(3630091, new Object[]{string, string2}, 3);
                n2 = n;
            }
        }
        return n2;
    }

    private boolean equals(String string, boolean bl) {
        boolean bl2 = bl;
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string.equalsIgnoreCase("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private void equalsIgnoreCase(User user) {
        Properties properties = null;
        try {
            properties = this.userProvider.getUserProperties(this.realmName, user.getName());
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException), 3);
            return;
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logDebug(noSuchUserException.getMessage(), 6);
            return;
        }
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.get(user, properties);
    }

    private void get(User user, Properties properties) {
        String string = properties.getProperty("user_password");
        int n = 0;
        int n2 = 0;
        String string2 = properties.getProperty("user_db_ldapType");
        if (string2 == null) {
            n = -1;
            n2 = -1;
        } else if (string2.equalsIgnoreCase("true")) {
            n = 1;
            n2 = 1;
        }
        boolean bl = this.equals(properties.getProperty("user_db_buildin"), false);
        String string3 = properties.getProperty("user_fullname");
        String string4 = properties.getProperty("user_description");
        String string5 = properties.getProperty("user_email");
        Date date = (Date)properties.get("user_create_time");
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        boolean bl2 = this.equals(properties.getProperty("user_enable_null_pwd"), false);
        int n3 = this.currentTimeMillis(properties.getProperty("user_min_pwd_length"), 6, user.getName());
        Date date2 = (Date)properties.get("user_last_modify_time");
        boolean bl3 = this.equals(properties.getProperty("user_never_expire"), false);
        int n4 = this.currentTimeMillis(properties.getProperty("user_expire_time"), 30, user.getName());
        boolean bl4 = this.equals(properties.getProperty("user_disabled_account"), false);
        boolean bl5 = this.equals(properties.getProperty("user_db_access_event_suc"), false);
        boolean bl6 = this.equals(properties.getProperty("user_db_access_event_fail"), false);
        boolean bl7 = this.equals(properties.getProperty("user_db_management_event_suc"), false);
        boolean bl8 = this.equals(properties.getProperty("user_db_management_event_fail"), false);
        boolean bl9 = this.equals(properties.getProperty("user_db_noAudit"), false);
        user.setFullName(string3);
        user.setDescription(string4);
        user.setEmail(string5);
        user.setPassword(string);
        user.setCreateTime(date);
        user.setBuildin(bl);
        user.setEnableNullPS(bl2);
        user.setMinPSLength(n3);
        user.setNeverExpire(bl3);
        user.setLastModifyTime(date2);
        user.setExpireTime(n4);
        user.setAccountDisable(bl4);
        user.setAccessEventSuc(bl5);
        user.setAccessEventFail(bl6);
        user.setManagementEventSuc(bl7);
        user.setManagementEventFail(bl8);
        user.setNoAudit(bl9);
        user.setAuthType(n);
        user.setLdapType(n2);
    }

    private Iterator getAcl(String string, String string2) throws JRCustomerException, NoSuchGroupException {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (null != string2 && 0 != string2.length()) {
            stringArray = string2.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        stringArray = new Vector();
        Iterator iterator = this.groupProvider.getAllGroups(this.realmName);
        if (iterator != null) {
            block1: while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Iterator iterator2 = null;
                Group group = this.securityCache.getGroup(string3);
                if (group != null) {
                    if (group.isHaveUser(string)) {
                        stringArray.add(string3);
                        continue;
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        if (!string3.equals(vector.get(i))) continue;
                        stringArray.add(string3);
                        vector.remove(i);
                        continue block1;
                    }
                    continue;
                }
                iterator2 = this.groupUserRelationProvider.getSubUsers(this.realmName, string3);
                if (string == null) continue;
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    if (!string4.equals(string)) continue;
                    stringArray.add(string3);
                }
            }
        }
        return stringArray.iterator();
    }

    private Iterator getAllOrganizations(String string) throws JRCustomerException, NoSuchRoleException {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.roleProvider.getAllRoles(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = null;
                Role role = this.securityCache.getRole(string2);
                if (role != null) {
                    if (!role.isHaveSubUser(string)) continue;
                    vector.add(string2);
                    continue;
                }
                iterator2 = this.roleUserRelationProvider.getUsersByRole(this.realmName, string2);
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!string3.equals(string)) continue;
                    vector.add(string2);
                }
            }
        }
        return vector.iterator();
    }

    private JAcl getAllRoles(String string, int n) {
        String string2 = SecurityUtil.createAclName(string, n);
        JAcl jAcl = this.getGroupPermissinProvider(string2, true, string, n);
        return jAcl;
    }

    private JAcl getGroup() {
        String string = "JAcl{extendAcl}";
        JAcl jAcl = this.getGroupPermissinProvider(string, false, null, 0);
        return jAcl;
    }

    private JAcl getGroupPermissinProvider(String string, boolean bl, String string2, int n) {
        Principal principal;
        Object v;
        String string3;
        Enumeration enumeration;
        JAclImpl jAclImpl = new JAclImpl(string, this);
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        try {
            hashtable = bl ? this.userPermissionProvider.getUserPermissions(this.realmName, string2, n) : this.userPrivilegeProvider.getUserPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        try {
            hashtable2 = bl ? this.rolePermissionProvider.getRolePermissions(this.realmName, string2, n) : this.rolePrivilegeProvider.getRolePrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        try {
            hashtable3 = bl ? this.groupPermissionProvider.getGroupPermissions(this.realmName, string2, n) : this.groupPrivilegeProvider.getGroupPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (hashtable == null && hashtable2 == null && hashtable3 == null) {
            return null;
        }
        if (hashtable != null) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                v = bl ? hashtable.get(string3) : hashtable.get(string3);
                principal = this.getUser(string3);
                if (principal == null) continue;
                this.getGroupPermissions(string3, principal, v, jAclImpl, bl);
            }
        }
        if (hashtable2 != null) {
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                v = bl ? hashtable2.get(string3) : hashtable2.get(string3);
                principal = this.getRole(string3);
                if (principal == null) continue;
                this.getGroupPermissions(string3, principal, v, jAclImpl, bl);
            }
        }
        if (hashtable3 != null) {
            enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                v = bl ? hashtable3.get(string3) : hashtable3.get(string3);
                principal = this.getGroup(string3);
                if (principal == null) continue;
                this.getGroupPermissions(string3, principal, v, jAclImpl, bl);
            }
        }
        return jAclImpl;
    }

    private void getGroupPermissions(String string, Principal principal, Object object, JAcl jAcl, boolean bl) {
        JAclEntry jAclEntry = new JAclEntryImpl(string, this);
        jAclEntry.setPrincipal(principal);
        int n = 0;
        if (bl) {
            try {
                n = SecurityUtil.getPermissionCodeFromString((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException, 3);
                return;
            }
            jAclEntry = PermissionUtil.addPermissionToAclEntry(jAclEntry, n);
        } else {
            n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames((String[])object);
            jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
        }
        try {
            jAcl.addEntry(principal, jAclEntry);
        }
        catch (NotOwnerException notOwnerException) {
            ServiceLogger.logError(notOwnerException, 3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRelation(Hashtable hashtable, String string, String string2) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Vector<String> vector = (Vector<String>)hashtable.get(string);
            if (vector == null) {
                vector = new Vector<String>();
                hashtable.put(string, vector);
            }
            if (!vector.contains(string2)) {
                vector.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRelation(Hashtable hashtable, String string, String string2) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Vector vector = (Vector)hashtable.get(string);
            if (vector != null) {
                vector.remove(string2);
            }
        }
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public AuthorizationProvider getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public OrganizationProvider getOrganizationProvider() {
        return this.orgProvider;
    }

    public UserProvider getUserProvider() {
        return this.userProvider;
    }

    public UserPermissionProvider getUserPermissionProvider() {
        return this.userPermissionProvider;
    }

    public UserPrivilegeProvider getUserPrivilegeProvider() {
        return this.userPrivilegeProvider;
    }

    public GroupProvider getGroupProvider() {
        return this.groupProvider;
    }

    public GroupPermissionProvider getGroupPermissionProvider() {
        return this.groupPermissionProvider;
    }

    public GroupPrivilegeProvider getGroupPrivilegeProvider() {
        return this.groupPrivilegeProvider;
    }

    public RoleProvider getRoleProvider() {
        return this.roleProvider;
    }

    public RolePermissionProvider getRolePermissionProvider() {
        return this.rolePermissionProvider;
    }

    public RolePrivilegeProvider getRolePrivilegeProvider() {
        return this.rolePrivilegeProvider;
    }

    public RoleGroupRelationProvider getRoleGroupRelationProvider() {
        return this.roleGroupRelationProvider;
    }

    public RoleUserRelationProvider getRoleUserRelationProvider() {
        return this.roleUserRelationProvider;
    }

    public GroupUserRelationProvider getGroupUserRelationProvider() {
        return this.groupUserRelationProvider;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void addPrincipalListener(PrincipalListener principalListener) {
        this.principalListeners.add(principalListener);
    }

    @Override
    public JOrganization[] getAllOrganizations() {
        Object object;
        Vector<JOrganization> vector = new Vector<JOrganization>();
        Iterator<String> iterator = null;
        try {
            iterator = this.orgProvider.getAllOrganizations(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = iterator.next();
                JOrganization jOrganization = this.getIntegrityOrganization((String)object);
                if (jOrganization == null) continue;
                vector.add(jOrganization);
            }
        }
        object = new JOrganization[vector.size()];
        return vector.toArray((T[])object);
    }

    public JOrganization getOrganization(String string) {
        JOrganizationImpl jOrganizationImpl = this.securityCache.getOrganization(string);
        if (jOrganizationImpl == null && (jOrganizationImpl = this.getGroupPrivileges(string)) != null) {
            this.securityCache.updateOrganization(jOrganizationImpl);
        }
        return jOrganizationImpl;
    }

    private void getGroupPrivilegeProvider(JOrganization jOrganization) {
        Properties properties = null;
        try {
            properties = this.orgProvider.getOrganizationProperties(this.realmName, jOrganization.getName());
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return;
        }
        catch (NoSuchOrganizationException noSuchOrganizationException) {
            ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException));
            return;
        }
        String string = properties.getProperty("organization_desc", "");
        int n = CSUtil.parseInt(properties.getProperty("organization_maxuser"), 0);
        JOrganizationImpl jOrganizationImpl = (JOrganizationImpl)jOrganization;
        jOrganizationImpl.setDescription(string);
        jOrganizationImpl.setMaxUserNumber(n);
    }

    public JOrganization getIntegrityOrganization(String string) {
        JOrganizationImpl jOrganizationImpl = this.securityCache.getOrganization(string);
        if (jOrganizationImpl == null) {
            jOrganizationImpl = this.getGroupPrivileges(string);
            if (jOrganizationImpl != null) {
                this.securityCache.updateOrganization(jOrganizationImpl);
            }
        } else {
            Properties properties = null;
            try {
                properties = this.orgProvider.getOrganizationProperties(this.realmName, string);
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException));
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            }
            jOrganizationImpl.setDescription(properties.getProperty("organization_desc"));
            jOrganizationImpl.setMaxUserNumber(CSUtil.parseInt(properties.getProperty("organization_maxuser"), 0));
        }
        return jOrganizationImpl;
    }

    private JOrganizationImpl getGroupPrivileges(String string) {
        Properties properties = null;
        try {
            properties = this.orgProvider.getOrganizationProperties(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException), 3);
            return null;
        }
        catch (NoSuchOrganizationException noSuchOrganizationException) {
            ServiceLogger.logDebug(noSuchOrganizationException.getMessage(), 6);
            return null;
        }
        if (properties == null || properties.size() == 0) {
            return null;
        }
        String string2 = properties.getProperty("organization_desc");
        int n = CSUtil.parseInt(properties.getProperty("organization_maxuser"), 0);
        JOrganizationImpl jOrganizationImpl = new JOrganizationImpl(string, string2, n);
        return jOrganizationImpl;
    }
}

