/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.config.xml;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.jrc.security.config.ProviderDescriptorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SecurityXMLReader {
    private String SEDU;
    private Hashtable equals;

    public SecurityXMLReader(String string) {
        this.SEDU = string;
        this.equals = new Hashtable();
    }

    public Hashtable getProperties() {
        return this.equals;
    }

    public void read() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(this.SEDU));
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("security");
        if (nodeList.getLength() <= 0) {
            throw new ParserConfigurationException("The format of configuration file has some error: 'can not find the tag <security>'!");
        }
        Element element2 = (Element)nodeList.item(0);
        this.SEDU(element2);
    }

    private void SEDU(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (node.getNodeType() != 1 || string == null) continue;
            if (string.equals("authentication-provider")) {
                this.getDocumentElement("authentication_provider", (Element)node);
            }
            if (string.equals("authorization-provider")) {
                this.getDocumentElement("authorization_provider", (Element)node);
            }
            if (string.equals("user")) {
                this.equals((Element)node);
            }
            if (string.equals("role")) {
                this.equalsIgnoreCase((Element)node);
            }
            if (string.equals("group")) {
                this.getAttribute((Element)node);
            }
            if (string.equals("relation")) {
                this.getChildNodes((Element)node);
            }
            if (!string.equals("organization")) continue;
            this.getDocumentElement("organization_provider", (Element)node);
        }
    }

    private void equals(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (node.getNodeType() != 1 || string == null) continue;
            if (string.equals("permission-provider")) {
                this.getDocumentElement("user_permission_provider", (Element)node);
            }
            if (string.equals("privilege-provider")) {
                this.getDocumentElement("user_privilege_provider", (Element)node);
            }
            if (!string.equals("provider")) continue;
            this.getDocumentElement("user_provider", (Element)node);
        }
    }

    private void equalsIgnoreCase(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (node.getNodeType() != 1 || string == null) continue;
            if (string.equals("permission-provider")) {
                this.getDocumentElement("role_permission_provider", (Element)node);
            }
            if (string.equals("privilege-provider")) {
                this.getDocumentElement("role_privilege_provider", (Element)node);
            }
            if (!string.equals("provider")) continue;
            this.getDocumentElement("role_provider", (Element)node);
        }
    }

    private void getAttribute(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (node.getNodeType() != 1 || string == null) continue;
            if (string.equals("permission-provider")) {
                this.getDocumentElement("group_permission_provider", (Element)node);
            }
            if (string.equals("privilege-provider")) {
                this.getDocumentElement("group_privilege_provider", (Element)node);
            }
            if (!string.equals("provider")) continue;
            this.getDocumentElement("group_provider", (Element)node);
        }
    }

    private void getChildNodes(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (node.getNodeType() != 1 || string == null) continue;
            if (string.equals("role-group")) {
                this.getDocumentElement("role_group_relation_provider", (Element)node);
            }
            if (string.equals("role-user")) {
                this.getDocumentElement("role_user_relation_provider", (Element)node);
            }
            if (!string.equals("group-user")) continue;
            this.getDocumentElement("group_user_relation_provider", (Element)node);
        }
    }

    private void getDocumentElement(String string, Element element) {
        Node node = element.getFirstChild();
        String string2 = node.getNodeValue();
        boolean bl = true;
        String string3 = element.getAttribute("active");
        if (string3 != null && string3.equalsIgnoreCase("false")) {
            bl = false;
        }
        ProviderDescriptorImpl providerDescriptorImpl = new ProviderDescriptorImpl(string, string2, bl);
        this.equals.put(string, providerDescriptorImpl);
    }
}

