/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom;

import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.cluster.core.ClusterServer;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.Topic;
import jet.server.event.TopicEvent;
import jet.server.event.TopicEventImpl;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityTransceiver;
import jet.server.jrc.security.event.AddOrganizationEvent;
import jet.server.jrc.security.event.AddPrincipalEvent;
import jet.server.jrc.security.event.AddRelationEvent;
import jet.server.jrc.security.event.RemoveOrganizationEvent;
import jet.server.jrc.security.event.RemovePrincipalEvent;
import jet.server.jrc.security.event.RemoveRelationEvent;
import jet.server.jrc.security.event.UpdateAllEvent;
import jet.server.jrc.security.event.UpdatePermissionsEvent;
import jet.server.jrc.security.event.UpdatePrivilegesEvent;
import jet.server.log.ServiceLogger;

public class SecurityListenerSynImpl
implements SecurityListener {
    private ExCachedSecurityDataImpl SECURITY;
    private SecurityTransceiver SEDU;

    public SecurityListenerSynImpl(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.SECURITY = exCachedSecurityDataImpl;
        if (ServerEnv.isClusterEnabled()) {
            this.SEDU = (SecurityTransceiver)ClusterServer.getTransceiver(Topic.SECURITY);
        }
    }

    @Override
    public void updateAll(String string) {
        Properties properties = new Properties();
        properties.setProperty("realm_name", string);
        UpdateAllEvent updateAllEvent = new UpdateAllEvent(string);
        TopicEventImpl topicEventImpl = new TopicEventImpl(updateAllEvent.getTopic(), 0, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    private void SECURITY(TopicEvent topicEvent) {
        if (this.SEDU != null) {
            try {
                this.SEDU.castMessage(new JRMessage(topicEvent));
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }
    }

    @Override
    public void addPrincipal(String string, String string2, int n) {
        Properties properties = new Properties();
        AddPrincipalEvent addPrincipalEvent = new AddPrincipalEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_principal", string2);
        properties.setProperty("security_event_para_principal_type", String.valueOf(n));
        TopicEventImpl topicEventImpl = new TopicEventImpl(addPrincipalEvent.getTopic(), 1, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    @Override
    public void removePrincipal(String string, String string2, int n) {
        Properties properties = new Properties();
        RemovePrincipalEvent removePrincipalEvent = new RemovePrincipalEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_principal", string2);
        properties.setProperty("security_event_para_principal_type", String.valueOf(n));
        TopicEventImpl topicEventImpl = new TopicEventImpl(removePrincipalEvent.getTopic(), 2, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    @Override
    public void addRelation(String string, String string2, int n, String string3, int n2) {
        Properties properties = new Properties();
        AddRelationEvent addRelationEvent = new AddRelationEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_parent_principal", string2);
        properties.setProperty("security_event_para_parent_principal_type", String.valueOf(n));
        properties.setProperty("security_event_para_sub_principal", string3);
        properties.setProperty("security_event_para_sub_principal_type", String.valueOf(n2));
        TopicEventImpl topicEventImpl = new TopicEventImpl(addRelationEvent.getTopic(), 3, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    @Override
    public void removeRelation(String string, String string2, int n, String string3, int n2) {
        Properties properties = new Properties();
        RemoveRelationEvent removeRelationEvent = new RemoveRelationEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_parent_principal", string2);
        properties.setProperty("security_event_para_parent_principal_type", String.valueOf(n));
        properties.setProperty("security_event_para_sub_principal", string3);
        properties.setProperty("security_event_para_sub_principal_type", String.valueOf(n2));
        TopicEventImpl topicEventImpl = new TopicEventImpl(removeRelationEvent.getTopic(), 4, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    @Override
    public void updatePermissons(String string, String string2, int n) {
        Properties properties = new Properties();
        UpdatePermissionsEvent updatePermissionsEvent = new UpdatePermissionsEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_resource_path", string2);
        properties.setProperty("security_event_para_version_number", String.valueOf(n));
        TopicEventImpl topicEventImpl = new TopicEventImpl(updatePermissionsEvent.getTopic(), 5, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    @Override
    public void updatePrivileges(String string, String string2, int n) {
        Properties properties = new Properties();
        UpdatePrivilegesEvent updatePrivilegesEvent = new UpdatePrivilegesEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_principal", string2);
        properties.setProperty("security_event_para_principal_type", String.valueOf(n));
        TopicEventImpl topicEventImpl = new TopicEventImpl(updatePrivilegesEvent.getTopic(), 6, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    @Override
    public void addOrganization(String string, String string2) {
        Properties properties = new Properties();
        AddOrganizationEvent addOrganizationEvent = new AddOrganizationEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_organization", string2);
        TopicEventImpl topicEventImpl = new TopicEventImpl(addOrganizationEvent.getTopic(), 7, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }

    @Override
    public void removeOrganization(String string, String string2) {
        Properties properties = new Properties();
        RemoveOrganizationEvent removeOrganizationEvent = new RemoveOrganizationEvent(string);
        properties.setProperty("realm_name", string);
        properties.setProperty("security_event_para_organization", string2);
        TopicEventImpl topicEventImpl = new TopicEventImpl(removeOrganizationEvent.getTopic(), 8, properties);
        this.SECURITY.process(topicEventImpl);
        this.SECURITY(topicEventImpl);
    }
}

