/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db;

import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.api.custom.security.AuthorizationProvider;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.JSPermissionImpl;
import jet.server.jrc.security.UserDataToolkit;

public class AuthorizationProviderDBImpl
implements AuthorizationProvider {
    @Override
    public boolean isPermissionOk(String string, String string2, String string3, int n, Permission permission) {
        if (string == null || string.length() == 0) {
            return false;
        }
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return false;
        }
        if (string2 == null || string3 == null || permission == null) {
            return false;
        }
        JAcl jAcl = exCachedSecurityDataImpl.getAcl(string3, n);
        BaseUser baseUser = exCachedSecurityDataImpl.getUser(string2);
        if (baseUser == null || jAcl == null) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        configurationAdvanced.loadProperties();
        int n2 = configurationAdvanced.getPermissionAlgorithmType();
        jAcl.setRoleBased(configurationAdvanced.isEnableRoleBasedAuthorization());
        boolean bl = false;
        if (n2 == 0) {
            bl = jAcl.checkPermission(baseUser, permission);
        } else {
            Vector<Object> vector = new Vector<Object>();
            JAclEntry jAclEntry = jAcl.getJAclEntry(baseUser, true);
            JAclEntry jAclEntry2 = jAcl.getJAclEntry(baseUser, false);
            if (jAclEntry != null || jAclEntry2 != null) {
                Object object;
                Enumeration enumeration = jAclEntry.permissions();
                while (enumeration.hasMoreElements()) {
                    object = (Permission)enumeration.nextElement();
                    vector.add(object);
                }
                if (jAclEntry2 != null) {
                    object = jAclEntry2.permissions();
                    while (object.hasMoreElements()) {
                        Permission permission2 = (Permission)object.nextElement();
                        if (!vector.contains(permission2)) continue;
                        vector.remove(permission2);
                    }
                }
                bl = vector.contains(permission);
            } else {
                bl = jAcl.checkPermission(baseUser, permission);
            }
        }
        return bl;
    }

    @Override
    public boolean checkPrivilege(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return false;
        }
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return false;
        }
        if (string2 == null || string3 == null) {
            return false;
        }
        JAcl jAcl = exCachedSecurityDataImpl.getExtendAcl();
        BaseUser baseUser = exCachedSecurityDataImpl.getUser(string2);
        if (baseUser == null || jAcl == null) {
            return false;
        }
        Vector vector = JSPermissionImpl.parseCmds(string3);
        boolean bl = false;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        configurationAdvanced.loadProperties();
        int n = configurationAdvanced.getPermissionAlgorithmType();
        for (int i = 0; i < vector.size(); ++i) {
            Permission permission = (Permission)vector.elementAt(i);
            if (n == 0) {
                bl = jAcl.checkPermission(baseUser, permission);
                continue;
            }
            Vector<Object> vector2 = new Vector<Object>();
            JAclEntry jAclEntry = jAcl.getJAclEntry(baseUser, true);
            JAclEntry jAclEntry2 = jAcl.getJAclEntry(baseUser, false);
            if (jAclEntry != null || jAclEntry2 != null) {
                Object object;
                Enumeration enumeration = jAclEntry.permissions();
                while (enumeration.hasMoreElements()) {
                    object = (Permission)enumeration.nextElement();
                    vector2.add(object);
                }
                if (jAclEntry2 != null) {
                    object = jAclEntry2.permissions();
                    while (object.hasMoreElements()) {
                        Permission permission2 = (Permission)object.nextElement();
                        if (!vector2.contains(permission2)) continue;
                        vector2.remove(permission2);
                    }
                }
                bl = vector2.contains(permission);
                continue;
            }
            bl = jAcl.checkPermission(baseUser, permission);
        }
        return bl;
    }
}

